# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.


class Instance(object):

    def __init__(self, id=None, name=None, carrier=None, ipType=None, ipCount=None, portCount=None, domainCount=None, elasticTriggerCount=None, abovePeakCount=None, inBitslimit=None, resilientBitslimit=None, businessBitslimit=None, ccThreshold=None, ccPeakQPS=None, ruleCount=None, webRuleCount=None, chargeStatus=None, securityStatus=None, createTime=None, expireTime=None, resourceId=None, ccObserveMode=None, ccProtectMode=None, ccProtectStatus=None, ccSpeedLimit=None, ccSpeedPeriod=None, ipBlackList=None, ipBlackStatus=None, ipWhiteList=None, ipWhiteStatus=None, urlWhitelist=None, urlWhitelistStatus=None, hostQps=None, hostUrlQps=None, ipHostQps=None, ipHostUrlQps=None):
        """
        :param id: (Optional) 实例 ID
        :param name: (Optional) 实例名称
        :param carrier: (Optional) 链路类型. <br>- 1: 电信<br>- 3: 电信、联通和移动<br>- 4: BGP 线路
        :param ipType: (Optional) 可防护 IP 类型, 目前仅电信线路支持 IPV6 线路. <br>- 0: IPV4. <br>- 1: IPV4/IPV6
        :param ipCount: (Optional) IP 数量
        :param portCount: (Optional) 可配的转发端口数量
        :param domainCount: (Optional) 可配的网站规则域名数量
        :param elasticTriggerCount: (Optional) 触发弹性带宽的次数
        :param abovePeakCount: (Optional) 超峰次数
        :param inBitslimit: (Optional) 保底带宽
        :param resilientBitslimit: (Optional) 弹性带宽
        :param businessBitslimit: (Optional) 业务带宽大小
        :param ccThreshold: (Optional) CC 阈值大小
        :param ccPeakQPS: (Optional) CC 防护峰值, 单位: QPS
        :param ruleCount: (Optional) 非网站类规则数
        :param webRuleCount: (Optional) 网站类规则数
        :param chargeStatus: (Optional) 计费状态. <br>- PAID: 已支付<br>- ARREARS: 欠费<br>- EXPIRED: 过期
        :param securityStatus: (Optional) 安全状态. <br>- SAFE: 安全<br>- CLEANING: 清洗中<br>- BLOCKING: 封禁中
        :param createTime: (Optional) 实例的创建的时间
        :param expireTime: (Optional) 实例的过期时间
        :param resourceId: (Optional) 资源 ID, 升级和续费时使用
        :param ccObserveMode: (Optional) CC 防护观察者模式. <br>- 0: 关闭 <br>- 1: 开启
        :param ccProtectMode: (Optional) CC 防护模式. <br>- 0: 正常 <br>- 1: 紧急 <br>- 2: 宽松 <br>- 3: 自定义
        :param ccProtectStatus: (Optional) CC 开关状态. <br>- 0: 关闭 <br>- 1: 开启
        :param ccSpeedLimit: (Optional) CC 防护模式为自定义时的限速大小
        :param ccSpeedPeriod: (Optional) CC 防护模式为自定义时的限速周期
        :param ipBlackList: (Optional) IP 黑名单列表
        :param ipBlackStatus: (Optional) IP 黑名单状态. <br>- 0: 关闭 <br>- 1: 开启
        :param ipWhiteList: (Optional) IP 白名单列表
        :param ipWhiteStatus: (Optional) IP 白名单状态. <br>- 0: 关闭<br>- 1: 开启
        :param urlWhitelist: (Optional) url白名单列表
        :param urlWhitelistStatus: (Optional) url白名单状态. <br>- 0: 关闭<br>- 1: 开启
        :param hostQps: (Optional) ccProtectMode为自定义模式时, 每个Host的防护阈值
        :param hostUrlQps: (Optional) ccProtectMode为自定义模式时, 每个Host+URI的防护阈值
        :param ipHostQps: (Optional) ccProtectMode为自定义模式时, 每个源IP对Host的防护阈值
        :param ipHostUrlQps: (Optional) ccProtectMode为自定义模式时, 每个源IP对Host+URI的防护阈值
        """

        self.id = id
        self.name = name
        self.carrier = carrier
        self.ipType = ipType
        self.ipCount = ipCount
        self.portCount = portCount
        self.domainCount = domainCount
        self.elasticTriggerCount = elasticTriggerCount
        self.abovePeakCount = abovePeakCount
        self.inBitslimit = inBitslimit
        self.resilientBitslimit = resilientBitslimit
        self.businessBitslimit = businessBitslimit
        self.ccThreshold = ccThreshold
        self.ccPeakQPS = ccPeakQPS
        self.ruleCount = ruleCount
        self.webRuleCount = webRuleCount
        self.chargeStatus = chargeStatus
        self.securityStatus = securityStatus
        self.createTime = createTime
        self.expireTime = expireTime
        self.resourceId = resourceId
        self.ccObserveMode = ccObserveMode
        self.ccProtectMode = ccProtectMode
        self.ccProtectStatus = ccProtectStatus
        self.ccSpeedLimit = ccSpeedLimit
        self.ccSpeedPeriod = ccSpeedPeriod
        self.ipBlackList = ipBlackList
        self.ipBlackStatus = ipBlackStatus
        self.ipWhiteList = ipWhiteList
        self.ipWhiteStatus = ipWhiteStatus
        self.urlWhitelist = urlWhitelist
        self.urlWhitelistStatus = urlWhitelistStatus
        self.hostQps = hostQps
        self.hostUrlQps = hostUrlQps
        self.ipHostQps = ipHostQps
        self.ipHostUrlQps = ipHostUrlQps
