# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class UpdateThingShadowRequest(JDCloudRequest):
    """
    更新设备影子的期望值
    """

    def __init__(self, parameters, header=None, version="v2"):
        super(UpdateThingShadowRequest, self).__init__(
            '/regions/{regionId}/products/{productKey}/devices/{identifier}/shadow', 'PATCH', header, version)
        self.parameters = parameters


class UpdateThingShadowParameters(object):

    def __init__(self, regionId, identifier, productKey, ):
        """
        :param regionId: 设备归属的实例所在区域
        :param identifier: 设备唯一标识
        :param productKey: 产品Key
        """

        self.regionId = regionId
        self.identifier = identifier
        self.productKey = productKey
        self.state = None
        self.version = None

    def setState(self, state):
        """
        :param state: (Optional) 运行状态
        """
        self.state = state

    def setVersion(self, version):
        """
        :param version: (Optional) 设备影子版本,当前版本加1，当前版本默认其实版本为-1
用户主动更新版本号时，设备影子会检查请求中的主动更新版本号是否大于当前版本号。
如果大于当前版本号，则更新设备影子，并将影子版本值更新到请求的版本中，反之则会拒绝更新设备影子。
影子版本参数为Integer型
取值范围：0到2147483647(2的31次方-1)
当取值达到最大值2147483647(2的31次方-1)时，请求中的主动更新版本号应为-1

        """
        self.version = version

