# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class SetLiveDomainBackSourceRequest(JDCloudRequest):
    """
    设置直播域名回源信息
    """

    def __init__(self, parameters, header=None, version="v1"):
        super(SetLiveDomainBackSourceRequest, self).__init__(
            '/liveDomain/{domain}/backSource', 'POST', header, version)
        self.parameters = parameters


class SetLiveDomainBackSourceParameters(object):

    def __init__(self, domain, ):
        """
        :param domain: 用户域名
        """

        self.domain = domain
        self.sourceType = None
        self.backSourceType = None
        self.defaultSourceHost = None
        self.domainSource = None
        self.ipSource = None

    def setSourceType(self, sourceType):
        """
        :param sourceType: (Optional) 回源类型只能为[ips,domain]中的一种
        """
        self.sourceType = sourceType

    def setBackSourceType(self, backSourceType):
        """
        :param backSourceType: (Optional) 
        """
        self.backSourceType = backSourceType

    def setDefaultSourceHost(self, defaultSourceHost):
        """
        :param defaultSourceHost: (Optional) 默认回源host
        """
        self.defaultSourceHost = defaultSourceHost

    def setDomainSource(self, domainSource):
        """
        :param domainSource: (Optional) 
        """
        self.domainSource = domainSource

    def setIpSource(self, ipSource):
        """
        :param ipSource: (Optional) 
        """
        self.ipSource = ipSource

