"""Sunsynk hybrid inverter sensor definitions."""
from sunsynk.sensor import HSensor

overall_state = HSensor(59, "Overall state")
day_active_power = HSensor(60, "Day Active Power", "kWh", 0.1)
day_reactive_power = HSensor(61, "Day Reactive Power", "kVarh", 0.1)
total_active_power = HSensor((63, 64), "Total Active Power", "kWh", 0.1)
battery_charge_day = HSensor(70, "Battery Charge Day", "kWh", 0.1)
battery_discharge_day = HSensor(71, "Battery discharge day", "kWh", 0.1)
total_battery_charge = HSensor((72, 73), "Total Battery Charge", "kWh", 0.1)
total_battery_discharge = HSensor((74, 75), "Total Battery Discharge", "kWh", 0.1)
grid_import_day = HSensor(76, "Grid Import Day", "kWh", 0.1)
grid_export_day = HSensor(77, "Grid Export Day", "kWh", 0.1)
total_grid_import = HSensor((78, 80), "Total Grid Import", "kWh", 0.1)
grid_frequency = HSensor(79, "Grid frequency", "Hz", 0.01)
total_grid_export = HSensor((81, 82), "Total Grid Export", "kWh", 0.1)
total_load_power = HSensor((85, 86), "Total Load Power", "kWh", 0.1)
year_load_power = HSensor((87, 88), "Year Load Power", "kWh", 0.1)
temp_dc_transformer = HSensor(90, "Temp DC transformer", "C", 0.1)
temp_radiator = HSensor(91, "Temp Radiator", "C", 0.1)
temperature_environment = HSensor(95, "Temperature Environment", "C", 0.1)
total_pv_power = HSensor((96, 97), "Total PV Power", "kWh", 0.1)
grid_export_year = HSensor((98, 99), "Grid Export Year", "kWh", 0.1)
pv_energy_day = HSensor(108, "PV Energy Day", "kWh", 0.1)
pv1_voltage = HSensor(109, "PV1 Voltage", "V", 0.1)
pv1_current = HSensor(110, "PV1 Current", "A", 0.1)
pv2_voltage = HSensor(111, "PV2 Voltage", "V", 0.1)
pv2_current = HSensor(112, "PV2 Current", "A", 0.1)
inverter_voltage = HSensor(154, "Inverter Voltage", "V", 0.1)
grid_inverter_load = HSensor(167, "Grid Inverter load", "W", 1)
grid_ct_load = HSensor(172, "Grid CT load", "W", 1)
total_load = HSensor(178, "Total load", "W", 1)
temperature_battery = HSensor(182, "Temperature Battery", "C", 0.1)
battery_voltage = HSensor(183, "Battery voltage", "V", 0.01)
battery_soc = HSensor(184, "Battery SOC", "%", 1)
pv1_power = HSensor(186, "PV1 power", "W", 1)
pv2_power = HSensor(187, "PV2 power", "W", 1)
battery_output_power = HSensor(190, "Battery output power", "W", 1)
battery_output_current = HSensor(191, "Battery output current", "A", 0.1)
battery_grid_charge = HSensor(230, "Battery Grid Charge", "A", 1)
battery_charge = HSensor(312, "Battery charge", "V", 0.01)
