#!/usr/bin/python
import versioneer
from setuptools import setup, find_packages


setup(
    extras_require={
        "dev": [
            "appdirs==1.4.4",
            "args==0.1.0",
            "attrs==19.3.0; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3'",
            "black==19.10b0; python_version >= '3.6'",
            "cached-property==1.5.1",
            "cerberus==1.3.2",
            "certifi==2020.6.20",
            "chardet==3.0.4",
            "click==7.1.2",
            "clint==0.5.1",
            "colorama==0.4.3; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3, 3.4'",
            "coverage==5.2.1; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3, 3.4' and python_version < '4'",
            "distlib==0.3.1",
            "doublex==1.9.2",
            "doublex-expects==0.7.1",
            "expects==0.9.0",
            "flake8==3.8.3",
            "httmock==1.3.0",
            "idna==2.10; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3'",
            "mamba==0.11.1",
            "mccabe==0.6.1",
            "orderedmultidict==1.0.1",
            "packaging==20.4; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3'",
            "pathspec==0.8.0",
            "pep517==0.8.2",
            "pip-shims==0.5.2; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3, 3.4'",
            "pipenv-setup==3.1.1",
            "pipfile==0.0.2",
            "plette[validation]==0.2.3; python_version >= '2.6' and python_version not in '3.0, 3.1, 3.2, 3.3'",
            "prettytable==0.7.2",
            "pyaml==20.4.0",
            "pycodestyle==2.6.0; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3'",
            "pyflakes==2.2.0; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3'",
            "pyhamcrest==2.0.2; python_version >= '3.5'",
            "pyparsing==2.4.7; python_version >= '2.6' and python_version not in '3.0, 3.1, 3.2, 3.3'",
            "python-dateutil==2.8.1",
            "pyyaml==5.3.1",
            "regex==2020.7.14",
            "requests==2.24.0",
            "requests-toolbelt==0.9.1",
            "requirementslib==1.5.12; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3, 3.4'",
            "sdcclient==0.11.0",
            "six==1.15.0; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3'",
            "tatsu==5.5.0",
            "toml==0.10.1",
            "tomlkit==0.6.0; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3'",
            "typed-ast==1.4.1",
            "urllib3==1.25.10; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3, 3.4' and python_version < '4'",
            "vistir==0.5.2; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3'",
            "wheel==0.34.2; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3, 3.4'",
        ]
    },
    name="sdccli",
    author="sysdig Inc.",
    author_email="info@sysdig.com",
    license="MIT",
    description="CLI client for Sysdig Cloud",
    url="https://github.com/draios/sysdig-platform-cli",
    packages=find_packages(exclude=["test", "specs", "specs.*"]),
    version=versioneer.get_version(),
    cmdclass=versioneer.get_cmdclass(),
    entry_points="""
    [console_scripts]
    sdc-cli=sdccli.cli:cli
    """,
    install_requires=[
        "certifi==2020.6.20",
        "chardet==3.0.4",
        "click==7.1.2",
        "idna==2.10; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3'",
        "prettytable==0.7.2",
        "pyaml==20.4.0",
        "python-dateutil==2.8.1",
        "pyyaml==5.3.1",
        "requests==2.24.0",
        "requests-toolbelt==0.9.1",
        "sdcclient==0.11.0",
        "six==1.15.0; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3'",
        "tatsu==5.5.0",
        "urllib3==1.25.10; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3, 3.4' and python_version < '4'",
    ],
    test_suite="test",
)
