dictionary_tag = "Palanque-Delabrouille et al. 2013 (likelihood method)"

reference   = "Palanque-Delabrouille, Yeche, Borde, Le Goff, Rossi, Viel, et al.; A&A 559, A85 (2013)"

url         = "https://www.aanda.org/articles/aa/abs/2013/11/aa22130-13/aa22130-13.html"

description = \
"""
1D Lyman-alpha power spectrum estimated from 13821 BOSS QSOs using the maximum likelihood method.
"""

data_structure         = "grid" #grid or points

extracted              = False

ndim                   = 2

dimensions_descriptors = ["redshift", "ks (s/km)"]

axes                   = [[2.2, 2.4, 2.6, 2.8, 3. , 3.2, 3.4, 3.6, 3.8, 4., 4.2, 4.4],
                          [0.00134705, 0.00242469, 0.00350233, 0.00457997, 0.0053882 , 0.00592703,
                           0.00646585, 0.00700467, 0.00754349, 0.00808231, 0.00862113, 0.00915995,
                           0.00969877, 0.0102376 , 0.0107764 , 0.0113152 , 0.0118541 , 0.0123929 ,
                           0.0129317 , 0.0134705 , 0.0140093 , 0.0145481 , 0.015087  , 0.0156258 ,
                           0.0161646 , 0.0167034 , 0.0172423 , 0.0177811 , 0.0183199 , 0.0188587 ,
                           0.0193975 , 0.0199364 ]
                         ]

values      = [[17.20920, 18.24320, 15.13800, 13.35710, 14.71530, 13.30140,  \
                13.02000, 11.20410, 11.17740, 12.49780, 10.84940, 10.30230,  \
                9.14649, 10.01420, 10.17200, 9.37221, 8.27984, 8.90573,  \
                8.14732, 8.41943, 7.95073, 7.48239, 7.64096, 7.45214,  \
                7.89784, 8.27902, 7.12060, 6.80462, 6.72505, 8.23319,  \
                6.45203, 6.09383 \
               ], \
               [21.64230, 21.85670, 19.12500, 15.98560, 17.14990, 16.73730,  \
                14.11700, 12.95680, 13.69790, 14.03110, 12.37130, 12.43900,  \
                10.85380, 10.78690, 11.11320, 11.60720, 10.27760, 9.54010,  \
                9.54386, 10.68780, 9.67051, 8.37240, 8.65984, 8.49419,  \
                8.40462, 8.34192, 8.12293, 7.74566, 7.16521, 8.40762,  \
                7.27376, 7.55931 \
               ], \
               [27.12540, 27.67230, 22.66340, 19.57760, 20.57220, 19.85360,  \
                17.59270, 15.41690, 16.71390, 16.48630, 15.82000, 14.69030,  \
                13.30570, 13.49370, 13.91300, 12.90940, 12.35910, 11.57440,  \
                11.11100, 11.68150, 10.28550, 10.39580, 9.49813, 9.87528,  \
                9.35842, 10.32030, 9.38212, 8.29876, 8.40387, 7.86429,  \
                7.65540, 7.68338 \
               ], \
               [34.14090, 33.50370, 27.41590, 23.36720, 24.72310, 24.20440,  \
                21.00470, 18.43680, 19.39420, 19.37570, 18.18900, 17.87680,  \
                16.23350, 16.24610, 16.12090, 15.76210, 15.22150, 13.78780,  \
                13.01130, 12.50530, 13.51110, 12.02130, 12.07830, 11.03380,  \
                11.29480, 10.23830, 11.17030, 9.80442, 9.98705, 9.88374,  \
                9.58175, 8.97503 \
               ], \
               [41.81010, 40.74910, 32.45080, 29.00860, 30.39570, 27.33230,  \
                24.81570, 22.98020, 23.32890, 24.22280, 20.71860, 19.35730,  \
                20.04760, 19.87700, 19.86630, 17.57050, 16.82970, 16.77450,  \
                16.58820, 15.87320, 15.39260, 14.22540, 13.46070, 13.11820,  \
                13.93590, 12.72330, 11.91490, 11.87580, 11.18650, 10.44030,  \
                11.74150, 10.00830 \
               ], \
               [51.52580, 49.48300, 40.67380, 34.21560, 35.79700, 32.57620,  \
                30.40350, 29.17230, 27.77050, 29.51630, 25.40450, 26.78680,  \
                23.54590, 22.53140, 23.41710, 23.73670, 21.53700, 20.29200,  \
                18.19460, 19.67850, 18.59920, 17.54790, 17.93150, 17.10970,  \
                16.76950, 16.76510, 15.60690, 13.91010, 14.01450, 14.97140,  \
                14.71640, 13.44260 \
               ], \
               [64.11970, 56.12870, 47.81330, 45.58820, 41.59570, 41.72230,  \
                35.49400, 34.87750, 34.53460, 34.44900, 35.29760, 30.79420,  \
                27.27340, 30.38920, 27.96670, 24.30380, 27.55630, 22.85520,  \
                25.17930, 23.27340, 28.67230, 20.73400, 21.31620, 20.65680,  \
                20.55970, 19.03350, 19.16680, 20.55850, 16.65170, 16.81020,  \
                18.98900, 15.37480 \
               ], \
               [73.48630, 71.71130, 63.74920, 51.78740, 52.78970, 44.30030,  \
                47.56990, 38.86600, 38.94930, 40.37810, 41.80230, 37.04210,  \
                39.94780, 34.91060, 33.45990, 36.96070, 30.86000, 24.92150,  \
                26.40960, 33.04590, 23.27390, 21.58970, 27.38310, 27.50020,  \
                25.11340, 26.55650, 22.44690, 24.61850, 23.71700, 25.64880,  \
                20.20860, 19.59340 \
               ], \
               [91.16530, 96.08560, 69.10480, 71.28040, 51.33700, 63.38160,  \
                55.77220, 53.64780, 52.37710, 41.12900, 52.83710, 37.64500,  \
                40.43570, 51.63010, 37.47630, 42.24790, 41.68330, 34.15660,  \
                44.59770, 31.90740, 43.55910, 29.01150, 23.67360, 37.97740,  \
                28.45830, 32.67370, 28.54510, 28.22630, 32.72890, 27.98000,  \
                32.55410, 25.94700 \
               ], \
               [116.99500, 114.09600, 87.40980, 65.03560, 82.75270, 58.78280,  \
                73.61290, 51.64340, 57.06330, 56.37960, 70.16620, 42.38530,  \
                46.54860, 45.21460, 53.16500, 37.28390, 46.63180, 37.49930,  \
                64.45970, 41.43680, 36.12970, 51.22910, 48.71800, 53.24480,  \
                55.64320, 32.29580, 35.64520, 52.09560, 47.10780, 22.30140,  \
                46.59130, 46.75720 \
               ], \
               [135.65600, 152.51700, 95.37750, 105.08200, 109.96700, 67.85910,  \
                98.00170, 66.18920, 78.16500, 49.98030, 95.70660, 70.63490,  \
                76.61800, 41.78580, 67.79160, 41.48480, 62.67570, 74.59390,  \
                60.44000, 45.26430, 72.21010, 37.04520, 58.75500, 44.11280,  \
                19.93030, 33.25520, 32.24370, 54.57000, 23.53820, 49.15420,  \
                52.16350, 44.51820 \
               ], \
               [131.64500, 113.67500, 106.35800, 116.14200, 78.57760, 77.59050,  \
                107.20000, 94.54920, 81.03170, 78.25270, 82.95010, 73.25740,  \
                88.94310, 36.04470, 69.25120, 99.90290, 114.88400, 102.96600,  \
                55.27600, 25.31640, 81.13030, 45.98600, 39.36180, 38.10220,  \
                47.97590, 59.49570, 68.87350, 88.16430, 36.10400, 45.50860,  \
                92.98310, 38.27090 \
               ], \
              ]

err_up      = [[0.96906, 0.84310, 0.81204, 0.65440, 0.90961, 0.79310,  \
                0.81348, 0.74819, 0.79980, 0.74382, 0.77403, 0.77479,  \
                0.71172, 0.74738, 0.85048, 0.86149, 0.78169, 0.81984,  \
                0.79814, 0.77801, 0.86174, 0.78925, 0.81062, 0.90789,  \
                0.95536, 0.91466, 0.89430, 0.86681, 0.99036, 1.20322,  \
                1.16826, 1.03450 \
               ], \
               [0.81452, 0.78314, 0.73426, 0.61860, 0.74092, 0.74377,  \
                0.66157, 0.65455, 0.72067, 0.71283, 0.65807, 0.68372,  \
                0.66635, 0.64980, 0.72556, 0.74255, 0.67195, 0.64934,  \
                0.66260, 0.75541, 0.74781, 0.67356, 0.75922, 0.78235,  \
                0.74351, 0.77565, 0.77101, 0.75840, 0.79622, 0.92020,  \
                0.84523, 0.97643 \
               ], \
               [0.89071, 0.99782, 0.91334, 0.72823, 0.87718, 0.87474,  \
                0.83078, 0.76052, 0.75924, 0.83322, 0.77944, 0.74592,  \
                0.76303, 0.79091, 0.83001, 0.83902, 0.82326, 0.69474,  \
                0.74887, 0.80270, 0.73509, 0.80541, 0.77765, 0.81930,  \
                0.79707, 0.82064, 0.86006, 0.76601, 0.75076, 0.81744,  \
                0.87785, 0.84053 \
               ], \
               [1.13458, 1.02693, 0.96930, 0.89358, 1.07368, 1.10511,  \
                0.94051, 0.79438, 0.88529, 0.98761, 0.94871, 0.93661,  \
                0.85203, 0.89361, 0.86371, 0.92778, 0.92209, 0.94927,  \
                0.78949, 0.91110, 0.92580, 0.83887, 0.93475, 0.81639,  \
                0.83379, 0.87971, 0.93575, 0.86890, 0.88470, 0.93836,  \
                0.92751, 0.93982 \
               ], \
               [1.58805, 1.56042, 1.12866, 1.21550, 1.39777, 1.22872,  \
                1.01160, 1.28180, 1.08233, 1.24050, 1.08850, 1.10243,  \
                1.09591, 1.19985, 1.15301, 1.04926, 1.01989, 1.26031,  \
                1.08903, 1.07813, 0.95553, 1.15155, 1.02783, 1.02083,  \
                1.01553, 1.09904, 1.01858, 1.16045, 1.28906, 1.15023,  \
                1.21446, 0.96799 \
               ], \
               [2.01669, 1.68817, 1.40889, 1.46861, 1.74655, 1.82584,  \
                1.81574, 1.52056, 1.68046, 1.18037, 1.53938, 1.46419,  \
                1.45007, 1.44826, 1.38412, 1.19211, 1.46027, 1.28406,  \
                1.38945, 1.57107, 1.14678, 1.11209, 1.47192, 1.04992,  \
                1.62560, 1.17734, 1.18534, 1.24775, 1.15273, 1.62774,  \
                1.77226, 1.53728 \
               ], \
               [2.96990, 2.23626, 2.13877, 2.62459, 3.25768, 1.89585,  \
                1.79178, 2.58179, 2.35439, 2.29037, 2.34823, 2.31919,  \
                1.88490, 2.04034, 1.69607, 1.76422, 2.10682, 2.08117,  \
                1.86805, 2.27347, 3.38910, 1.17400, 2.20975, 1.88974,  \
                2.09267, 1.89362, 1.87516, 2.01787, 1.83584, 1.87466,  \
                1.80539, 1.37178 \
               ], \
               [3.69327, 3.30197, 2.98113, 2.67749, 3.73391, 3.53554,  \
                3.53546, 3.26055, 3.25552, 3.30894, 3.25953, 3.11007,  \
                3.14706, 3.04029, 2.98513, 3.07526, 2.85496, 2.65093,  \
                2.78126, 3.05980, 2.69356, 2.59953, 2.98720, 2.95445,  \
                2.91294, 3.05261, 2.90778, 3.11433, 3.09848, 3.27115,  \
                2.95904, 3.05855 \
               ], \
               [6.04421, 5.46476, 4.75670, 4.52119, 5.79314, 5.88748,  \
                5.45289, 5.45121, 5.42611, 4.85564, 5.33286, 4.70247,  \
                4.72076, 5.06013, 4.66674, 4.73428, 4.83545, 4.60964,  \
                4.82837, 4.49758, 5.13849, 4.33749, 4.13223, 4.95603,  \
                4.41808, 4.73446, 4.61817, 4.77473, 4.98563, 4.81606,  \
                5.40553, 5.12254 \
               ], \
               [10.53526, 8.81284, 7.69268, 6.91501, 10.47702, 9.09239,  \
                9.50094, 8.60340, 8.68044, 8.39322, 8.96752, 7.80487,  \
                7.64567, 7.69697, 8.15655, 7.21414, 7.75546, 7.39979,  \
                8.56685, 7.65726, 7.32992, 8.09075, 8.30340, 8.41888,  \
                8.79687, 7.73947, 8.10330, 9.54059, 9.72561, 7.14018,  \
                9.97821, 10.40763 \
               ], \
               [14.93734, 14.09144, 11.57969, 10.93349, 16.30536, 13.96397,  \
                15.27551, 13.32129, 14.01322, 12.55711, 14.43440, 13.02952,  \
                13.72998, 11.34650, 12.94179, 11.67187, 12.53641, 13.43366,  \
                12.66810, 11.99574, 14.21563, 11.13192, 13.73165, 11.96123,  \
                9.19767, 10.69156, 11.52531, 14.65977, 11.35197, 15.03417,  \
                16.81588, 16.50702 \
               ], \
               [23.32275, 21.50096, 18.95351, 17.44895, 24.63456, 22.73192,  \
                22.73405, 21.57811, 21.27095, 20.37296, 20.90733, 20.66207,  \
                20.82462, 14.70032, 18.58133, 19.25039, 19.85974, 20.29680,  \
                17.50047, 14.35292, 19.32825, 17.61219, 17.33311, 17.14843,  \
                18.70796, 20.63799, 21.00355, 24.39705, 17.16934, 19.82829,  \
                30.83593, 21.34295 \
               ], \
              ]


err_down    = [[0.96906, 0.84310, 0.81204, 0.65440, 0.90961, 0.79310,  \
                0.81348, 0.74819, 0.79980, 0.74382, 0.77403, 0.77479,  \
                0.71172, 0.74738, 0.85048, 0.86149, 0.78169, 0.81984,  \
                0.79814, 0.77801, 0.86174, 0.78925, 0.81062, 0.90789,  \
                0.95536, 0.91466, 0.89430, 0.86681, 0.99036, 1.20322,  \
                1.16826, 1.03450 \
               ], \
               [0.81452, 0.78314, 0.73426, 0.61860, 0.74092, 0.74377,  \
                0.66157, 0.65455, 0.72067, 0.71283, 0.65807, 0.68372,  \
                0.66635, 0.64980, 0.72556, 0.74255, 0.67195, 0.64934,  \
                0.66260, 0.75541, 0.74781, 0.67356, 0.75922, 0.78235,  \
                0.74351, 0.77565, 0.77101, 0.75840, 0.79622, 0.92020,  \
                0.84523, 0.97643 \
               ], \
               [0.89071, 0.99782, 0.91334, 0.72823, 0.87718, 0.87474,  \
                0.83078, 0.76052, 0.75924, 0.83322, 0.77944, 0.74592,  \
                0.76303, 0.79091, 0.83001, 0.83902, 0.82326, 0.69474,  \
                0.74887, 0.80270, 0.73509, 0.80541, 0.77765, 0.81930,  \
                0.79707, 0.82064, 0.86006, 0.76601, 0.75076, 0.81744,  \
                0.87785, 0.84053 \
               ], \
               [1.13458, 1.02693, 0.96930, 0.89358, 1.07368, 1.10511,  \
                0.94051, 0.79438, 0.88529, 0.98761, 0.94871, 0.93661,  \
                0.85203, 0.89361, 0.86371, 0.92778, 0.92209, 0.94927,  \
                0.78949, 0.91110, 0.92580, 0.83887, 0.93475, 0.81639,  \
                0.83379, 0.87971, 0.93575, 0.86890, 0.88470, 0.93836,  \
                0.92751, 0.93982 \
               ], \
               [1.58805, 1.56042, 1.12866, 1.21550, 1.39777, 1.22872,  \
                1.01160, 1.28180, 1.08233, 1.24050, 1.08850, 1.10243,  \
                1.09591, 1.19985, 1.15301, 1.04926, 1.01989, 1.26031,  \
                1.08903, 1.07813, 0.95553, 1.15155, 1.02783, 1.02083,  \
                1.01553, 1.09904, 1.01858, 1.16045, 1.28906, 1.15023,  \
                1.21446, 0.96799 \
               ], \
               [2.01669, 1.68817, 1.40889, 1.46861, 1.74655, 1.82584,  \
                1.81574, 1.52056, 1.68046, 1.18037, 1.53938, 1.46419,  \
                1.45007, 1.44826, 1.38412, 1.19211, 1.46027, 1.28406,  \
                1.38945, 1.57107, 1.14678, 1.11209, 1.47192, 1.04992,  \
                1.62560, 1.17734, 1.18534, 1.24775, 1.15273, 1.62774,  \
                1.77226, 1.53728 \
               ], \
               [2.96990, 2.23626, 2.13877, 2.62459, 3.25768, 1.89585,  \
                1.79178, 2.58179, 2.35439, 2.29037, 2.34823, 2.31919,  \
                1.88490, 2.04034, 1.69607, 1.76422, 2.10682, 2.08117,  \
                1.86805, 2.27347, 3.38910, 1.17400, 2.20975, 1.88974,  \
                2.09267, 1.89362, 1.87516, 2.01787, 1.83584, 1.87466,  \
                1.80539, 1.37178 \
               ], \
               [3.69327, 3.30197, 2.98113, 2.67749, 3.73391, 3.53554,  \
                3.53546, 3.26055, 3.25552, 3.30894, 3.25953, 3.11007,  \
                3.14706, 3.04029, 2.98513, 3.07526, 2.85496, 2.65093,  \
                2.78126, 3.05980, 2.69356, 2.59953, 2.98720, 2.95445,  \
                2.91294, 3.05261, 2.90778, 3.11433, 3.09848, 3.27115,  \
                2.95904, 3.05855 \
               ], \
               [6.04421, 5.46476, 4.75670, 4.52119, 5.79314, 5.88748,  \
                5.45289, 5.45121, 5.42611, 4.85564, 5.33286, 4.70247,  \
                4.72076, 5.06013, 4.66674, 4.73428, 4.83545, 4.60964,  \
                4.82837, 4.49758, 5.13849, 4.33749, 4.13223, 4.95603,  \
                4.41808, 4.73446, 4.61817, 4.77473, 4.98563, 4.81606,  \
                5.40553, 5.12254 \
               ], \
               [10.53526, 8.81284, 7.69268, 6.91501, 10.47702, 9.09239,  \
                9.50094, 8.60340, 8.68044, 8.39322, 8.96752, 7.80487,  \
                7.64567, 7.69697, 8.15655, 7.21414, 7.75546, 7.39979,  \
                8.56685, 7.65726, 7.32992, 8.09075, 8.30340, 8.41888,  \
                8.79687, 7.73947, 8.10330, 9.54059, 9.72561, 7.14018,  \
                9.97821, 10.40763 \
               ], \
               [14.93734, 14.09144, 11.57969, 10.93349, 16.30536, 13.96397,  \
                15.27551, 13.32129, 14.01322, 12.55711, 14.43440, 13.02952,  \
                13.72998, 11.34650, 12.94179, 11.67187, 12.53641, 13.43366,  \
                12.66810, 11.99574, 14.21563, 11.13192, 13.73165, 11.96123,  \
                9.19767, 10.69156, 11.52531, 14.65977, 11.35197, 15.03417,  \
                16.81588, 16.50702 \
               ], \
               [23.32275, 21.50096, 18.95351, 17.44895, 24.63456, 22.73192,  \
                22.73405, 21.57811, 21.27095, 20.37296, 20.90733, 20.66207,  \
                20.82462, 14.70032, 18.58133, 19.25039, 19.85974, 20.29680,  \
                17.50047, 14.35292, 19.32825, 17.61219, 17.33311, 17.14843,  \
                18.70796, 20.63799, 21.00355, 24.39705, 17.16934, 19.82829,  \
                30.83593, 21.34295 \
               ], \
              ]


err_up2     = None

err_down2   = None

upper_lim   = [[False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False \
               ], \
               [False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False \
               ], \
               [False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False \
               ], \
               [False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False \
               ], \
               [False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False \
               ], \
               [False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False \
               ], \
               [False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False \
               ], \
               [False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False \
               ], \
               [False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False \
               ], \
               [False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False \
               ], \
               [False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False \
               ], \
               [False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False \
               ], \
              ]

lower_lim   = [[False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False \
               ], \
               [False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False \
               ], \
               [False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False \
               ], \
               [False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False \
               ], \
               [False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False \
               ], \
               [False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False \
               ], \
               [False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False \
               ], \
               [False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False \
               ], \
               [False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False \
               ], \
               [False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False \
               ], \
               [False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False \
               ], \
               [False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False, False, False, False, False,  \
                False, False \
               ], \
              ]
