# reflekt-PROJECT_NAME
A [Reflekt](https://github.com/GClunies/reflekt) project defining tracking plans as `code`. Automagically build a dbt package that models and documents events in a tracking plan, ready for use in dbt, by running:
```
reflekt dbt --name <your-plan> --schema <schema_wth_raw_data>
```
### Getting Started
- See the [Reflekt docs](https://reflekt-ci.notion.site/reflekt-ci/Reflekt-Docs-a27c2dd7006b4584b6a451819b09cdb7) for a full list of commands.
- Tracking plans are defined in the [`tracking-plans/`](tracking-plans/) directory.
- Templated dbt packages generated by Reflekt are defined in the [`dbt-packages/`](dbt-packages/) directory.

### Using Reflekt dbt packages
To use a Reflekt dbt package, add it to the `packages.yml` of your dbt project.
```yaml
  # Example packages.yml in dbt project
  packages:
  - package: dbt-labs/dbt_utils
    version: 0.8.5

  - git: "https://github.com/<YOUR-USER-ORG>/<YOUR-REPO>"  # Replace with your repo URL
    subdirectory: "dbt-packages/_DBT_PKG_NAME_"
    revision: v0.1.0___DBT_PKG_NAME_  # Example tag. Replace with your branch, tag, or commit (full 40-character hash)
  ```

### Reflekt resources:
- [GitHub repo](https://github.com/GClunies/Reflekt)
- [Reflekt Docs](https://reflekt-ci.notion.site/Reflekt-Docs-a27c2dd7006b4584b6a451819b09cdb7)

### dbt resources:
- dbt [docs](https://docs.getdbt.com/docs/introduction)
- Docs on dbt [packages](https://docs.getdbt.com/docs/building-a-dbt-project/package-management/)
- dbt [slack & discourse communities](https://community.getdbt.com/)
- dbt [blog](https://blog.getdbt.com/)
