import numpy as np
import json
import uproot as uproot3

_bins = np.arange(0, 10200, 200).tolist()

hists = {}
hists["ttbar"] = {
    "counts": [
        0.0,
        0.0,
        0.0,
        0.0,
        0.3145166039466858,
        7.2418060302734375,
        45.25672912597656,
        134.04141235351562,
        231.0113525390625,
        273.54193115234375,
        296.6809997558594,
        286.7523193359375,
        272.54486083984375,
        211.73052978515625,
        190.4210662841797,
        156.30685424804688,
        119.97146606445312,
        93.86913299560547,
        70.11909484863281,
        56.061134338378906,
        37.198997497558594,
        30.94329071044922,
        20.68305206298828,
        17.785188674926758,
        14.215546607971191,
        7.17054557800293,
        6.651706695556641,
        4.698818683624268,
        3.993070363998413,
        2.641758918762207,
        1.3068435192108154,
        1.3031160831451416,
        0.8138104677200317,
        0.0,
        0.5351243019104004,
        0.08187742531299591,
        0.1506800502538681,
        0.0,
        0.1435033231973648,
        0.0,
        0.0,
        0.06447046995162964,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
    ],
    "bins": _bins,
}
hists["wjets"] = {
    "counts": [
        0.0,
        0.0,
        0.0,
        0.0,
        0.10623589158058167,
        1.7013399600982666,
        18.633102416992188,
        66.14845275878906,
        125.98065185546875,
        185.17539978027344,
        231.74041748046875,
        235.9666290283203,
        218.30909729003906,
        189.5952911376953,
        163.8505401611328,
        146.1702117919922,
        117.85649871826172,
        95.81492614746094,
        74.69441223144531,
        62.39524459838867,
        50.34844207763672,
        39.63264465332031,
        32.3713264465332,
        25.127117156982422,
        22.122390747070312,
        17.041786193847656,
        13.065917015075684,
        9.379816055297852,
        7.743692398071289,
        7.677905559539795,
        4.750833034515381,
        4.233030319213867,
        4.667469501495361,
        2.502551794052124,
        2.3198564052581787,
        1.5924724340438843,
        1.6770440340042114,
        0.969511091709137,
        1.102301836013794,
        0.7128994464874268,
        0.4960392415523529,
        0.37627124786376953,
        0.5317050218582153,
        0.19502437114715576,
        0.10343337059020996,
        0.2804989516735077,
        0.020329751074314117,
        0.01687653735280037,
        0.014217065647244453,
        0.13452327251434326,
    ],
    "bins": _bins,
}
hists["other"] = {
    "counts": [
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        1.6017433404922485,
        12.571949005126953,
        31.072559356689453,
        55.107425689697266,
        73.1304931640625,
        84.36318969726562,
        71.67894744873047,
        70.61822509765625,
        62.37221145629883,
        48.24855041503906,
        34.864646911621094,
        37.766658782958984,
        28.555511474609375,
        21.9793758392334,
        14.759515762329102,
        11.358992576599121,
        8.459224700927734,
        4.990572452545166,
        4.813954830169678,
        3.344588279724121,
        2.642652750015259,
        1.2027652263641357,
        0.5784282684326172,
        1.2299072742462158,
        0.751128077507019,
        0.18134482204914093,
        0.31080135703086853,
        0.49968796968460083,
        0.265651136636734,
        0.5369163155555725,
        0.21403779089450836,
        0.07746481150388718,
        0.04041733965277672,
        0.17663560807704926,
        0.0023117370437830687,
        0.050860557705163956,
        0.0,
        0.0,
        0.0,
        0.04223140701651573,
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
    ],
    "bins": _bins,
}
hists["signal"] = {
    "counts": [
        0.0,
        0.0,
        0.0,
        0.0,
        0.0,
        0.1305842101573944,
        1.8680684566497803,
        5.039996147155762,
        10.908727645874023,
        16.122821807861328,
        19.942882537841797,
        20.3310489654541,
        20.61619758605957,
        19.830669403076172,
        16.36935806274414,
        14.46778678894043,
        12.30238151550293,
        10.680359840393066,
        8.495804786682129,
        6.819866180419922,
        5.613673210144043,
        4.6372199058532715,
        3.0081684589385986,
        2.6621906757354736,
        1.9703816175460815,
        1.5290508270263672,
        1.142599105834961,
        1.1284815073013306,
        0.9037942886352539,
        0.5355855226516724,
        0.2520864009857178,
        0.3385327458381653,
        0.2901037633419037,
        0.15997962653636932,
        0.126237154006958,
        0.07963479310274124,
        0.04193861410021782,
        0.0325426310300827,
        0.03738107904791832,
        0.005638935137540102,
        0.0,
        0.0,
        0.006189885549247265,
        0.0,
        0.0,
        0.0,
        0.010353004559874535,
        0.0,
        0.0,
        0.0,
    ],
    "bins": _bins,
}


def make_data_hist(hists):
    # Make pseudodata from Poisson fluctuaions
    data_hist = []
    for key in hists.keys():
        counts = np.array(hists[key]["counts"])
        data_hist.append(counts + np.random.poisson(np.sqrt(counts)))
    data_hist = np.array(sum(data_hist))

    # If counts less than one then take count as Poisson init
    less_than_one = np.logical_and(data_hist > 0, data_hist <= 1)
    data_hist[np.where(less_than_one)[0]] = np.random.poisson(
        lam=data_hist[less_than_one]
    )
    # As experimental counts need to be integers
    return data_hist.astype(int)


def main():
    np.random.seed(0)

    data_hist = make_data_hist(hists)
    hists["data"] = {"counts": data_hist.tolist(), "bins": _bins}

    with open("example.json", "w") as serialization:
        json.dump(hists, serialization)

    with uproot3.recreate("example.root", compression=uproot3.ZLIB(4)) as outfile:
        for key in hists.keys():
            outfile[key] = (
                np.array(hists[key]["counts"]),
                np.array(hists[key]["bins"]),
            )


if __name__ == "__main__":
    main()
