"use strict";
var _a, _b, _c, _d;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ReactTypeDef = exports.ReactComponent = exports.ReactTypeScriptProject = exports.ReactProject = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const component_1 = require("../component");
const file_1 = require("../file");
const javascript_1 = require("../javascript");
const sample_file_1 = require("../sample-file");
const source_code_1 = require("../source-code");
const typescript_1 = require("../typescript");
const util_1 = require("../util");
/**
 * (experimental) React project without TypeScript.
 *
 * @experimental
 * @pjid react
 */
class ReactProject extends javascript_1.NodeProject {
    /**
     * @experimental
     */
    constructor(options) {
        var _e, _f;
        super({
            jest: false,
            ...options,
        });
        this.srcdir = (_e = options.srcdir) !== null && _e !== void 0 ? _e : 'src';
        new ReactComponent(this, { typescript: false, rewire: options.rewire });
        // generate sample code in `src` and `public` if these directories are empty or non-existent.
        if ((_f = options.sampleCode) !== null && _f !== void 0 ? _f : true) {
            new ReactSampleCode(this, {
                fileExt: 'jsx',
                srcdir: this.srcdir,
            });
            new sample_file_1.SampleDir(this, 'public', { sourceDir: path.join(__dirname, '..', '..', 'assets', 'web', 'react') });
        }
    }
}
exports.ReactProject = ReactProject;
_a = JSII_RTTI_SYMBOL_1;
ReactProject[_a] = { fqn: "projen.web.ReactProject", version: "0.40.2" };
/**
 * (experimental) React project with TypeScript.
 *
 * @experimental
 * @pjid react-ts
 */
class ReactTypeScriptProject extends typescript_1.TypeScriptAppProject {
    /**
     * @experimental
     */
    constructor(options) {
        var _e, _f, _g;
        const defaultOptions = {
            srcdir: 'src',
            eslint: false,
            jest: false,
            tsconfig: {
                include: ['src'],
                compilerOptions: {
                    target: 'es5',
                    lib: [
                        'dom',
                        'dom.iterable',
                        'esnext',
                    ],
                    allowJs: true,
                    skipLibCheck: true,
                    esModuleInterop: true,
                    allowSyntheticDefaultImports: true,
                    strict: true,
                    forceConsistentCasingInFileNames: true,
                    noFallthroughCasesInSwitch: true,
                    module: 'esnext',
                    moduleResolution: javascript_1.TypeScriptModuleResolution.NODE,
                    resolveJsonModule: true,
                    isolatedModules: true,
                    noEmit: true,
                    jsx: javascript_1.TypeScriptJsxMode.REACT_JSX,
                },
            },
            typescriptVersion: (_e = options.typescriptVersion) !== null && _e !== void 0 ? _e : '^4.0.3',
        };
        // never generate default TypeScript sample code, since this class provides its own
        super(util_1.deepMerge([defaultOptions, options, { sampleCode: false }]));
        this.srcdir = (_f = options.srcdir) !== null && _f !== void 0 ? _f : 'src';
        new ReactComponent(this, { typescript: true, rewire: options.rewire });
        this.reactTypeDef = new ReactTypeDef(this, 'react-app-env.d.ts');
        // generate sample code in `src` and `public` if these directories are empty or non-existent.
        if ((_g = options.sampleCode) !== null && _g !== void 0 ? _g : true) {
            new ReactSampleCode(this, {
                fileExt: 'tsx',
                srcdir: this.srcdir,
            });
            new sample_file_1.SampleDir(this, 'public', { sourceDir: path.join(__dirname, '..', '..', 'assets', 'web', 'react') });
        }
    }
}
exports.ReactTypeScriptProject = ReactTypeScriptProject;
_b = JSII_RTTI_SYMBOL_1;
ReactTypeScriptProject[_b] = { fqn: "projen.web.ReactTypeScriptProject", version: "0.40.2" };
/**
 * @experimental
 */
class ReactComponent extends component_1.Component {
    /**
     * @experimental
     */
    constructor(project, options) {
        var _e, _f, _g;
        super(project);
        this.typescript = (_e = options.typescript) !== null && _e !== void 0 ? _e : false;
        // No compile for react app
        project.compileTask.reset();
        project.addDeps('react', 'react-dom', 'react-scripts@^4.0.0', 'web-vitals');
        project.addDevDeps('@testing-library/jest-dom', '@testing-library/react', '@testing-library/user-event');
        if (this.typescript) {
            project.addDevDeps('@types/jest', '@types/react', '@types/react-dom');
        }
        const rewire = (_f = options.rewire) !== null && _f !== void 0 ? _f : false;
        if (rewire) {
            const overridesPath = '.projen/react-config-overrides.js';
            project.addDevDeps('react-app-rewired');
            project.addFields({ 'config-overrides-path': overridesPath });
            const configOverrides = new source_code_1.SourceCode(this.project, overridesPath);
            configOverrides.line(`// ${file_1.FileBase.PROJEN_MARKER}`);
            configOverrides.line('/**');
            configOverrides.line(' * Override CRA configuration without needing to eject.');
            configOverrides.line(' *');
            configOverrides.line(' * @see https://www.npmjs.com/package/react-app-rewired');
            configOverrides.line(' */');
            configOverrides.open('module.exports = function override(config, env) {');
            for (const [key, value] of Object.entries(rewire)) {
                configOverrides.line(`config.${key} = ${JSON.stringify(value)};`);
            }
            configOverrides.line('return config;');
            configOverrides.close('};');
        }
        const reactScripts = rewire ? 'react-app-rewired' : 'react-scripts';
        // Create React App CLI commands, see: https://create-react-app.dev/docs/available-scripts/
        project.addTask('dev', {
            description: 'Starts the react application',
            exec: `${reactScripts} start`,
        });
        project.compileTask.exec(`${reactScripts} build`);
        project.addTask('eject', {
            description: 'Ejects your React application from react-scripts',
            // eject is not necessary to rewire
            exec: 'react-scripts eject',
        });
        project.testTask.exec(`${reactScripts} test --watchAll=false`);
        const testWatch = project.tasks.tryFind('test:watch');
        testWatch === null || testWatch === void 0 ? void 0 : testWatch.reset(`${reactScripts} test`);
        (_g = project.npmignore) === null || _g === void 0 ? void 0 : _g.exclude('# Build', '/build/');
        project.gitignore.exclude('# Build', '/build/');
        project.package.addField('eslintConfig', {
            extends: [
                'react-app',
                'react-app/jest',
            ],
        });
        project.package.addField('browserslist', {
            production: [
                '>0.2%',
                'not dead',
                'not op_mini all',
            ],
            development: [
                'last 1 chrome version',
                'last 1 firefox version',
                'last 1 safari version',
            ],
        });
    }
}
exports.ReactComponent = ReactComponent;
_c = JSII_RTTI_SYMBOL_1;
ReactComponent[_c] = { fqn: "projen.web.ReactComponent", version: "0.40.2" };
class ReactSampleCode extends component_1.Component {
    constructor(project, options) {
        var _e;
        super(project);
        this.fileExt = (_e = options.fileExt) !== null && _e !== void 0 ? _e : 'jsx';
        this.srcdir = options.srcdir;
        const logoSvg = [
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 841.9 595.3">',
            '    <g fill="#61DAFB">',
            '        <path d="M666.3 296.5c0-32.5-40.7-63.3-103.1-82.4 14.4-63.6 8-114.2-20.2-130.4-6.5-3.8-14.1-5.6-22.4-5.6v22.3c4.6 0 8.3.9 11.4 2.6 13.6 7.8 19.5 37.5 14.9 75.7-1.1 9.4-2.9 19.3-5.1 29.4-19.6-4.8-41-8.5-63.5-10.9-13.5-18.5-27.5-35.3-41.6-50 32.6-30.3 63.2-46.9 84-46.9V78c-27.5 0-63.5 19.6-99.9 53.6-36.4-33.8-72.4-53.2-99.9-53.2v22.3c20.7 0 51.4 16.5 84 46.6-14 14.7-28 31.4-41.3 49.9-22.6 2.4-44 6.1-63.6 11-2.3-10-4-19.7-5.2-29-4.7-38.2 1.1-67.9 14.6-75.8 3-1.8 6.9-2.6 11.5-2.6V78.5c-8.4 0-16 1.8-22.6 5.6-28.1 16.2-34.4 66.7-19.9 130.1-62.2 19.2-102.7 49.9-102.7 82.3 0 32.5 40.7 63.3 103.1 82.4-14.4 63.6-8 114.2 20.2 130.4 6.5 3.8 14.1 5.6 22.5 5.6 27.5 0 63.5-19.6 99.9-53.6 36.4 33.8 72.4 53.2 99.9 53.2 8.4 0 16-1.8 22.6-5.6 28.1-16.2 34.4-66.7 19.9-130.1 62-19.1 102.5-49.9 102.5-82.3zm-130.2-66.7c-3.7 12.9-8.3 26.2-13.5 39.5-4.1-8-8.4-16-13.1-24-4.6-8-9.5-15.8-14.4-23.4 14.2 2.1 27.9 4.7 41 7.9zm-45.8 106.5c-7.8 13.5-15.8 26.3-24.1 38.2-14.9 1.3-30 2-45.2 2-15.1 0-30.2-.7-45-1.9-8.3-11.9-16.4-24.6-24.2-38-7.6-13.1-14.5-26.4-20.8-39.8 6.2-13.4 13.2-26.8 20.7-39.9 7.8-13.5 15.8-26.3 24.1-38.2 14.9-1.3 30-2 45.2-2 15.1 0 30.2.7 45 1.9 8.3 11.9 16.4 24.6 24.2 38 7.6 13.1 14.5 26.4 20.8 39.8-6.3 13.4-13.2 26.8-20.7 39.9zm32.3-13c5.4 13.4 10 26.8 13.8 39.8-13.1 3.2-26.9 5.9-41.2 8 4.9-7.7 9.8-15.6 14.4-23.7 4.6-8 8.9-16.1 13-24.1zM421.2 430c-9.3-9.6-18.6-20.3-27.8-32 9 .4 18.2.7 27.5.7 9.4 0 18.7-.2 27.8-.7-9 11.7-18.3 22.4-27.5 32zm-74.4-58.9c-14.2-2.1-27.9-4.7-41-7.9 3.7-12.9 8.3-26.2 13.5-39.5 4.1 8 8.4 16 13.1 24 4.7 8 9.5 15.8 14.4 23.4zM420.7 163c9.3 9.6 18.6 20.3 27.8 32-9-.4-18.2-.7-27.5-.7-9.4 0-18.7.2-27.8.7 9-11.7 18.3-22.4 27.5-32zm-74 58.9c-4.9 7.7-9.8 15.6-14.4 23.7-4.6 8-8.9 16-13 24-5.4-13.4-10-26.8-13.8-39.8 13.1-3.1 26.9-5.8 41.2-7.9zm-90.5 125.2c-35.4-15.1-58.3-34.9-58.3-50.6 0-15.7 22.9-35.6 58.3-50.6 8.6-3.7 18-7 27.7-10.1 5.7 19.6 13.2 40 22.5 60.9-9.2 20.8-16.6 41.1-22.2 60.6-9.9-3.1-19.3-6.5-28-10.2zM310 490c-13.6-7.8-19.5-37.5-14.9-75.7 1.1-9.4 2.9-19.3 5.1-29.4 19.6 4.8 41 8.5 63.5 10.9 13.5 18.5 27.5 35.3 41.6 50-32.6 30.3-63.2 46.9-84 46.9-4.5-.1-8.3-1-11.3-2.7zm237.2-76.2c4.7 38.2-1.1 67.9-14.6 75.8-3 1.8-6.9 2.6-11.5 2.6-20.7 0-51.4-16.5-84-46.6 14-14.7 28-31.4 41.3-49.9 22.6-2.4 44-6.1 63.6-11 2.3 10.1 4.1 19.8 5.2 29.1zm38.5-66.7c-8.6 3.7-18 7-27.7 10.1-5.7-19.6-13.2-40-22.5-60.9 9.2-20.8 16.6-41.1 22.2-60.6 9.9 3.1 19.3 6.5 28.1 10.2 35.4 15.1 58.3 34.9 58.3 50.6-.1 15.7-23 35.6-58.4 50.6zM320.8 78.4z"/>',
            '        <circle cx="420.9" cy="296.5" r="45.7"/>',
            '        <path d="M520.5 78.1z"/>',
            '    </g>',
            '</svg>',
            '',
        ];
        const appJsx = [
            "import logo from './logo.svg';",
            "import './App.css'",
            '',
            'function App() {',
            '  return (',
            '   <div className="App">',
            '      <header className="App-header">',
            '        <img src={logo} className="App-logo" alt="logo" />',
            '        <p>',
            `          Edit <code>src/App.${this.fileExt}</code> and save to reload.`,
            '        </p>',
            '        <a className="App-link"',
            '          href="https://reactjs.org"',
            '          target="_blank"',
            '          rel="noopener noreferrer"',
            '        >',
            '          Learn React',
            '        </a>',
            '      </header>',
            '    </div>',
            '  );',
            '}',
            '',
            'export default App;',
            '',
        ];
        const appCss = [
            '.App {',
            '  text-align: center;',
            '}',
            '',
            '.App-logo {',
            '  height: 40vmin;',
            '  pointer-events: none;',
            '}',
            '',
            '@media (prefers-reduced-motion: no-preference) {',
            '  .App-logo {',
            '    animation: App-logo-spin infinite 20s linear;',
            '  }',
            '}',
            '',
            '.App-header {',
            '  background-color: #282c34;',
            '  min-height: 100vh;',
            '  display: flex;',
            '  flex-direction: column;',
            '  align-items: center;',
            '  justify-content: center;',
            '  font-size: calc(10px + 2vmin);',
            '  color: white;',
            '}',
            '',
            '.App-link {',
            '  color: #61dafb;',
            '}',
            '',
            '@keyframes App-logo-spin {',
            '  from {',
            '    transform: rotate(0deg);',
            '  }',
            '  to {',
            '    transform: rotate(360deg);',
            '  }',
            '}',
            '',
        ];
        const appTestJsx = [
            "import React from 'react';",
            "import { render, screen } from '@testing-library/react';",
            "import App from './App';",
            '',
            "test('renders learn react link', () => {",
            '  render(<App />);',
            '  const linkElement = screen.getByText(/learn react/i);',
            '  expect(linkElement).toBeInTheDocument();',
            '});',
            '',
        ];
        const indexJsx = [
            "import React from 'react';",
            "import ReactDOM from 'react-dom';",
            "import './index.css';",
            "import App from './App';",
            "import reportWebVitals from './reportWebVitals';",
            '',
            'ReactDOM.render(',
            '  <React.StrictMode>',
            '    <App />',
            '  </React.StrictMode>,',
            "  document.getElementById('root')",
            ');',
            '',
            '// If you want to start measuring performance in your app, pass a function',
            '// to log results (for example: reportWebVitals(console.log))',
            '// or send to an analytics endpoint. Learn more: https://bit.ly/CRA-vitals',
            'reportWebVitals();',
            '',
        ];
        const indexCss = [
            'body {',
            '  margin: 0;',
            "  font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', 'Roboto', 'Oxygen',",
            "    'Ubuntu', 'Cantarell', 'Fira Sans', 'Droid Sans', 'Helvetica Neue',",
            '    sans-serif;',
            '  -webkit-font-smoothing: antialiased;',
            '  -moz-osx-font-smoothing: grayscale;',
            '}',
            '',
            'code {',
            "  font-family: source-code-pro, Menlo, Monaco, Consolas, 'Courier New',",
            '    monospace;',
            '}',
            '',
        ];
        const reportWebVitalsJs = [
            "import { ReportHandler } from 'web-vitals';",
            '',
            'const reportWebVitals = (onPerfEntry?: ReportHandler) => {',
            '  if (onPerfEntry && onPerfEntry instanceof Function) {',
            "    import('web-vitals').then(({ getCLS, getFID, getFCP, getLCP, getTTFB }) => {",
            '      getCLS(onPerfEntry);',
            '      getFID(onPerfEntry);',
            '      getFCP(onPerfEntry);',
            '      getLCP(onPerfEntry);',
            '      getTTFB(onPerfEntry);',
            '    });',
            '  }',
            '}',
            '',
            'export default reportWebVitals;',
        ];
        const setupTestsJs = [
            '// jest-dom adds custom jest matchers for asserting on DOM nodes.',
            '// allows you to do things like:',
            '// expect(element).toHaveTextContent(/react/i)',
            '// learn more: https://github.com/testing-library/jest-dom',
            "import '@testing-library/jest-dom';",
            '',
        ];
        // js/ts not jsx/tsx
        const fileExtWithoutX = this.fileExt.replace('x', '');
        new sample_file_1.SampleDir(project, this.srcdir, {
            files: {
                'logo.svg': logoSvg.join('\n'),
                ['App.' + this.fileExt]: appJsx.join('\n'),
                ['App.test.' + this.fileExt]: appTestJsx.join('\n'),
                'App.css': appCss.join('\n'),
                ['index.' + this.fileExt]: indexJsx.join('\n'),
                'index.css': indexCss.join('\n'),
                ['reportWebVitals.' + fileExtWithoutX]: reportWebVitalsJs.join('\n'),
                ['setupTests.' + fileExtWithoutX]: setupTestsJs.join('\n'),
            },
        });
    }
}
/**
 * @experimental
 */
class ReactTypeDef extends file_1.FileBase {
    /**
     * @experimental
     */
    constructor(project, filePath, options = {}) {
        super(project, filePath, options);
    }
    /**
     * (experimental) Implemented by derived classes and returns the contents of the file to emit.
     *
     * @experimental
     */
    synthesizeContent(_) {
        return [
            '/// <reference types="react-scripts" />',
        ].join('\n');
    }
}
exports.ReactTypeDef = ReactTypeDef;
_d = JSII_RTTI_SYMBOL_1;
ReactTypeDef[_d] = { fqn: "projen.web.ReactTypeDef", version: "0.40.2" };
//# sourceMappingURL=data:application/json;base64,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