"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.mergeTsconfigOptions = exports.TypeScriptLibraryProject = exports.TypeScriptAppProject = exports.TypeScriptProject = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const common_1 = require("../common");
const component_1 = require("../component");
const javascript_1 = require("../javascript");
const sample_file_1 = require("../sample-file");
const textfile_1 = require("../textfile");
const typescript_1 = require("../typescript");
/**
 * (experimental) TypeScript project.
 *
 * @experimental
 * @pjid typescript
 */
class TypeScriptProject extends javascript_1.NodeProject {
    /**
     * @experimental
     */
    constructor(options) {
        var _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s, _t, _u, _v, _w, _x, _y, _z, _0, _1, _2, _3;
        super({
            ...options,
            // disable .projenrc.js if typescript is enabled
            projenrcJs: options.projenrcTs ? false : options.projenrcJs,
            jestOptions: {
                ...options.jestOptions,
                jestConfig: {
                    ...(_d = options.jestOptions) === null || _d === void 0 ? void 0 : _d.jestConfig,
                    testMatch: [],
                },
            },
        });
        this.srcdir = (_e = options.srcdir) !== null && _e !== void 0 ? _e : 'src';
        this.libdir = (_f = options.libdir) !== null && _f !== void 0 ? _f : 'lib';
        this.docgen = options.docgen;
        this.docsDirectory = (_g = options.docsDirectory) !== null && _g !== void 0 ? _g : 'docs/';
        this.compileTask.exec('tsc --build');
        this.watchTask = this.addTask('watch', {
            description: 'Watch & compile in the background',
            exec: 'tsc --build -w',
        });
        this.testdir = (_h = options.testdir) !== null && _h !== void 0 ? _h : 'test';
        this.gitignore.include(`/${this.testdir}/`);
        (_j = this.npmignore) === null || _j === void 0 ? void 0 : _j.exclude(`/${this.testdir}/`);
        // if the test directory is under `src/`, then we will run our tests against
        // the javascript files and not let jest compile it for us.
        const compiledTests = this.testdir.startsWith(this.srcdir + path.posix.sep);
        if ((_k = options.package) !== null && _k !== void 0 ? _k : true) {
            this.packageTask.exec('mkdir -p dist/js');
            this.packageTask.exec(`${this.package.packageManager} pack`);
            this.packageTask.exec('mv *.tgz dist/js/');
        }
        if (options.entrypointTypes || this.entrypoint !== '') {
            const entrypointTypes = (_l = options.entrypointTypes) !== null && _l !== void 0 ? _l : `${path.join(path.dirname(this.entrypoint), path.basename(this.entrypoint, '.js')).replace(/\\/g, '/')}.d.ts`;
            this.package.addField('types', entrypointTypes);
        }
        const compilerOptionDefaults = {
            alwaysStrict: true,
            declaration: true,
            esModuleInterop: true,
            experimentalDecorators: true,
            inlineSourceMap: true,
            inlineSources: true,
            lib: ['es2019'],
            module: 'CommonJS',
            noEmitOnError: false,
            noFallthroughCasesInSwitch: true,
            noImplicitAny: true,
            noImplicitReturns: true,
            noImplicitThis: true,
            noUnusedLocals: true,
            noUnusedParameters: true,
            resolveJsonModule: true,
            strict: true,
            strictNullChecks: true,
            strictPropertyInitialization: true,
            stripInternal: true,
            target: 'ES2019',
        };
        if (!options.disableTsconfig) {
            this.tsconfig = new javascript_1.TypescriptConfig(this, mergeTsconfigOptions({
                include: [`${this.srcdir}/**/*.ts`],
                // exclude: ['node_modules'], // TODO: shouldn't we exclude node_modules?
                compilerOptions: {
                    rootDir: this.srcdir,
                    outDir: this.libdir,
                    ...compilerOptionDefaults,
                },
            }, options.tsconfig));
        }
        const tsconfigDevFile = (_m = options.tsconfigDevFile) !== null && _m !== void 0 ? _m : 'tsconfig.dev.json';
        this.tsconfigDev = new javascript_1.TypescriptConfig(this, mergeTsconfigOptions({
            fileName: tsconfigDevFile,
            include: [
                common_1.PROJEN_RC,
                `${this.srcdir}/**/*.ts`,
                `${this.testdir}/**/*.ts`,
            ],
            exclude: ['node_modules'],
            compilerOptions: compilerOptionDefaults,
        }, options.tsconfig, options.tsconfigDev));
        this.gitignore.include(`/${this.srcdir}/`);
        (_o = this.npmignore) === null || _o === void 0 ? void 0 : _o.exclude(`/${this.srcdir}/`);
        if (this.srcdir !== this.libdir) {
            // separated, can ignore the entire libdir
            this.gitignore.exclude(`/${this.libdir}`);
        }
        else {
            // collocated, can only ignore the compiled output
            this.gitignore.exclude(`/${this.libdir}/**/*.js`);
            this.gitignore.exclude(`/${this.libdir}/**/*.d.ts`);
        }
        (_p = this.npmignore) === null || _p === void 0 ? void 0 : _p.include(`/${this.libdir}/`);
        (_q = this.npmignore) === null || _q === void 0 ? void 0 : _q.include(`/${this.libdir}/**/*.js`);
        (_r = this.npmignore) === null || _r === void 0 ? void 0 : _r.include(`/${this.libdir}/**/*.d.ts`);
        this.gitignore.exclude('/dist/');
        (_s = this.npmignore) === null || _s === void 0 ? void 0 : _s.exclude('dist'); // jsii-pacmak expects this to be "dist" and not "/dist". otherwise it will tamper with it
        (_t = this.npmignore) === null || _t === void 0 ? void 0 : _t.exclude('/tsconfig.json');
        (_u = this.npmignore) === null || _u === void 0 ? void 0 : _u.exclude('/.github/');
        (_v = this.npmignore) === null || _v === void 0 ? void 0 : _v.exclude('/.vscode/');
        (_w = this.npmignore) === null || _w === void 0 ? void 0 : _w.exclude('/.idea/');
        (_x = this.npmignore) === null || _x === void 0 ? void 0 : _x.exclude('/.projenrc.js');
        (_y = this.npmignore) === null || _y === void 0 ? void 0 : _y.exclude('tsconfig.tsbuildinfo');
        // tests are compiled to `lib/TESTDIR`, so we don't need jest to compile them for us.
        // just run them directly from javascript.
        if (this.jest && compiledTests) {
            this.addDevDeps('@types/jest');
            const testout = path.posix.relative(this.srcdir, this.testdir);
            const libtest = path.posix.join(this.libdir, testout);
            const srctest = this.testdir;
            (_z = this.npmignore) === null || _z === void 0 ? void 0 : _z.exclude(`/${libtest}/`);
            this.jest.addTestMatch(`**/${libtest}/**/?(*.)+(spec|test).js?(x)`);
            this.jest.addWatchIgnorePattern(`/${this.srcdir}/`);
            const resolveSnapshotPath = (test, ext) => {
                const fullpath = test.replace(libtest, srctest);
                return path.join(path.dirname(fullpath), '__snapshots__', path.basename(fullpath, '.js') + '.ts' + ext);
            };
            const resolveTestPath = (snap, ext) => {
                const filename = path.basename(snap, '.ts' + ext) + '.js';
                const dir = path.dirname(path.dirname(snap)).replace(srctest, libtest);
                return path.join(dir, filename);
            };
            const resolver = new textfile_1.TextFile(this, path.posix.join(common_1.PROJEN_DIR, 'jest-snapshot-resolver.js'));
            resolver.addLine(`// ${textfile_1.TextFile.PROJEN_MARKER}`);
            resolver.addLine('const path = require("path");');
            resolver.addLine(`const libtest = "${libtest}";`);
            resolver.addLine(`const srctest= "${srctest}";`);
            resolver.addLine('module.exports = {');
            resolver.addLine(`  resolveSnapshotPath: ${resolveSnapshotPath.toString()},`);
            resolver.addLine(`  resolveTestPath: ${resolveTestPath.toString()},`);
            resolver.addLine('  testPathForConsistencyCheck: path.join(\'some\', \'__tests__\', \'example.test.js\')');
            resolver.addLine('};');
            this.jest.addSnapshotResolver(`./${resolver.path}`);
        }
        if (this.jest && !compiledTests) {
            this.jest.addTestMatch('**\/__tests__/**\/*.ts?(x)');
            this.jest.addTestMatch('**\/?(*.)+(spec|test).ts?(x)');
            // create a tsconfig for jest that does NOT include outDir and rootDir and
            // includes both "src" and "test" as inputs.
            this.jest.addTypeScriptSupport(this.tsconfigDev);
        }
        if ((_0 = options.eslint) !== null && _0 !== void 0 ? _0 : true) {
            this.eslint = new javascript_1.Eslint(this, {
                tsconfigPath: `./${this.tsconfigDev.fileName}`,
                dirs: [this.srcdir],
                devdirs: [this.testdir, 'build-tools'],
                fileExtensions: ['.ts', '.tsx'],
                ...options.eslintOptions,
            });
            this.tsconfigEslint = this.tsconfigDev;
        }
        const tsver = options.typescriptVersion ? `@${options.typescriptVersion}` : '';
        this.addDevDeps(`typescript${tsver}`, `@types/node@^${(_1 = this.package.minNodeVersion) !== null && _1 !== void 0 ? _1 : '14.17.0'}`);
        // generate sample code in `src` and `lib` if these directories are empty or non-existent.
        if ((_2 = options.sampleCode) !== null && _2 !== void 0 ? _2 : true) {
            new SampleCode(this);
        }
        if (this.docgen) {
            new typescript_1.TypedocDocgen(this);
        }
        const projenrcTypeScript = (_3 = options.projenrcTs) !== null && _3 !== void 0 ? _3 : false;
        if (projenrcTypeScript) {
            new typescript_1.Projenrc(this, options.projenrcTsOptions);
        }
    }
}
exports.TypeScriptProject = TypeScriptProject;
_a = JSII_RTTI_SYMBOL_1;
TypeScriptProject[_a] = { fqn: "projen.typescript.TypeScriptProject", version: "0.40.2" };
class SampleCode extends component_1.Component {
    constructor(project) {
        super(project);
        const srcCode = [
            'export class Hello {',
            '  public sayHello() {',
            '    return \'hello, world!\';',
            '  }',
            '}',
        ].join('\n');
        const testCode = [
            "import { Hello } from '../src';",
            '',
            "test('hello', () => {",
            "  expect(new Hello().sayHello()).toBe('hello, world!');",
            '});',
        ].join('\n');
        new sample_file_1.SampleDir(project, project.srcdir, {
            files: {
                'index.ts': srcCode,
            },
        });
        new sample_file_1.SampleDir(project, project.testdir, {
            files: {
                'hello.test.ts': testCode,
            },
        });
    }
}
/**
 * (experimental) TypeScript app.
 *
 * @experimental
 * @pjid typescript-app
 */
class TypeScriptAppProject extends TypeScriptProject {
    /**
     * @experimental
     */
    constructor(options) {
        super({
            allowLibraryDependencies: false,
            releaseWorkflow: false,
            entrypoint: '',
            package: false,
            ...options,
        });
    }
}
exports.TypeScriptAppProject = TypeScriptAppProject;
_b = JSII_RTTI_SYMBOL_1;
TypeScriptAppProject[_b] = { fqn: "projen.typescript.TypeScriptAppProject", version: "0.40.2" };
/**
 * @deprecated use `TypeScriptProject`
 */
class TypeScriptLibraryProject extends TypeScriptProject {
}
exports.TypeScriptLibraryProject = TypeScriptLibraryProject;
_c = JSII_RTTI_SYMBOL_1;
TypeScriptLibraryProject[_c] = { fqn: "projen.typescript.TypeScriptLibraryProject", version: "0.40.2" };
;
/**
 * @internal
 */
function mergeTsconfigOptions(...options) {
    const definedOptions = options.filter(Boolean);
    return definedOptions.reduce((previous, current) => {
        var _d, _e, _f, _g;
        return ({
            ...previous,
            ...current,
            include: [
                ...(_d = previous.include) !== null && _d !== void 0 ? _d : [],
                ...(_e = current.include) !== null && _e !== void 0 ? _e : [],
            ],
            exclude: [
                ...(_f = previous.exclude) !== null && _f !== void 0 ? _f : [],
                ...(_g = current.exclude) !== null && _g !== void 0 ? _g : [],
            ],
            compilerOptions: {
                ...previous.compilerOptions,
                ...current.compilerOptions,
            },
        });
    }, { compilerOptions: {} });
}
exports.mergeTsconfigOptions = mergeTsconfigOptions;
//# sourceMappingURL=data:application/json;base64,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