"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Tasks = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const common_1 = require("./common");
const component_1 = require("./component");
const json_1 = require("./json");
const task_1 = require("./task");
/**
 * (experimental) Defines project tasks.
 *
 * Tasks extend the projen CLI by adding subcommands to it. Task definitions are
 * synthesized into `.projen/tasks.json`.
 *
 * @experimental
 */
class Tasks extends component_1.Component {
    /**
     * @experimental
     */
    constructor(project) {
        super(project);
        const manifestFile = Tasks.MANIFEST_FILE;
        this._tasks = {};
        this._env = {};
        new json_1.JsonFile(project, manifestFile, {
            omitEmpty: true,
            obj: {
                tasks: (() => this.renderTasks()),
                env: (() => this._env),
            },
        });
    }
    /**
     * (experimental) All tasks.
     *
     * @experimental
     */
    get all() {
        return Object.values(this._tasks);
    }
    /**
     * (experimental) Adds a task to a project.
     *
     * @param name The name of the task.
     * @param options Task options.
     * @experimental
     */
    addTask(name, options = {}) {
        const task = new task_1.Task(name, options);
        if (this._tasks[name]) {
            throw new Error(`A task with the name ${name} already exists. To override it, call removeTask first and then create the new task.`);
        }
        this._tasks[name] = task;
        return task;
    }
    /**
     * (experimental) Removes a task from a project.
     *
     * @param name The name of the task to remove.
     * @returns The `Task` that was removed, otherwise `undefined`.
     * @experimental
     */
    removeTask(name) {
        const dependentTasks = this.all.filter(task => task.steps.find(step => step.spawn == name));
        if (dependentTasks.length > 0) {
            const errList = dependentTasks.map(depTask => depTask.name).join(', ');
            throw new Error(`Unable to remove task "${name}" because the following tasks depend on it: ${errList}`);
        }
        const task = this._tasks[name];
        if (task) {
            delete this._tasks[name];
            return task;
        }
        else {
            return undefined;
        }
    }
    /**
     * (experimental) Adds global environment.
     *
     * @param name Environment variable name.
     * @param value Value.
     * @experimental
     */
    addEnvironment(name, value) {
        this._env[name] = value;
    }
    /**
     * (experimental) Returns a copy of the currently global environment for this project.
     *
     * @experimental
     */
    get env() {
        return {
            ...this._env,
        };
    }
    /**
     * (experimental) Finds a task by name.
     *
     * Returns `undefined` if the task cannot be found.
     *
     * @param name The name of the task.
     * @experimental
     */
    tryFind(name) {
        return this._tasks[name];
    }
    renderTasks() {
        const tasks = {};
        for (const task of Object.values(this._tasks).sort((x, y) => x.name.localeCompare(y.name))) {
            tasks[task.name] = task._renderSpec();
        }
        return tasks;
    }
}
exports.Tasks = Tasks;
_a = JSII_RTTI_SYMBOL_1;
Tasks[_a] = { fqn: "projen.Tasks", version: "0.40.2" };
/**
 * (experimental) The project-relative path of the tasks manifest file.
 *
 * @experimental
 */
Tasks.MANIFEST_FILE = path.posix.join(common_1.PROJEN_DIR, 'tasks.json');
//# sourceMappingURL=data:application/json;base64,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