"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Prepends the release changelog entry onto the provided project-level changelog
 *
 * Currently assumes a headerless changelog formatted according to
 * [conventional-changelog](https://github.com/conventional-changelog/conventional-changelog)
 * rules.
 *
 * Environment variables:
 *
 * - VERSION_FILE: Current semantic version file
 * - CHANGELOG_FILE: Release changelog
 * - PROJECT_CHANGELOG_FILE: Project-level changelog
 *
 */
const update_changelog_1 = require("./update-changelog");
const inputChangelog = process.env.CHANGELOG;
const outputChangelog = process.env.PROJECT_CHANGELOG_FILE;
const versionFile = process.env.VERSION_FILE;
if (!versionFile) {
    throw new Error('VERSION_FILE is required');
}
if (!inputChangelog) {
    throw new Error('CHANGELOG is required');
}
if (!outputChangelog) {
    throw new Error('PROJECT_CHANGELOG_FILE is required');
}
const opts = {
    inputChangelog,
    outputChangelog,
    versionFile: versionFile,
};
update_changelog_1.updateChangelog(process.cwd(), opts).catch((e) => {
    console.log(e.stack);
    process.exit(1);
});
//# sourceMappingURL=data:application/json;base64,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