"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ReleaseTrigger = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * (experimental) Used to manage release strategies.
 *
 * This includes release
 * and release artifact automation
 *
 * @experimental
 */
class ReleaseTrigger {
    constructor(options = {}) {
        var _b;
        this.isContinuous = (_b = options.continuous) !== null && _b !== void 0 ? _b : false;
        this.schedule = options.schedule;
        this.changelogPath = options.changelogPath;
        this.gitPushCommand = options.gitPushCommand;
    }
    /**
     * (experimental) Creates a manual release trigger.
     *
     * Use this option if you want totally manual releases.
     *
     * This will give you a release task that, in addition to the normal
     * release activities will trigger a `publish:git` task. This task will
     * handle project-level changelog management, release tagging, and pushing
     * these artifacts to origin.
     *
     * The command used for pushing can be customised by specifying
     * `gitPushCommand`. Set to an empty string to disable pushing entirely.
     *
     * Simply run `yarn release` to trigger a manual release.
     *
     * @param options release options.
     * @experimental
     */
    static manual(options = {}) {
        var _b, _c;
        let changelogPath;
        if ((_b = options.changelog) !== null && _b !== void 0 ? _b : true) {
            changelogPath = (_c = options.changelogPath) !== null && _c !== void 0 ? _c : 'CHANGELOG.md';
        }
        return new ReleaseTrigger({
            changelogPath: changelogPath,
            gitPushCommand: options.gitPushCommand,
        });
    }
    /**
     * (experimental) Creates a scheduled release trigger.
     *
     * Automated releases will occur based on the provided cron schedule.
     *
     * @param options release options.
     * @experimental
     */
    static scheduled(options) {
        return new ReleaseTrigger({
            schedule: options.schedule,
        });
    }
    /**
     * (experimental) Creates a continuous release trigger.
     *
     * Automated releases will occur on every commit.
     *
     * @experimental
     */
    static continuous() {
        return new ReleaseTrigger({
            continuous: true,
        });
    }
    /**
     * (experimental) Whether or not this is a manual release trigger.
     *
     * @experimental
     */
    get isManual() {
        return !(this.isContinuous || this.schedule);
    }
}
exports.ReleaseTrigger = ReleaseTrigger;
_a = JSII_RTTI_SYMBOL_1;
ReleaseTrigger[_a] = { fqn: "projen.release.ReleaseTrigger", version: "0.40.2" };
//# sourceMappingURL=data:application/json;base64,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