/**
 * @experimental
 */
export interface ScheduledReleaseOptions {
    /**
     * (experimental) Cron schedule for releases.
     *
     * Only defined if this is a scheduled release.
     *
     * @experimental
     * @example
     *
     * '0 17 * * *' - every day at 5 pm
     */
    readonly schedule: string;
}
/**
 * @experimental
 */
export interface ManualReleaseOptions {
    /**
     * (experimental) Maintain a project-level changelog.
     *
     * @default true
     * @experimental
     */
    readonly changelog?: boolean;
    /**
     * (experimental) Project-level changelog file path.
     *
     * Ignored if `changelog` is false.
     *
     * @default 'CHANGELOG.md'
     * @experimental
     */
    readonly changelogPath?: string;
    /**
     * (experimental) Override git-push command.
     *
     * Set to an empty string to disable pushing.
     *
     * @experimental
     */
    readonly gitPushCommand?: string;
}
/**
 * (experimental) Used to manage release strategies.
 *
 * This includes release
 * and release artifact automation
 *
 * @experimental
 */
export declare class ReleaseTrigger {
    /**
     * (experimental) Creates a manual release trigger.
     *
     * Use this option if you want totally manual releases.
     *
     * This will give you a release task that, in addition to the normal
     * release activities will trigger a `publish:git` task. This task will
     * handle project-level changelog management, release tagging, and pushing
     * these artifacts to origin.
     *
     * The command used for pushing can be customised by specifying
     * `gitPushCommand`. Set to an empty string to disable pushing entirely.
     *
     * Simply run `yarn release` to trigger a manual release.
     *
     * @param options release options.
     * @experimental
     */
    static manual(options?: ManualReleaseOptions): ReleaseTrigger;
    /**
     * (experimental) Creates a scheduled release trigger.
     *
     * Automated releases will occur based on the provided cron schedule.
     *
     * @param options release options.
     * @experimental
     */
    static scheduled(options: ScheduledReleaseOptions): ReleaseTrigger;
    /**
     * (experimental) Creates a continuous release trigger.
     *
     * Automated releases will occur on every commit.
     *
     * @experimental
     */
    static continuous(): ReleaseTrigger;
    /**
     * (experimental) Project-level changelog file path.
     *
     * @experimental
     */
    readonly changelogPath?: string;
    /**
     * (experimental) Cron schedule for releases.
     *
     * Only defined if this is a scheduled release.
     *
     * @experimental
     * @example
     *
     * '0 17 * * *' - every day at 5 pm
     */
    readonly schedule?: string;
    /**
     * (experimental) Whether or not this is a continuous release.
     *
     * @experimental
     */
    readonly isContinuous: boolean;
    /**
     * (experimental) Override git-push command used when releasing manually.
     *
     * Set to an empty string to disable pushing.
     *
     * @experimental
     */
    readonly gitPushCommand?: string;
    private constructor();
    /**
     * (experimental) Whether or not this is a manual release trigger.
     *
     * @experimental
     */
    get isManual(): boolean;
}
