import { BranchOptions } from '.';
import { Component } from '../component';
import { Job } from '../github/workflows-model';
import { Project } from '../project';
/**
 * (experimental) Options for `Publisher`.
 *
 * @experimental
 */
export interface PublisherOptions {
    /**
     * (experimental) The job ID that produces the build artifacts.
     *
     * All publish jobs will take a dependency on this job.
     *
     * @experimental
     */
    readonly buildJobId: string;
    /**
     * (experimental) A GitHub workflow expression used as a condition for publishers.
     *
     * @default - no condition
     * @experimental
     */
    readonly condition?: string;
    /**
     * (experimental) The name of the artifact to download (e.g. `dist`).
     *
     * The artifact is expected to include a subdirectory for each release target:
     * `go` (GitHub), `dotnet` (NuGet), `java` (Maven), `js` (npm), `python`
     * (PyPI).
     *
     * @see https://github.com/aws/jsii-release
     * @experimental
     */
    readonly artifactName: string;
    /**
     * (experimental) Version requirement for `jsii-release`.
     *
     * @default "latest"
     * @experimental
     */
    readonly jsiiReleaseVersion?: string;
    /**
     * (experimental) Create an issue when a publish task fails.
     *
     * @default false
     * @experimental
     */
    readonly failureIssue?: boolean;
    /**
     * (experimental) The label to apply to the issue marking failed publish tasks.
     *
     * Only applies if `failureIssue` is true.
     *
     * @default "failed-release"
     * @experimental
     */
    readonly failureIssueLabel?: string;
    /**
     * (experimental) Github Runner selection labels.
     *
     * @default ["ubuntu-latest"]
     * @experimental
     */
    readonly workflowRunsOn?: string[];
    /**
     * (experimental) Define publishing tasks that can be executed manually as well as workflows.
     *
     * Normally, publishing only happens within automated workflows. Enable this
     * in order to create a publishing task for each publishing activity.
     *
     * @default false
     * @experimental
     */
    readonly publishTasks?: boolean;
}
/**
 * (experimental) Implements GitHub jobs for publishing modules to package managers.
 *
 * Under the hood, it uses https://github.com/aws/jsii-release
 *
 * @experimental
 */
export declare class Publisher extends Component {
    /**
     * @experimental
     */
    readonly buildJobId: string;
    /**
     * @experimental
     */
    readonly artifactName: string;
    /**
     * @experimental
     */
    readonly jsiiReleaseVersion: string;
    /**
     * @experimental
     */
    readonly condition?: string;
    private readonly failureIssue;
    private readonly failureIssueLabel;
    private readonly runsOn;
    private readonly publishTasks;
    private readonly _jobFactories;
    /**
     * @experimental
     */
    constructor(project: Project, options: PublisherOptions);
    /**
     * Called by `Release` to add the publishing jobs to a release workflow
     * associated with a specific branch.
     * @param branch The branch name
     * @param options Branch options
     *
     * @internal
     */
    _renderJobsForBranch(branch: string, options: Partial<BranchOptions>): Record<string, Job>;
    /**
     * (experimental) Publish to git.
     *
     * This includes generating a project-level changelog and release tags.
     *
     * @param options Options.
     * @experimental
     */
    publishToGit(options: GitPublishOptions): import("..").Task;
    /**
     * (experimental) Creates a GitHub Release.
     *
     * @param options Options.
     * @experimental
     */
    publishToGitHubReleases(options: GitHubReleasesPublishOptions): void;
    /**
     * (experimental) Publishes artifacts from `js/**` to npm.
     *
     * @param options Options.
     * @experimental
     */
    publishToNpm(options?: NpmPublishOptions): void;
    /**
     * (experimental) Publishes artifacts from `dotnet/**` to NuGet Gallery.
     *
     * @param options Options.
     * @experimental
     */
    publishToNuget(options?: NugetPublishOptions): void;
    /**
     * (experimental) Publishes artifacts from `java/**` to Maven.
     *
     * @param options Options.
     * @experimental
     */
    publishToMaven(options?: MavenPublishOptions): void;
    /**
     * (experimental) Publishes wheel artifacts from `python` to PyPI.
     *
     * @param options Options.
     * @experimental
     */
    publishToPyPi(options?: PyPiPublishOptions): void;
    /**
     * (experimental) Adds a go publishing job.
     *
     * @param options Options.
     * @experimental
     */
    publishToGo(options?: GoPublishOptions): void;
    private addPublishJob;
    private jsiiReleaseCommand;
}
/**
 * @deprecated Use `NpmPublishOptions` instead.
 */
export interface JsiiReleaseNpm extends NpmPublishOptions {
}
/**
 * (experimental) Options for npm release.
 *
 * @experimental
 */
export interface NpmPublishOptions {
    /**
     * (deprecated) Tags can be used to provide an alias instead of version numbers.
     *
     * For example, a project might choose to have multiple streams of development
     * and use a different tag for each stream, e.g., stable, beta, dev, canary.
     *
     * By default, the `latest` tag is used by npm to identify the current version
     * of a package, and `npm install <pkg>` (without any `@<version>` or `@<tag>`
     * specifier) installs the latest tag. Typically, projects only use the
     * `latest` tag for stable release versions, and use other tags for unstable
     * versions such as prereleases.
     *
     * The `next` tag is used by some projects to identify the upcoming version.
     *
     * @default "latest"
     * @deprecated Use `npmDistTag` for each release branch instead.
     */
    readonly distTag?: string;
    /**
     * (experimental) The domain name of the npm package registry.
     *
     * To publish to GitHub Packages, set this value to `"npm.pkg.github.com"`. In
     * this if `npmTokenSecret` is not specified, it will default to
     * `GITHUB_TOKEN` which means that you will be able to publish to the
     * repository's package store. In this case, make sure `repositoryUrl` is
     * correctly defined.
     *
     * @default "registry.npmjs.org"
     * @experimental
     * @example
     *
     * "npm.pkg.github.com"
     */
    readonly registry?: string;
    /**
     * (experimental) GitHub secret which contains the NPM token to use when publishing packages.
     *
     * @default - "NPM_TOKEN" or "GITHUB_TOKEN" if `registry` is set to `npm.pkg.github.com`.
     * @experimental
     */
    readonly npmTokenSecret?: string;
    /**
     * (experimental) Options for publishing npm package to AWS CodeArtifact.
     *
     * @default - undefined
     * @experimental
     */
    readonly codeArtifactOptions?: CodeArtifactOptions;
}
/**
 * @experimental
 */
export interface CodeArtifactOptions {
    /**
     * (experimental) GitHub secret which contains the AWS access key ID to use when publishing packages to AWS CodeArtifact.
     *
     * This property must be specified only when publishing to AWS CodeArtifact (`registry` contains AWS CodeArtifact URL).
     *
     * @default "AWS_ACCESS_KEY_ID"
     * @experimental
     */
    readonly accessKeyIdSecret?: string;
    /**
     * (experimental) GitHub secret which contains the AWS secret access key to use when publishing packages to AWS CodeArtifact.
     *
     * This property must be specified only when publishing to AWS CodeArtifact (`registry` contains AWS CodeArtifact URL).
     *
     * @default "AWS_SECRET_ACCESS_KEY"
     * @experimental
     */
    readonly secretAccessKeySecret?: string;
    /**
     * (experimental) ARN of AWS role to be assumed prior to get authorization token from AWS CodeArtifact This property must be specified only when publishing to AWS CodeArtifact (`registry` contains AWS CodeArtifact URL).
     *
     * @default undefined
     * @experimental
     */
    readonly roleToAssume?: string;
}
/**
 * @deprecated Use `PyPiPublishOptions` instead.
 */
export interface JsiiReleasePyPi extends PyPiPublishOptions {
}
/**
 * (experimental) Options for PyPI release.
 *
 * @experimental
 */
export interface PyPiPublishOptions {
    /**
     * (experimental) The registry url to use when releasing packages.
     *
     * @default - twine default
     * @experimental
     */
    readonly twineRegistryUrl?: string;
    /**
     * (experimental) The GitHub secret which contains PyPI user name.
     *
     * @default "TWINE_USERNAME"
     * @experimental
     */
    readonly twineUsernameSecret?: string;
    /**
     * (experimental) The GitHub secret which contains PyPI password.
     *
     * @default "TWINE_PASSWORD"
     * @experimental
     */
    readonly twinePasswordSecret?: string;
}
/**
 * @deprecated Use `NugetPublishOptions` instead.
 */
export interface JsiiReleaseNuget extends NugetPublishOptions {
}
/**
 * (experimental) Options for NuGet releases.
 *
 * @experimental
 */
export interface NugetPublishOptions {
    /**
     * (experimental) GitHub secret which contains the API key for NuGet.
     *
     * @default "NUGET_API_KEY"
     * @experimental
     */
    readonly nugetApiKeySecret?: string;
}
/**
 * @deprecated Use `MavenPublishOptions` instead.
 */
export interface JsiiReleaseMaven extends MavenPublishOptions {
}
/**
 * (experimental) Options for Maven releases.
 *
 * @experimental
 */
export interface MavenPublishOptions {
    /**
     * (experimental) URL of Nexus repository.
     *
     * if not set, defaults to https://oss.sonatype.org
     *
     * @default "https://oss.sonatype.org"
     * @experimental
     */
    readonly mavenEndpoint?: string;
    /**
     * (experimental) Used in maven settings for credential lookup (e.g. use github when publishing to GitHub).
     *
     * @default "ossrh" (Maven Central) or "github" when using GitHub Packages
     * @experimental
     */
    readonly mavenServerId?: string;
    /**
     * (experimental) Deployment repository when not deploying to Maven Central.
     *
     * @default - not set
     * @experimental
     */
    readonly mavenRepositoryUrl?: string;
    /**
     * (experimental) GitHub secret name which contains the GPG private key or file that includes it.
     *
     * This is used to sign your Maven
     * packages. See instructions.
     *
     * @default "MAVEN_GPG_PRIVATE_KEY" or not set when using GitHub Packages
     * @see https://github.com/aws/jsii-release#maven
     * @experimental
     */
    readonly mavenGpgPrivateKeySecret?: string;
    /**
     * (experimental) GitHub secret name which contains the GPG private key or file that includes it.
     *
     * This is used to sign your Maven packages. See instructions.
     *
     * @default "MAVEN_GPG_PRIVATE_KEY_PASSPHRASE" or not set when using GitHub Packages
     * @see https://github.com/aws/jsii-release#maven
     * @experimental
     */
    readonly mavenGpgPrivateKeyPassphrase?: string;
    /**
     * (experimental) GitHub secret name which contains the Username for maven repository.
     *
     * For Maven Central, you will need to Create JIRA account and then request a
     * new project (see links).
     *
     * @default "MAVEN_USERNAME" or the GitHub Actor when using GitHub Packages
     * @see https://issues.sonatype.org/secure/CreateIssue.jspa?issuetype=21&pid=10134
     * @experimental
     */
    readonly mavenUsername?: string;
    /**
     * (experimental) GitHub secret name which contains the Password for maven repository.
     *
     * For Maven Central, you will need to Create JIRA account and then request a
     * new project (see links).
     *
     * @default "MAVEN_PASSWORD" or "GITHUB_TOKEN" when using GitHub Packages
     * @see https://issues.sonatype.org/secure/CreateIssue.jspa?issuetype=21&pid=10134
     * @experimental
     */
    readonly mavenPassword?: string;
    /**
     * (experimental) GitHub secret name which contains the Maven Central (sonatype) staging profile ID (e.g. 68a05363083174). Staging profile ID can be found in the URL of the "Releases" staging profile under "Staging Profiles" in https://oss.sonatype.org (e.g. https://oss.sonatype.org/#stagingProfiles;11a33451234521).
     *
     * @default "MAVEN_STAGING_PROFILE_ID" or not set when using GitHub Packages
     * @experimental
     */
    readonly mavenStagingProfileId?: string;
}
/**
 * @deprecated Use `GoPublishOptions` instead.
 * export interface JsiiReleaseGo extends GoPublishOptions { }
 * /**
 * Options for Go releases.
 */
export interface GoPublishOptions {
    /**
     * (deprecated) The name of the secret that includes a personal GitHub access token used to push to the GitHub repository.
     *
     * @default "GO_GITHUB_TOKEN"
     * @deprecated
     */
    readonly githubTokenSecret?: string;
    /**
     * (deprecated) GitHub repository to push to.
     *
     * @default - derived from `moduleName`
     * @deprecated
     */
    readonly githubRepo?: string;
    /**
     * (deprecated) Branch to push to.
     *
     * @default "main"
     * @deprecated
     */
    readonly gitBranch?: string;
    /**
     * (deprecated) The user name to use for the release git commit.
     *
     * @default "github-actions"
     * @deprecated
     */
    readonly gitUserName?: string;
    /**
     * (deprecated) The email to use in the release git commit.
     *
     * @default "github-actions
     * @deprecated
     * @github .com"
     */
    readonly gitUserEmail?: string;
    /**
     * (deprecated) The commit message.
     *
     * @default "chore(release): $VERSION"
     * @deprecated
     */
    readonly gitCommitMessage?: string;
}
interface VersionArtifactOptions {
    /**
     * (experimental) The location of a text file (relative to `dist/`) that contains the version number.
     *
     * @experimental
     * @example
     *
     * version.txt
     */
    readonly versionFile: string;
    /**
     * (experimental) The location of a text file (relative to `dist/`) that contains the release tag.
     *
     * @experimental
     * @example
     *
     * releasetag.txt
     */
    readonly releaseTagFile: string;
    /**
     * (experimental) The location of an .md file (relative to `dist/`) that includes the changelog for the release.
     *
     * @experimental
     * @example
     *
     * changelog.md
     */
    readonly changelogFile: string;
}
/**
 * Evaluates if the `registryUrl` is a AWS CodeArtifact registry.
 * @param registryUrl url of registry
 * @returns true for AWS CodeArtifact
 */
export declare function isAwsCodeArtifactRegistry(registryUrl: string | undefined): boolean | "" | undefined;
/**
 * (experimental) Publishing options for GitHub releases.
 *
 * @experimental
 */
export interface GitHubReleasesPublishOptions extends VersionArtifactOptions {
}
/**
 * (experimental) Publishing options for Git releases.
 *
 * @experimental
 */
export interface GitPublishOptions extends VersionArtifactOptions {
    /**
     * (experimental) The location of an .md file that includes the project-level changelog.
     *
     * @experimental
     */
    readonly projectChangelogFile?: string;
    /**
     * (experimental) Branch to push to.
     *
     * @default "main"
     * @experimental
     */
    readonly gitBranch?: string;
    /**
     * (experimental) Override git-push command.
     *
     * Set to an empty string to disable pushing.
     *
     * @experimental
     */
    readonly gitPushCommand?: string;
}
export {};
