"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RequirementsFile = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const dependencies_1 = require("../dependencies");
const file_1 = require("../file");
const semver_1 = require("../util/semver");
/**
 * (experimental) Specifies a list of packages to be installed using pip.
 *
 * @see https://pip.pypa.io/en/stable/reference/pip_install/#requirements-file-format
 * @experimental
 */
class RequirementsFile extends file_1.FileBase {
    /**
     * @experimental
     */
    constructor(project, filePath, options) {
        super(project, filePath);
        this.packages = new Array();
        this.packageProvider = options.packageProvider;
    }
    /**
     * (experimental) Adds the specified packages provided in semver format.
     *
     * Comment lines (start with `#`) are ignored.
     *
     * @param packages Package version in format `<module>@<semver>`.
     * @experimental
     */
    addPackages(...packages) {
        for (let pkg of packages) {
            if (pkg.startsWith('#')) {
                this.packages.push(pkg);
            }
            else {
                const { name, version } = dependencies_1.Dependencies.parseDependency(pkg);
                if (version) {
                    this.packages.push(`${name}${semver_1.toPythonVersionRange(version)}`);
                }
                else {
                    this.packages.push(name);
                }
            }
        }
    }
    formatDependency(dep) {
        if (dep.version) {
            return `${dep.name}${semver_1.toPythonVersionRange(dep.version)}`;
        }
        else {
            return dep.name;
        }
    }
    /**
     * (experimental) Implemented by derived classes and returns the contents of the file to emit.
     *
     * @experimental
     */
    synthesizeContent(resolver) {
        const allPackages = [...this.packages];
        if (this.packageProvider) {
            allPackages.push(...this.packageProvider.packages.map(dep => this.formatDependency(dep)));
        }
        return `${resolver.resolve([
            `# ${file_1.FileBase.PROJEN_MARKER}`,
            ...allPackages,
        ]).join('\n')}\n`;
    }
}
exports.RequirementsFile = RequirementsFile;
_a = JSII_RTTI_SYMBOL_1;
RequirementsFile[_a] = { fqn: "projen.python.RequirementsFile", version: "0.40.2" };
//# sourceMappingURL=data:application/json;base64,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