"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PythonProject = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const github_1 = require("../github");
const javascript_1 = require("../javascript");
const project_1 = require("../project");
const pip_1 = require("./pip");
const poetry_1 = require("./poetry");
const projenrc_1 = require("./projenrc");
const pytest_1 = require("./pytest");
const python_sample_1 = require("./python-sample");
const setuptools_1 = require("./setuptools");
const venv_1 = require("./venv");
/** Allowed characters in python project names */
const PYTHON_PROJECT_NAME_REGEX = /^[A-Za-z0-9-_\.]+$/;
/**
 * (experimental) Python project.
 *
 * @experimental
 * @pjid python
 */
class PythonProject extends github_1.GitHubProject {
    /**
     * @experimental
     */
    constructor(options) {
        var _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s, _t;
        super(options);
        if (!PYTHON_PROJECT_NAME_REGEX.test(options.name)) {
            throw new Error('Python projects must only consist of alphanumeric characters, hyphens, and underscores.');
        }
        this.moduleName = options.moduleName;
        this.version = options.version;
        if ((_b = options.projenrcPython) !== null && _b !== void 0 ? _b : false) {
            new projenrc_1.Projenrc(this, options.projenrcPythonOptions);
        }
        else {
            new javascript_1.Projenrc(this);
        }
        if ((_c = options.venv) !== null && _c !== void 0 ? _c : true) {
            this.envManager = new venv_1.Venv(this, options.venvOptions);
        }
        if ((_d = options.pip) !== null && _d !== void 0 ? _d : true) {
            this.depsManager = new pip_1.Pip(this);
        }
        if ((_e = options.setuptools) !== null && _e !== void 0 ? _e : (this.projectType === project_1.ProjectType.LIB)) {
            this.packagingManager = new setuptools_1.Setuptools(this, {
                version: options.version,
                description: options.description,
                authorName: options.authorName,
                authorEmail: options.authorEmail,
                license: options.license,
                homepage: options.homepage,
                classifiers: options.classifiers,
                setupConfig: options.setupConfig,
            });
        }
        // if (options.conda ?? false) {
        //   this.depsManager = new Conda(this, options);
        //   this.envManager = this.depsManager;
        // }
        // if (options.pipenv ?? false) {
        //   this.depsManager = new Pipenv(this, options);
        //   this.envManager = this.depsManager;
        // }
        if ((_f = options.poetry) !== null && _f !== void 0 ? _f : false) {
            const poetry = new poetry_1.Poetry(this, {
                version: options.version,
                description: options.description,
                authorName: options.authorName,
                authorEmail: options.authorEmail,
                license: options.license,
                homepage: options.homepage,
                classifiers: options.classifiers,
                poetryOptions: {
                    readme: (_h = (_g = options.readme) === null || _g === void 0 ? void 0 : _g.filename) !== null && _h !== void 0 ? _h : 'README.md',
                    ...options.poetryOptions,
                },
            });
            this.depsManager = poetry;
            this.envManager = poetry;
            this.packagingManager = poetry;
        }
        if (!this.envManager) {
            throw new Error('At least one tool must be chosen for managing the environment (venv, conda, pipenv, or poetry).');
        }
        if (!this.depsManager) {
            throw new Error('At least one tool must be chosen for managing dependencies (pip, conda, pipenv, or poetry).');
        }
        if (!this.packagingManager && this.projectType === project_1.ProjectType.LIB) {
            throw new Error('At least one tool must be chosen for managing packaging (setuptools or poetry).');
        }
        if (Number((_j = options.venv) !== null && _j !== void 0 ? _j : true) + Number((_k = options.poetry) !== null && _k !== void 0 ? _k : false) > 1) {
            throw new Error('More than one component has been chosen for managing the environment (venv, conda, pipenv, or poetry)');
        }
        if (Number((_l = options.pip) !== null && _l !== void 0 ? _l : true) + Number((_m = options.poetry) !== null && _m !== void 0 ? _m : false) > 1) {
            throw new Error('More than one component has been chosen for managing dependencies (pip, conda, pipenv, or poetry)');
        }
        if (Number((_o = options.setuptools) !== null && _o !== void 0 ? _o : true) + Number((_p = options.poetry) !== null && _p !== void 0 ? _p : false) > 1) {
            throw new Error('More than one component has been chosen for managing packaging (setuptools or poetry)');
        }
        if ((_q = options.pytest) !== null && _q !== void 0 ? _q : true) {
            this.pytest = new pytest_1.Pytest(this, options.pytestOptions);
        }
        if ((_r = options.sample) !== null && _r !== void 0 ? _r : true) {
            new python_sample_1.PythonSample(this, {});
        }
        for (const dep of (_s = options.deps) !== null && _s !== void 0 ? _s : []) {
            this.addDependency(dep);
        }
        for (const dep of (_t = options.devDeps) !== null && _t !== void 0 ? _t : []) {
            this.addDevDependency(dep);
        }
        this.addDefaultGitIgnore();
    }
    /**
     * Adds default gitignore options for a Python project based on
     * https://github.com/github/gitignore/blob/master/Python.gitignore
     */
    addDefaultGitIgnore() {
        this.gitignore.exclude('# Byte-compiled / optimized / DLL files', '__pycache__/', '*.py[cod]', '*$py.class', '', '# C extensions', '*.so', '', '# Distribution / packaging', '.Python', 'build/', 'develop-eggs/', 'dist/', 'downloads/', 'eggs/', '.eggs/', 'lib/', 'lib64/', 'parts/', 'sdist/', 'var/', 'wheels/', 'share/python-wheels/', '*.egg-info/', '.installed.cfg', '*.egg', 'MANIFEST', '', '# PyInstaller', '#  Usually these files are written by a python script from a template', '#  before PyInstaller builds the exe, so as to inject date/other infos into it.', '*.manifest', '*.spec', '', '# Installer logs', 'pip-log.txt', 'pip-delete-this-directory.txt', '', '# Unit test / coverage reports', 'htmlcov/', '.tox/', '.nox/', '.coverage', '.coverage.*', '.cache', 'nosetests.xml', 'coverage.xml', '*.cover', '*.py,cover', '.hypothesis/', '.pytest_cache/', 'cover/', '', '# Translations', '*.mo', '*.pot', '', '# Django stuff:', '*.log', 'local_settings.py', 'db.sqlite3', 'db.sqlite3-journal', '', '# Flask stuff:', 'instance/', '.webassets-cache', '', '# Scrapy stuff:', '.scrapy', '', '# Sphinx documentation', 'docs/_build/', '', '# PyBuilder', '.pybuilder/', 'target/', '', '# Jupyter Notebook', '.ipynb_checkpoints', '', '# IPython', 'profile_default/', 'ipython_config.py', '', '# PEP 582; used by e.g. github.com/David-OConnor/pyflow', '__pypackages__/', '', '# Celery stuff', 'celerybeat-schedule', 'celerybeat.pid', '', '# SageMath parsed files', '*.sage.py', '', '# Environments', '.env', '.venv', 'env/', 'venv/', 'ENV/', 'env.bak/', 'venv.bak/', '', '# Spyder project settings', '.spyderproject', '.spyproject', '', '# Rope project settings', '.ropeproject', '', '# mkdocs documentation', '/site', '', '# mypy', '.mypy_cache/', '.dmypy.json', 'dmypy.json', '', '# Pyre type checker', '.pyre/', '', '# pytype static type analyzer', '.pytype/', '', '# Cython debug symbols', 'cython_debug/');
    }
    /**
     * (experimental) Adds a runtime dependency.
     *
     * @param spec Format `<module>@<semver>`.
     * @experimental
     */
    addDependency(spec) {
        return this.depsManager.addDependency(spec);
    }
    /**
     * (experimental) Adds a dev dependency.
     *
     * @param spec Format `<module>@<semver>`.
     * @experimental
     */
    addDevDependency(spec) {
        return this.depsManager.addDevDependency(spec);
    }
    /**
     * (experimental) Called after all components are synthesized.
     *
     * Order is *not* guaranteed.
     *
     * @experimental
     */
    postSynthesize() {
        super.postSynthesize();
        this.envManager.setupEnvironment();
        this.depsManager.installDependencies();
    }
}
exports.PythonProject = PythonProject;
_a = JSII_RTTI_SYMBOL_1;
PythonProject[_a] = { fqn: "projen.python.PythonProject", version: "0.40.2" };
//# sourceMappingURL=data:application/json;base64,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