"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Pytest = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
const sample_file_1 = require("../sample-file");
/**
 * @experimental
 */
class Pytest extends component_1.Component {
    /**
     * @experimental
     */
    constructor(project, options = {}) {
        var _b;
        super(project);
        const version = (_b = options.version) !== null && _b !== void 0 ? _b : '6.2.1';
        project.addDevDependency(`pytest@${version}`);
        project.testTask.exec([
            'pytest',
            ...(options.maxFailures ? [`--maxfail=${options.maxFailures}`] : []),
        ].join(' '));
        new sample_file_1.SampleDir(project, 'tests', {
            files: {
                '__init__.py': '',
                'test_example.py': [
                    'import pytest',
                    '',
                    `from ${project.moduleName}.example import hello`,
                    '',
                    '@pytest.mark.parametrize(',
                    '    ("name", "expected"),',
                    '    [',
                    '        ("A. Musing", "Hello A. Musing!"),',
                    '        ("traveler", "Hello traveler!"),',
                    '        ("projen developer", "Hello projen developer!"),',
                    '    ],',
                    ')',
                    'def test_hello(name, expected):',
                    '    """Example test with parametrization."""',
                    '    assert hello(name) == expected',
                    '',
                ].join('\n'),
            },
        });
    }
}
exports.Pytest = Pytest;
_a = JSII_RTTI_SYMBOL_1;
Pytest[_a] = { fqn: "projen.python.Pytest", version: "0.40.2" };
//# sourceMappingURL=data:application/json;base64,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