"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProjectBuild = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("./component");
/**
 * (experimental) Manages a standard build process for all projects.
 *
 * Build spawns these tasks in order:
 * 1. default
 * 2. pre-compile
 * 3. compile
 * 4. post-compile
 * 5. test
 * 6. package
 *
 * @experimental
 */
class ProjectBuild extends component_1.Component {
    /**
     * @experimental
     */
    constructor(project) {
        super(project);
        this.preCompileTask = project.tasks.addTask('pre-compile', {
            description: 'Prepare the project for compilation',
        });
        this.compileTask = project.tasks.addTask('compile', {
            description: 'Only compile',
        });
        this.postCompileTask = project.tasks.addTask('post-compile', {
            description: 'Runs after successful compilation',
        });
        this.testTask = project.tasks.addTask('test', {
            description: 'Run tests',
        });
        this.packageTask = project.tasks.addTask('package', {
            description: 'Creates the distribution package',
        });
        this.buildTask = project.tasks.addTask('build', {
            description: 'Full release build',
        });
        // if this is not subproject, execute the "default" task which will
        // synthesize project files.
        if (!this.project.parent) {
            this.buildTask.spawn(this.project.defaultTask);
        }
        this.buildTask.spawn(this.preCompileTask);
        this.buildTask.spawn(this.compileTask);
        this.buildTask.spawn(this.postCompileTask);
        this.buildTask.spawn(this.testTask);
        this.buildTask.spawn(this.packageTask);
        // do not allow additional build phases
        this.buildTask.lock();
    }
}
exports.ProjectBuild = ProjectBuild;
_a = JSII_RTTI_SYMBOL_1;
ProjectBuild[_a] = { fqn: "projen.ProjectBuild", version: "0.40.2" };
//# sourceMappingURL=data:application/json;base64,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