"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.renderBundleName = void 0;
const path_1 = require("path");
function renderBundleName(entrypoint) {
    const parts = path_1.join(entrypoint).split(path_1.sep);
    if (parts[0] === 'src') {
        parts.shift(); // just remove 'src' if its the first element for ergonomics
    }
    const p = parts.join(path_1.sep);
    const dir = path_1.dirname(p);
    const base = path_1.basename(p, path_1.extname(p));
    return path_1.join(dir, base);
}
exports.renderBundleName = renderBundleName;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidXRpbC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy9qYXZhc2NyaXB0L3V0aWwudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEsK0JBQTZEO0FBRTdELFNBQWdCLGdCQUFnQixDQUFDLFVBQWtCO0lBQ2pELE1BQU0sS0FBSyxHQUFHLFdBQUksQ0FBQyxVQUFVLENBQUMsQ0FBQyxLQUFLLENBQUMsVUFBRyxDQUFDLENBQUM7SUFDMUMsSUFBSSxLQUFLLENBQUMsQ0FBQyxDQUFDLEtBQUssS0FBSyxFQUFFO1FBQ3RCLEtBQUssQ0FBQyxLQUFLLEVBQUUsQ0FBQyxDQUFDLDREQUE0RDtLQUM1RTtJQUVELE1BQU0sQ0FBQyxHQUFHLEtBQUssQ0FBQyxJQUFJLENBQUMsVUFBRyxDQUFDLENBQUM7SUFDMUIsTUFBTSxHQUFHLEdBQUcsY0FBTyxDQUFDLENBQUMsQ0FBQyxDQUFDO0lBQ3ZCLE1BQU0sSUFBSSxHQUFHLGVBQVEsQ0FBQyxDQUFDLEVBQUUsY0FBTyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7SUFDckMsT0FBTyxXQUFJLENBQUMsR0FBRyxFQUFFLElBQUksQ0FBQyxDQUFDO0FBQ3pCLENBQUM7QUFWRCw0Q0FVQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IGJhc2VuYW1lLCBkaXJuYW1lLCBleHRuYW1lLCBqb2luLCBzZXAgfSBmcm9tICdwYXRoJztcblxuZXhwb3J0IGZ1bmN0aW9uIHJlbmRlckJ1bmRsZU5hbWUoZW50cnlwb2ludDogc3RyaW5nKSB7XG4gIGNvbnN0IHBhcnRzID0gam9pbihlbnRyeXBvaW50KS5zcGxpdChzZXApO1xuICBpZiAocGFydHNbMF0gPT09ICdzcmMnKSB7XG4gICAgcGFydHMuc2hpZnQoKTsgLy8ganVzdCByZW1vdmUgJ3NyYycgaWYgaXRzIHRoZSBmaXJzdCBlbGVtZW50IGZvciBlcmdvbm9taWNzXG4gIH1cblxuICBjb25zdCBwID0gcGFydHMuam9pbihzZXApO1xuICBjb25zdCBkaXIgPSBkaXJuYW1lKHApO1xuICBjb25zdCBiYXNlID0gYmFzZW5hbWUocCwgZXh0bmFtZShwKSk7XG4gIHJldHVybiBqb2luKGRpciwgYmFzZSk7XG59XG4iXX0=