"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.UpgradeDependenciesSchedule = exports.UpgradeDependencies = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
const github_1 = require("../github");
const constants_1 = require("../github/constants");
function context(value) {
    return `\${{ ${value} }}`;
}
function setOutput(name, value) {
    return `echo "::set-output name=${name}::${value}"`;
}
const RUNNER_TEMP = context('runner.temp');
const DEFAULT_TOKEN = context('secrets.GITHUB_TOKEN');
const REPO = context('github.repository');
const RUN_ID = context('github.run_id');
const RUN_URL = `https://github.com/${REPO}/actions/runs/${RUN_ID}`;
/**
 * (experimental) Upgrade node project dependencies.
 *
 * @experimental
 */
class UpgradeDependencies extends component_1.Component {
    /**
     * @experimental
     */
    constructor(project, options = {}) {
        var _c, _d, _e, _f;
        super(project);
        /**
         * (experimental) The workflows that execute the upgrades.
         *
         * One workflow per branch.
         *
         * @experimental
         */
        this.workflows = [];
        this._project = project;
        this.options = options;
        this.pullRequestTitle = (_c = options.pullRequestTitle) !== null && _c !== void 0 ? _c : 'upgrade dependencies';
        this.ignoresProjen = (_d = this.options.ignoreProjen) !== null && _d !== void 0 ? _d : true;
        this.gitIdentity = (_f = (_e = options.workflowOptions) === null || _e === void 0 ? void 0 : _e.gitIdentity) !== null && _f !== void 0 ? _f : constants_1.DEFAULT_GITHUB_ACTIONS_USER;
        project.addDevDeps('npm-check-updates@^11');
    }
    // create the upgrade task and a corresponding github workflow
    // for each requested branch.
    /**
     * (experimental) Called before synthesis.
     *
     * @experimental
     */
    preSynthesize() {
        var _c, _d, _e, _f, _g;
        const task = this.createTask();
        if (this._project.github && ((_c = this.options.workflow) !== null && _c !== void 0 ? _c : true)) {
            // represents the default repository branch.
            // just like not specifying anything.
            const defaultBranch = undefined;
            const branches = (_e = (_d = this.options.workflowOptions) === null || _d === void 0 ? void 0 : _d.branches) !== null && _e !== void 0 ? _e : ((_g = (_f = this._project.release) === null || _f === void 0 ? void 0 : _f.branches) !== null && _g !== void 0 ? _g : [defaultBranch]);
            for (const branch of branches) {
                this.workflows.push(this.createWorkflow(task, this._project.github, branch));
            }
        }
    }
    createTask() {
        var _c, _d;
        const taskName = (_c = this.options.taskName) !== null && _c !== void 0 ? _c : 'upgrade';
        const task = this._project.addTask(taskName, {
            // this task should not run in CI mode because its designed to
            // update package.json and lock files.
            env: { CI: '0' },
            description: this.pullRequestTitle,
        });
        const exclude = (_d = this.options.exclude) !== null && _d !== void 0 ? _d : [];
        if (this.ignoresProjen) {
            exclude.push('projen');
        }
        for (const dep of ['dev', 'optional', 'peer', 'prod', 'bundle']) {
            const ncuCommand = ['npm-check-updates', '--dep', dep, '--upgrade', '--target=minor'];
            if (exclude.length > 0) {
                ncuCommand.push(`--reject='${exclude.join(',')}'`);
            }
            if (this.options.include) {
                ncuCommand.push(`--filter='${this.options.include.join(',')}'`);
            }
            task.exec(ncuCommand.join(' '));
        }
        // run "yarn/npm install" to update the lockfile and install any deps (such as projen)
        task.exec(this._project.package.installAndUpdateLockfileCommand);
        // run upgrade command to upgrade transitive deps as well
        task.exec(this._project.package.renderUpgradePackagesCommand(exclude, this.options.include));
        // run "projen" to give projen a chance to update dependencies (it will also run "yarn install")
        task.exec(this._project.projenCommand);
        return task;
    }
    createWorkflow(task, github, branch) {
        var _c, _d;
        const schedule = (_d = (_c = this.options.workflowOptions) === null || _c === void 0 ? void 0 : _c.schedule) !== null && _d !== void 0 ? _d : UpgradeDependenciesSchedule.DAILY;
        const workflowName = `${task.name}${branch ? `-${branch.replace(/\//g, '-')}` : ''}`;
        const workflow = github.addWorkflow(workflowName);
        const triggers = {
            workflowDispatch: {},
            schedule: schedule.cron ? schedule.cron.map(e => ({ cron: e })) : undefined,
        };
        workflow.on(triggers);
        const upgrade = this.createUpgrade(task, branch);
        const pr = this.createPr(workflow, upgrade);
        const jobs = {};
        jobs[upgrade.jobId] = upgrade.job;
        jobs[pr.jobId] = pr.job;
        workflow.addJobs(jobs);
        return workflow;
    }
    createUpgrade(task, branch) {
        var _c, _d, _e, _f, _g;
        const build = (_d = (_c = this.options.workflowOptions) === null || _c === void 0 ? void 0 : _c.rebuild) !== null && _d !== void 0 ? _d : true;
        const runsOn = (_f = (_e = this.options.workflowOptions) === null || _e === void 0 ? void 0 : _e.runsOn) !== null && _f !== void 0 ? _f : ['ubuntu-latest'];
        const patchFile = '.upgrade.tmp.patch';
        const buildStepId = 'build';
        const conclusion = 'conclusion';
        // thats all we should need at this stage since all we do is clone.
        // note that this also prevents new code that is introduced in the upgrade
        // to have write access to anything, in case its somehow executed. (for example during build)
        const permissions = {
            contents: github_1.workflows.JobPermission.READ,
        };
        const outputs = {};
        const steps = [
            {
                name: 'Checkout',
                uses: 'actions/checkout@v2',
                with: branch ? { ref: branch } : undefined,
            },
            constants_1.setGitIdentityStep(this.gitIdentity),
            ...this._project.installWorkflowSteps,
            {
                name: 'Upgrade dependencies',
                run: this._project.runTaskCommand(task),
            },
        ];
        if (build) {
            steps.push({
                name: 'Build',
                id: buildStepId,
                run: `${this._project.runTaskCommand(this._project.buildTask)} && ${setOutput(conclusion, 'success')} || ${setOutput(conclusion, 'failure')}`,
            });
            outputs[conclusion] = {
                stepId: buildStepId,
                outputName: conclusion,
            };
        }
        steps.push({
            name: 'Create Patch',
            run: [
                'git add .',
                `git diff --patch --staged > ${patchFile}`,
            ].join('\n'),
        }, {
            name: 'Upload patch',
            uses: 'actions/upload-artifact@v2',
            with: { name: patchFile, path: patchFile },
        });
        return {
            job: {
                name: 'Upgrade',
                container: (_g = this.options.workflowOptions) === null || _g === void 0 ? void 0 : _g.container,
                permissions: permissions,
                runsOn: runsOn !== null && runsOn !== void 0 ? runsOn : ['ubuntu-latest'],
                outputs: outputs,
                steps: steps,
            },
            jobId: 'upgrade',
            patchFile: patchFile,
            build: build,
            buildConclusionOutput: conclusion,
            ref: branch,
        };
    }
    createPr(workflow, upgrade) {
        var _c, _d, _e, _f, _g, _h;
        const customToken = ((_c = this.options.workflowOptions) === null || _c === void 0 ? void 0 : _c.secret) ? context(`secrets.${this.options.workflowOptions.secret}`) : undefined;
        const runsOn = (_e = (_d = this.options.workflowOptions) === null || _d === void 0 ? void 0 : _d.runsOn) !== null && _e !== void 0 ? _e : ['ubuntu-latest'];
        const workflowName = workflow.name;
        const branchName = `github-actions/${workflowName}`;
        const prStepId = 'create-pr';
        const title = `chore(deps): ${this.pullRequestTitle}`;
        const description = [
            'Upgrades project dependencies. See details in [workflow run].',
            '',
            `[Workflow Run]: ${RUN_URL}`,
            '',
            '------',
            '',
            `*Automatically created by projen via the "${workflow.name}" workflow*`,
        ].join('\n');
        const comitter = `${this.gitIdentity.name} <${this.gitIdentity.email}>`;
        const steps = [
            {
                name: 'Checkout',
                uses: 'actions/checkout@v2',
                with: upgrade.ref ? { ref: upgrade.ref } : undefined,
            },
            constants_1.setGitIdentityStep(this.gitIdentity),
            {
                name: 'Download patch',
                uses: 'actions/download-artifact@v2',
                with: { name: upgrade.patchFile, path: RUNNER_TEMP },
            },
            {
                name: 'Apply patch',
                run: `[ -s ${RUNNER_TEMP}/${upgrade.patchFile} ] && git apply ${RUNNER_TEMP}/${upgrade.patchFile} || echo "Empty patch. Skipping."`,
            },
            {
                name: 'Create Pull Request',
                id: prStepId,
                uses: 'peter-evans/create-pull-request@v3',
                with: {
                    // the pr can modify workflow files, so we need to use the custom
                    // secret if one is configured.
                    'token': customToken !== null && customToken !== void 0 ? customToken : DEFAULT_TOKEN,
                    'commit-message': `${title}\n\n${description}`,
                    'branch': branchName,
                    'title': title,
                    'labels': ((_g = (_f = this.options.workflowOptions) === null || _f === void 0 ? void 0 : _f.labels) === null || _g === void 0 ? void 0 : _g.join(',')) || undefined,
                    'body': description,
                    'author': comitter,
                    'committer': comitter,
                    'signoff': (_h = this.options.signoff) !== null && _h !== void 0 ? _h : true,
                },
            },
        ];
        let writeChecksPermission = false;
        if (this._project.buildWorkflowJobId && upgrade.build) {
            const body = {
                name: this._project.buildWorkflowJobId,
                head_sha: branchName,
                status: 'completed',
                conclusion: context(`needs.${upgrade.jobId}.outputs.${upgrade.buildConclusionOutput}`),
                output: {
                    title: `Created via the ${workflowName} workflow.`,
                    summary: `Action run URL: ${RUN_URL}`,
                },
            };
            steps.push({
                name: 'Update status check',
                if: `steps.${prStepId}.outputs.pull-request-url != \'\'`,
                run: 'curl -i --fail '
                    + '-X POST '
                    + '-H "Accept: application/vnd.github.v3+json" '
                    + `-H "Authorization: token \${GITHUB_TOKEN}" https://api.github.com/repos/${REPO}/check-runs `
                    + `-d '${JSON.stringify(body)}'`,
                env: { GITHUB_TOKEN: DEFAULT_TOKEN },
            });
            // necessary to update status checks
            writeChecksPermission = true;
        }
        return {
            job: {
                name: 'Create Pull Request',
                needs: [upgrade.jobId],
                permissions: {
                    contents: github_1.workflows.JobPermission.WRITE,
                    pullRequests: github_1.workflows.JobPermission.WRITE,
                    checks: writeChecksPermission ? github_1.workflows.JobPermission.WRITE : undefined,
                },
                runsOn: runsOn !== null && runsOn !== void 0 ? runsOn : ['ubuntu-latest'],
                steps: steps,
            },
            jobId: 'pr',
        };
    }
}
exports.UpgradeDependencies = UpgradeDependencies;
_a = JSII_RTTI_SYMBOL_1;
UpgradeDependencies[_a] = { fqn: "projen.javascript.UpgradeDependencies", version: "0.40.2" };
/**
 * (experimental) How often to check for new versions and raise pull requests for version upgrades.
 *
 * @experimental
 */
class UpgradeDependenciesSchedule {
    constructor(cron) {
        this.cron = cron;
    }
    /**
     * (experimental) Create a schedule from a raw cron expression.
     *
     * @experimental
     */
    static expressions(cron) {
        return new UpgradeDependenciesSchedule(cron);
    }
}
exports.UpgradeDependenciesSchedule = UpgradeDependenciesSchedule;
_b = JSII_RTTI_SYMBOL_1;
UpgradeDependenciesSchedule[_b] = { fqn: "projen.javascript.UpgradeDependenciesSchedule", version: "0.40.2" };
/**
 * (experimental) Disables automatic upgrades.
 *
 * @experimental
 */
UpgradeDependenciesSchedule.NEVER = new UpgradeDependenciesSchedule([]);
/**
 * (experimental) At 00:00.
 *
 * @experimental
 */
UpgradeDependenciesSchedule.DAILY = new UpgradeDependenciesSchedule(['0 0 * * *']);
/**
 * (experimental) At 00:00 on every day-of-week from Monday through Friday.
 *
 * @experimental
 */
UpgradeDependenciesSchedule.WEEKDAY = new UpgradeDependenciesSchedule(['0 0 * * 1-5']);
/**
 * (experimental) At 00:00 on Monday.
 *
 * @experimental
 */
UpgradeDependenciesSchedule.WEEKLY = new UpgradeDependenciesSchedule(['0 0 * * 1']);
/**
 * (experimental) At 00:00 on day-of-month 1.
 *
 * @experimental
 */
UpgradeDependenciesSchedule.MONTHLY = new UpgradeDependenciesSchedule(['0 0 1 * *']);
//# sourceMappingURL=data:application/json;base64,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