"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NpmConfig = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
const ini_1 = require("../ini");
/**
 * (experimental) File representing the local NPM config in .npmrc.
 *
 * @experimental
 */
class NpmConfig extends component_1.Component {
    /**
     * @experimental
     */
    constructor(project, options = {}) {
        super(project);
        /**
         * The config object. This object can be mutated until the project is
         * synthesized.
         */
        this.config = {};
        new ini_1.IniFile(project, '.npmrc', { obj: this.config });
        if (options.registry) {
            this.addRegistry(options.registry);
        }
    }
    /**
     * (experimental) configure a scoped registry.
     *
     * @param url the URL of the registry to use.
     * @param scope the scope the registry is used for;
     * @experimental
     */
    addRegistry(url, scope) {
        this.addConfig(scope ? `${scope}:registry` : 'registry', url);
    }
    /**
     * (experimental) configure a generic property.
     *
     * @param name the name of the property.
     * @param value the value of the property.
     * @experimental
     */
    addConfig(name, value) {
        this.config[name] = value;
    }
}
exports.NpmConfig = NpmConfig;
_a = JSII_RTTI_SYMBOL_1;
NpmConfig[_a] = { fqn: "projen.javascript.NpmConfig", version: "0.40.2" };
//# sourceMappingURL=data:application/json;base64,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