"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NodeProject = exports.AutoRelease = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const common_1 = require("../common");
const github_1 = require("../github");
const constants_1 = require("../github/constants");
const workflows_model_1 = require("../github/workflows-model");
const ignore_file_1 = require("../ignore-file");
const javascript_1 = require("../javascript");
const license_1 = require("../license");
const release_1 = require("../release");
const util_1 = require("../util");
const version_1 = require("../version");
const bundler_1 = require("./bundler");
const jest_1 = require("./jest");
const node_package_1 = require("./node-package");
const projenrc_1 = require("./projenrc");
const PROJEN_SCRIPT = 'projen';
/**
 * (experimental) Automatic bump modes.
 *
 * @experimental
 */
var AutoRelease;
(function (AutoRelease) {
    AutoRelease[AutoRelease["EVERY_COMMIT"] = 0] = "EVERY_COMMIT";
    AutoRelease[AutoRelease["DAILY"] = 1] = "DAILY";
})(AutoRelease = exports.AutoRelease || (exports.AutoRelease = {}));
/**
 * (experimental) Node.js project.
 *
 * @experimental
 * @pjid node
 */
class NodeProject extends github_1.GitHubProject {
    /**
     * @experimental
     */
    constructor(options) {
        var _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s, _t, _u, _v, _w, _x, _y, _z, _0, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13;
        super(options);
        this.package = new node_package_1.NodePackage(this, options);
        this.workflowBootstrapSteps = (_b = options.workflowBootstrapSteps) !== null && _b !== void 0 ? _b : [];
        this.workflowGitIdentity = (_c = options.workflowGitIdentity) !== null && _c !== void 0 ? _c : constants_1.DEFAULT_GITHUB_ACTIONS_USER;
        this.runScriptCommand = (() => {
            switch (this.packageManager) {
                case node_package_1.NodePackageManager.NPM: return 'npm run';
                case node_package_1.NodePackageManager.YARN: return 'yarn run';
                case node_package_1.NodePackageManager.PNPM: return 'pnpm run';
                default: throw new Error(`unexpected package manager ${this.packageManager}`);
            }
        })();
        this.nodeVersion = (_d = options.workflowNodeVersion) !== null && _d !== void 0 ? _d : this.package.minNodeVersion;
        // add PATH for all tasks which includes the project's npm .bin list
        this.tasks.addEnvironment('PATH', '$(npx -c "node -e \\\"console.log(process.env.PATH)\\\"")');
        this.addLicense(options);
        if ((_e = options.npmignoreEnabled) !== null && _e !== void 0 ? _e : true) {
            this.npmignore = new ignore_file_1.IgnoreFile(this, '.npmignore');
        }
        this.addDefaultGitIgnore();
        if ((_f = options.gitignore) === null || _f === void 0 ? void 0 : _f.length) {
            for (const i of options.gitignore) {
                this.gitignore.exclude(i);
            }
        }
        if ((_g = options.npmignore) === null || _g === void 0 ? void 0 : _g.length) {
            if (!this.npmignore) {
                throw new Error('.npmignore is not defined for an APP project type. Add "npmIgnore: true" to override this');
            }
            for (const i of options.npmignore) {
                this.npmignore.exclude(i);
            }
        }
        this.setScript(PROJEN_SCRIPT, this.package.projenCommand);
        (_h = this.npmignore) === null || _h === void 0 ? void 0 : _h.exclude(`/${common_1.PROJEN_RC}`);
        (_j = this.npmignore) === null || _j === void 0 ? void 0 : _j.exclude(`/${common_1.PROJEN_DIR}/`);
        this.gitignore.include(`/${common_1.PROJEN_RC}`);
        const projen = (_k = options.projenDevDependency) !== null && _k !== void 0 ? _k : true;
        if (projen) {
            const postfix = options.projenVersion ? `@${options.projenVersion}` : '';
            this.addDevDeps(`projen${postfix}`);
        }
        if (!options.defaultReleaseBranch) {
            throw new Error('"defaultReleaseBranch" is temporarily a required option while we migrate its default value from "master" to "main"');
        }
        const buildEnabled = (_l = options.buildWorkflow) !== null && _l !== void 0 ? _l : (this.parent ? false : true);
        const mutableBuilds = (_m = options.mutableBuild) !== null && _m !== void 0 ? _m : true;
        // indicate if we have anti-tamper configured in our workflows. used by e.g. Jest
        // to decide if we can always run with --updateSnapshot
        this.antitamper = buildEnabled && ((_o = options.antitamper) !== null && _o !== void 0 ? _o : true);
        // configure jest if enabled
        // must be before the build/release workflows
        if ((_p = options.jest) !== null && _p !== void 0 ? _p : true) {
            this.jest = new jest_1.Jest(this, options.jestOptions);
        }
        if (buildEnabled) {
            const branch = '${{ github.event.pull_request.head.ref }}';
            const repo = '${{ github.event.pull_request.head.repo.full_name }}';
            const buildJobId = 'build';
            const postBuildSteps = new Array();
            const gitDiffStepId = 'git_diff';
            const hasChangesCondName = 'has_changes';
            const hasChanges = `steps.${gitDiffStepId}.outputs.${hasChangesCondName}`;
            // disable anti-tamper if build workflow is mutable
            const antitamperSteps = ((_q = !mutableBuilds) !== null && _q !== void 0 ? _q : this.antitamper) ? [{
                    // anti-tamper check (fails if there were changes to committed files)
                    // this will identify any non-committed files generated during build (e.g. test snapshots)
                    name: 'Anti-tamper check',
                    run: 'git diff --ignore-space-at-eol --exit-code',
                }] : [];
            // run codecov if enabled or a secret token name is passed in
            // AND jest must be configured
            if ((options.codeCov || options.codeCovTokenSecret) && ((_r = this.jest) === null || _r === void 0 ? void 0 : _r.config)) {
                postBuildSteps.push({
                    name: 'Upload coverage to Codecov',
                    uses: 'codecov/codecov-action@v1',
                    with: options.codeCovTokenSecret ? {
                        token: `\${{ secrets.${options.codeCovTokenSecret} }}`,
                        directory: this.jest.config.coverageDirectory,
                    } : {
                        directory: this.jest.config.coverageDirectory,
                    },
                });
            }
            // use "git diff --exit code" to check if there were changes in the repo
            // and create a step output that will be used in subsequent steps.
            postBuildSteps.push({
                name: 'Check for changes',
                id: gitDiffStepId,
                run: `git diff --exit-code || echo "::set-output name=${hasChangesCondName}::true"`,
            });
            // only if we had changes, commit them and push to the repo note that for
            // forks, this will fail (because the workflow doesn't have permissions.
            // this indicates to users that they need to update their branch manually.
            postBuildSteps.push({
                if: hasChanges,
                name: 'Commit and push changes (if changed)',
                run: `git add . && git commit -m "chore: self mutation" && git push origin HEAD:${branch}`,
            });
            // if we pushed changes, we need to manually update the status check so
            // that the PR will be green (we won't get here for forks with updates
            // because the push would have failed).
            postBuildSteps.push({
                if: hasChanges,
                name: 'Update status check (if changed)',
                run: [
                    'gh api',
                    '-X POST',
                    `/repos/${repo}/check-runs`,
                    `-F name="${buildJobId}"`,
                    '-F head_sha="$(git rev-parse HEAD)"',
                    '-F status="completed"',
                    '-F conclusion="success"',
                ].join(' '),
                env: {
                    GITHUB_TOKEN: '${{ secrets.GITHUB_TOKEN }}',
                },
            });
            // if we pushed changes, we need to mark the current commit as failed, so
            // that GitHub auto-merge does not risk merging this commit before the
            // event for the new commit has registered.
            postBuildSteps.push({
                if: hasChanges,
                name: 'Cancel workflow (if changed)',
                run: [
                    'gh api',
                    '-X POST',
                    `/repos/${repo}/actions/runs/\${{ github.run_id }}/cancel`,
                ].join(' '),
                env: {
                    GITHUB_TOKEN: '${{ secrets.GITHUB_TOKEN }}',
                },
            });
            postBuildSteps.push(...antitamperSteps);
            if (this.github) {
                this.buildWorkflow = new github_1.TaskWorkflow(this.github, {
                    gitIdentity: this.workflowGitIdentity,
                    name: 'build',
                    jobId: buildJobId,
                    triggers: {
                        pullRequest: {},
                    },
                    env: {
                        CI: 'true',
                    },
                    permissions: {
                        checks: workflows_model_1.JobPermission.WRITE,
                        contents: workflows_model_1.JobPermission.WRITE,
                        actions: workflows_model_1.JobPermission.WRITE,
                    },
                    checkoutWith: mutableBuilds ? {
                        ref: branch,
                        repository: repo,
                    } : undefined,
                    preBuildSteps: [
                        ...antitamperSteps,
                        ...this.installWorkflowSteps,
                    ],
                    task: this.buildTask,
                    postBuildSteps,
                    container: options.workflowContainerImage ? { image: options.workflowContainerImage } : undefined,
                });
                this.buildWorkflowJobId = buildJobId;
            }
        }
        const release = (_t = (_s = options.release) !== null && _s !== void 0 ? _s : options.releaseWorkflow) !== null && _t !== void 0 ? _t : (this.parent ? false : true);
        if (release) {
            this.addDevDeps(version_1.Version.STANDARD_VERSION);
            this.release = new release_1.Release(this, {
                versionFile: 'package.json',
                task: this.buildTask,
                branch: (_u = options.defaultReleaseBranch) !== null && _u !== void 0 ? _u : 'main',
                ...options,
                releaseWorkflowSetupSteps: [
                    ...this.installWorkflowSteps,
                    ...(_v = options.releaseWorkflowSetupSteps) !== null && _v !== void 0 ? _v : [],
                ],
            });
            this.publisher = this.release.publisher;
            if ((_w = options.releaseToNpm) !== null && _w !== void 0 ? _w : false) {
                this.release.publisher.publishToNpm({
                    registry: this.package.npmRegistry,
                    npmTokenSecret: this.package.npmTokenSecret,
                    codeArtifactOptions: {
                        accessKeyIdSecret: (_x = options.codeArtifactOptions) === null || _x === void 0 ? void 0 : _x.accessKeyIdSecret,
                        secretAccessKeySecret: (_y = options.codeArtifactOptions) === null || _y === void 0 ? void 0 : _y.secretAccessKeySecret,
                        roleToAssume: (_z = options.codeArtifactOptions) === null || _z === void 0 ? void 0 : _z.roleToAssume,
                    },
                });
            }
        }
        else {
            // validate that no release options are selected if the release workflow is disabled.
            if (options.releaseToNpm) {
                throw new Error('"releaseToNpm" is not supported for APP projects');
            }
            if (options.releaseEveryCommit) {
                throw new Error('"releaseEveryCommit" is not supported for APP projects');
            }
            if (options.releaseSchedule) {
                throw new Error('"releaseSchedule" is not supported for APP projects');
            }
        }
        if ((_0 = this.github) === null || _0 === void 0 ? void 0 : _0.mergify) {
            this.autoMerge = new github_1.AutoMerge(this.github, {
                buildJob: this.buildWorkflowJobId,
                ...options.autoMergeOptions,
            });
        }
        const dependabot = (_1 = options.dependabot) !== null && _1 !== void 0 ? _1 : false;
        const depsUpgrade = (_2 = options.depsUpgrade) !== null && _2 !== void 0 ? _2 : !dependabot;
        if (dependabot && depsUpgrade) {
            throw new Error("'dependabot' cannot be configured together with 'depsUpgrade'");
        }
        if (options.projenUpgradeAutoMerge !== undefined && options.autoApproveProjenUpgrades !== undefined) {
            throw new Error("'projenUpgradeAutoMerge' cannot be configured together with 'autoApproveProjenUpgrades'");
        }
        const projenAutoApprove = (_3 = options.autoApproveProjenUpgrades) !== null && _3 !== void 0 ? _3 : ((_4 = options.projenUpgradeAutoMerge) !== null && _4 !== void 0 ? _4 : false);
        const depsAutoApprove = (_5 = options.autoApproveUpgrades) !== null && _5 !== void 0 ? _5 : false;
        if (projenAutoApprove && !this.autoApprove) {
            throw new Error('Autoamtic approval of projen upgrades requires configuring `autoApproveOptions`');
        }
        if (depsAutoApprove && !this.autoApprove) {
            throw new Error('Autoamtic approval of dependencies upgrades requires configuring `autoApproveOptions`');
        }
        const autoApproveLabel = (condition) => { var _b; return (condition && ((_b = this.autoApprove) === null || _b === void 0 ? void 0 : _b.label)) ? [this.autoApprove.label] : undefined; };
        let ignoresProjen;
        if (dependabot) {
            const defaultOptions = {
                labels: autoApproveLabel(depsAutoApprove),
            };
            const dependabotConf = (_6 = this.github) === null || _6 === void 0 ? void 0 : _6.addDependabot(util_1.deepMerge([defaultOptions, (_7 = options.dependabotOptions) !== null && _7 !== void 0 ? _7 : {}]));
            ignoresProjen = dependabotConf === null || dependabotConf === void 0 ? void 0 : dependabotConf.ignoresProjen;
        }
        if (depsUpgrade) {
            const defaultOptions = {
                // if projen secret is defined we can also upgrade projen here.
                ignoreProjen: !options.projenUpgradeSecret,
                workflowOptions: {
                    // if projen secret is defined, use it (otherwise default to GITHUB_TOKEN).
                    secret: options.projenUpgradeSecret,
                    container: options.workflowContainerImage ? {
                        image: options.workflowContainerImage,
                    } : undefined,
                    labels: autoApproveLabel(depsAutoApprove),
                    gitIdentity: this.workflowGitIdentity,
                },
            };
            const upgradeDependencies = new javascript_1.UpgradeDependencies(this, util_1.deepMerge([defaultOptions, (_8 = options.depsUpgradeOptions) !== null && _8 !== void 0 ? _8 : {}]));
            ignoresProjen = upgradeDependencies.ignoresProjen;
        }
        // create a dedicated workflow to upgrade projen itself if needed
        if (ignoresProjen && this.package.packageName !== 'projen') {
            new javascript_1.UpgradeDependencies(this, {
                include: ['projen'],
                taskName: 'upgrade-projen',
                pullRequestTitle: 'upgrade projen',
                ignoreProjen: false,
                workflow: !!options.projenUpgradeSecret,
                workflowOptions: {
                    schedule: javascript_1.UpgradeDependenciesSchedule.expressions((_9 = options.projenUpgradeSchedule) !== null && _9 !== void 0 ? _9 : ['0 6 * * *']),
                    container: options.workflowContainerImage ? { image: options.workflowContainerImage } : undefined,
                    secret: options.projenUpgradeSecret,
                    labels: autoApproveLabel(projenAutoApprove),
                    gitIdentity: this.workflowGitIdentity,
                },
            });
        }
        if ((_10 = options.pullRequestTemplate) !== null && _10 !== void 0 ? _10 : true) {
            (_11 = this.github) === null || _11 === void 0 ? void 0 : _11.addPullRequestTemplate(...(_12 = options.pullRequestTemplateContents) !== null && _12 !== void 0 ? _12 : []);
        }
        const projenrcJs = (_13 = options.projenrcJs) !== null && _13 !== void 0 ? _13 : !options.projenrcJson;
        if (projenrcJs) {
            new projenrc_1.Projenrc(this, options.projenrcJsOptions);
        }
        // add a bundler component - this enables things like Lambda bundling and in the future web bundling.
        this.bundler = new bundler_1.Bundler(this, options.bundlerOptions);
    }
    /**
     * @deprecated use `package.allowLibraryDependencies`
     */
    get allowLibraryDependencies() { return this.package.allowLibraryDependencies; }
    /**
     * @deprecated use `package.entrypoint`
     */
    get entrypoint() { return this.package.entrypoint; }
    /**
     * (experimental) Minimum node.js version required by this package.
     *
     * @experimental
     */
    get minNodeVersion() { return this.package.minNodeVersion; }
    /**
     * (experimental) Maximum node version required by this pacakge.
     *
     * @experimental
     */
    get maxNodeVersion() { return this.package.maxNodeVersion; }
    /**
     * (deprecated) The package manager to use.
     *
     * @deprecated use `package.packageManager`
     */
    get packageManager() { return this.package.packageManager; }
    /**
     * @deprecated use `package.addField(x, y)`
     */
    get manifest() {
        return this.package.manifest;
    }
    /**
     * @experimental
     */
    addBins(bins) {
        this.package.addBin(bins);
    }
    /**
     * (experimental) Replaces the contents of an npm package.json script.
     *
     * @param name The script name.
     * @param command The command to execute.
     * @experimental
     */
    setScript(name, command) {
        this.package.setScript(name, command);
    }
    /**
     * (experimental) Removes the npm script (always successful).
     *
     * @param name The name of the script.
     * @experimental
     */
    removeScript(name) {
        this.package.removeScript(name);
    }
    /**
     * (experimental) Indicates if a script by the name name is defined.
     *
     * @param name The name of the script.
     * @experimental
     */
    hasScript(name) {
        return this.package.hasScript(name);
    }
    /**
     * (deprecated) DEPRECATED.
     *
     * @deprecated use `project.compileTask.exec()`
     */
    addCompileCommand(...commands) {
        for (const c of commands) {
            this.compileTask.exec(c);
        }
    }
    /**
     * (deprecated) DEPRECATED.
     *
     * @deprecated use `project.testTask.exec()`
     */
    addTestCommand(...commands) {
        for (const c of commands) {
            this.testTask.exec(c);
        }
    }
    /**
     * (experimental) Directly set fields in `package.json`.
     *
     * @param fields The fields to set.
     * @experimental
     */
    addFields(fields) {
        for (const [name, value] of Object.entries(fields)) {
            this.package.addField(name, value);
        }
    }
    /**
     * (experimental) Adds keywords to package.json (deduplicated).
     *
     * @param keywords The keywords to add.
     * @experimental
     */
    addKeywords(...keywords) {
        this.package.addKeywords(...keywords);
    }
    /**
     * @experimental
     */
    get installWorkflowSteps() {
        const install = new Array();
        // first run the workflow bootstrap steps
        install.push(...this.workflowBootstrapSteps);
        if (this.nodeVersion) {
            install.push({
                name: 'Setup Node.js',
                uses: 'actions/setup-node@v2.2.0',
                with: { 'node-version': this.nodeVersion },
            });
        }
        if (this.package.packageManager === node_package_1.NodePackageManager.PNPM) {
            install.push({
                name: 'Setup pnpm',
                uses: 'pnpm/action-setup@v2.0.1',
                with: { version: '6.14.7' },
            });
        }
        install.push({
            name: 'Install dependencies',
            run: this.package.installCommand,
        });
        return install;
    }
    /**
     * (experimental) Defines normal dependencies.
     *
     * @param deps Names modules to install.
     * @experimental
     */
    addDeps(...deps) {
        return this.package.addDeps(...deps);
    }
    /**
     * (experimental) Defines development/test dependencies.
     *
     * @param deps Names modules to install.
     * @experimental
     */
    addDevDeps(...deps) {
        return this.package.addDevDeps(...deps);
    }
    /**
     * (experimental) Defines peer dependencies.
     *
     * When adding peer dependencies, a devDependency will also be added on the
     * pinned version of the declared peer. This will ensure that you are testing
     * your code against the minimum version required from your consumers.
     *
     * @param deps Names modules to install.
     * @experimental
     */
    addPeerDeps(...deps) {
        return this.package.addPeerDeps(...deps);
    }
    /**
     * (experimental) Defines bundled dependencies.
     *
     * Bundled dependencies will be added as normal dependencies as well as to the
     * `bundledDependencies` section of your `package.json`.
     *
     * @param deps Names modules to install.
     * @experimental
     */
    addBundledDeps(...deps) {
        return this.package.addBundledDeps(...deps);
    }
    /**
     * (experimental) Exclude these files from the bundled package.
     *
     * Implemented by project types based on the
     * packaging mechanism. For example, `NodeProject` delegates this to `.npmignore`.
     *
     * @experimental
     */
    addPackageIgnore(pattern) {
        var _b;
        (_b = this.npmignore) === null || _b === void 0 ? void 0 : _b.addPatterns(pattern);
    }
    addLicense(options) {
        var _b;
        if (this.package.license) {
            new license_1.License(this, {
                spdx: this.package.license,
                copyrightOwner: (_b = options.copyrightOwner) !== null && _b !== void 0 ? _b : options.authorName,
                copyrightPeriod: options.copyrightPeriod,
            });
        }
    }
    addDefaultGitIgnore() {
        this.gitignore.exclude('# Logs', 'logs', '*.log', 'npm-debug.log*', 'yarn-debug.log*', 'yarn-error.log*', 'lerna-debug.log*', '# Diagnostic reports (https://nodejs.org/api/report.html)', 'report.[0-9]*.[0-9]*.[0-9]*.[0-9]*.json', '# Runtime data', 'pids', '*.pid', '*.seed', '*.pid.lock', '# Directory for instrumented libs generated by jscoverage/JSCover', 'lib-cov', '# Coverage directory used by tools like istanbul', 'coverage', '*.lcov', '# nyc test coverage', '.nyc_output', '# Compiled binary addons (https://nodejs.org/api/addons.html)', 'build/Release', '# Dependency directories', 'node_modules/', 'jspm_packages/', '# TypeScript cache', '*.tsbuildinfo', '# Optional eslint cache', '.eslintcache', '# Output of \'npm pack\'', '*.tgz', '# Yarn Integrity file', '.yarn-integrity', '# parcel-bundler cache (https://parceljs.org/)', '.cache');
    }
    /**
     * (experimental) Returns the shell command to execute in order to run a task.
     *
     * This will
     * typically be `npx projen TASK`.
     *
     * @param task The task for which the command is required.
     * @experimental
     */
    runTaskCommand(task) {
        return `${this.package.projenCommand} ${task.name}`;
    }
}
exports.NodeProject = NodeProject;
_a = JSII_RTTI_SYMBOL_1;
NodeProject[_a] = { fqn: "projen.javascript.NodeProject", version: "0.40.2" };
//# sourceMappingURL=data:application/json;base64,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