import { Project } from '..';
import { Component } from '../component';
import { NodeProject } from '../javascript';
/**
 * @experimental
 */
export interface EslintOptions {
    /**
     * (experimental) Path to `tsconfig.json` which should be used by eslint.
     *
     * @default "./tsconfig.json"
     * @experimental
     */
    readonly tsconfigPath?: string;
    /**
     * (experimental) Directories with source files to lint (e.g. [ "src" ]).
     *
     * @experimental
     */
    readonly dirs: string[];
    /**
     * (experimental) Directories with source files that include tests and build tools.
     *
     * These
     * sources are linted but may also import packages from `devDependencies`.
     *
     * @default []
     * @experimental
     */
    readonly devdirs?: string[];
    /**
     * (experimental) File types that should be linted (e.g. [ ".js", ".ts" ]).
     *
     * @default [".ts"]
     * @experimental
     */
    readonly fileExtensions?: string[];
    /**
     * (experimental) List of file patterns that should not be linted, using the same syntax as .gitignore patterns.
     *
     * @default [ '*.js', '*.d.ts', 'node_modules/', '*.generated.ts', 'coverage' ]
     * @experimental
     */
    readonly ignorePatterns?: string[];
    /**
     * (experimental) Should we lint .projenrc.js.
     *
     * @default true
     * @experimental
     */
    readonly lintProjenRc?: boolean;
    /**
     * (experimental) Enable prettier for code formatting.
     *
     * @default false
     * @experimental
     */
    readonly prettier?: boolean;
    /**
     * (experimental) Enable import alias for module paths.
     *
     * @default undefined
     * @experimental
     */
    readonly aliasMap?: {
        [key: string]: string;
    };
    /**
     * (experimental) Enable import alias for module paths.
     *
     * @default undefined
     * @experimental
     */
    readonly aliasExtensions?: string[];
    /**
     * (experimental) Always try to resolve types under `<root>@types` directory even it doesn't contain any source code.
     *
     * This prevents `import/no-unresolved` eslint errors when importing a `@types/*` module that would otherwise remain unresolved.
     *
     * @default true
     * @experimental
     */
    readonly tsAlwaysTryTypes?: boolean;
}
/**
 * (experimental) eslint rules override.
 *
 * @experimental
 */
export interface EslintOverride {
    /**
     * (experimental) Files or file patterns on which to apply the override.
     *
     * @experimental
     */
    readonly files: string[];
    /**
     * (experimental) The overriden rules.
     *
     * @experimental
     */
    readonly rules: {
        [rule: string]: any;
    };
}
/**
 * (experimental) Represents eslint configuration.
 *
 * @experimental
 */
export declare class Eslint extends Component {
    /**
     * (experimental) Returns the singletone Eslint component of a project or undefined if there is none.
     *
     * @experimental
     */
    static of(project: Project): Eslint | undefined;
    /**
     * (experimental) eslint rules.
     *
     * @experimental
     */
    readonly rules: {
        [rule: string]: any[];
    };
    /**
     * (experimental) eslint overrides.
     *
     * @experimental
     */
    readonly overrides: EslintOverride[];
    /**
     * (experimental) Direct access to the eslint configuration (escape hatch).
     *
     * @experimental
     */
    readonly config: any;
    /**
     * (experimental) File patterns that should not be linted.
     *
     * @experimental
     */
    readonly ignorePatterns: string[];
    private readonly _allowDevDeps;
    /**
     * @experimental
     */
    constructor(project: NodeProject, options: EslintOptions);
    /**
     * (experimental) Add an eslint rule.
     *
     * @experimental
     */
    addRules(rules: {
        [rule: string]: any;
    }): void;
    /**
     * (experimental) Add an eslint override.
     *
     * @experimental
     */
    addOverride(override: EslintOverride): void;
    /**
     * (experimental) Do not lint these files.
     *
     * @experimental
     */
    addIgnorePattern(pattern: string): void;
    /**
     * (experimental) Add a glob file pattern which allows importing dev dependencies.
     *
     * @param pattern glob pattern.
     * @experimental
     */
    allowDevDeps(pattern: string): void;
    private renderDevDepsAllowList;
}
