import { Task } from '../task';
import { GitHub } from './github';
import { GithubWorkflow } from './workflows';
import { ContainerOptions, JobPermissions, JobStep, JobStepOutput, Triggers } from './workflows-model';
/**
 * @experimental
 */
export interface TaskWorkflowOptions {
    /**
     * (experimental) The workflow name.
     *
     * @experimental
     */
    readonly name: string;
    /**
     * (experimental) The primary job id.
     *
     * @default "build"
     * @experimental
     */
    readonly jobId?: string;
    /**
     * @default - default image
     * @experimental
     */
    readonly container?: ContainerOptions;
    /**
     * (experimental) Adds an 'if' condition to the workflow.
     *
     * @experimental
     */
    readonly condition?: string;
    /**
     * (experimental) A directory name which contains artifacts to be uploaded (e.g. `dist`). If this is set, the contents of this directory will be uploaded as an artifact at the end of the workflow run, even if other steps fail.
     *
     * @default - not set
     * @experimental
     */
    readonly artifactsDirectory?: string;
    /**
     * (experimental) The triggers for the workflow.
     *
     * @default - by default workflows can only be triggered by manually.
     * @experimental
     */
    readonly triggers?: Triggers;
    /**
     * (experimental) Initial steps to run before the source code checkout.
     *
     * @default - not set
     * @experimental
     */
    readonly preCheckoutSteps?: JobStep[];
    /**
     * (experimental) Override for the `with` property of the source code checkout step.
     *
     * @default - not set
     * @experimental
     */
    readonly checkoutWith?: Record<string, any>;
    /**
     * (experimental) Steps to run before the main build step.
     *
     * @default - not set
     * @experimental
     */
    readonly preBuildSteps?: JobStep[];
    /**
     * (experimental) The main task to be executed.
     *
     * @experimental
     */
    readonly task: Task;
    /**
     * (experimental) Actions to run after the main build step.
     *
     * @default - not set
     * @experimental
     */
    readonly postBuildSteps?: JobStep[];
    /**
     * (experimental) Workflow environment variables.
     *
     * @default {}
     * @experimental
     */
    readonly env?: Record<string, string>;
    /**
     * (experimental) Permissions for the build job.
     *
     * @experimental
     */
    readonly permissions: JobPermissions;
    /**
     * (experimental) Mapping of job output names to values/expressions.
     *
     * @default {}
     * @experimental
     */
    readonly outputs?: {
        [name: string]: JobStepOutput;
    };
    /**
     * (experimental) The git identity to use in this workflow.
     *
     * @experimental
     */
    readonly gitIdentity?: GitIdentity;
    /**
     * (experimental) Github Runner selection labels.
     *
     * @default ["ubuntu-latest"]
     * @experimental
     */
    readonly runsOn?: string[];
}
/**
 * (experimental) A GitHub workflow for common build tasks within a project.
 *
 * @experimental
 */
export declare class TaskWorkflow extends GithubWorkflow {
    private readonly github;
    /**
     * @experimental
     */
    readonly jobId: string;
    /**
     * @experimental
     */
    constructor(github: GitHub, options: TaskWorkflowOptions);
}
/**
 * (experimental) Represents the git identity.
 *
 * @experimental
 */
export interface GitIdentity {
    /**
     * (experimental) The name of the user.
     *
     * @experimental
     */
    readonly name: string;
    /**
     * (experimental) The email address of the git user.
     *
     * @experimental
     */
    readonly email: string;
}
