"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PullRequestLint = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
const workflows_model_1 = require("./workflows-model");
/**
 * (experimental) Configure validations to run on GitHub pull requests.
 *
 * Only generates a file if at least one linter is configured.
 *
 * @experimental
 */
class PullRequestLint extends component_1.Component {
    /**
     * @experimental
     */
    constructor(github, options = {}) {
        var _b, _c, _d, _e, _f;
        super(github.project);
        // should only create a workflow if one or more linters are enabled
        if ((_b = options.semanticTitle) !== null && _b !== void 0 ? _b : true) {
            const opts = (_c = options.semanticTitleOptions) !== null && _c !== void 0 ? _c : {};
            const types = (_d = opts.types) !== null && _d !== void 0 ? _d : [
                'feat',
                'fix',
                'chore',
            ];
            const validateJob = {
                name: 'Validate PR title',
                runsOn: (_e = options.runsOn) !== null && _e !== void 0 ? _e : ['ubuntu-latest'],
                permissions: {
                    pullRequests: workflows_model_1.JobPermission.WRITE,
                },
                steps: [
                    {
                        uses: 'amannn/action-semantic-pull-request@v3.4.6',
                        env: {
                            GITHUB_TOKEN: '${{ secrets.GITHUB_TOKEN }}',
                        },
                        with: {
                            types: types.join('\n'),
                            requireScope: (_f = opts.requireScope) !== null && _f !== void 0 ? _f : false,
                        },
                    },
                ],
            };
            const workflow = github.addWorkflow('pull-request-lint');
            workflow.on({
                pullRequestTarget: {
                    types: ['labeled', 'opened', 'synchronize', 'reopened', 'ready_for_review', 'edited'],
                },
            });
            workflow.addJobs({ validate: validateJob });
        }
    }
}
exports.PullRequestLint = PullRequestLint;
_a = JSII_RTTI_SYMBOL_1;
PullRequestLint[_a] = { fqn: "projen.github.PullRequestLint", version: "0.40.2" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicHVsbC1yZXF1ZXN0LWxpbnQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9zcmMvZ2l0aHViL3B1bGwtcmVxdWVzdC1saW50LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQ0EsNENBQXlDO0FBQ3pDLHVEQUF1RDs7Ozs7Ozs7QUF3QnZELE1BQWEsZUFBZ0IsU0FBUSxxQkFBUzs7OztJQUM1QyxZQUFZLE1BQWMsRUFBRSxVQUFrQyxFQUFFOztRQUM5RCxLQUFLLENBQUMsTUFBTSxDQUFDLE9BQU8sQ0FBQyxDQUFDO1FBRXRCLG1FQUFtRTtRQUNuRSxVQUFJLE9BQU8sQ0FBQyxhQUFhLG1DQUFJLElBQUksRUFBRTtZQUNqQyxNQUFNLElBQUksU0FBRyxPQUFPLENBQUMsb0JBQW9CLG1DQUFJLEVBQUUsQ0FBQztZQUNoRCxNQUFNLEtBQUssU0FBRyxJQUFJLENBQUMsS0FBSyxtQ0FBSTtnQkFDMUIsTUFBTTtnQkFDTixLQUFLO2dCQUNMLE9BQU87YUFDUixDQUFDO1lBRUYsTUFBTSxXQUFXLEdBQVE7Z0JBQ3ZCLElBQUksRUFBRSxtQkFBbUI7Z0JBQ3pCLE1BQU0sUUFBRSxPQUFPLENBQUMsTUFBTSxtQ0FBSSxDQUFDLGVBQWUsQ0FBQztnQkFDM0MsV0FBVyxFQUFFO29CQUNYLFlBQVksRUFBRSwrQkFBYSxDQUFDLEtBQUs7aUJBQ2xDO2dCQUNELEtBQUssRUFBRTtvQkFDTDt3QkFDRSxJQUFJLEVBQUUsNENBQTRDO3dCQUNsRCxHQUFHLEVBQUU7NEJBQ0gsWUFBWSxFQUFFLDZCQUE2Qjt5QkFDNUM7d0JBQ0QsSUFBSSxFQUFFOzRCQUNKLEtBQUssRUFBRSxLQUFLLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQzs0QkFDdkIsWUFBWSxRQUFFLElBQUksQ0FBQyxZQUFZLG1DQUFJLEtBQUs7eUJBQ3pDO3FCQUNGO2lCQUNGO2FBQ0YsQ0FBQztZQUVGLE1BQU0sUUFBUSxHQUFHLE1BQU0sQ0FBQyxXQUFXLENBQUMsbUJBQW1CLENBQUMsQ0FBQztZQUN6RCxRQUFRLENBQUMsRUFBRSxDQUFDO2dCQUNWLGlCQUFpQixFQUFFO29CQUNqQixLQUFLLEVBQUUsQ0FBQyxTQUFTLEVBQUUsUUFBUSxFQUFFLGFBQWEsRUFBRSxVQUFVLEVBQUUsa0JBQWtCLEVBQUUsUUFBUSxDQUFDO2lCQUN0RjthQUNGLENBQUMsQ0FBQztZQUNILFFBQVEsQ0FBQyxPQUFPLENBQUMsRUFBRSxRQUFRLEVBQUUsV0FBVyxFQUFFLENBQUMsQ0FBQztTQUM3QztJQUNILENBQUM7O0FBekNILDBDQTBDQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEdpdEh1YiB9IGZyb20gJy4nO1xuaW1wb3J0IHsgQ29tcG9uZW50IH0gZnJvbSAnLi4vY29tcG9uZW50JztcbmltcG9ydCB7IEpvYiwgSm9iUGVybWlzc2lvbiB9IGZyb20gJy4vd29ya2Zsb3dzLW1vZGVsJztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBpbnRlcmZhY2UgUHVsbFJlcXVlc3RMaW50T3B0aW9ucyB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgc2VtYW50aWNUaXRsZT86IGJvb2xlYW47XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBzZW1hbnRpY1RpdGxlT3B0aW9ucz86IFNlbWFudGljVGl0bGVPcHRpb25zO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHJ1bnNPbj86IHN0cmluZ1tdO1xufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGludGVyZmFjZSBTZW1hbnRpY1RpdGxlT3B0aW9ucyB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHR5cGVzPzogc3RyaW5nW107XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSByZXF1aXJlU2NvcGU/OiBib29sZWFuO1xufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgY2xhc3MgUHVsbFJlcXVlc3RMaW50IGV4dGVuZHMgQ29tcG9uZW50IHtcbiAgY29uc3RydWN0b3IoZ2l0aHViOiBHaXRIdWIsIG9wdGlvbnM6IFB1bGxSZXF1ZXN0TGludE9wdGlvbnMgPSB7fSkge1xuICAgIHN1cGVyKGdpdGh1Yi5wcm9qZWN0KTtcblxuICAgIC8vIHNob3VsZCBvbmx5IGNyZWF0ZSBhIHdvcmtmbG93IGlmIG9uZSBvciBtb3JlIGxpbnRlcnMgYXJlIGVuYWJsZWRcbiAgICBpZiAob3B0aW9ucy5zZW1hbnRpY1RpdGxlID8/IHRydWUpIHtcbiAgICAgIGNvbnN0IG9wdHMgPSBvcHRpb25zLnNlbWFudGljVGl0bGVPcHRpb25zID8/IHt9O1xuICAgICAgY29uc3QgdHlwZXMgPSBvcHRzLnR5cGVzID8/IFtcbiAgICAgICAgJ2ZlYXQnLFxuICAgICAgICAnZml4JyxcbiAgICAgICAgJ2Nob3JlJyxcbiAgICAgIF07XG5cbiAgICAgIGNvbnN0IHZhbGlkYXRlSm9iOiBKb2IgPSB7XG4gICAgICAgIG5hbWU6ICdWYWxpZGF0ZSBQUiB0aXRsZScsXG4gICAgICAgIHJ1bnNPbjogb3B0aW9ucy5ydW5zT24gPz8gWyd1YnVudHUtbGF0ZXN0J10sXG4gICAgICAgIHBlcm1pc3Npb25zOiB7XG4gICAgICAgICAgcHVsbFJlcXVlc3RzOiBKb2JQZXJtaXNzaW9uLldSSVRFLFxuICAgICAgICB9LFxuICAgICAgICBzdGVwczogW1xuICAgICAgICAgIHtcbiAgICAgICAgICAgIHVzZXM6ICdhbWFubm4vYWN0aW9uLXNlbWFudGljLXB1bGwtcmVxdWVzdEB2My40LjYnLFxuICAgICAgICAgICAgZW52OiB7XG4gICAgICAgICAgICAgIEdJVEhVQl9UT0tFTjogJyR7eyBzZWNyZXRzLkdJVEhVQl9UT0tFTiB9fScsXG4gICAgICAgICAgICB9LFxuICAgICAgICAgICAgd2l0aDoge1xuICAgICAgICAgICAgICB0eXBlczogdHlwZXMuam9pbignXFxuJyksXG4gICAgICAgICAgICAgIHJlcXVpcmVTY29wZTogb3B0cy5yZXF1aXJlU2NvcGUgPz8gZmFsc2UsXG4gICAgICAgICAgICB9LFxuICAgICAgICAgIH0sXG4gICAgICAgIF0sXG4gICAgICB9O1xuXG4gICAgICBjb25zdCB3b3JrZmxvdyA9IGdpdGh1Yi5hZGRXb3JrZmxvdygncHVsbC1yZXF1ZXN0LWxpbnQnKTtcbiAgICAgIHdvcmtmbG93Lm9uKHtcbiAgICAgICAgcHVsbFJlcXVlc3RUYXJnZXQ6IHtcbiAgICAgICAgICB0eXBlczogWydsYWJlbGVkJywgJ29wZW5lZCcsICdzeW5jaHJvbml6ZScsICdyZW9wZW5lZCcsICdyZWFkeV9mb3JfcmV2aWV3JywgJ2VkaXRlZCddLFxuICAgICAgICB9LFxuICAgICAgfSk7XG4gICAgICB3b3JrZmxvdy5hZGRKb2JzKHsgdmFsaWRhdGU6IHZhbGlkYXRlSm9iIH0pO1xuICAgIH1cbiAgfVxufVxuIl19