"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.setGitIdentityStep = exports.DEFAULT_GITHUB_ACTIONS_USER = void 0;
/**
 * Represents the github-actions user.
 *
 * Use this when you need to perform a commit as part of your workflow.
 */
exports.DEFAULT_GITHUB_ACTIONS_USER = {
    name: 'github-actions',
    email: 'github-actions@github.com',
};
/**
 * Workflow flow to configure git with the github actions identity.
 */
function setGitIdentityStep(id) {
    return {
        name: 'Set git identity',
        run: [
            `git config user.name "${id.name}"`,
            `git config user.email "${id.email}"`,
        ].join('\n'),
    };
}
exports.setGitIdentityStep = setGitIdentityStep;
;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY29uc3RhbnRzLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vc3JjL2dpdGh1Yi9jb25zdGFudHMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBR0E7Ozs7R0FJRztBQUNVLFFBQUEsMkJBQTJCLEdBQWdCO0lBQ3RELElBQUksRUFBRSxnQkFBZ0I7SUFDdEIsS0FBSyxFQUFFLDJCQUEyQjtDQUNuQyxDQUFDO0FBRUY7O0dBRUc7QUFDSCxTQUFnQixrQkFBa0IsQ0FBQyxFQUFlO0lBQ2hELE9BQU87UUFDTCxJQUFJLEVBQUUsa0JBQWtCO1FBQ3hCLEdBQUcsRUFBRTtZQUNILHlCQUF5QixFQUFFLENBQUMsSUFBSSxHQUFHO1lBQ25DLDBCQUEwQixFQUFFLENBQUMsS0FBSyxHQUFHO1NBQ3RDLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQztLQUNiLENBQUM7QUFDSixDQUFDO0FBUkQsZ0RBUUM7QUFBQSxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgR2l0SWRlbnRpdHkgfSBmcm9tICcuJztcbmltcG9ydCAqIGFzIHdvcmtmbG93IGZyb20gJy4vd29ya2Zsb3dzLW1vZGVsJztcblxuLyoqXG4gKiBSZXByZXNlbnRzIHRoZSBnaXRodWItYWN0aW9ucyB1c2VyLlxuICpcbiAqIFVzZSB0aGlzIHdoZW4geW91IG5lZWQgdG8gcGVyZm9ybSBhIGNvbW1pdCBhcyBwYXJ0IG9mIHlvdXIgd29ya2Zsb3cuXG4gKi9cbmV4cG9ydCBjb25zdCBERUZBVUxUX0dJVEhVQl9BQ1RJT05TX1VTRVI6IEdpdElkZW50aXR5ID0ge1xuICBuYW1lOiAnZ2l0aHViLWFjdGlvbnMnLFxuICBlbWFpbDogJ2dpdGh1Yi1hY3Rpb25zQGdpdGh1Yi5jb20nLFxufTtcblxuLyoqXG4gKiBXb3JrZmxvdyBmbG93IHRvIGNvbmZpZ3VyZSBnaXQgd2l0aCB0aGUgZ2l0aHViIGFjdGlvbnMgaWRlbnRpdHkuXG4gKi9cbmV4cG9ydCBmdW5jdGlvbiBzZXRHaXRJZGVudGl0eVN0ZXAoaWQ6IEdpdElkZW50aXR5KTogd29ya2Zsb3cuSm9iU3RlcCB7XG4gIHJldHVybiB7XG4gICAgbmFtZTogJ1NldCBnaXQgaWRlbnRpdHknLFxuICAgIHJ1bjogW1xuICAgICAgYGdpdCBjb25maWcgdXNlci5uYW1lIFwiJHtpZC5uYW1lfVwiYCxcbiAgICAgIGBnaXQgY29uZmlnIHVzZXIuZW1haWwgXCIke2lkLmVtYWlsfVwiYCxcbiAgICBdLmpvaW4oJ1xcbicpLFxuICB9O1xufTtcbiJdfQ==