"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AutoApprove = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
const workflows_model_1 = require("./workflows-model");
/**
 * (experimental) Auto approve pull requests that meet a criteria.
 *
 * @experimental
 */
class AutoApprove extends component_1.Component {
    /**
     * @experimental
     */
    constructor(github, options) {
        var _b, _c, _d;
        super(github.project);
        this.label = (_b = options.label) !== null && _b !== void 0 ? _b : 'auto-approve';
        const usernames = (_c = options.allowedUsernames) !== null && _c !== void 0 ? _c : ['github-actions[bot]'];
        let condition = `contains(github.event.pull_request.labels.*.name, '${this.label}')`;
        if (usernames.length > 0) {
            condition += ' && (';
            condition += usernames.map(u => `github.event.pull_request.user.login == '${u}'`).join(' || ');
            condition += ')';
        }
        const approveJob = {
            runsOn: (_d = options.runsOn) !== null && _d !== void 0 ? _d : ['ubuntu-latest'],
            permissions: {
                pullRequests: workflows_model_1.JobPermission.WRITE,
            },
            if: condition,
            steps: [{
                    uses: 'hmarr/auto-approve-action@v2.1.0',
                    with: {
                        'github-token': `\${{ secrets.${options.secret} }}`,
                    },
                }],
        };
        const workflow = github.addWorkflow('auto-approve');
        workflow.on({
            // The 'pull request' event gives the workflow 'read-only' permissions on some
            // pull requests (such as the ones from dependabot) when using the `GITHUB_TOKEN`
            // security token. This prevents the workflow from approving these pull requests.
            // Github has placed this guard so as to prevent security attacks by simply opening
            // a pull request and triggering a workflow on a commit that was not vetted to make
            // unintended changes to the repository.
            //
            // Instead use the 'pull request target' event here that gives the Github workflow
            // 'read-write' permissions. This is safe because, this event, unlike the 'pull request'
            // event references the BASE commit of the pull request and not the HEAD commit.
            pullRequestTarget: {
                types: ['labeled', 'opened', 'synchronize', 'reopened', 'ready_for_review'],
            },
        });
        workflow.addJobs({ approve: approveJob });
    }
}
exports.AutoApprove = AutoApprove;
_a = JSII_RTTI_SYMBOL_1;
AutoApprove[_a] = { fqn: "projen.github.AutoApprove", version: "0.40.2" };
//# sourceMappingURL=data:application/json;base64,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