import { Component } from '../component';
import { GitHub } from './github';
/**
 * (experimental) Options for 'AutoApprove'.
 *
 * @experimental
 */
export interface AutoApproveOptions {
    /**
     * (experimental) Only pull requests authored by these Github usernames will be auto-approved.
     *
     * @default ['github-bot']
     * @experimental
     */
    readonly allowedUsernames?: string[];
    /**
     * (experimental) Only pull requests with this label will be auto-approved.
     *
     * @default 'auto-approve'
     * @experimental
     */
    readonly label?: string;
    /**
     * (experimental) A GitHub secret name which contains a GitHub Access Token with write permissions for the `pull_request` scope.
     *
     * This token is used to approve pull requests.
     *
     * Github forbids an identity to approve its own pull request.
     * If your project produces automated pull requests using the Github default token -
     * {@link https://docs.github.com/en/actions/reference/authentication-in-a-workflow `GITHUB_TOKEN` }
     * - that you would like auto approved, such as when using the `depsUpgrade` property in
     * `NodeProjectOptions`, then you must use a different token here.
     *
     * @experimental
     */
    readonly secret: string;
    /**
     * (experimental) Github Runner selection labels.
     *
     * @default ["ubuntu-latest"]
     * @experimental
     */
    readonly runsOn?: string[];
}
/**
 * (experimental) Auto approve pull requests that meet a criteria.
 *
 * @experimental
 */
export declare class AutoApprove extends Component {
    /**
     * @experimental
     */
    readonly label: string;
    /**
     * @experimental
     */
    constructor(github: GitHub, options: AutoApproveOptions);
}
