"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GitAttributesFile = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const file_1 = require("./file");
/**
 * (experimental) Assign attributes to file names in a git repository.
 *
 * @see https://git-scm.com/docs/gitattributes
 * @experimental
 */
class GitAttributesFile extends file_1.FileBase {
    /**
     * @experimental
     */
    constructor(project) {
        super(project, '.gitattributes', {
            editGitignore: false,
        });
        this.attributes = new Map();
    }
    /**
     * (experimental) Maps a set of attributes to a set of files.
     *
     * @param glob Glob pattern to match files in the repo.
     * @param attributes Attributes to assign to these files.
     * @experimental
     */
    addAttributes(glob, ...attributes) {
        if (!this.attributes.has(glob)) {
            this.attributes.set(glob, new Set());
        }
        const set = this.attributes.get(glob);
        for (const attribute of attributes) {
            set.add(attribute);
        }
    }
    /**
     * (experimental) Implemented by derived classes and returns the contents of the file to emit.
     *
     * @experimental
     */
    synthesizeContent(_) {
        // We can assume the file map is never empty.
        const entries = Array.from(this.attributes.entries())
            .sort(([l], [r]) => l.localeCompare(r));
        if (entries.length === 0) {
            return undefined;
        }
        return [
            `# ${file_1.FileBase.PROJEN_MARKER}`,
            '',
            ...entries.map(([name, attributes]) => `${name} ${Array.from(attributes).join(' ')}`),
        ].join('\n');
    }
}
exports.GitAttributesFile = GitAttributesFile;
_a = JSII_RTTI_SYMBOL_1;
GitAttributesFile[_a] = { fqn: "projen.GitAttributesFile", version: "0.40.2" };
//# sourceMappingURL=data:application/json;base64,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