"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConstructLibraryCdk8s = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk_1 = require("../cdk");
/**
 * (experimental) CDK8s construct library project.
 *
 * A multi-language (jsii) construct library which vends constructs designed to
 * use within the CDK for Kubernetes (CDK8s), with a friendly workflow and
 * automatic publishing to the construct catalog.
 *
 * @experimental
 * @pjid cdk8s-construct
 */
class ConstructLibraryCdk8s extends cdk_1.ConstructLibrary {
    /**
     * @experimental
     */
    constructor(options) {
        super(options);
        if (!options.cdk8sVersion) {
            throw new Error('Required field cdk8sVersion is not specified.');
        }
        this.cdk8sVersion = options.cdk8sVersionPinning ? options.cdk8sVersion : `^${options.cdk8sVersion}`;
        if (options.constructsVersion) {
            this.constructsVersion = options.constructsVersionPinning ? options.constructsVersion : `^${options.constructsVersion}`;
        }
        else {
            this.constructsVersion = '^3.2.34';
        }
        this.addPeerDeps(`constructs@${this.constructsVersion}`, `cdk8s@${this.cdk8sVersion}`);
    }
}
exports.ConstructLibraryCdk8s = ConstructLibraryCdk8s;
_a = JSII_RTTI_SYMBOL_1;
ConstructLibraryCdk8s[_a] = { fqn: "projen.cdk8s.ConstructLibraryCdk8s", version: "0.40.2" };
//# sourceMappingURL=data:application/json;base64,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