"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.JsiiProject = exports.Stability = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const semver = require("semver");
const typescript_1 = require("../typescript");
const jsii_docgen_1 = require("./jsii-docgen");
const SUPERCHAIN_IMAGE = 'jsii/superchain:1-buster-slim';
const SUPERCHAIN_NODE_VERSIONS = [12, 14, 16]; // supported jsii/superchain image tags: `1-buster-slim-nodeNN`
const EMAIL_REGEX = /(?:[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*|"(?:[\x01-\x08\x0b\x0c\x0e-\x1f\x21\x23-\x5b\x5d-\x7f]|\\[\x01-\x09\x0b\x0c\x0e-\x7f])*")@(?:(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?|\[(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?|[a-z0-9-]*[a-z0-9]:(?:[\x01-\x08\x0b\x0c\x0e-\x1f\x21-\x5a\x53-\x7f]|\\[\x01-\x09\x0b\x0c\x0e-\x7f])+)\])/;
const URL_REGEX = /((([A-Za-z]{3,9}:(?:\/\/)?)(?:[\-;:&=\+\$,\w]+@)?[A-Za-z0-9\.\-]+|(?:www\.|[\-;:&=\+\$,\w]+@)[A-Za-z0-9\.\-]+)((?:\/[\+~%\/\.\w\-_]*)?\??(?:[\-\+=&;%@\.\w_]*)#?(?:[\.\!\/\\\w]*))?)/;
/**
 * @experimental
 */
var Stability;
(function (Stability) {
    Stability["EXPERIMENTAL"] = "experimental";
    Stability["STABLE"] = "stable";
    Stability["DEPRECATED"] = "deprecated";
})(Stability = exports.Stability || (exports.Stability = {}));
/**
 * (experimental) Multi-language jsii library project.
 *
 * @experimental
 * @pjid jsii
 */
class JsiiProject extends typescript_1.TypeScriptProject {
    /**
     * @experimental
     */
    constructor(options) {
        var _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q;
        const { authorEmail, authorUrl } = parseAuthorAddress(options);
        super({
            repository: options.repositoryUrl,
            authorName: options.author,
            authorEmail,
            authorUrl,
            ...options,
            workflowContainerImage: (_b = options.workflowContainerImage) !== null && _b !== void 0 ? _b : determineSuperchainImage(options.minNodeVersion),
            // this is needed temporarily because our release workflows use the 'gh'
            // cli and its not yet available in jsii/superchain:node14
            releaseWorkflowSetupSteps: options.releaseWorkflowSetupSteps,
            releaseToNpm: false,
            disableTsconfig: true,
            docgen: false,
        });
        const srcdir = this.srcdir;
        const libdir = this.libdir;
        this.addFields({ types: `${libdir}/index.d.ts` });
        // this is an unhelpful warning
        const jsiiFlags = [
            '--silence-warnings=reserved-word',
            '--no-fix-peer-dependencies',
        ].join(' ');
        const compatIgnore = (_c = options.compatIgnore) !== null && _c !== void 0 ? _c : '.compatignore';
        this.addFields({ stability: (_d = options.stability) !== null && _d !== void 0 ? _d : Stability.STABLE });
        if (options.stability === Stability.DEPRECATED) {
            this.addFields({ deprecated: true });
        }
        const compatTask = this.addTask('compat', {
            description: 'Perform API compatibility check against latest version',
            exec: `jsii-diff npm:$(node -p "require(\'./package.json\').name") -k --ignore-file ${compatIgnore} || (echo "\nUNEXPECTED BREAKING CHANGES: add keys such as \'removed:constructs.Node.of\' to ${compatIgnore} to skip.\n" && exit 1)`,
        });
        const compat = (_e = options.compat) !== null && _e !== void 0 ? _e : false;
        if (compat) {
            this.compileTask.spawn(compatTask);
        }
        this.compileTask.reset(`jsii ${jsiiFlags}`);
        this.watchTask.reset(`jsii -w ${jsiiFlags}`);
        (_f = this.packageTask) === null || _f === void 0 ? void 0 : _f.reset('jsii-pacmak');
        const targets = {};
        const jsii = {
            outdir: 'dist',
            targets,
            tsc: {
                outDir: libdir,
                rootDir: srcdir,
            },
        };
        if (options.excludeTypescript) {
            jsii.excludeTypescript = options.excludeTypescript;
        }
        this.addFields({ jsii });
        if (options.releaseToNpm != false) {
            (_g = this.publisher) === null || _g === void 0 ? void 0 : _g.publishToNpm({
                registry: this.package.npmRegistry,
                npmTokenSecret: this.package.npmTokenSecret,
            });
        }
        // we cannot call an option `java` because the java code generated by jsii
        // does not compile due to a conflict between this option name and the `java`
        // package (e.g. when `java.util.Objects` is referenced).
        if ('java' in options) {
            throw new Error('the "java" option is now called "publishToMaven"');
        }
        if (options.publishToMaven) {
            targets.java = {
                package: options.publishToMaven.javaPackage,
                maven: {
                    groupId: options.publishToMaven.mavenGroupId,
                    artifactId: options.publishToMaven.mavenArtifactId,
                },
            };
            (_h = this.publisher) === null || _h === void 0 ? void 0 : _h.publishToMaven(options.publishToMaven);
        }
        const pypi = (_j = options.publishToPypi) !== null && _j !== void 0 ? _j : options.python;
        if (pypi) {
            targets.python = {
                distName: pypi.distName,
                module: pypi.module,
            };
            (_k = this.publisher) === null || _k === void 0 ? void 0 : _k.publishToPyPi(pypi);
        }
        const nuget = (_l = options.publishToNuget) !== null && _l !== void 0 ? _l : options.dotnet;
        if (nuget) {
            targets.dotnet = {
                namespace: nuget.dotNetNamespace,
                packageId: nuget.packageId,
            };
            (_m = this.publisher) === null || _m === void 0 ? void 0 : _m.publishToNuget(nuget);
        }
        const golang = options.publishToGo;
        if (golang) {
            targets.go = {
                moduleName: golang.moduleName,
            };
            (_o = this.publisher) === null || _o === void 0 ? void 0 : _o.publishToGo(golang);
        }
        this.addDevDeps('jsii', 'jsii-diff', 'jsii-pacmak');
        this.gitignore.exclude('.jsii', 'tsconfig.json');
        (_p = this.npmignore) === null || _p === void 0 ? void 0 : _p.include('.jsii');
        if ((_q = options.docgen) !== null && _q !== void 0 ? _q : true) {
            new jsii_docgen_1.JsiiDocgen(this);
        }
        // jsii updates .npmignore, so we make it writable
        if (this.npmignore) {
            this.npmignore.readonly = false;
        }
    }
}
exports.JsiiProject = JsiiProject;
_a = JSII_RTTI_SYMBOL_1;
JsiiProject[_a] = { fqn: "projen.cdk.JsiiProject", version: "0.40.2" };
function parseAuthorAddress(options) {
    let authorEmail = options.authorEmail;
    let authorUrl = options.authorUrl;
    if (options.authorAddress) {
        if (options.authorEmail && options.authorEmail !== options.authorAddress) {
            throw new Error('authorEmail is deprecated and cannot be used in conjunction with authorAddress');
        }
        if (options.authorUrl && options.authorUrl !== options.authorAddress) {
            throw new Error('authorUrl is deprecated and cannot be used in conjunction with authorAddress.');
        }
        if (EMAIL_REGEX.test(options.authorAddress)) {
            authorEmail = options.authorAddress;
        }
        else if (URL_REGEX.test(options.authorAddress)) {
            authorUrl = options.authorAddress;
        }
        else {
            throw new Error(`authorAddress must be either an email address or a URL: ${options.authorAddress}`);
        }
    }
    return { authorEmail, authorUrl };
}
/**
 * Determines the jsii/superchain image to use based on the minimum node
 * version.
 *
 * @param minNodeVersion The minimum node version of the project. If not
 * specified, v14.17.4 is used.
 */
function determineSuperchainImage(minNodeVersion) {
    // the default image (`jsii/superchain:1-buster-slim`) will include the
    // minimum supported node version of JSII (as of this writing it is 12.x).
    if (!minNodeVersion) {
        return SUPERCHAIN_IMAGE;
    }
    const major = semver.major(minNodeVersion);
    if (!SUPERCHAIN_NODE_VERSIONS.includes(major)) {
        throw new Error(`No jsii/superchain image available for node ${major}.x. Supported node versions: ${SUPERCHAIN_NODE_VERSIONS.map(m => `${m}.x`).join(',')}`);
    }
    return `${SUPERCHAIN_IMAGE}-node${major}`;
}
//# sourceMappingURL=data:application/json;base64,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