"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsCdkJavaApp = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path_1 = require("path");
const semver = require("semver");
const __1 = require("..");
const java_1 = require("../java");
const cdk_config_1 = require("./cdk-config");
const cdk_tasks_1 = require("./cdk-tasks");
/**
 * (experimental) AWS CDK app in Java.
 *
 * @experimental
 * @pjid awscdk-app-java
 */
class AwsCdkJavaApp extends java_1.JavaProject {
    /**
     * @experimental
     */
    constructor(options) {
        var _b, _c, _d;
        const mainClassComponents = options.mainClass.split('.');
        const mainPackage = mainClassComponents.slice(0, -1);
        const mainClassName = mainClassComponents[mainClassComponents.length - 1];
        super({
            ...options,
            sample: false,
            sampleJavaPackage: mainPackage.join('.'),
        });
        this.mainClass = options.mainClass;
        this.mainPackage = mainPackage.join('.');
        this.mainClassName = mainClassName;
        this.cdkVersion = options.cdkVersion;
        if (!this.cdkVersion) {
            throw new Error('Required field cdkVersion is not specified.');
        }
        const cdkMajorVersion = (_c = (_b = semver.minVersion(this.cdkVersion)) === null || _b === void 0 ? void 0 : _b.major) !== null && _c !== void 0 ? _c : 1;
        if (cdkMajorVersion >= 2) {
            throw new Error('CDKv2 is still not supported');
        }
        this.addCdkDependency('core');
        this.addCdkDependency(...(_d = options.cdkDependencies) !== null && _d !== void 0 ? _d : []);
        this.cdkTasks = new cdk_tasks_1.CdkTasks(this);
        this.postCompileTask.spawn(this.cdkTasks.synth);
        this.cdkConfig = new cdk_config_1.CdkConfig(this, {
            app: `mvn exec:java --quiet -Dexec.mainClass=${this.mainClass}`,
            ...options,
        });
        this.addSample();
    }
    /**
     * (experimental) Adds an AWS CDK module dependencies.
     *
     * @param modules The list of modules to depend on (e.g. "core", "aws-lambda", etc).
     * @experimental
     */
    addCdkDependency(...modules) {
        for (const m of modules) {
            this.addDependency(`software.amazon.awscdk/${m}@${this.cdkVersion}`);
        }
    }
    addSample() {
        const pkg = this.mainPackage.split('.');
        const javaFile = `${this.mainClassName}.java`;
        new __1.SampleDir(this, path_1.join('src', 'main', 'java', ...pkg), {
            files: {
                [javaFile]: [
                    `package ${pkg.join('.')};`,
                    '',
                    'import software.amazon.awscdk.core.App;',
                    'import software.amazon.awscdk.core.Stack;',
                    '',
                    `public class ${this.mainClassName} {`,
                    '  public static void main(final String[] args) {',
                    '    App app = new App();',
                    '    new Stack(app, "MyStack");',
                    '    app.synth();',
                    '  }',
                    '}',
                ].join('\n'),
            },
        });
    }
}
exports.AwsCdkJavaApp = AwsCdkJavaApp;
_a = JSII_RTTI_SYMBOL_1;
AwsCdkJavaApp[_a] = { fqn: "projen.awscdk.AwsCdkJavaApp", version: "0.40.2" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiamF2YS1hcHAuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9zcmMvYXdzY2RrL2phdmEtYXBwLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEsK0JBQTRCO0FBQzVCLGlDQUFpQztBQUNqQywwQkFBK0I7QUFDL0Isa0NBQTBEO0FBQzFELDZDQUFpRTtBQUNqRSwyQ0FBdUM7Ozs7Ozs7QUFjdkMsTUFBYSxhQUFjLFNBQVEsa0JBQVc7Ozs7SUFtQjVDLFlBQVksT0FBNkI7O1FBQ3ZDLE1BQU0sbUJBQW1CLEdBQUcsT0FBTyxDQUFDLFNBQVMsQ0FBQyxLQUFLLENBQUMsR0FBRyxDQUFDLENBQUM7UUFDekQsTUFBTSxXQUFXLEdBQUcsbUJBQW1CLENBQUMsS0FBSyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDO1FBQ3JELE1BQU0sYUFBYSxHQUFHLG1CQUFtQixDQUFDLG1CQUFtQixDQUFDLE1BQU0sR0FBRyxDQUFDLENBQUMsQ0FBQztRQUUxRSxLQUFLLENBQUM7WUFDSixHQUFHLE9BQU87WUFDVixNQUFNLEVBQUUsS0FBSztZQUNiLGlCQUFpQixFQUFFLFdBQVcsQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDO1NBQ3pDLENBQUMsQ0FBQztRQUVILElBQUksQ0FBQyxTQUFTLEdBQUcsT0FBTyxDQUFDLFNBQVMsQ0FBQztRQUNuQyxJQUFJLENBQUMsV0FBVyxHQUFHLFdBQVcsQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDLENBQUM7UUFDekMsSUFBSSxDQUFDLGFBQWEsR0FBRyxhQUFhLENBQUM7UUFDbkMsSUFBSSxDQUFDLFVBQVUsR0FBRyxPQUFPLENBQUMsVUFBVSxDQUFDO1FBRXJDLElBQUksQ0FBQyxJQUFJLENBQUMsVUFBVSxFQUFFO1lBQ3BCLE1BQU0sSUFBSSxLQUFLLENBQUMsNkNBQTZDLENBQUMsQ0FBQztTQUNoRTtRQUVELE1BQU0sZUFBZSxlQUFHLE1BQU0sQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLFVBQVUsQ0FBQywwQ0FBRSxLQUFLLG1DQUFJLENBQUMsQ0FBQztRQUN2RSxJQUFJLGVBQWUsSUFBSSxDQUFDLEVBQUU7WUFDeEIsTUFBTSxJQUFJLEtBQUssQ0FBQyw4QkFBOEIsQ0FBQyxDQUFDO1NBQ2pEO1FBRUQsSUFBSSxDQUFDLGdCQUFnQixDQUFDLE1BQU0sQ0FBQyxDQUFDO1FBQzlCLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxTQUFHLE9BQU8sQ0FBQyxlQUFlLG1DQUFJLEVBQUUsQ0FBQyxDQUFDO1FBRXhELElBQUksQ0FBQyxRQUFRLEdBQUcsSUFBSSxvQkFBUSxDQUFDLElBQUksQ0FBQyxDQUFDO1FBQ25DLElBQUksQ0FBQyxlQUFlLENBQUMsS0FBSyxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsS0FBSyxDQUFDLENBQUM7UUFFaEQsSUFBSSxDQUFDLFNBQVMsR0FBRyxJQUFJLHNCQUFTLENBQUMsSUFBSSxFQUFFO1lBQ25DLEdBQUcsRUFBRSwwQ0FBMEMsSUFBSSxDQUFDLFNBQVMsRUFBRTtZQUMvRCxHQUFHLE9BQU87U0FDWCxDQUFDLENBQUM7UUFFSCxJQUFJLENBQUMsU0FBUyxFQUFFLENBQUM7SUFDbkIsQ0FBQzs7Ozs7OztJQUdNLGdCQUFnQixDQUFDLEdBQUcsT0FBaUI7UUFDMUMsS0FBSyxNQUFNLENBQUMsSUFBSSxPQUFPLEVBQUU7WUFDdkIsSUFBSSxDQUFDLGFBQWEsQ0FBQywwQkFBMEIsQ0FBQyxJQUFJLElBQUksQ0FBQyxVQUFVLEVBQUUsQ0FBQyxDQUFDO1NBQ3RFO0lBQ0gsQ0FBQztJQUVPLFNBQVM7UUFDZixNQUFNLEdBQUcsR0FBRyxJQUFJLENBQUMsV0FBVyxDQUFDLEtBQUssQ0FBQyxHQUFHLENBQUMsQ0FBQztRQUN4QyxNQUFNLFFBQVEsR0FBRyxHQUFHLElBQUksQ0FBQyxhQUFhLE9BQU8sQ0FBQztRQUM5QyxJQUFJLGFBQVMsQ0FBQyxJQUFJLEVBQUUsV0FBSSxDQUFDLEtBQUssRUFBRSxNQUFNLEVBQUUsTUFBTSxFQUFFLEdBQUcsR0FBRyxDQUFDLEVBQUU7WUFDdkQsS0FBSyxFQUFFO2dCQUNMLENBQUMsUUFBUSxDQUFDLEVBQUU7b0JBQ1YsV0FBVyxHQUFHLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxHQUFHO29CQUMzQixFQUFFO29CQUNGLHlDQUF5QztvQkFDekMsMkNBQTJDO29CQUMzQyxFQUFFO29CQUNGLGdCQUFnQixJQUFJLENBQUMsYUFBYSxJQUFJO29CQUN0QyxrREFBa0Q7b0JBQ2xELDBCQUEwQjtvQkFDMUIsZ0NBQWdDO29CQUNoQyxrQkFBa0I7b0JBQ2xCLEtBQUs7b0JBQ0wsR0FBRztpQkFDSixDQUFDLElBQUksQ0FBQyxJQUFJLENBQUM7YUFDYjtTQUNGLENBQUMsQ0FBQztJQUNMLENBQUM7O0FBdEZILHNDQXVGQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IGpvaW4gfSBmcm9tICdwYXRoJztcbmltcG9ydCAqIGFzIHNlbXZlciBmcm9tICdzZW12ZXInO1xuaW1wb3J0IHsgU2FtcGxlRGlyIH0gZnJvbSAnLi4nO1xuaW1wb3J0IHsgSmF2YVByb2plY3QsIEphdmFQcm9qZWN0T3B0aW9ucyB9IGZyb20gJy4uL2phdmEnO1xuaW1wb3J0IHsgQ2RrQ29uZmlnLCBDZGtDb25maWdDb21tb25PcHRpb25zIH0gZnJvbSAnLi9jZGstY29uZmlnJztcbmltcG9ydCB7IENka1Rhc2tzIH0gZnJvbSAnLi9jZGstdGFza3MnO1xuXG5leHBvcnQgaW50ZXJmYWNlIEF3c0Nka0phdmFBcHBPcHRpb25zIGV4dGVuZHMgSmF2YVByb2plY3RPcHRpb25zLCBDZGtDb25maWdDb21tb25PcHRpb25zIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGNka1ZlcnNpb246IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgY2RrRGVwZW5kZW5jaWVzPzogc3RyaW5nW107XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgbWFpbkNsYXNzOiBzdHJpbmc7XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgY2xhc3MgQXdzQ2RrSmF2YUFwcCBleHRlbmRzIEphdmFQcm9qZWN0IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgcmVhZG9ubHkgY2RrVmVyc2lvbjogc3RyaW5nO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyByZWFkb25seSBjZGtDb25maWc6IENka0NvbmZpZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyByZWFkb25seSBtYWluQ2xhc3M6IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyByZWFkb25seSBjZGtUYXNrczogQ2RrVGFza3M7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgcmVhZG9ubHkgbWFpblBhY2thZ2U6IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgcmVhZG9ubHkgbWFpbkNsYXNzTmFtZTogc3RyaW5nO1xuXG4gIGNvbnN0cnVjdG9yKG9wdGlvbnM6IEF3c0Nka0phdmFBcHBPcHRpb25zKSB7XG4gICAgY29uc3QgbWFpbkNsYXNzQ29tcG9uZW50cyA9IG9wdGlvbnMubWFpbkNsYXNzLnNwbGl0KCcuJyk7XG4gICAgY29uc3QgbWFpblBhY2thZ2UgPSBtYWluQ2xhc3NDb21wb25lbnRzLnNsaWNlKDAsIC0xKTtcbiAgICBjb25zdCBtYWluQ2xhc3NOYW1lID0gbWFpbkNsYXNzQ29tcG9uZW50c1ttYWluQ2xhc3NDb21wb25lbnRzLmxlbmd0aCAtIDFdO1xuXG4gICAgc3VwZXIoe1xuICAgICAgLi4ub3B0aW9ucyxcbiAgICAgIHNhbXBsZTogZmFsc2UsXG4gICAgICBzYW1wbGVKYXZhUGFja2FnZTogbWFpblBhY2thZ2Uuam9pbignLicpLFxuICAgIH0pO1xuXG4gICAgdGhpcy5tYWluQ2xhc3MgPSBvcHRpb25zLm1haW5DbGFzcztcbiAgICB0aGlzLm1haW5QYWNrYWdlID0gbWFpblBhY2thZ2Uuam9pbignLicpO1xuICAgIHRoaXMubWFpbkNsYXNzTmFtZSA9IG1haW5DbGFzc05hbWU7XG4gICAgdGhpcy5jZGtWZXJzaW9uID0gb3B0aW9ucy5jZGtWZXJzaW9uO1xuXG4gICAgaWYgKCF0aGlzLmNka1ZlcnNpb24pIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcignUmVxdWlyZWQgZmllbGQgY2RrVmVyc2lvbiBpcyBub3Qgc3BlY2lmaWVkLicpO1xuICAgIH1cblxuICAgIGNvbnN0IGNka01ham9yVmVyc2lvbiA9IHNlbXZlci5taW5WZXJzaW9uKHRoaXMuY2RrVmVyc2lvbik/Lm1ham9yID8/IDE7XG4gICAgaWYgKGNka01ham9yVmVyc2lvbiA+PSAyKSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoJ0NES3YyIGlzIHN0aWxsIG5vdCBzdXBwb3J0ZWQnKTtcbiAgICB9XG5cbiAgICB0aGlzLmFkZENka0RlcGVuZGVuY3koJ2NvcmUnKTtcbiAgICB0aGlzLmFkZENka0RlcGVuZGVuY3koLi4ub3B0aW9ucy5jZGtEZXBlbmRlbmNpZXMgPz8gW10pO1xuXG4gICAgdGhpcy5jZGtUYXNrcyA9IG5ldyBDZGtUYXNrcyh0aGlzKTtcbiAgICB0aGlzLnBvc3RDb21waWxlVGFzay5zcGF3bih0aGlzLmNka1Rhc2tzLnN5bnRoKTtcblxuICAgIHRoaXMuY2RrQ29uZmlnID0gbmV3IENka0NvbmZpZyh0aGlzLCB7XG4gICAgICBhcHA6IGBtdm4gZXhlYzpqYXZhIC0tcXVpZXQgLURleGVjLm1haW5DbGFzcz0ke3RoaXMubWFpbkNsYXNzfWAsXG4gICAgICAuLi5vcHRpb25zLFxuICAgIH0pO1xuXG4gICAgdGhpcy5hZGRTYW1wbGUoKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgYWRkQ2RrRGVwZW5kZW5jeSguLi5tb2R1bGVzOiBzdHJpbmdbXSkge1xuICAgIGZvciAoY29uc3QgbSBvZiBtb2R1bGVzKSB7XG4gICAgICB0aGlzLmFkZERlcGVuZGVuY3koYHNvZnR3YXJlLmFtYXpvbi5hd3NjZGsvJHttfUAke3RoaXMuY2RrVmVyc2lvbn1gKTtcbiAgICB9XG4gIH1cblxuICBwcml2YXRlIGFkZFNhbXBsZSgpIHtcbiAgICBjb25zdCBwa2cgPSB0aGlzLm1haW5QYWNrYWdlLnNwbGl0KCcuJyk7XG4gICAgY29uc3QgamF2YUZpbGUgPSBgJHt0aGlzLm1haW5DbGFzc05hbWV9LmphdmFgO1xuICAgIG5ldyBTYW1wbGVEaXIodGhpcywgam9pbignc3JjJywgJ21haW4nLCAnamF2YScsIC4uLnBrZyksIHtcbiAgICAgIGZpbGVzOiB7XG4gICAgICAgIFtqYXZhRmlsZV06IFtcbiAgICAgICAgICBgcGFja2FnZSAke3BrZy5qb2luKCcuJyl9O2AsXG4gICAgICAgICAgJycsXG4gICAgICAgICAgJ2ltcG9ydCBzb2Z0d2FyZS5hbWF6b24uYXdzY2RrLmNvcmUuQXBwOycsXG4gICAgICAgICAgJ2ltcG9ydCBzb2Z0d2FyZS5hbWF6b24uYXdzY2RrLmNvcmUuU3RhY2s7JyxcbiAgICAgICAgICAnJyxcbiAgICAgICAgICBgcHVibGljIGNsYXNzICR7dGhpcy5tYWluQ2xhc3NOYW1lfSB7YCxcbiAgICAgICAgICAnICBwdWJsaWMgc3RhdGljIHZvaWQgbWFpbihmaW5hbCBTdHJpbmdbXSBhcmdzKSB7JyxcbiAgICAgICAgICAnICAgIEFwcCBhcHAgPSBuZXcgQXBwKCk7JyxcbiAgICAgICAgICAnICAgIG5ldyBTdGFjayhhcHAsIFwiTXlTdGFja1wiKTsnLFxuICAgICAgICAgICcgICAgYXBwLnN5bnRoKCk7JyxcbiAgICAgICAgICAnICB9JyxcbiAgICAgICAgICAnfScsXG4gICAgICAgIF0uam9pbignXFxuJyksXG4gICAgICB9LFxuICAgIH0pO1xuICB9XG59XG4iXX0=