import { JavaProject, JavaProjectOptions } from '../java';
import { CdkConfig, CdkConfigCommonOptions } from './cdk-config';
import { CdkTasks } from './cdk-tasks';
/**
 * @experimental
 */
export interface AwsCdkJavaAppOptions extends JavaProjectOptions, CdkConfigCommonOptions {
    /**
     * (experimental) AWS CDK version to use (you can use semantic versioning).
     *
     * @default "^1.130.0"
     * @experimental
     */
    readonly cdkVersion: string;
    /**
     * (experimental) Which AWS CDK modules this app uses.
     *
     * The `core` module is included by
     * default and you can add additional modules here by stating only the package
     * name (e.g. `aws-lambda`).
     *
     * @experimental
     * @featured true
     */
    readonly cdkDependencies?: string[];
    /**
     * (experimental) The name of the Java class with the static `main()` method.
     *
     * This method
     * should call `app.synth()` on the CDK app.
     *
     * @default "org.acme.App"
     * @experimental
     */
    readonly mainClass: string;
}
/**
 * (experimental) AWS CDK app in Java.
 *
 * @experimental
 * @pjid awscdk-app-java
 */
export declare class AwsCdkJavaApp extends JavaProject {
    /**
     * (experimental) The CDK version this app is using.
     *
     * @experimental
     */
    readonly cdkVersion: string;
    /**
     * (experimental) The `cdk.json` file.
     *
     * @experimental
     */
    readonly cdkConfig: CdkConfig;
    /**
     * (experimental) The full name of the main class of the java app (package.Class).
     *
     * @experimental
     */
    readonly mainClass: string;
    /**
     * (experimental) CDK tasks.
     *
     * @experimental
     */
    readonly cdkTasks: CdkTasks;
    /**
     * (experimental) The name of the Java package that includes the main class.
     *
     * @experimental
     */
    readonly mainPackage: string;
    /**
     * (experimental) The name of the Java class with the static `main()` method.
     *
     * @experimental
     */
    readonly mainClassName: string;
    /**
     * @experimental
     */
    constructor(options: AwsCdkJavaAppOptions);
    /**
     * (experimental) Adds an AWS CDK module dependencies.
     *
     * @param modules The list of modules to depend on (e.g. "core", "aws-lambda", etc).
     * @experimental
     */
    addCdkDependency(...modules: string[]): void;
    private addSample;
}
