"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegrationTest = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path_1 = require("path");
const component_1 = require("../component");
const dependencies_1 = require("../dependencies");
const internal_1 = require("./internal");
/**
 * (experimental) Cloud integration tests.
 *
 * @experimental
 */
class IntegrationTest extends component_1.Component {
    /**
     * @experimental
     */
    constructor(project, options) {
        var _b;
        super(project);
        const entry = options.entrypoint;
        const name = path_1.basename(entry, internal_1.TYPESCRIPT_INTEG_EXT);
        const dir = path_1.dirname(entry);
        const deploydir = path_1.join(dir, '.tmp', `${name}.integ`, 'deploy.cdk.out');
        const actualdir = path_1.join(dir, '.tmp', `${name}.integ`, 'synth.cdk.out');
        const snapshotdir = path_1.join(dir, `${name}.integ.snapshot`);
        const app = `ts-node -P ${options.tsconfigPath} ${entry}`;
        if (!project.deps.tryGetDependency('ts-node')) {
            project.deps.addDependency('ts-node', dependencies_1.DependencyType.BUILD);
        }
        const opts = [
            `--app "${app}"`,
            '--no-version-reporting',
        ];
        // add all feature flags
        const features = [
            ...internal_1.FEATURE_FLAGS,
            '@aws-cdk/core:newStyleStackSynthesis',
        ];
        for (const feature of features) {
            opts.push(`--context ${feature}=true`);
        }
        const cdkopts = opts.join(' ');
        const deployTask = project.addTask(`integ:${name}:deploy`, {
            description: `deploy integration test '${name}' and capture snapshot`,
        });
        deployTask.exec(`rm -fr ${deploydir}`);
        deployTask.exec(`cdk deploy ${cdkopts} --require-approval=never -o ${deploydir}`);
        // if deployment was successful, copy the deploy dir to the expected dir
        deployTask.exec(`rm -fr ${snapshotdir}`);
        deployTask.exec(`mv ${deploydir} ${snapshotdir}`);
        const watchTask = project.addTask(`integ:${name}:watch`, {
            description: `watch integration test '${name}' (without updating snapshots)`,
            exec: `cdk watch ${cdkopts} -o ${deploydir}`,
        });
        const destroyTask = project.addTask(`integ:${name}:destroy`, {
            description: `destroy integration test '${name}'`,
            exec: `cdk destroy --app ${snapshotdir} --no-version-reporting`,
        });
        const destroyAfterDeploy = (_b = options.destroyAfterDeploy) !== null && _b !== void 0 ? _b : true;
        if (destroyAfterDeploy) {
            deployTask.spawn(destroyTask);
        }
        const exclude = ['asset.*', 'cdk.out', 'manifest.json', 'tree.json'];
        const assertTask = project.addTask(`integ:${name}:assert`, {
            description: `assert the snapshot of integration test '${name}'`,
        });
        assertTask.exec(`[ -d "${snapshotdir}" ] || (echo "No snapshot available for integration test '${name}'. Run 'projen ${deployTask.name}' to capture." && exit 1)`);
        assertTask.exec(`cdk synth ${cdkopts} -o ${actualdir} > /dev/null`);
        assertTask.exec(`diff -r ${exclude.map(x => `-x ${x}`).join(' ')} ${snapshotdir}/ ${actualdir}/`);
        const snapshotTask = project.addTask(`integ:${name}:snapshot`, {
            description: `update snapshot for integration test "${name}"`,
            exec: `cdk synth ${cdkopts} -o ${snapshotdir} > /dev/null`,
        });
        // synth as part of our tests, which means that if outdir changes, anti-tamper will fail
        project.testTask.spawn(assertTask);
        project.addGitIgnore(`!${snapshotdir}`); // commit outdir to git but not assets
        // do not commit all files we are excluding
        for (const x of exclude) {
            project.addGitIgnore(`${snapshotdir}/${x}`);
            project.addGitIgnore(`${snapshotdir}/**/${x}`); // nested assemblies
        }
        project.addGitIgnore(deploydir);
        project.addPackageIgnore(deploydir);
        project.addGitIgnore(actualdir);
        project.addPackageIgnore(actualdir);
        // commit the snapshot (but not into the tarball)
        project.addGitIgnore(`!${snapshotdir}`);
        project.addPackageIgnore(snapshotdir);
        this.deployTask = deployTask;
        this.assertTask = assertTask;
        this.destroyTask = destroyTask;
        this.snapshotTask = snapshotTask;
        this.watchTask = watchTask;
    }
}
exports.IntegrationTest = IntegrationTest;
_a = JSII_RTTI_SYMBOL_1;
IntegrationTest[_a] = { fqn: "projen.awscdk.IntegrationTest", version: "0.40.2" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWdyYXRpb24tdGVzdC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy9hd3NjZGsvaW50ZWdyYXRpb24tdGVzdC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUFBLCtCQUErQztBQUMvQyw0Q0FBeUM7QUFDekMsa0RBQWlEO0FBR2pELHlDQUFpRTs7Ozs7O0FBaUJqRSxNQUFhLGVBQWdCLFNBQVEscUJBQVM7Ozs7SUFnQjVDLFlBQVksT0FBZ0IsRUFBRSxPQUErQjs7UUFDM0QsS0FBSyxDQUFDLE9BQU8sQ0FBQyxDQUFDO1FBQ2YsTUFBTSxLQUFLLEdBQUcsT0FBTyxDQUFDLFVBQVUsQ0FBQztRQUNqQyxNQUFNLElBQUksR0FBRyxlQUFRLENBQUMsS0FBSyxFQUFFLCtCQUFvQixDQUFDLENBQUM7UUFDbkQsTUFBTSxHQUFHLEdBQUcsY0FBTyxDQUFDLEtBQUssQ0FBQyxDQUFDO1FBRTNCLE1BQU0sU0FBUyxHQUFHLFdBQUksQ0FBQyxHQUFHLEVBQUUsTUFBTSxFQUFFLEdBQUcsSUFBSSxRQUFRLEVBQUUsZ0JBQWdCLENBQUMsQ0FBQztRQUN2RSxNQUFNLFNBQVMsR0FBRyxXQUFJLENBQUMsR0FBRyxFQUFFLE1BQU0sRUFBRSxHQUFHLElBQUksUUFBUSxFQUFFLGVBQWUsQ0FBQyxDQUFDO1FBQ3RFLE1BQU0sV0FBVyxHQUFHLFdBQUksQ0FBQyxHQUFHLEVBQUUsR0FBRyxJQUFJLGlCQUFpQixDQUFDLENBQUM7UUFFeEQsTUFBTSxHQUFHLEdBQUcsY0FBYyxPQUFPLENBQUMsWUFBWSxJQUFJLEtBQUssRUFBRSxDQUFDO1FBRTFELElBQUksQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLGdCQUFnQixDQUFDLFNBQVMsQ0FBQyxFQUFFO1lBQzdDLE9BQU8sQ0FBQyxJQUFJLENBQUMsYUFBYSxDQUFDLFNBQVMsRUFBRSw2QkFBYyxDQUFDLEtBQUssQ0FBQyxDQUFDO1NBQzdEO1FBRUQsTUFBTSxJQUFJLEdBQUc7WUFDWCxVQUFVLEdBQUcsR0FBRztZQUNoQix3QkFBd0I7U0FDekIsQ0FBQztRQUVGLHdCQUF3QjtRQUN4QixNQUFNLFFBQVEsR0FBRztZQUNmLEdBQUcsd0JBQWE7WUFDaEIsc0NBQXNDO1NBQ3ZDLENBQUM7UUFFRixLQUFLLE1BQU0sT0FBTyxJQUFJLFFBQVEsRUFBRTtZQUM5QixJQUFJLENBQUMsSUFBSSxDQUFDLGFBQWEsT0FBTyxPQUFPLENBQUMsQ0FBQztTQUN4QztRQUVELE1BQU0sT0FBTyxHQUFHLElBQUksQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDLENBQUM7UUFFL0IsTUFBTSxVQUFVLEdBQUcsT0FBTyxDQUFDLE9BQU8sQ0FBQyxTQUFTLElBQUksU0FBUyxFQUFFO1lBQ3pELFdBQVcsRUFBRSw0QkFBNEIsSUFBSSx3QkFBd0I7U0FDdEUsQ0FBQyxDQUFDO1FBRUgsVUFBVSxDQUFDLElBQUksQ0FBQyxVQUFVLFNBQVMsRUFBRSxDQUFDLENBQUM7UUFDdkMsVUFBVSxDQUFDLElBQUksQ0FBQyxjQUFjLE9BQU8sZ0NBQWdDLFNBQVMsRUFBRSxDQUFDLENBQUM7UUFFbEYsd0VBQXdFO1FBQ3hFLFVBQVUsQ0FBQyxJQUFJLENBQUMsVUFBVSxXQUFXLEVBQUUsQ0FBQyxDQUFDO1FBQ3pDLFVBQVUsQ0FBQyxJQUFJLENBQUMsTUFBTSxTQUFTLElBQUksV0FBVyxFQUFFLENBQUMsQ0FBQztRQUVsRCxNQUFNLFNBQVMsR0FBRyxPQUFPLENBQUMsT0FBTyxDQUFDLFNBQVMsSUFBSSxRQUFRLEVBQUU7WUFDdkQsV0FBVyxFQUFFLDJCQUEyQixJQUFJLGdDQUFnQztZQUM1RSxJQUFJLEVBQUUsYUFBYSxPQUFPLE9BQU8sU0FBUyxFQUFFO1NBQzdDLENBQUMsQ0FBQztRQUVILE1BQU0sV0FBVyxHQUFHLE9BQU8sQ0FBQyxPQUFPLENBQUMsU0FBUyxJQUFJLFVBQVUsRUFBRTtZQUMzRCxXQUFXLEVBQUUsNkJBQTZCLElBQUksR0FBRztZQUNqRCxJQUFJLEVBQUUscUJBQXFCLFdBQVcseUJBQXlCO1NBQ2hFLENBQUMsQ0FBQztRQUVILE1BQU0sa0JBQWtCLFNBQUcsT0FBTyxDQUFDLGtCQUFrQixtQ0FBSSxJQUFJLENBQUM7UUFDOUQsSUFBSSxrQkFBa0IsRUFBRTtZQUN0QixVQUFVLENBQUMsS0FBSyxDQUFDLFdBQVcsQ0FBQyxDQUFDO1NBQy9CO1FBRUQsTUFBTSxPQUFPLEdBQUcsQ0FBQyxTQUFTLEVBQUUsU0FBUyxFQUFFLGVBQWUsRUFBRSxXQUFXLENBQUMsQ0FBQztRQUVyRSxNQUFNLFVBQVUsR0FBRyxPQUFPLENBQUMsT0FBTyxDQUFDLFNBQVMsSUFBSSxTQUFTLEVBQUU7WUFDekQsV0FBVyxFQUFFLDRDQUE0QyxJQUFJLEdBQUc7U0FDakUsQ0FBQyxDQUFDO1FBRUgsVUFBVSxDQUFDLElBQUksQ0FBQyxTQUFTLFdBQVcsNkRBQTZELElBQUksa0JBQWtCLFVBQVUsQ0FBQyxJQUFJLDJCQUEyQixDQUFDLENBQUM7UUFDbkssVUFBVSxDQUFDLElBQUksQ0FBQyxhQUFhLE9BQU8sT0FBTyxTQUFTLGNBQWMsQ0FBQyxDQUFDO1FBQ3BFLFVBQVUsQ0FBQyxJQUFJLENBQUMsV0FBVyxPQUFPLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsTUFBTSxDQUFDLEVBQUUsQ0FBQyxDQUFDLElBQUksQ0FBQyxHQUFHLENBQUMsSUFBSSxXQUFXLEtBQUssU0FBUyxHQUFHLENBQUMsQ0FBQztRQUVsRyxNQUFNLFlBQVksR0FBRyxPQUFPLENBQUMsT0FBTyxDQUFDLFNBQVMsSUFBSSxXQUFXLEVBQUU7WUFDN0QsV0FBVyxFQUFFLHlDQUF5QyxJQUFJLEdBQUc7WUFDN0QsSUFBSSxFQUFFLGFBQWEsT0FBTyxPQUFPLFdBQVcsY0FBYztTQUMzRCxDQUFDLENBQUM7UUFFSCx3RkFBd0Y7UUFDeEYsT0FBTyxDQUFDLFFBQVEsQ0FBQyxLQUFLLENBQUMsVUFBVSxDQUFDLENBQUM7UUFDbkMsT0FBTyxDQUFDLFlBQVksQ0FBQyxJQUFJLFdBQVcsRUFBRSxDQUFDLENBQUMsQ0FBQyxzQ0FBc0M7UUFFL0UsMkNBQTJDO1FBQzNDLEtBQUssTUFBTSxDQUFDLElBQUksT0FBTyxFQUFFO1lBQ3ZCLE9BQU8sQ0FBQyxZQUFZLENBQUMsR0FBRyxXQUFXLElBQUksQ0FBQyxFQUFFLENBQUMsQ0FBQztZQUM1QyxPQUFPLENBQUMsWUFBWSxDQUFDLEdBQUcsV0FBVyxPQUFPLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxvQkFBb0I7U0FDckU7UUFFRCxPQUFPLENBQUMsWUFBWSxDQUFDLFNBQVMsQ0FBQyxDQUFDO1FBQ2hDLE9BQU8sQ0FBQyxnQkFBZ0IsQ0FBQyxTQUFTLENBQUMsQ0FBQztRQUNwQyxPQUFPLENBQUMsWUFBWSxDQUFDLFNBQVMsQ0FBQyxDQUFDO1FBQ2hDLE9BQU8sQ0FBQyxnQkFBZ0IsQ0FBQyxTQUFTLENBQUMsQ0FBQztRQUVwQyxpREFBaUQ7UUFDakQsT0FBTyxDQUFDLFlBQVksQ0FBQyxJQUFJLFdBQVcsRUFBRSxDQUFDLENBQUM7UUFDeEMsT0FBTyxDQUFDLGdCQUFnQixDQUFDLFdBQVcsQ0FBQyxDQUFDO1FBRXRDLElBQUksQ0FBQyxVQUFVLEdBQUcsVUFBVSxDQUFDO1FBQzdCLElBQUksQ0FBQyxVQUFVLEdBQUcsVUFBVSxDQUFDO1FBQzdCLElBQUksQ0FBQyxXQUFXLEdBQUcsV0FBVyxDQUFDO1FBQy9CLElBQUksQ0FBQyxZQUFZLEdBQUcsWUFBWSxDQUFDO1FBQ2pDLElBQUksQ0FBQyxTQUFTLEdBQUcsU0FBUyxDQUFDO0lBQzdCLENBQUM7O0FBbEhILDBDQW1IQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IGJhc2VuYW1lLCBkaXJuYW1lLCBqb2luIH0gZnJvbSAncGF0aCc7XG5pbXBvcnQgeyBDb21wb25lbnQgfSBmcm9tICcuLi9jb21wb25lbnQnO1xuaW1wb3J0IHsgRGVwZW5kZW5jeVR5cGUgfSBmcm9tICcuLi9kZXBlbmRlbmNpZXMnO1xuaW1wb3J0IHsgUHJvamVjdCB9IGZyb20gJy4uL3Byb2plY3QnO1xuaW1wb3J0IHsgVGFzayB9IGZyb20gJy4uL3Rhc2snO1xuaW1wb3J0IHsgRkVBVFVSRV9GTEFHUywgVFlQRVNDUklQVF9JTlRFR19FWFQgfSBmcm9tICcuL2ludGVybmFsJztcblxuZXhwb3J0IGludGVyZmFjZSBJbnRlZ3JhdGlvblRlc3RDb21tb25PcHRpb25zIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGRlc3Ryb3lBZnRlckRlcGxveT86IGJvb2xlYW47XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgaW50ZXJmYWNlIEludGVncmF0aW9uVGVzdE9wdGlvbnMgZXh0ZW5kcyBJbnRlZ3JhdGlvblRlc3RDb21tb25PcHRpb25zIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGVudHJ5cG9pbnQ6IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgdHNjb25maWdQYXRoOiBzdHJpbmc7XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgY2xhc3MgSW50ZWdyYXRpb25UZXN0IGV4dGVuZHMgQ29tcG9uZW50IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHJlYWRvbmx5IGRlcGxveVRhc2s6IFRhc2s7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHJlYWRvbmx5IGRlc3Ryb3lUYXNrOiBUYXNrO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgcmVhZG9ubHkgYXNzZXJ0VGFzazogVGFzaztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHJlYWRvbmx5IHNuYXBzaG90VGFzazogVGFzaztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHJlYWRvbmx5IHdhdGNoVGFzazogVGFzaztcblxuICBjb25zdHJ1Y3Rvcihwcm9qZWN0OiBQcm9qZWN0LCBvcHRpb25zOiBJbnRlZ3JhdGlvblRlc3RPcHRpb25zKSB7XG4gICAgc3VwZXIocHJvamVjdCk7XG4gICAgY29uc3QgZW50cnkgPSBvcHRpb25zLmVudHJ5cG9pbnQ7XG4gICAgY29uc3QgbmFtZSA9IGJhc2VuYW1lKGVudHJ5LCBUWVBFU0NSSVBUX0lOVEVHX0VYVCk7XG4gICAgY29uc3QgZGlyID0gZGlybmFtZShlbnRyeSk7XG5cbiAgICBjb25zdCBkZXBsb3lkaXIgPSBqb2luKGRpciwgJy50bXAnLCBgJHtuYW1lfS5pbnRlZ2AsICdkZXBsb3kuY2RrLm91dCcpO1xuICAgIGNvbnN0IGFjdHVhbGRpciA9IGpvaW4oZGlyLCAnLnRtcCcsIGAke25hbWV9LmludGVnYCwgJ3N5bnRoLmNkay5vdXQnKTtcbiAgICBjb25zdCBzbmFwc2hvdGRpciA9IGpvaW4oZGlyLCBgJHtuYW1lfS5pbnRlZy5zbmFwc2hvdGApO1xuXG4gICAgY29uc3QgYXBwID0gYHRzLW5vZGUgLVAgJHtvcHRpb25zLnRzY29uZmlnUGF0aH0gJHtlbnRyeX1gO1xuXG4gICAgaWYgKCFwcm9qZWN0LmRlcHMudHJ5R2V0RGVwZW5kZW5jeSgndHMtbm9kZScpKSB7XG4gICAgICBwcm9qZWN0LmRlcHMuYWRkRGVwZW5kZW5jeSgndHMtbm9kZScsIERlcGVuZGVuY3lUeXBlLkJVSUxEKTtcbiAgICB9XG5cbiAgICBjb25zdCBvcHRzID0gW1xuICAgICAgYC0tYXBwIFwiJHthcHB9XCJgLFxuICAgICAgJy0tbm8tdmVyc2lvbi1yZXBvcnRpbmcnLFxuICAgIF07XG5cbiAgICAvLyBhZGQgYWxsIGZlYXR1cmUgZmxhZ3NcbiAgICBjb25zdCBmZWF0dXJlcyA9IFtcbiAgICAgIC4uLkZFQVRVUkVfRkxBR1MsXG4gICAgICAnQGF3cy1jZGsvY29yZTpuZXdTdHlsZVN0YWNrU3ludGhlc2lzJywgLy8gc2ltcGxpZmllcyBhc3NldCBjb29yZGluYXRlcyBpbiBzeW50aCBvdXRwdXRcbiAgICBdO1xuXG4gICAgZm9yIChjb25zdCBmZWF0dXJlIG9mIGZlYXR1cmVzKSB7XG4gICAgICBvcHRzLnB1c2goYC0tY29udGV4dCAke2ZlYXR1cmV9PXRydWVgKTtcbiAgICB9XG5cbiAgICBjb25zdCBjZGtvcHRzID0gb3B0cy5qb2luKCcgJyk7XG5cbiAgICBjb25zdCBkZXBsb3lUYXNrID0gcHJvamVjdC5hZGRUYXNrKGBpbnRlZzoke25hbWV9OmRlcGxveWAsIHtcbiAgICAgIGRlc2NyaXB0aW9uOiBgZGVwbG95IGludGVncmF0aW9uIHRlc3QgJyR7bmFtZX0nIGFuZCBjYXB0dXJlIHNuYXBzaG90YCxcbiAgICB9KTtcblxuICAgIGRlcGxveVRhc2suZXhlYyhgcm0gLWZyICR7ZGVwbG95ZGlyfWApO1xuICAgIGRlcGxveVRhc2suZXhlYyhgY2RrIGRlcGxveSAke2Nka29wdHN9IC0tcmVxdWlyZS1hcHByb3ZhbD1uZXZlciAtbyAke2RlcGxveWRpcn1gKTtcblxuICAgIC8vIGlmIGRlcGxveW1lbnQgd2FzIHN1Y2Nlc3NmdWwsIGNvcHkgdGhlIGRlcGxveSBkaXIgdG8gdGhlIGV4cGVjdGVkIGRpclxuICAgIGRlcGxveVRhc2suZXhlYyhgcm0gLWZyICR7c25hcHNob3RkaXJ9YCk7XG4gICAgZGVwbG95VGFzay5leGVjKGBtdiAke2RlcGxveWRpcn0gJHtzbmFwc2hvdGRpcn1gKTtcblxuICAgIGNvbnN0IHdhdGNoVGFzayA9IHByb2plY3QuYWRkVGFzayhgaW50ZWc6JHtuYW1lfTp3YXRjaGAsIHtcbiAgICAgIGRlc2NyaXB0aW9uOiBgd2F0Y2ggaW50ZWdyYXRpb24gdGVzdCAnJHtuYW1lfScgKHdpdGhvdXQgdXBkYXRpbmcgc25hcHNob3RzKWAsXG4gICAgICBleGVjOiBgY2RrIHdhdGNoICR7Y2Rrb3B0c30gLW8gJHtkZXBsb3lkaXJ9YCxcbiAgICB9KTtcblxuICAgIGNvbnN0IGRlc3Ryb3lUYXNrID0gcHJvamVjdC5hZGRUYXNrKGBpbnRlZzoke25hbWV9OmRlc3Ryb3lgLCB7XG4gICAgICBkZXNjcmlwdGlvbjogYGRlc3Ryb3kgaW50ZWdyYXRpb24gdGVzdCAnJHtuYW1lfSdgLFxuICAgICAgZXhlYzogYGNkayBkZXN0cm95IC0tYXBwICR7c25hcHNob3RkaXJ9IC0tbm8tdmVyc2lvbi1yZXBvcnRpbmdgLFxuICAgIH0pO1xuXG4gICAgY29uc3QgZGVzdHJveUFmdGVyRGVwbG95ID0gb3B0aW9ucy5kZXN0cm95QWZ0ZXJEZXBsb3kgPz8gdHJ1ZTtcbiAgICBpZiAoZGVzdHJveUFmdGVyRGVwbG95KSB7XG4gICAgICBkZXBsb3lUYXNrLnNwYXduKGRlc3Ryb3lUYXNrKTtcbiAgICB9XG5cbiAgICBjb25zdCBleGNsdWRlID0gWydhc3NldC4qJywgJ2Nkay5vdXQnLCAnbWFuaWZlc3QuanNvbicsICd0cmVlLmpzb24nXTtcblxuICAgIGNvbnN0IGFzc2VydFRhc2sgPSBwcm9qZWN0LmFkZFRhc2soYGludGVnOiR7bmFtZX06YXNzZXJ0YCwge1xuICAgICAgZGVzY3JpcHRpb246IGBhc3NlcnQgdGhlIHNuYXBzaG90IG9mIGludGVncmF0aW9uIHRlc3QgJyR7bmFtZX0nYCxcbiAgICB9KTtcblxuICAgIGFzc2VydFRhc2suZXhlYyhgWyAtZCBcIiR7c25hcHNob3RkaXJ9XCIgXSB8fCAoZWNobyBcIk5vIHNuYXBzaG90IGF2YWlsYWJsZSBmb3IgaW50ZWdyYXRpb24gdGVzdCAnJHtuYW1lfScuIFJ1biAncHJvamVuICR7ZGVwbG95VGFzay5uYW1lfScgdG8gY2FwdHVyZS5cIiAmJiBleGl0IDEpYCk7XG4gICAgYXNzZXJ0VGFzay5leGVjKGBjZGsgc3ludGggJHtjZGtvcHRzfSAtbyAke2FjdHVhbGRpcn0gPiAvZGV2L251bGxgKTtcbiAgICBhc3NlcnRUYXNrLmV4ZWMoYGRpZmYgLXIgJHtleGNsdWRlLm1hcCh4ID0+IGAteCAke3h9YCkuam9pbignICcpfSAke3NuYXBzaG90ZGlyfS8gJHthY3R1YWxkaXJ9L2ApO1xuXG4gICAgY29uc3Qgc25hcHNob3RUYXNrID0gcHJvamVjdC5hZGRUYXNrKGBpbnRlZzoke25hbWV9OnNuYXBzaG90YCwge1xuICAgICAgZGVzY3JpcHRpb246IGB1cGRhdGUgc25hcHNob3QgZm9yIGludGVncmF0aW9uIHRlc3QgXCIke25hbWV9XCJgLFxuICAgICAgZXhlYzogYGNkayBzeW50aCAke2Nka29wdHN9IC1vICR7c25hcHNob3RkaXJ9ID4gL2Rldi9udWxsYCxcbiAgICB9KTtcblxuICAgIC8vIHN5bnRoIGFzIHBhcnQgb2Ygb3VyIHRlc3RzLCB3aGljaCBtZWFucyB0aGF0IGlmIG91dGRpciBjaGFuZ2VzLCBhbnRpLXRhbXBlciB3aWxsIGZhaWxcbiAgICBwcm9qZWN0LnRlc3RUYXNrLnNwYXduKGFzc2VydFRhc2spO1xuICAgIHByb2plY3QuYWRkR2l0SWdub3JlKGAhJHtzbmFwc2hvdGRpcn1gKTsgLy8gY29tbWl0IG91dGRpciB0byBnaXQgYnV0IG5vdCBhc3NldHNcblxuICAgIC8vIGRvIG5vdCBjb21taXQgYWxsIGZpbGVzIHdlIGFyZSBleGNsdWRpbmdcbiAgICBmb3IgKGNvbnN0IHggb2YgZXhjbHVkZSkge1xuICAgICAgcHJvamVjdC5hZGRHaXRJZ25vcmUoYCR7c25hcHNob3RkaXJ9LyR7eH1gKTtcbiAgICAgIHByb2plY3QuYWRkR2l0SWdub3JlKGAke3NuYXBzaG90ZGlyfS8qKi8ke3h9YCk7IC8vIG5lc3RlZCBhc3NlbWJsaWVzXG4gICAgfVxuXG4gICAgcHJvamVjdC5hZGRHaXRJZ25vcmUoZGVwbG95ZGlyKTtcbiAgICBwcm9qZWN0LmFkZFBhY2thZ2VJZ25vcmUoZGVwbG95ZGlyKTtcbiAgICBwcm9qZWN0LmFkZEdpdElnbm9yZShhY3R1YWxkaXIpO1xuICAgIHByb2plY3QuYWRkUGFja2FnZUlnbm9yZShhY3R1YWxkaXIpO1xuXG4gICAgLy8gY29tbWl0IHRoZSBzbmFwc2hvdCAoYnV0IG5vdCBpbnRvIHRoZSB0YXJiYWxsKVxuICAgIHByb2plY3QuYWRkR2l0SWdub3JlKGAhJHtzbmFwc2hvdGRpcn1gKTtcbiAgICBwcm9qZWN0LmFkZFBhY2thZ2VJZ25vcmUoc25hcHNob3RkaXIpO1xuXG4gICAgdGhpcy5kZXBsb3lUYXNrID0gZGVwbG95VGFzaztcbiAgICB0aGlzLmFzc2VydFRhc2sgPSBhc3NlcnRUYXNrO1xuICAgIHRoaXMuZGVzdHJveVRhc2sgPSBkZXN0cm95VGFzaztcbiAgICB0aGlzLnNuYXBzaG90VGFzayA9IHNuYXBzaG90VGFzaztcbiAgICB0aGlzLndhdGNoVGFzayA9IHdhdGNoVGFzaztcbiAgfVxufSJdfQ==