"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApprovalLevel = exports.CdkConfig = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
const json_1 = require("../json");
const internal_1 = require("./internal");
/**
 * (experimental) Represents cdk.json file.
 *
 * @experimental
 */
class CdkConfig extends component_1.Component {
    /**
     * @experimental
     */
    constructor(project, options) {
        var _b, _c, _d, _e;
        super(project);
        this.cdkout = (_b = options.cdkout) !== null && _b !== void 0 ? _b : 'cdk.out';
        const context = { ...options.context };
        const fflags = (_c = options.featureFlags) !== null && _c !== void 0 ? _c : true;
        if (fflags) {
            for (const flag of internal_1.FEATURE_FLAGS) {
                context[flag] = true;
            }
        }
        this.json = new json_1.JsonFile(project, 'cdk.json', {
            omitEmpty: true,
            obj: {
                app: options.app,
                context: context,
                requireApproval: options.requireApproval,
                output: this.cdkout,
                watch: {
                    include: (_d = options.watchIncludes) !== null && _d !== void 0 ? _d : [],
                    exclude: (_e = options.watchExcludes) !== null && _e !== void 0 ? _e : [],
                },
            },
        });
        project.gitignore.exclude(`/${this.cdkout}/`);
        project.gitignore.exclude('.cdk.staging/');
    }
}
exports.CdkConfig = CdkConfig;
_a = JSII_RTTI_SYMBOL_1;
CdkConfig[_a] = { fqn: "projen.awscdk.CdkConfig", version: "0.40.2" };
/**
 * (experimental) Which approval is required when deploying CDK apps.
 *
 * @experimental
 */
var ApprovalLevel;
(function (ApprovalLevel) {
    ApprovalLevel["NEVER"] = "never";
    ApprovalLevel["ANY_CHANGE"] = "any-change";
    ApprovalLevel["BROADENING"] = "broadening";
})(ApprovalLevel = exports.ApprovalLevel || (exports.ApprovalLevel = {}));
//# sourceMappingURL=data:application/json;base64,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