import { Component } from '../component';
import { JsonFile } from '../json';
import { Project } from '../project';
/**
 * (experimental) Common options for `cdk.json`.
 *
 * @experimental
 */
export interface CdkConfigCommonOptions {
    /**
     * (experimental) Additional context to include in `cdk.json`.
     *
     * @default - no additional context
     * @experimental
     */
    readonly context?: {
        [key: string]: string;
    };
    /**
     * (experimental) Include all feature flags in cdk.json.
     *
     * @default true
     * @experimental
     */
    readonly featureFlags?: boolean;
    /**
     * (experimental) To protect you against unintended changes that affect your security posture, the AWS CDK Toolkit prompts you to approve security-related changes before deploying them.
     *
     * @default ApprovalLevel.BROADENING
     * @experimental
     */
    readonly requireApproval?: ApprovalLevel;
    /**
     * (experimental) cdk.out directory.
     *
     * @default "cdk.out"
     * @experimental
     */
    readonly cdkout?: string;
    /**
     * (experimental) Glob patterns to include in `cdk watch`.
     *
     * @default []
     * @experimental
     */
    readonly watchIncludes?: string[];
    /**
     * (experimental) Glob patterns to exclude from `cdk watch`.
     *
     * @default []
     * @experimental
     */
    readonly watchExcludes?: string[];
}
/**
 * (experimental) Options for `CdkJson`.
 *
 * @experimental
 */
export interface CdkConfigOptions extends CdkConfigCommonOptions {
    /**
     * (experimental) The command line to execute in order to synthesize the CDK application (language specific).
     *
     * @experimental
     */
    readonly app: string;
}
/**
 * (experimental) Represents cdk.json file.
 *
 * @experimental
 */
export declare class CdkConfig extends Component {
    /**
     * (experimental) Represents the JSON file.
     *
     * @experimental
     */
    readonly json: JsonFile;
    /**
     * (experimental) Name of the cdk.out directory.
     *
     * @experimental
     */
    readonly cdkout: string;
    /**
     * @experimental
     */
    constructor(project: Project, options: CdkConfigOptions);
}
/**
 * (experimental) Which approval is required when deploying CDK apps.
 *
 * @experimental
 */
export declare enum ApprovalLevel {
    /**
     * (experimental) Approval is never required.
     *
     * @experimental
     */
    NEVER = "never",
    /**
     * (experimental) Requires approval on any IAM or security-group-related change.
     *
     * @experimental
     */
    ANY_CHANGE = "any-change",
    /**
     * (experimental) Requires approval when IAM statements or traffic rules are added;
     *
     * removals don't require approval
     *
     * @experimental
     */
    BROADENING = "broadening"
}
