"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConstructLibraryAws = exports.AwsCdkConstructLibrary = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const semver = require("semver");
const cdk_1 = require("../cdk");
const auto_discover_1 = require("./auto-discover");
/**
 * (experimental) AWS CDK construct library project.
 *
 * A multi-language (jsii) construct library which vends constructs designed to
 * use within the AWS CDK with a friendly workflow and automatic publishing to
 * the construct catalog.
 *
 * @experimental
 * @pjid awscdk-construct
 */
class AwsCdkConstructLibrary extends cdk_1.ConstructLibrary {
    /**
     * @experimental
     */
    constructor(options) {
        var _c, _d, _e, _f, _g, _h, _j, _k, _l;
        const cdkVersion = options.cdkVersionPinning ? options.cdkVersion : `^${options.cdkVersion}`;
        const cdkMajorVersion = (_d = (_c = semver.minVersion(cdkVersion)) === null || _c === void 0 ? void 0 : _c.major) !== null && _d !== void 0 ? _d : 2;
        super({
            peerDependencyOptions: cdkMajorVersion === 1 ? {
                pinnedDevDependency: false,
            } : undefined,
            ...options,
        });
        this.cdkVersion = cdkVersion;
        this.cdkDependenciesAsDeps = (_e = options.cdkDependenciesAsDeps) !== null && _e !== void 0 ? _e : true;
        switch (cdkMajorVersion) {
            case 1:
                if (options.cdkAssert) {
                    this.addDevDeps(this.formatModuleSpec('@aws-cdk/assert'));
                }
                if ((_f = options.cdkAssertions) !== null && _f !== void 0 ? _f : true) {
                    this.addDevDeps(this.formatModuleSpec('@aws-cdk/assertions'));
                }
                // CDK 1.x is built on constructs 3.x
                if (options.constructsVersion) {
                    const constructsMajorVersion = (_g = semver.minVersion(options.constructsVersion)) === null || _g === void 0 ? void 0 : _g.major;
                    if (constructsMajorVersion !== undefined && constructsMajorVersion >= 10) {
                        throw new Error('CDK 1.x requires constructs version < 10');
                    }
                    this.addPeerDeps(`constructs@^${options.constructsVersion}`);
                }
                else {
                    this.addPeerDeps('constructs@^3.2.27');
                }
                this.addCdkDependencies(...(_h = options.cdkDependencies) !== null && _h !== void 0 ? _h : []);
                this.addCdkTestDependencies(...(_j = options.cdkTestDependencies) !== null && _j !== void 0 ? _j : []);
                break;
            case 2:
                if (options.cdkAssert !== undefined) {
                    throw new Error('cdkAssert is not used for CDK 2.x. Use the assertions library that is provided in aws-cdk-lib');
                }
                if (options.cdkDependencies !== undefined) {
                    throw new Error('cdkDependencies is not used for CDK 2.x. Use "peerDeps" instead');
                }
                if (options.cdkDependenciesAsDeps !== undefined) {
                    throw new Error('cdkDependenciesAsDeps is not used for CDK 2.x');
                }
                if (options.cdkTestDependencies !== undefined) {
                    throw new Error('cdkTestDependencies is not used for CDK 2.x. Use "devDeps" instead');
                }
                // CDK 2.x is built on constructs 10.x
                if (options.constructsVersion) {
                    const constructsMajorVersion = (_k = semver.minVersion(options.constructsVersion)) === null || _k === void 0 ? void 0 : _k.major;
                    if (constructsMajorVersion !== undefined && constructsMajorVersion < 10) {
                        throw new Error('CDK 2.x requires constructs version >= 10');
                    }
                    this.addPeerDeps(`constructs@^${options.constructsVersion}`);
                }
                else {
                    this.addPeerDeps('constructs@^10.0.5');
                }
                this.addPeerDeps(`aws-cdk-lib@${this.cdkVersion}`);
                break;
            default:
                // Otherwise, let the user manage which version they use
                this.addPeerDeps('constructs');
                break;
        }
        const lambdaAutoDiscover = (_l = options.lambdaAutoDiscover) !== null && _l !== void 0 ? _l : true;
        if (lambdaAutoDiscover) {
            new auto_discover_1.AutoDiscover(this, {
                srcdir: this.srcdir,
                testdir: this.testdir,
                lambdaOptions: options.lambdaOptions,
                tsconfigPath: this.tsconfigDev.fileName,
            });
        }
    }
    /**
     * @deprecated use `cdkVersion`
     */
    get version() {
        return this.cdkVersion;
    }
    /**
     * (experimental) Adds CDK modules as runtime dependencies.
     *
     * Modules are currently by default added with a caret CDK version both as "dependencies"
     * and "peerDependencies". This is because currently npm would not
     * automatically install peer dependencies that are not declared as concerete
     * dependencies by the consumer, so this is a little npm "hack" so that
     * consumers will not need to depend on them directly if they don't interact
     * with them.
     * See `cdkDependenciesAsDeps` for changing the default behavior.
     *
     * @param deps names of cdk modules (e.g. `@aws-cdk/aws-lambda`).
     * @experimental
     */
    addCdkDependencies(...deps) {
        // this ugliness will go away in cdk v2.0
        this.addPeerDeps(...deps.map(m => this.formatModuleSpec(m)));
        if (this.cdkDependenciesAsDeps) {
            this.addDeps(...deps.map(m => this.formatModuleSpec(m)));
        }
        else {
            this.addDevDeps(...deps.map(m => this.formatModuleSpec(m)));
        }
    }
    /**
     * (experimental) Adds CDK modules as test dependencies.
     *
     * @param deps names of cdk modules (e.g. `@aws-cdk/aws-lambda`).
     * @experimental
     */
    addCdkTestDependencies(...deps) {
        this.addDevDeps(...deps.map(m => this.formatModuleSpec(m)));
    }
    formatModuleSpec(module) {
        return `${module}@${this.cdkVersion}`;
    }
}
exports.AwsCdkConstructLibrary = AwsCdkConstructLibrary;
_a = JSII_RTTI_SYMBOL_1;
AwsCdkConstructLibrary[_a] = { fqn: "projen.awscdk.AwsCdkConstructLibrary", version: "0.40.2" };
/**
 * @deprecated use `AwsCdkConstructLibrary`
 */
class ConstructLibraryAws extends AwsCdkConstructLibrary {
}
exports.ConstructLibraryAws = ConstructLibraryAws;
_b = JSII_RTTI_SYMBOL_1;
ConstructLibraryAws[_b] = { fqn: "projen.awscdk.ConstructLibraryAws", version: "0.40.2" };
//# sourceMappingURL=data:application/json;base64,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