"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsCdkTypeScriptApp = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const fs = require("fs-extra");
const semver = require("semver");
const component_1 = require("../component");
const typescript_1 = require("../typescript");
const auto_discover_1 = require("./auto-discover");
const cdk_config_1 = require("./cdk-config");
const cdk_tasks_1 = require("./cdk-tasks");
/**
 * (experimental) AWS CDK app in TypeScript.
 *
 * @experimental
 * @pjid awscdk-app-ts
 */
class AwsCdkTypeScriptApp extends typescript_1.TypeScriptAppProject {
    /**
     * @experimental
     */
    constructor(options) {
        var _b, _c, _d, _e, _f, _g, _h, _j;
        super({
            ...options,
            sampleCode: false,
        });
        this.appEntrypoint = (_b = options.appEntrypoint) !== null && _b !== void 0 ? _b : 'main.ts';
        this.cdkVersion = options.cdkVersionPinning ? options.cdkVersion : `^${options.cdkVersion}`;
        // CLI
        this.addDevDeps(this.formatModuleSpec('aws-cdk'));
        this.addCdkDependency('@aws-cdk/assert');
        if (!this.cdkVersion) {
            throw new Error('Required field cdkVersion is not specified.');
        }
        const cdkMajorVersion = (_d = (_c = semver.minVersion(this.cdkVersion)) === null || _c === void 0 ? void 0 : _c.major) !== null && _d !== void 0 ? _d : 1;
        if (cdkMajorVersion < 2) {
            this.addCdkDependency('@aws-cdk/core');
        }
        else {
            this.addCdkDependency('aws-cdk-lib');
            this.addDeps('constructs@^10.0.5');
        }
        this.addCdkDependency(...(_e = options.cdkDependencies) !== null && _e !== void 0 ? _e : []);
        this.cdkTasks = new cdk_tasks_1.CdkTasks(this);
        // no compile step because we do all of it in typescript directly
        this.compileTask.reset();
        this.removeScript('watch'); // because we use ts-node
        // add synth to the build
        this.postCompileTask.spawn(this.cdkTasks.synth);
        this.cdkConfig = new cdk_config_1.CdkConfig(this, {
            app: `npx ts-node --prefer-ts-exts ${path.posix.join(this.srcdir, this.appEntrypoint)}`,
            featureFlags: cdkMajorVersion < 2,
            watchIncludes: [
                `${this.srcdir}/**/*.ts`,
                `${this.testdir}/**/*.ts`,
            ],
            watchExcludes: [
                'README.md',
                'cdk*.json',
                '**/*.d.ts',
                '**/*.js',
                'tsconfig.json',
                'package*.json',
                'yarn.lock',
                'node_modules',
            ],
            ...options,
        });
        this.gitignore.exclude('.parcel-cache/');
        (_f = this.npmignore) === null || _f === void 0 ? void 0 : _f.exclude(`${this.cdkConfig.cdkout}/`);
        (_g = this.npmignore) === null || _g === void 0 ? void 0 : _g.exclude('.cdk.staging/');
        if (this.tsconfig) {
            this.tsconfig.exclude.push(this.cdkConfig.cdkout);
        }
        this.addDevDeps('ts-node@^9');
        if ((_h = options.sampleCode) !== null && _h !== void 0 ? _h : true) {
            new SampleCode(this, cdkMajorVersion);
        }
        const lambdaAutoDiscover = (_j = options.lambdaAutoDiscover) !== null && _j !== void 0 ? _j : true;
        if (lambdaAutoDiscover) {
            new auto_discover_1.AutoDiscover(this, {
                srcdir: this.srcdir,
                testdir: this.testdir,
                lambdaOptions: options.lambdaOptions,
                tsconfigPath: this.tsconfigDev.fileName,
            });
        }
    }
    /**
     * (experimental) Adds an AWS CDK module dependencies.
     *
     * @param modules The list of modules to depend on.
     * @experimental
     */
    addCdkDependency(...modules) {
        if (modules.length === 0) {
            return;
        }
        this.addDeps(...modules.map(m => this.formatModuleSpec(m)));
    }
    formatModuleSpec(module) {
        return `${module}@${this.cdkVersion}`;
    }
}
exports.AwsCdkTypeScriptApp = AwsCdkTypeScriptApp;
_a = JSII_RTTI_SYMBOL_1;
AwsCdkTypeScriptApp[_a] = { fqn: "projen.awscdk.AwsCdkTypeScriptApp", version: "0.40.2" };
class SampleCode extends component_1.Component {
    constructor(project, cdkMajorVersion) {
        super(project);
        this.cdkMajorVersion = cdkMajorVersion;
        this.appProject = project;
    }
    synthesize() {
        const outdir = this.project.outdir;
        const srcdir = path.join(outdir, this.appProject.srcdir);
        if (fs.pathExistsSync(srcdir) && fs.readdirSync(srcdir).filter(x => x.endsWith('.ts'))) {
            return;
        }
        const srcImports = new Array();
        if (this.cdkMajorVersion < 2) {
            srcImports.push('import { App, Construct, Stack, StackProps } from \'@aws-cdk/core\';');
        }
        else {
            srcImports.push('import { App, Stack, StackProps } from \'aws-cdk-lib\';');
            srcImports.push('import { Construct } from \'constructs\';');
        }
        const srcCode = `${srcImports.join('\n')}

export class MyStack extends Stack {
  constructor(scope: Construct, id: string, props: StackProps = {}) {
    super(scope, id, props);

    // define resources here...
  }
}

// for development, use account/region from cdk cli
const devEnv = {
  account: process.env.CDK_DEFAULT_ACCOUNT,
  region: process.env.CDK_DEFAULT_REGION,
};

const app = new App();

new MyStack(app, 'my-stack-dev', { env: devEnv });
// new MyStack(app, 'my-stack-prod', { env: prodEnv });

app.synth();`;
        fs.mkdirpSync(srcdir);
        fs.writeFileSync(path.join(srcdir, this.appProject.appEntrypoint), srcCode);
        const testdir = path.join(outdir, this.appProject.testdir);
        if (fs.pathExistsSync(testdir) && fs.readdirSync(testdir).filter(x => x.endsWith('.ts'))) {
            return;
        }
        const testImports = new Array();
        if (this.cdkMajorVersion < 2) {
            testImports.push('import { App } from \'@aws-cdk/core\';');
        }
        else {
            testImports.push('import { App } from \'aws-cdk-lib\';');
        }
        const appEntrypointName = path.basename(this.appProject.appEntrypoint, '.ts');
        const testCode = `import '@aws-cdk/assert/jest';
${testImports.join('\n')}
import { MyStack } from '../src/${appEntrypointName}';

test('Snapshot', () => {
  const app = new App();
  const stack = new MyStack(app, 'test');

  expect(stack).not.toHaveResource('AWS::S3::Bucket');
  expect(app.synth().getStackArtifact(stack.artifactId).template).toMatchSnapshot();
});`;
        fs.mkdirpSync(testdir);
        fs.writeFileSync(path.join(testdir, `${appEntrypointName}.test.ts`), testCode);
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXdzY2RrLWFwcC10cy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy9hd3NjZGsvYXdzY2RrLWFwcC10cy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUFBLDZCQUE2QjtBQUM3QiwrQkFBK0I7QUFDL0IsaUNBQWlDO0FBQ2pDLDRDQUF5QztBQUN6Qyw4Q0FBK0U7QUFDL0UsbURBQStDO0FBQy9DLDZDQUFpRTtBQUNqRSwyQ0FBdUM7Ozs7Ozs7QUF3QnZDLE1BQWEsbUJBQW9CLFNBQVEsaUNBQW9COzs7O0lBYTNELFlBQVksT0FBbUM7O1FBQzdDLEtBQUssQ0FBQztZQUNKLEdBQUcsT0FBTztZQUNWLFVBQVUsRUFBRSxLQUFLO1NBQ2xCLENBQUMsQ0FBQztRQUVILElBQUksQ0FBQyxhQUFhLFNBQUcsT0FBTyxDQUFDLGFBQWEsbUNBQUksU0FBUyxDQUFDO1FBRXhELElBQUksQ0FBQyxVQUFVLEdBQUcsT0FBTyxDQUFDLGlCQUFpQixDQUFDLENBQUMsQ0FBQyxPQUFPLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxJQUFJLE9BQU8sQ0FBQyxVQUFVLEVBQUUsQ0FBQztRQUU1RixNQUFNO1FBQ04sSUFBSSxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsZ0JBQWdCLENBQUMsU0FBUyxDQUFDLENBQUMsQ0FBQztRQUNsRCxJQUFJLENBQUMsZ0JBQWdCLENBQUMsaUJBQWlCLENBQUMsQ0FBQztRQUV6QyxJQUFJLENBQUMsSUFBSSxDQUFDLFVBQVUsRUFBRTtZQUNwQixNQUFNLElBQUksS0FBSyxDQUFDLDZDQUE2QyxDQUFDLENBQUM7U0FDaEU7UUFFRCxNQUFNLGVBQWUsZUFBRyxNQUFNLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxVQUFVLENBQUMsMENBQUUsS0FBSyxtQ0FBSSxDQUFDLENBQUM7UUFDdkUsSUFBSSxlQUFlLEdBQUcsQ0FBQyxFQUFFO1lBQ3ZCLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxlQUFlLENBQUMsQ0FBQztTQUN4QzthQUFNO1lBQ0wsSUFBSSxDQUFDLGdCQUFnQixDQUFDLGFBQWEsQ0FBQyxDQUFDO1lBQ3JDLElBQUksQ0FBQyxPQUFPLENBQUMsb0JBQW9CLENBQUMsQ0FBQztTQUNwQztRQUVELElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxTQUFHLE9BQU8sQ0FBQyxlQUFlLG1DQUFJLEVBQUUsQ0FBQyxDQUFDO1FBRXhELElBQUksQ0FBQyxRQUFRLEdBQUcsSUFBSSxvQkFBUSxDQUFDLElBQUksQ0FBQyxDQUFDO1FBRW5DLGlFQUFpRTtRQUNqRSxJQUFJLENBQUMsV0FBVyxDQUFDLEtBQUssRUFBRSxDQUFDO1FBRXpCLElBQUksQ0FBQyxZQUFZLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQyx5QkFBeUI7UUFFckQseUJBQXlCO1FBQ3pCLElBQUksQ0FBQyxlQUFlLENBQUMsS0FBSyxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsS0FBSyxDQUFDLENBQUM7UUFFaEQsSUFBSSxDQUFDLFNBQVMsR0FBRyxJQUFJLHNCQUFTLENBQUMsSUFBSSxFQUFFO1lBQ25DLEdBQUcsRUFBRSxnQ0FBZ0MsSUFBSSxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLE1BQU0sRUFBRSxJQUFJLENBQUMsYUFBYSxDQUFDLEVBQUU7WUFDdkYsWUFBWSxFQUFFLGVBQWUsR0FBRyxDQUFDO1lBQ2pDLGFBQWEsRUFBRTtnQkFDYixHQUFHLElBQUksQ0FBQyxNQUFNLFVBQVU7Z0JBQ3hCLEdBQUcsSUFBSSxDQUFDLE9BQU8sVUFBVTthQUMxQjtZQUNELGFBQWEsRUFBRTtnQkFDYixXQUFXO2dCQUNYLFdBQVc7Z0JBQ1gsV0FBVztnQkFDWCxTQUFTO2dCQUNULGVBQWU7Z0JBQ2YsZUFBZTtnQkFDZixXQUFXO2dCQUNYLGNBQWM7YUFDZjtZQUNELEdBQUcsT0FBTztTQUNYLENBQUMsQ0FBQztRQUVILElBQUksQ0FBQyxTQUFTLENBQUMsT0FBTyxDQUFDLGdCQUFnQixDQUFDLENBQUM7UUFFekMsTUFBQSxJQUFJLENBQUMsU0FBUywwQ0FBRSxPQUFPLENBQUMsR0FBRyxJQUFJLENBQUMsU0FBUyxDQUFDLE1BQU0sR0FBRyxFQUFFO1FBQ3JELE1BQUEsSUFBSSxDQUFDLFNBQVMsMENBQUUsT0FBTyxDQUFDLGVBQWUsRUFBRTtRQUV6QyxJQUFJLElBQUksQ0FBQyxRQUFRLEVBQUU7WUFDakIsSUFBSSxDQUFDLFFBQVEsQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxTQUFTLENBQUMsTUFBTSxDQUFDLENBQUM7U0FDbkQ7UUFFRCxJQUFJLENBQUMsVUFBVSxDQUFDLFlBQVksQ0FBQyxDQUFDO1FBQzlCLFVBQUksT0FBTyxDQUFDLFVBQVUsbUNBQUksSUFBSSxFQUFFO1lBQzlCLElBQUksVUFBVSxDQUFDLElBQUksRUFBRSxlQUFlLENBQUMsQ0FBQztTQUN2QztRQUVELE1BQU0sa0JBQWtCLFNBQUcsT0FBTyxDQUFDLGtCQUFrQixtQ0FBSSxJQUFJLENBQUM7UUFDOUQsSUFBSSxrQkFBa0IsRUFBRTtZQUN0QixJQUFJLDRCQUFZLENBQUMsSUFBSSxFQUFFO2dCQUNyQixNQUFNLEVBQUUsSUFBSSxDQUFDLE1BQU07Z0JBQ25CLE9BQU8sRUFBRSxJQUFJLENBQUMsT0FBTztnQkFDckIsYUFBYSxFQUFFLE9BQU8sQ0FBQyxhQUFhO2dCQUNwQyxZQUFZLEVBQUUsSUFBSSxDQUFDLFdBQVcsQ0FBQyxRQUFRO2FBQ3hDLENBQUMsQ0FBQztTQUNKO0lBQ0gsQ0FBQzs7Ozs7OztJQUdNLGdCQUFnQixDQUFDLEdBQUcsT0FBaUI7UUFDMUMsSUFBSSxPQUFPLENBQUMsTUFBTSxLQUFLLENBQUMsRUFBRTtZQUN4QixPQUFPO1NBQ1I7UUFDRCxJQUFJLENBQUMsT0FBTyxDQUFDLEdBQUcsT0FBTyxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7SUFDOUQsQ0FBQztJQUVPLGdCQUFnQixDQUFDLE1BQWM7UUFDckMsT0FBTyxHQUFHLE1BQU0sSUFBSSxJQUFJLENBQUMsVUFBVSxFQUFFLENBQUM7SUFDeEMsQ0FBQzs7QUExR0gsa0RBMkdDOzs7QUFFRCxNQUFNLFVBQVcsU0FBUSxxQkFBUztJQUdoQyxZQUFZLE9BQTRCLEVBQW1CLGVBQXVCO1FBQ2hGLEtBQUssQ0FBQyxPQUFPLENBQUMsQ0FBQztRQUQwQyxvQkFBZSxHQUFmLGVBQWUsQ0FBUTtRQUVoRixJQUFJLENBQUMsVUFBVSxHQUFHLE9BQU8sQ0FBQztJQUM1QixDQUFDO0lBRU0sVUFBVTtRQUNmLE1BQU0sTUFBTSxHQUFHLElBQUksQ0FBQyxPQUFPLENBQUMsTUFBTSxDQUFDO1FBQ25DLE1BQU0sTUFBTSxHQUFHLElBQUksQ0FBQyxJQUFJLENBQUMsTUFBTSxFQUFFLElBQUksQ0FBQyxVQUFVLENBQUMsTUFBTSxDQUFDLENBQUM7UUFDekQsSUFBSSxFQUFFLENBQUMsY0FBYyxDQUFDLE1BQU0sQ0FBQyxJQUFJLEVBQUUsQ0FBQyxXQUFXLENBQUMsTUFBTSxDQUFDLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLFFBQVEsQ0FBQyxLQUFLLENBQUMsQ0FBQyxFQUFFO1lBQ3RGLE9BQU87U0FDUjtRQUVELE1BQU0sVUFBVSxHQUFHLElBQUksS0FBSyxFQUFVLENBQUM7UUFDdkMsSUFBSSxJQUFJLENBQUMsZUFBZSxHQUFHLENBQUMsRUFBRTtZQUM1QixVQUFVLENBQUMsSUFBSSxDQUFDLHNFQUFzRSxDQUFDLENBQUM7U0FDekY7YUFBTTtZQUNMLFVBQVUsQ0FBQyxJQUFJLENBQUMseURBQXlELENBQUMsQ0FBQztZQUMzRSxVQUFVLENBQUMsSUFBSSxDQUFDLDJDQUEyQyxDQUFDLENBQUM7U0FDOUQ7UUFFRCxNQUFNLE9BQU8sR0FBRyxHQUFHLFVBQVUsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7YUFxQi9CLENBQUM7UUFFVixFQUFFLENBQUMsVUFBVSxDQUFDLE1BQU0sQ0FBQyxDQUFDO1FBQ3RCLEVBQUUsQ0FBQyxhQUFhLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxNQUFNLEVBQUUsSUFBSSxDQUFDLFVBQVUsQ0FBQyxhQUFhLENBQUMsRUFBRSxPQUFPLENBQUMsQ0FBQztRQUU1RSxNQUFNLE9BQU8sR0FBRyxJQUFJLENBQUMsSUFBSSxDQUFDLE1BQU0sRUFBRSxJQUFJLENBQUMsVUFBVSxDQUFDLE9BQU8sQ0FBQyxDQUFDO1FBQzNELElBQUksRUFBRSxDQUFDLGNBQWMsQ0FBQyxPQUFPLENBQUMsSUFBSSxFQUFFLENBQUMsV0FBVyxDQUFDLE9BQU8sQ0FBQyxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxRQUFRLENBQUMsS0FBSyxDQUFDLENBQUMsRUFBRTtZQUN4RixPQUFPO1NBQ1I7UUFFRCxNQUFNLFdBQVcsR0FBRyxJQUFJLEtBQUssRUFBVSxDQUFDO1FBQ3hDLElBQUksSUFBSSxDQUFDLGVBQWUsR0FBRyxDQUFDLEVBQUU7WUFDNUIsV0FBVyxDQUFDLElBQUksQ0FBQyx3Q0FBd0MsQ0FBQyxDQUFDO1NBQzVEO2FBQU07WUFDTCxXQUFXLENBQUMsSUFBSSxDQUFDLHNDQUFzQyxDQUFDLENBQUM7U0FDMUQ7UUFHRCxNQUFNLGlCQUFpQixHQUFHLElBQUksQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLFVBQVUsQ0FBQyxhQUFhLEVBQUUsS0FBSyxDQUFDLENBQUM7UUFDOUUsTUFBTSxRQUFRLEdBQUc7RUFDbkIsV0FBVyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUM7a0NBQ1UsaUJBQWlCOzs7Ozs7OztJQVEvQyxDQUFDO1FBRUQsRUFBRSxDQUFDLFVBQVUsQ0FBQyxPQUFPLENBQUMsQ0FBQztRQUN2QixFQUFFLENBQUMsYUFBYSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsT0FBTyxFQUFFLEdBQUcsaUJBQWlCLFVBQVUsQ0FBQyxFQUFFLFFBQVEsQ0FBQyxDQUFDO0lBQ2pGLENBQUM7Q0FDRiIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIHBhdGggZnJvbSAncGF0aCc7XG5pbXBvcnQgKiBhcyBmcyBmcm9tICdmcy1leHRyYSc7XG5pbXBvcnQgKiBhcyBzZW12ZXIgZnJvbSAnc2VtdmVyJztcbmltcG9ydCB7IENvbXBvbmVudCB9IGZyb20gJy4uL2NvbXBvbmVudCc7XG5pbXBvcnQgeyBUeXBlU2NyaXB0QXBwUHJvamVjdCwgVHlwZVNjcmlwdFByb2plY3RPcHRpb25zIH0gZnJvbSAnLi4vdHlwZXNjcmlwdCc7XG5pbXBvcnQgeyBBdXRvRGlzY292ZXIgfSBmcm9tICcuL2F1dG8tZGlzY292ZXInO1xuaW1wb3J0IHsgQ2RrQ29uZmlnLCBDZGtDb25maWdDb21tb25PcHRpb25zIH0gZnJvbSAnLi9jZGstY29uZmlnJztcbmltcG9ydCB7IENka1Rhc2tzIH0gZnJvbSAnLi9jZGstdGFza3MnO1xuaW1wb3J0IHsgTGFtYmRhRnVuY3Rpb25Db21tb25PcHRpb25zIH0gZnJvbSAnLi9sYW1iZGEtZnVuY3Rpb24nO1xuXG5leHBvcnQgaW50ZXJmYWNlIEF3c0Nka1R5cGVTY3JpcHRBcHBPcHRpb25zIGV4dGVuZHMgVHlwZVNjcmlwdFByb2plY3RPcHRpb25zLCBDZGtDb25maWdDb21tb25PcHRpb25zIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBjZGtWZXJzaW9uOiBzdHJpbmc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBjZGtWZXJzaW9uUGlubmluZz86IGJvb2xlYW47XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGNka0RlcGVuZGVuY2llcz86IHN0cmluZ1tdO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgYXBwRW50cnlwb2ludD86IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBsYW1iZGFBdXRvRGlzY292ZXI/OiBib29sZWFuO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBsYW1iZGFPcHRpb25zPzogTGFtYmRhRnVuY3Rpb25Db21tb25PcHRpb25zO1xufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGNsYXNzIEF3c0Nka1R5cGVTY3JpcHRBcHAgZXh0ZW5kcyBUeXBlU2NyaXB0QXBwUHJvamVjdCB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHJlYWRvbmx5IGNka1ZlcnNpb246IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyByZWFkb25seSBhcHBFbnRyeXBvaW50OiBzdHJpbmc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHJlYWRvbmx5IGNka1Rhc2tzOiBDZGtUYXNrcztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgcmVhZG9ubHkgY2RrQ29uZmlnOiBDZGtDb25maWc7XG5cbiAgY29uc3RydWN0b3Iob3B0aW9uczogQXdzQ2RrVHlwZVNjcmlwdEFwcE9wdGlvbnMpIHtcbiAgICBzdXBlcih7XG4gICAgICAuLi5vcHRpb25zLFxuICAgICAgc2FtcGxlQ29kZTogZmFsc2UsXG4gICAgfSk7XG5cbiAgICB0aGlzLmFwcEVudHJ5cG9pbnQgPSBvcHRpb25zLmFwcEVudHJ5cG9pbnQgPz8gJ21haW4udHMnO1xuXG4gICAgdGhpcy5jZGtWZXJzaW9uID0gb3B0aW9ucy5jZGtWZXJzaW9uUGlubmluZyA/IG9wdGlvbnMuY2RrVmVyc2lvbiA6IGBeJHtvcHRpb25zLmNka1ZlcnNpb259YDtcblxuICAgIC8vIENMSVxuICAgIHRoaXMuYWRkRGV2RGVwcyh0aGlzLmZvcm1hdE1vZHVsZVNwZWMoJ2F3cy1jZGsnKSk7XG4gICAgdGhpcy5hZGRDZGtEZXBlbmRlbmN5KCdAYXdzLWNkay9hc3NlcnQnKTtcblxuICAgIGlmICghdGhpcy5jZGtWZXJzaW9uKSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoJ1JlcXVpcmVkIGZpZWxkIGNka1ZlcnNpb24gaXMgbm90IHNwZWNpZmllZC4nKTtcbiAgICB9XG5cbiAgICBjb25zdCBjZGtNYWpvclZlcnNpb24gPSBzZW12ZXIubWluVmVyc2lvbih0aGlzLmNka1ZlcnNpb24pPy5tYWpvciA/PyAxO1xuICAgIGlmIChjZGtNYWpvclZlcnNpb24gPCAyKSB7XG4gICAgICB0aGlzLmFkZENka0RlcGVuZGVuY3koJ0Bhd3MtY2RrL2NvcmUnKTtcbiAgICB9IGVsc2Uge1xuICAgICAgdGhpcy5hZGRDZGtEZXBlbmRlbmN5KCdhd3MtY2RrLWxpYicpO1xuICAgICAgdGhpcy5hZGREZXBzKCdjb25zdHJ1Y3RzQF4xMC4wLjUnKTtcbiAgICB9XG5cbiAgICB0aGlzLmFkZENka0RlcGVuZGVuY3koLi4ub3B0aW9ucy5jZGtEZXBlbmRlbmNpZXMgPz8gW10pO1xuXG4gICAgdGhpcy5jZGtUYXNrcyA9IG5ldyBDZGtUYXNrcyh0aGlzKTtcblxuICAgIC8vIG5vIGNvbXBpbGUgc3RlcCBiZWNhdXNlIHdlIGRvIGFsbCBvZiBpdCBpbiB0eXBlc2NyaXB0IGRpcmVjdGx5XG4gICAgdGhpcy5jb21waWxlVGFzay5yZXNldCgpO1xuXG4gICAgdGhpcy5yZW1vdmVTY3JpcHQoJ3dhdGNoJyk7IC8vIGJlY2F1c2Ugd2UgdXNlIHRzLW5vZGVcblxuICAgIC8vIGFkZCBzeW50aCB0byB0aGUgYnVpbGRcbiAgICB0aGlzLnBvc3RDb21waWxlVGFzay5zcGF3bih0aGlzLmNka1Rhc2tzLnN5bnRoKTtcblxuICAgIHRoaXMuY2RrQ29uZmlnID0gbmV3IENka0NvbmZpZyh0aGlzLCB7XG4gICAgICBhcHA6IGBucHggdHMtbm9kZSAtLXByZWZlci10cy1leHRzICR7cGF0aC5wb3NpeC5qb2luKHRoaXMuc3JjZGlyLCB0aGlzLmFwcEVudHJ5cG9pbnQpfWAsXG4gICAgICBmZWF0dXJlRmxhZ3M6IGNka01ham9yVmVyc2lvbiA8IDIsXG4gICAgICB3YXRjaEluY2x1ZGVzOiBbXG4gICAgICAgIGAke3RoaXMuc3JjZGlyfS8qKi8qLnRzYCxcbiAgICAgICAgYCR7dGhpcy50ZXN0ZGlyfS8qKi8qLnRzYCxcbiAgICAgIF0sXG4gICAgICB3YXRjaEV4Y2x1ZGVzOiBbXG4gICAgICAgICdSRUFETUUubWQnLFxuICAgICAgICAnY2RrKi5qc29uJyxcbiAgICAgICAgJyoqLyouZC50cycsXG4gICAgICAgICcqKi8qLmpzJyxcbiAgICAgICAgJ3RzY29uZmlnLmpzb24nLFxuICAgICAgICAncGFja2FnZSouanNvbicsXG4gICAgICAgICd5YXJuLmxvY2snLFxuICAgICAgICAnbm9kZV9tb2R1bGVzJyxcbiAgICAgIF0sXG4gICAgICAuLi5vcHRpb25zLFxuICAgIH0pO1xuXG4gICAgdGhpcy5naXRpZ25vcmUuZXhjbHVkZSgnLnBhcmNlbC1jYWNoZS8nKTtcblxuICAgIHRoaXMubnBtaWdub3JlPy5leGNsdWRlKGAke3RoaXMuY2RrQ29uZmlnLmNka291dH0vYCk7XG4gICAgdGhpcy5ucG1pZ25vcmU/LmV4Y2x1ZGUoJy5jZGsuc3RhZ2luZy8nKTtcblxuICAgIGlmICh0aGlzLnRzY29uZmlnKSB7XG4gICAgICB0aGlzLnRzY29uZmlnLmV4Y2x1ZGUucHVzaCh0aGlzLmNka0NvbmZpZy5jZGtvdXQpO1xuICAgIH1cblxuICAgIHRoaXMuYWRkRGV2RGVwcygndHMtbm9kZUBeOScpO1xuICAgIGlmIChvcHRpb25zLnNhbXBsZUNvZGUgPz8gdHJ1ZSkge1xuICAgICAgbmV3IFNhbXBsZUNvZGUodGhpcywgY2RrTWFqb3JWZXJzaW9uKTtcbiAgICB9XG5cbiAgICBjb25zdCBsYW1iZGFBdXRvRGlzY292ZXIgPSBvcHRpb25zLmxhbWJkYUF1dG9EaXNjb3ZlciA/PyB0cnVlO1xuICAgIGlmIChsYW1iZGFBdXRvRGlzY292ZXIpIHtcbiAgICAgIG5ldyBBdXRvRGlzY292ZXIodGhpcywge1xuICAgICAgICBzcmNkaXI6IHRoaXMuc3JjZGlyLFxuICAgICAgICB0ZXN0ZGlyOiB0aGlzLnRlc3RkaXIsXG4gICAgICAgIGxhbWJkYU9wdGlvbnM6IG9wdGlvbnMubGFtYmRhT3B0aW9ucyxcbiAgICAgICAgdHNjb25maWdQYXRoOiB0aGlzLnRzY29uZmlnRGV2LmZpbGVOYW1lLFxuICAgICAgfSk7XG4gICAgfVxuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgYWRkQ2RrRGVwZW5kZW5jeSguLi5tb2R1bGVzOiBzdHJpbmdbXSkge1xuICAgIGlmIChtb2R1bGVzLmxlbmd0aCA9PT0gMCkge1xuICAgICAgcmV0dXJuO1xuICAgIH1cbiAgICB0aGlzLmFkZERlcHMoLi4ubW9kdWxlcy5tYXAobSA9PiB0aGlzLmZvcm1hdE1vZHVsZVNwZWMobSkpKTtcbiAgfVxuXG4gIHByaXZhdGUgZm9ybWF0TW9kdWxlU3BlYyhtb2R1bGU6IHN0cmluZyk6IHN0cmluZyB7XG4gICAgcmV0dXJuIGAke21vZHVsZX1AJHt0aGlzLmNka1ZlcnNpb259YDtcbiAgfVxufVxuXG5jbGFzcyBTYW1wbGVDb2RlIGV4dGVuZHMgQ29tcG9uZW50IHtcbiAgcHJpdmF0ZSByZWFkb25seSBhcHBQcm9qZWN0OiBBd3NDZGtUeXBlU2NyaXB0QXBwO1xuXG4gIGNvbnN0cnVjdG9yKHByb2plY3Q6IEF3c0Nka1R5cGVTY3JpcHRBcHAsIHByaXZhdGUgcmVhZG9ubHkgY2RrTWFqb3JWZXJzaW9uOiBudW1iZXIpIHtcbiAgICBzdXBlcihwcm9qZWN0KTtcbiAgICB0aGlzLmFwcFByb2plY3QgPSBwcm9qZWN0O1xuICB9XG5cbiAgcHVibGljIHN5bnRoZXNpemUoKSB7XG4gICAgY29uc3Qgb3V0ZGlyID0gdGhpcy5wcm9qZWN0Lm91dGRpcjtcbiAgICBjb25zdCBzcmNkaXIgPSBwYXRoLmpvaW4ob3V0ZGlyLCB0aGlzLmFwcFByb2plY3Quc3JjZGlyKTtcbiAgICBpZiAoZnMucGF0aEV4aXN0c1N5bmMoc3JjZGlyKSAmJiBmcy5yZWFkZGlyU3luYyhzcmNkaXIpLmZpbHRlcih4ID0+IHguZW5kc1dpdGgoJy50cycpKSkge1xuICAgICAgcmV0dXJuO1xuICAgIH1cblxuICAgIGNvbnN0IHNyY0ltcG9ydHMgPSBuZXcgQXJyYXk8c3RyaW5nPigpO1xuICAgIGlmICh0aGlzLmNka01ham9yVmVyc2lvbiA8IDIpIHtcbiAgICAgIHNyY0ltcG9ydHMucHVzaCgnaW1wb3J0IHsgQXBwLCBDb25zdHJ1Y3QsIFN0YWNrLCBTdGFja1Byb3BzIH0gZnJvbSBcXCdAYXdzLWNkay9jb3JlXFwnOycpO1xuICAgIH0gZWxzZSB7XG4gICAgICBzcmNJbXBvcnRzLnB1c2goJ2ltcG9ydCB7IEFwcCwgU3RhY2ssIFN0YWNrUHJvcHMgfSBmcm9tIFxcJ2F3cy1jZGstbGliXFwnOycpO1xuICAgICAgc3JjSW1wb3J0cy5wdXNoKCdpbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tIFxcJ2NvbnN0cnVjdHNcXCc7Jyk7XG4gICAgfVxuXG4gICAgY29uc3Qgc3JjQ29kZSA9IGAke3NyY0ltcG9ydHMuam9pbignXFxuJyl9XG5cbmV4cG9ydCBjbGFzcyBNeVN0YWNrIGV4dGVuZHMgU3RhY2sge1xuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogU3RhY2tQcm9wcyA9IHt9KSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkLCBwcm9wcyk7XG5cbiAgICAvLyBkZWZpbmUgcmVzb3VyY2VzIGhlcmUuLi5cbiAgfVxufVxuXG4vLyBmb3IgZGV2ZWxvcG1lbnQsIHVzZSBhY2NvdW50L3JlZ2lvbiBmcm9tIGNkayBjbGlcbmNvbnN0IGRldkVudiA9IHtcbiAgYWNjb3VudDogcHJvY2Vzcy5lbnYuQ0RLX0RFRkFVTFRfQUNDT1VOVCxcbiAgcmVnaW9uOiBwcm9jZXNzLmVudi5DREtfREVGQVVMVF9SRUdJT04sXG59O1xuXG5jb25zdCBhcHAgPSBuZXcgQXBwKCk7XG5cbm5ldyBNeVN0YWNrKGFwcCwgJ215LXN0YWNrLWRldicsIHsgZW52OiBkZXZFbnYgfSk7XG4vLyBuZXcgTXlTdGFjayhhcHAsICdteS1zdGFjay1wcm9kJywgeyBlbnY6IHByb2RFbnYgfSk7XG5cbmFwcC5zeW50aCgpO2A7XG5cbiAgICBmcy5ta2RpcnBTeW5jKHNyY2Rpcik7XG4gICAgZnMud3JpdGVGaWxlU3luYyhwYXRoLmpvaW4oc3JjZGlyLCB0aGlzLmFwcFByb2plY3QuYXBwRW50cnlwb2ludCksIHNyY0NvZGUpO1xuXG4gICAgY29uc3QgdGVzdGRpciA9IHBhdGguam9pbihvdXRkaXIsIHRoaXMuYXBwUHJvamVjdC50ZXN0ZGlyKTtcbiAgICBpZiAoZnMucGF0aEV4aXN0c1N5bmModGVzdGRpcikgJiYgZnMucmVhZGRpclN5bmModGVzdGRpcikuZmlsdGVyKHggPT4geC5lbmRzV2l0aCgnLnRzJykpKSB7XG4gICAgICByZXR1cm47XG4gICAgfVxuXG4gICAgY29uc3QgdGVzdEltcG9ydHMgPSBuZXcgQXJyYXk8c3RyaW5nPigpO1xuICAgIGlmICh0aGlzLmNka01ham9yVmVyc2lvbiA8IDIpIHtcbiAgICAgIHRlc3RJbXBvcnRzLnB1c2goJ2ltcG9ydCB7IEFwcCB9IGZyb20gXFwnQGF3cy1jZGsvY29yZVxcJzsnKTtcbiAgICB9IGVsc2Uge1xuICAgICAgdGVzdEltcG9ydHMucHVzaCgnaW1wb3J0IHsgQXBwIH0gZnJvbSBcXCdhd3MtY2RrLWxpYlxcJzsnKTtcbiAgICB9XG5cblxuICAgIGNvbnN0IGFwcEVudHJ5cG9pbnROYW1lID0gcGF0aC5iYXNlbmFtZSh0aGlzLmFwcFByb2plY3QuYXBwRW50cnlwb2ludCwgJy50cycpO1xuICAgIGNvbnN0IHRlc3RDb2RlID0gYGltcG9ydCAnQGF3cy1jZGsvYXNzZXJ0L2plc3QnO1xuJHt0ZXN0SW1wb3J0cy5qb2luKCdcXG4nKX1cbmltcG9ydCB7IE15U3RhY2sgfSBmcm9tICcuLi9zcmMvJHthcHBFbnRyeXBvaW50TmFtZX0nO1xuXG50ZXN0KCdTbmFwc2hvdCcsICgpID0+IHtcbiAgY29uc3QgYXBwID0gbmV3IEFwcCgpO1xuICBjb25zdCBzdGFjayA9IG5ldyBNeVN0YWNrKGFwcCwgJ3Rlc3QnKTtcblxuICBleHBlY3Qoc3RhY2spLm5vdC50b0hhdmVSZXNvdXJjZSgnQVdTOjpTMzo6QnVja2V0Jyk7XG4gIGV4cGVjdChhcHAuc3ludGgoKS5nZXRTdGFja0FydGlmYWN0KHN0YWNrLmFydGlmYWN0SWQpLnRlbXBsYXRlKS50b01hdGNoU25hcHNob3QoKTtcbn0pO2A7XG5cbiAgICBmcy5ta2RpcnBTeW5jKHRlc3RkaXIpO1xuICAgIGZzLndyaXRlRmlsZVN5bmMocGF0aC5qb2luKHRlc3RkaXIsIGAke2FwcEVudHJ5cG9pbnROYW1lfS50ZXN0LnRzYCksIHRlc3RDb2RlKTtcbiAgfVxufVxuIl19