from enum import IntEnum

DISCOVERY_MULTICAST_ADDR = '224.0.23.12'
DISCOVERY_MULTICAST_PORT = 3671

KNXNETIP_VERSION_10 = 0x10
HEADER_SIZE_10 = 0x06

IPV4_UDP = 0x01


class Services(IntEnum):
    # Core services
    SEARCH_REQUEST = 0x0201
    SEARCH_RESPONSE = 0x0202
    DESCRIPTION_REQUEST = 0x0203
    DESCRIPTION_RESPONSE = 0x0204
    CONNECT_REQUEST = 0x0205
    CONNECT_RESPONSE = 0x0206
    CONNECTIONSTATE_REQUEST = 0x0207
    CONNECTIONSTATE_RESPONSE = 0x0208
    DISCONNECT_REQUEST = 0x0209
    DISCONNECT_RESPONSE = 0x020A

    # Device Management services
    DEVICE_CONFIGURATION_REQUEST = 0x0310
    DEVICE_CONFIGURATION_ACK = 0x0311

    # Tunnelling services
    TUNNELING_REQUEST = 0x0420
    TUNNELING_ACK = 0x0421

    # Routing services
    ROUTING_INDICATION = 0x0530
    ROUTING_LOST_MESSAGE = 0x0531


class ConnectionTypes(IntEnum):
    DEVICE_MGMT_CONNECTION = 0x03
    TUNNEL_CONNECTION = 0x04
    REMLOG_CONNECTION = 0x06
    REMCONF_CONNECTION = 0x07
    OBJSVR_CONNECTION = 0x08


class ErrorCodes(IntEnum):
    E_NO_ERROR = 0x00
    E_HOST_PROTOCOL_TYPE = 0x01
    E_VERSION_NOT_SUPPORTED = 0x02
    E_SEQUENCE_NUMBER = 0x03


class ConnectResponseStatusCode(IntEnum):
    E_NO_ERROR = 0x00
    E_CONNECTION_TYPE = 0x22
    E_CONNECTION_OPTION = 0x23
    E_NO_MORE_CONNECTIONS = 0x24


class ConnectionstateResponseStatusCode(IntEnum):
    E_NO_ERROR = 0x00
    E_CONNECTION_ID = 0x21
    E_DATA_CONNECTION = 0x26
    E_KNX_CONNECTION = 0x27


class ConnectAckErrorCodes(IntEnum):
    E_NO_ERROR = 0x00
    E_TUNNELING_LAYER = 0x29


class TunnelingKNXLayers(IntEnum):
    E_TUNNEL_LINKLAYER = 0x02
    E_TUNNEL_RAW = 0x04
    E_TUNNEL_BUSMONITOR = 0x80


CONNECT_REQUEST_TIMEOUT = 10
CONNECTIONSTATE_REQUEST_TIMEOUT = 10
DEVICE_CONFIGURATION_REQUEST_TIMEOUT = 10
TUNNELING_REQUEST_TIMEOUT = 1
CONNECTION_ALIVE_TIME = 120
