# SPDX-License-Identifier: MIT
# Copyright (c) 2020-2021 The Pybricks Authors

from typing import Optional, Tuple, overload, Union

from ._common import Control, Motor
from .parameters import Stop

class DriveBase:
    distance_control: Control
    heading_control: Control
    def __init__(
        self,
        left_motor: Motor,
        right_motor: Motor,
        wheel_diameter: Union[int, float],
        axle_track: Union[int, float],
    ): ...
    def drive(self, speed: int, turn_rate: int) -> None: ...
    def stop(self) -> None: ...
    def distance(self) -> int: ...
    def angle(self) -> int: ...
    def state(self) -> Tuple[int, int, int, int]: ...
    def reset(self) -> None: ...
    @overload
    def settings(self) -> Tuple[int, int, int, int]: ...
    @overload
    def settings(
        self,
        straight_speed: Optional[int],
        straight_acceleration: Optional[int],
        turn_rate: Optional[int],
        turn_acceleration: Optional[int],
    ) -> None: ...
    def straight(self, distance: int) -> None: ...
    def turn(self, angle: int) -> None: ...
    def curve(
        self, radius: int, angle: int, then: Stop = Stop.HOLD, wait: bool = True
    ) -> None: ...
