/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import solver.AltErgoSolverInfo;
import solver.CVC4SolverInfo;
import solver.CVC5SolverInfo;
import solver.VampireSolverInfo;
import solver.YicesSolverInfo;
import solver.Z3SolverInfo;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0002\u0010\u0011J\u000e\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u000eR\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0005R\u0011\u0010\u0006\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0005R\u0011\u0010\u0007\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005R\u0011\u0010\b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0005R\u0011\u0010\t\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0005R\u0011\u0010\n\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0005R\u0011\u0010\u000b\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0005\u00a8\u0006\u0014"}, d2={"Lutils/RuntimeEnvInfo;", "", "()V", "isAltErgoAvailable", "", "()Z", "isCVC4Available", "isCVC5Available", "isTimeoutCommandAvailable", "isVampireAvailable", "isYicesAvailable", "isZ3Available", "getTimeoutCommand", "", "", "timeoutSeconds", "", "(Ljava/lang/Integer;)Ljava/util/List;", "isExecutableInPath", "cmd", "GeneralUtils"})
public final class RuntimeEnvInfo {
    private static final boolean isTimeoutCommandAvailable;
    public static final RuntimeEnvInfo INSTANCE;

    public final boolean isExecutableInPath(@NotNull String cmd) {
        int n;
        Process process2;
        Intrinsics.checkParameterIsNotNull(cmd, "cmd");
        try {
            process2 = Runtime.getRuntime().exec(cmd);
        }
        catch (IOException e) {
            return false;
        }
        Process proc = process2;
        try {
            proc.waitFor(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            return false;
        }
        try {
            n = proc.exitValue();
        }
        catch (IllegalThreadStateException e) {
            proc.destroyForcibly();
            return false;
        }
        int exitVal = n;
        return exitVal == 0;
    }

    public final boolean isCVC4Available() {
        return this.isExecutableInPath(CVC4SolverInfo.INSTANCE.getDefaultCommand() + " --version");
    }

    public final boolean isCVC5Available() {
        return this.isExecutableInPath(CVC5SolverInfo.INSTANCE.getDefaultCommand() + " --version");
    }

    public final boolean isYicesAvailable() {
        return this.isExecutableInPath(YicesSolverInfo.INSTANCE.getDefaultCommand() + " --version");
    }

    public final boolean isZ3Available() {
        return this.isExecutableInPath(Z3SolverInfo.INSTANCE.getDefaultCommand() + " --version");
    }

    public final boolean isVampireAvailable() {
        return this.isExecutableInPath(VampireSolverInfo.INSTANCE.getDefaultCommand() + " --version");
    }

    public final boolean isAltErgoAvailable() {
        return this.isExecutableInPath(AltErgoSolverInfo.INSTANCE.getDefaultCommand() + " --version");
    }

    public final boolean isTimeoutCommandAvailable() {
        return isTimeoutCommandAvailable;
    }

    @NotNull
    public final List<String> getTimeoutCommand(@Nullable Integer timeoutSeconds) {
        List<String> list2;
        if (isTimeoutCommandAvailable) {
            String[] stringArray = new String[4];
            stringArray[0] = "timeout";
            stringArray[1] = "-k";
            stringArray[2] = "3s";
            Integer n = timeoutSeconds;
            stringArray[3] = String.valueOf((n != null ? n : 600000) + 3);
            list2 = CollectionsKt.listOf(stringArray);
        } else {
            boolean bl = false;
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    private RuntimeEnvInfo() {
    }

    static {
        RuntimeEnvInfo runtimeEnvInfo;
        INSTANCE = runtimeEnvInfo = new RuntimeEnvInfo();
        isTimeoutCommandAvailable = runtimeEnvInfo.isExecutableInPath("timeout --version");
    }
}

