/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.io.File;
import java.io.FileWriter;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import log.ArtifactManagerFactoryInternal;
import org.apache.commons.io.FilenameUtils;
import org.codehaus.plexus.util.FileUtils;
import org.jetbrains.annotations.NotNull;
import utils.ArtifactFileUtilsKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lutils/ArtifactFileUtils;", "", "()V", "Companion", "Shared"})
public final class ArtifactFileUtils {
    @NotNull
    private static final List<Pair<String, String>> conversion;
    public static final Companion Companion;

    static {
        Companion = new Companion(null);
        conversion = CollectionsKt.listOf(new Pair<String, String>("(", "LP"), new Pair<String, String>(")", "RP"), new Pair<String, String>(",", "C"), new Pair<String, String>("[", "LB"), new Pair<String, String>("]", "RB"), new Pair<String, String>("[]", "LBRB"), new Pair<String, String>("uint256", "U256"), new Pair<String, String>("address", "ADR"), new Pair<String, String>("bytes32", "B32"));
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0004J\u000e\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u0006J\u000e\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0006J\u0006\u0010\u0010\u001a\u00020\u0006J\u000e\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0006J\u000e\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0006J\u001c\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0006J\u000e\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0006J\u0006\u0010\u0018\u001a\u00020\u0006J\"\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000f\u001a\u00020\u00062\b\b\u0002\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u001cJ\u0006\u0010\u001e\u001a\u00020\u001cJ\u000e\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u0006J\u000e\u0010 \u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u0006J\u0012\u0010!\u001a\n \"*\u0004\u0018\u00010\u00060\u0006*\u00020\u0006J\f\u0010#\u001a\u00020\u0006*\u00020\u0006H\u0007J\n\u0010$\u001a\u00020\u0006*\u00020\u0006R#\u0010\u0003\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006%"}, d2={"Lutils/ArtifactFileUtils$Companion;", "", "()V", "conversion", "", "Lkotlin/Pair;", "", "getConversion", "()Ljava/util/List;", "copyInputsToRootOfOutputDir", "", "filenames", "ensureFolderExists", "dirString", "getBasenameOnly", "fileName", "getCertoraDir", "getCmdErrorFilepath", "name", "getCmdOutputFilepath", "getFilesWithExtension", "path", "ext", "getNameFromPath", "getResultFile", "getWriterForFile", "Ljava/io/FileWriter;", "overwrite", "", "append", "hasCertoraDir", "isSol", "isTAC", "asUnixPath", "kotlin.jvm.PlatformType", "normalizeEncodedStringToStringWithABIChars", "normalizeStringWithABICharsToEncodedFilename", "Shared"})
    public static final class Companion {
        public final String asUnixPath(@NotNull String $this$asUnixPath) {
            Intrinsics.checkParameterIsNotNull($this$asUnixPath, "$this$asUnixPath");
            return FilenameUtils.separatorsToUnix($this$asUnixPath);
        }

        public final boolean hasCertoraDir() {
            return System.getenv().containsKey("CERTORA");
        }

        @NotNull
        public final String getCertoraDir() {
            String string2 = System.getenv("CERTORA");
            Intrinsics.checkExpressionValueIsNotNull(string2, "System.getenv(\"CERTORA\")");
            return string2;
        }

        @NotNull
        public final String getCmdOutputFilepath(@NotNull String name) {
            Intrinsics.checkParameterIsNotNull(name, "name");
            return ArtifactManagerFactoryInternal.Companion.invoke().getDebugDir() + File.separator + "Cmd_" + name + ".out.txt";
        }

        @NotNull
        public final String getCmdErrorFilepath(@NotNull String name) {
            Intrinsics.checkParameterIsNotNull(name, "name");
            return ArtifactManagerFactoryInternal.Companion.invoke().getDebugDir() + File.separator + "Cmd_" + name + ".err.txt";
        }

        @NotNull
        public final String getNameFromPath(@NotNull String name) {
            Intrinsics.checkParameterIsNotNull(name, "name");
            String string2 = FileUtils.filename(name);
            Intrinsics.checkExpressionValueIsNotNull(string2, "FileUtils.filename(name)");
            return string2;
        }

        @NotNull
        public final String getResultFile() {
            return "Results.txt";
        }

        public final void ensureFolderExists(@NotNull String dirString) {
            boolean success;
            Intrinsics.checkParameterIsNotNull(dirString, "dirString");
            File dir = new File(dirString);
            if (!(dir.exists() || (success = dir.mkdirs()) || dir.exists())) {
                throw (Throwable)new Exception("Failed to create directory " + dirString);
            }
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<String> getFilesWithExtension(@NotNull String path, @NotNull String ext) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkParameterIsNotNull(path, "path");
            Intrinsics.checkParameterIsNotNull(ext, "ext");
            String[] lsResult = new File(path).list();
            Intrinsics.checkExpressionValueIsNotNull(lsResult, "lsResult");
            String[] $this$filter$iv = lsResult;
            boolean $i$f$filter = false;
            String[] stringArray = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            void var10_9 = $this$filterTo$iv$iv;
            int n = ((void)var10_9).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv;
                void fileName = element$iv$iv = var10_9[i];
                boolean bl = false;
                if (!ext.equals(FileUtils.extension((String)fileName))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List relevantResults = (List)destination$iv$iv;
            ArtifactFileUtilsKt.access$getLogger$p().info("For path " + path + " ls result is " + ArraysKt.asList(lsResult) + " and files matching extension " + ext + " are " + relevantResults);
            return relevantResults;
        }

        public final boolean isTAC(@NotNull String fileName) {
            Intrinsics.checkParameterIsNotNull(fileName, "fileName");
            String string2 = FileUtils.extension(fileName);
            Intrinsics.checkExpressionValueIsNotNull(string2, "FileUtils.extension(fileName)");
            String string3 = string2;
            boolean bl = false;
            String string4 = string3;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.toLowerCase();
            Intrinsics.checkNotNullExpressionValue(string5, "(this as java.lang.String).toLowerCase()");
            return Intrinsics.areEqual(string5, "tac");
        }

        public final boolean isSol(@NotNull String fileName) {
            Intrinsics.checkParameterIsNotNull(fileName, "fileName");
            String string2 = FileUtils.extension(fileName);
            Intrinsics.checkExpressionValueIsNotNull(string2, "FileUtils.extension(fileName)");
            String string3 = string2;
            boolean bl = false;
            String string4 = string3;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.toLowerCase();
            Intrinsics.checkNotNullExpressionValue(string5, "(this as java.lang.String).toLowerCase()");
            return Intrinsics.areEqual(string5, "sol");
        }

        @NotNull
        public final String getBasenameOnly(@NotNull String fileName) {
            String string2;
            String basename;
            Intrinsics.checkParameterIsNotNull(fileName, "fileName");
            String separators = "/|\\\\";
            CharSequence charSequence = fileName;
            Regex regex = new Regex(separators);
            int n = 0;
            boolean bl = false;
            charSequence = CollectionsKt.last(regex.split(charSequence, n));
            boolean bl2 = false;
            n = 0;
            String filename = (String)charSequence;
            boolean bl3 = false;
            String string3 = basename = FileUtils.basename(filename);
            Intrinsics.checkExpressionValueIsNotNull(string3, "basename");
            if (StringsKt.last(string3) == '.') {
                String string4 = basename;
                int n2 = 0;
                int n3 = basename.length() - 1;
                boolean bl4 = false;
                String string5 = string4.substring(n2, n3);
                string2 = string5;
                Intrinsics.checkNotNullExpressionValue(string5, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            } else {
                string2 = basename;
            }
            return string2;
        }

        @NotNull
        public final FileWriter getWriterForFile(@NotNull String fileName, boolean overwrite, boolean append) {
            String string2;
            Intrinsics.checkParameterIsNotNull(fileName, "fileName");
            if (new File(fileName).exists() && !overwrite) {
                String string3 = FileUtils.dirname(fileName);
                boolean bl = false;
                boolean bl2 = false;
                String dir = string3;
                boolean bl3 = false;
                String string4 = dir;
                Intrinsics.checkExpressionValueIsNotNull(string4, "dir");
                CharSequence charSequence = string4;
                boolean bl4 = false;
                String currentDir = !StringsKt.isBlank(charSequence) ? dir + File.separator : "";
                StringBuilder stringBuilder = new StringBuilder().append(currentDir).append(this.getBasenameOnly(fileName)).append('_');
                String string5 = LocalDateTime.now().toString();
                Intrinsics.checkExpressionValueIsNotNull(string5, "LocalDateTime.now().toString()");
                string2 = stringBuilder.append(StringsKt.replace$default(string5, ':', '-', false, 4, null)).append(".").append(FileUtils.extension(fileName)).toString();
            } else {
                string2 = fileName;
            }
            String finalFileName = string2;
            return new FileWriter(finalFileName, append);
        }

        public static /* synthetic */ FileWriter getWriterForFile$default(Companion companion, String string2, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            if ((n & 4) != 0) {
                bl2 = false;
            }
            return companion.getWriterForFile(string2, bl, bl2);
        }

        @NotNull
        public final List<Pair<String, String>> getConversion() {
            return conversion;
        }

        @NotNull
        public final String normalizeStringWithABICharsToEncodedFilename(@NotNull String $this$normalizeStringWithABICharsToEncodedFilename) {
            Intrinsics.checkParameterIsNotNull($this$normalizeStringWithABICharsToEncodedFilename, "$this$normalizeStringWithABICharsToEncodedFilename");
            String filename = $this$normalizeStringWithABICharsToEncodedFilename;
            for (Pair<String, String> p : this.getConversion()) {
                filename = StringsKt.replace$default(filename, p.getFirst(), p.getSecond(), false, 4, null);
            }
            if (filename.length() > 165) {
                String string2 = filename;
                int n = 0;
                int n2 = 165;
                boolean bl = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.substring(n, n2);
                Intrinsics.checkNotNullExpressionValue(string4, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                filename = string4;
            }
            return filename;
        }

        @Deprecated(message="Never use this function. DO NOT reintroduce any translation back to strings with ABI chars", level=DeprecationLevel.ERROR)
        @NotNull
        public final String normalizeEncodedStringToStringWithABIChars(@NotNull String $this$normalizeEncodedStringToStringWithABIChars) {
            Intrinsics.checkParameterIsNotNull($this$normalizeEncodedStringToStringWithABIChars, "$this$normalizeEncodedStringToStringWithABIChars");
            String filename = $this$normalizeEncodedStringToStringWithABIChars;
            for (Pair<String, String> p : this.getConversion()) {
                filename = StringsKt.replace$default(filename, p.getSecond(), p.getFirst(), false, 4, null);
            }
            return filename;
        }

        public final void copyInputsToRootOfOutputDir(@NotNull List<String> filenames) {
            Intrinsics.checkParameterIsNotNull(filenames, "filenames");
            if (ArtifactManagerFactoryInternal.Companion.isEnabled()) {
                String target = ArtifactManagerFactoryInternal.Companion.invoke().getMainPath();
                try {
                    Iterable $this$forEach$iv = filenames;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        String filename = (String)element$iv;
                        boolean bl = false;
                        String targetFile = target + File.separator + Companion.getBasenameOnly(filename) + '.' + FileUtils.extension(filename);
                        FilesKt.copyTo$default(new File(filename), new File(targetFile), false, 0, 6, null);
                    }
                }
                catch (Exception e) {
                    ArtifactFileUtilsKt.access$getLogger$p().error("Failed to copy some inputs files " + filenames + ", got error: " + e.getMessage());
                }
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

