/*
 * Decompiled with CFR 0.152.
 */
package tac;

import java.io.Serializable;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tac.TACExprTag;
import tac.TACStructKt;
import tac.Tag;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \b2\u00020\u0001:\u0005\u0007\b\t\n\u000bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u0082\u0001\u0004\f\r\u000e\u000f\u00a8\u0006\u0010"}, d2={"Ltac/TACExprTag;", "Ljava/io/Serializable;", "()V", "getFieldTagOfStructSimpleType", "Ltac/Tag;", "fieldName", "", "AnyMap", "Companion", "Error", "Simple", "Struct", "Ltac/TACExprTag$Simple;", "Ltac/TACExprTag$Struct;", "Ltac/TACExprTag$AnyMap;", "Ltac/TACExprTag$Error;", "Shared"})
public abstract class TACExprTag
implements Serializable {
    @NotNull
    private static final Simple Bool;
    @NotNull
    private static final Simple Int;
    @NotNull
    private static final Simple Bit256;
    @NotNull
    private static final Simple ByteMap;
    @NotNull
    private static final Simple WordMap;
    @NotNull
    private static final Simple DoubleMap;
    @NotNull
    private static final Simple UF;
    @NotNull
    private static final Function1<Tag.UninterpretedSort, Simple> UninterpretedSort;
    public static final Companion Companion;

    @NotNull
    public final Tag getFieldTagOfStructSimpleType(@NotNull String fieldName) {
        Tag tag2;
        Intrinsics.checkParameterIsNotNull(fieldName, "fieldName");
        TACExprTag tACExprTag = this;
        if (tACExprTag instanceof Struct) {
            Map<String, TACExprTag> map2 = ((Struct)this).getFieldNameToTag();
            boolean bl = false;
            TACExprTag tACExprTag2 = map2.get(fieldName);
            if (tACExprTag2 == null) {
                boolean bl2 = false;
                String string2 = "struct " + this + " does not have a field of name " + fieldName;
                boolean bl3 = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            if (tACExprTag2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type tac.TACExprTag.Simple");
            }
            tag2 = ((Simple)tACExprTag2).getType();
        } else if (Intrinsics.areEqual(tACExprTag, Error.INSTANCE)) {
            tag2 = Tag.Bit256.INSTANCE;
        } else {
            String string3 = "only call this on struct tags";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string3.toString());
        }
        return tag2;
    }

    private TACExprTag() {
    }

    static {
        Companion = new Companion(null);
        Bool = new Simple(Tag.Bool.INSTANCE);
        Int = new Simple(Tag.Int.INSTANCE);
        Bit256 = new Simple(Tag.Bit256.INSTANCE);
        ByteMap = new Simple(Tag.ByteMap.INSTANCE);
        WordMap = new Simple(Tag.WordMap.INSTANCE);
        DoubleMap = new Simple(Tag.DoubleMap.INSTANCE);
        UF = new Simple(Tag.UF.INSTANCE);
        UninterpretedSort = Companion.UninterpretedSort.1.INSTANCE;
    }

    public /* synthetic */ TACExprTag(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Ltac/TACExprTag$Simple;", "Ltac/TACExprTag;", "type", "Ltac/Tag;", "(Ltac/Tag;)V", "getType", "()Ltac/Tag;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "Shared"})
    public static final class Simple
    extends TACExprTag {
        @NotNull
        private final Tag type;

        @NotNull
        public final Tag getType() {
            return this.type;
        }

        public Simple(@NotNull Tag type) {
            Intrinsics.checkParameterIsNotNull(type, "type");
            super(null);
            this.type = type;
        }

        @NotNull
        public final Tag component1() {
            return this.type;
        }

        @NotNull
        public final Simple copy(@NotNull Tag type) {
            Intrinsics.checkParameterIsNotNull(type, "type");
            return new Simple(type);
        }

        public static /* synthetic */ Simple copy$default(Simple simple, Tag tag2, int n, Object object) {
            if ((n & 1) != 0) {
                tag2 = simple.type;
            }
            return simple.copy(tag2);
        }

        @NotNull
        public String toString() {
            return "Simple(type=" + this.type + ")";
        }

        public int hashCode() {
            Tag tag2 = this.type;
            return tag2 != null ? tag2.hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Simple)) break block3;
                    Simple simple = (Simple)object;
                    if (!Intrinsics.areEqual(this.type, simple.type)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\u0015\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0003H\u00c6\u0003J\u001f\u0010\t\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0004H\u00d6\u0001R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Ltac/TACExprTag$Struct;", "Ltac/TACExprTag;", "fieldNameToTag", "", "", "(Ljava/util/Map;)V", "getFieldNameToTag", "()Ljava/util/Map;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "Shared"})
    public static final class Struct
    extends TACExprTag {
        @NotNull
        private final Map<String, TACExprTag> fieldNameToTag;

        @NotNull
        public final Map<String, TACExprTag> getFieldNameToTag() {
            return this.fieldNameToTag;
        }

        public Struct(@NotNull Map<String, ? extends TACExprTag> fieldNameToTag) {
            Intrinsics.checkParameterIsNotNull(fieldNameToTag, "fieldNameToTag");
            super(null);
            this.fieldNameToTag = fieldNameToTag;
        }

        @NotNull
        public final Map<String, TACExprTag> component1() {
            return this.fieldNameToTag;
        }

        @NotNull
        public final Struct copy(@NotNull Map<String, ? extends TACExprTag> fieldNameToTag) {
            Intrinsics.checkParameterIsNotNull(fieldNameToTag, "fieldNameToTag");
            return new Struct(fieldNameToTag);
        }

        public static /* synthetic */ Struct copy$default(Struct struct, Map map2, int n, Object object) {
            if ((n & 1) != 0) {
                map2 = struct.fieldNameToTag;
            }
            return struct.copy(map2);
        }

        @NotNull
        public String toString() {
            return "Struct(fieldNameToTag=" + this.fieldNameToTag + ")";
        }

        public int hashCode() {
            Map<String, TACExprTag> map2 = this.fieldNameToTag;
            return map2 != null ? ((Object)map2).hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Struct)) break block3;
                    Struct struct = (Struct)object;
                    if (!Intrinsics.areEqual(this.fieldNameToTag, struct.fieldNameToTag)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Ltac/TACExprTag$AnyMap;", "Ltac/TACExprTag;", "()V", "readResolve", "", "Shared"})
    public static final class AnyMap
    extends TACExprTag {
        public static final AnyMap INSTANCE;

        @NotNull
        public final Object readResolve() {
            return INSTANCE;
        }

        private AnyMap() {
            super(null);
        }

        static {
            AnyMap anyMap;
            INSTANCE = anyMap = new AnyMap();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Ltac/TACExprTag$Error;", "Ltac/TACExprTag;", "()V", "readResolve", "", "Shared"})
    public static final class Error
    extends TACExprTag {
        public static final Error INSTANCE;

        @NotNull
        public final Object readResolve() {
            return INSTANCE;
        }

        private Error() {
            super(null);
        }

        static {
            Error error;
            INSTANCE = error = new Error();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0086\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u001d\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00040\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0006\u00a8\u0006\u001c"}, d2={"Ltac/TACExprTag$Companion;", "", "()V", "Bit256", "Ltac/TACExprTag$Simple;", "getBit256", "()Ltac/TACExprTag$Simple;", "Bool", "getBool", "ByteMap", "getByteMap", "DoubleMap", "getDoubleMap", "Int", "getInt", "UF", "getUF", "UninterpretedSort", "Lkotlin/Function1;", "Ltac/Tag$UninterpretedSort;", "getUninterpretedSort", "()Lkotlin/jvm/functions/Function1;", "WordMap", "getWordMap", "invoke", "Ltac/TACExprTag;", "type", "Ltac/Tag;", "Shared"})
    public static final class Companion {
        @NotNull
        public final TACExprTag invoke(@NotNull Tag type) {
            TACExprTag tACExprTag;
            Intrinsics.checkParameterIsNotNull(type, "type");
            Tag tag2 = type;
            if (Intrinsics.areEqual(tag2, Tag.ByteMap.INSTANCE)) {
                tACExprTag = this.getByteMap();
            } else if (Intrinsics.areEqual(tag2, Tag.Bit256.INSTANCE)) {
                tACExprTag = this.getBit256();
            } else if (Intrinsics.areEqual(tag2, Tag.Bool.INSTANCE)) {
                tACExprTag = this.getBool();
            } else if (Intrinsics.areEqual(tag2, Tag.WordMap.INSTANCE)) {
                tACExprTag = this.getWordMap();
            } else if (Intrinsics.areEqual(tag2, Tag.DoubleMap.INSTANCE)) {
                tACExprTag = this.getDoubleMap();
            } else if (Intrinsics.areEqual(tag2, Tag.Int.INSTANCE)) {
                tACExprTag = this.getInt();
            } else if (Intrinsics.areEqual(tag2, Tag.UF.INSTANCE)) {
                tACExprTag = this.getUF();
            } else if (tag2 instanceof Tag.UninterpretedSort) {
                Struct struct = TACStructKt.getStructTag(type);
                tACExprTag = struct != null ? (TACExprTag)struct : (TACExprTag)this.getUninterpretedSort().invoke((Tag.UninterpretedSort)type);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return tACExprTag;
        }

        @NotNull
        public final Simple getBool() {
            return Bool;
        }

        @NotNull
        public final Simple getInt() {
            return Int;
        }

        @NotNull
        public final Simple getBit256() {
            return Bit256;
        }

        @NotNull
        public final Simple getByteMap() {
            return ByteMap;
        }

        @NotNull
        public final Simple getWordMap() {
            return WordMap;
        }

        @NotNull
        public final Simple getDoubleMap() {
            return DoubleMap;
        }

        @NotNull
        public final Simple getUF() {
            return UF;
        }

        @NotNull
        public final Function1<Tag.UninterpretedSort, Simple> getUninterpretedSort() {
            return UninterpretedSort;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

