/*
 * Decompiled with CFR 0.152.
 */
package spec.cvlast;

import java.io.Serializable;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import spec.cvlast.CVLImportedContract;
import spec.cvlast.CvlSpecFile;
import spec.cvlast.ErrorFunctionDeclarationScope;
import spec.cvlast.FunctionDeclarationScope;
import spec.cvlast.SolidityContract;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\u0006\u0010\u0014\u001a\u00020\u000fJ\u001c\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00002\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017J\b\u0010\u0019\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001b"}, d2={"Lspec/cvlast/MethodReference;", "Ljava/io/Serializable;", "declarationScope", "Lspec/cvlast/FunctionDeclarationScope;", "methodId", "", "(Lspec/cvlast/FunctionDeclarationScope;Ljava/lang/String;)V", "getDeclarationScope", "()Lspec/cvlast/FunctionDeclarationScope;", "getMethodId", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "isConstructor", "matches", "importedContracts", "", "Lspec/cvlast/CVLImportedContract;", "toString", "Companion", "Shared"})
public final class MethodReference
implements Serializable {
    @NotNull
    private final FunctionDeclarationScope declarationScope;
    @NotNull
    private final String methodId;
    @NotNull
    private static final MethodReference Error;
    public static final Companion Companion;

    @NotNull
    public String toString() {
        String string2;
        FunctionDeclarationScope functionDeclarationScope = this.declarationScope;
        if (Intrinsics.areEqual(functionDeclarationScope, CvlSpecFile.INSTANCE)) {
            string2 = this.methodId;
        } else if (Intrinsics.areEqual(functionDeclarationScope, SolidityContract.Current.INSTANCE)) {
            string2 = this.methodId;
        } else if (Intrinsics.areEqual(functionDeclarationScope, ErrorFunctionDeclarationScope.INSTANCE)) {
            string2 = this.declarationScope.getName() + '.' + this.methodId;
        } else if (functionDeclarationScope instanceof SolidityContract.Named) {
            string2 = this.declarationScope.getName() + '.' + this.methodId;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string2;
    }

    public final boolean matches(@NotNull MethodReference other, @NotNull List<CVLImportedContract> importedContracts) {
        Intrinsics.checkParameterIsNotNull(other, "other");
        Intrinsics.checkParameterIsNotNull(importedContracts, "importedContracts");
        if (Intrinsics.areEqual(this.methodId, other.methodId) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual(this.declarationScope, other.declarationScope)) {
            return true;
        }
        if (this.declarationScope instanceof SolidityContract && other.declarationScope instanceof SolidityContract) {
            return SolidityContract.Companion.areAliases((SolidityContract)this.declarationScope, (SolidityContract)other.declarationScope, importedContracts);
        }
        return false;
    }

    public final boolean isConstructor() {
        return Intrinsics.areEqual(this.methodId, "constructor");
    }

    @NotNull
    public final FunctionDeclarationScope getDeclarationScope() {
        return this.declarationScope;
    }

    @NotNull
    public final String getMethodId() {
        return this.methodId;
    }

    public MethodReference(@NotNull FunctionDeclarationScope declarationScope, @NotNull String methodId) {
        Intrinsics.checkParameterIsNotNull(declarationScope, "declarationScope");
        Intrinsics.checkParameterIsNotNull(methodId, "methodId");
        this.declarationScope = declarationScope;
        this.methodId = methodId;
    }

    static {
        Companion = new Companion(null);
        Error = new MethodReference(ErrorFunctionDeclarationScope.INSTANCE, "errorMethodReferenceMethodId");
    }

    @NotNull
    public final FunctionDeclarationScope component1() {
        return this.declarationScope;
    }

    @NotNull
    public final String component2() {
        return this.methodId;
    }

    @NotNull
    public final MethodReference copy(@NotNull FunctionDeclarationScope declarationScope, @NotNull String methodId) {
        Intrinsics.checkParameterIsNotNull(declarationScope, "declarationScope");
        Intrinsics.checkParameterIsNotNull(methodId, "methodId");
        return new MethodReference(declarationScope, methodId);
    }

    public static /* synthetic */ MethodReference copy$default(MethodReference methodReference, FunctionDeclarationScope functionDeclarationScope, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            functionDeclarationScope = methodReference.declarationScope;
        }
        if ((n & 2) != 0) {
            string2 = methodReference.methodId;
        }
        return methodReference.copy(functionDeclarationScope, string2);
    }

    public int hashCode() {
        FunctionDeclarationScope functionDeclarationScope = this.declarationScope;
        String string2 = this.methodId;
        return (functionDeclarationScope != null ? functionDeclarationScope.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof MethodReference)) break block3;
                MethodReference methodReference = (MethodReference)object;
                if (!Intrinsics.areEqual(this.declarationScope, methodReference.declarationScope) || !Intrinsics.areEqual(this.methodId, methodReference.methodId)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0007\u001a\u00020\u00042\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\tH\u0086\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lspec/cvlast/MethodReference$Companion;", "", "()V", "Error", "Lspec/cvlast/MethodReference;", "getError", "()Lspec/cvlast/MethodReference;", "invoke", "contractId", "", "methodId", "Shared"})
    public static final class Companion {
        @NotNull
        public final MethodReference getError() {
            return Error;
        }

        @NotNull
        public final MethodReference invoke(@Nullable String contractId, @NotNull String methodId) {
            Intrinsics.checkParameterIsNotNull(methodId, "methodId");
            return contractId == null ? new MethodReference(SolidityContract.Current.INSTANCE, methodId) : new MethodReference(SolidityContract.Companion.fromName(contractId), methodId);
        }

        public static /* synthetic */ MethodReference invoke$default(Companion companion, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = null;
            }
            return companion.invoke(string2, string3);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

