/*
 * Decompiled with CFR 0.152.
 */
package spec.cvlast;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import log.Logger;
import log.LoggerTypes;
import org.jetbrains.annotations.NotNull;
import spec.CVLErrorLogger;
import spec.cvlast.CVLErrorType;
import spec.cvlast.CVLExp;
import spec.cvlast.CVLLocation;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u000e"}, d2={"logger", "Llog/Logger;", "getLogger", "()Llog/Logger;", "syntaxError", "", "loc", "Lspec/cvlast/CVLLocation;", "message", "", "typeError", "Lspec/cvlast/CVLErrorType;", "exp", "Lspec/cvlast/CVLExp;", "Shared"})
public final class CVLTypeCheckerKt {
    @NotNull
    private static final Logger logger = new Logger(LoggerTypes.CVL_TYPE_CHECKER);

    @NotNull
    public static final Logger getLogger() {
        return logger;
    }

    public static final void syntaxError(@NotNull CVLLocation loc, @NotNull String message) {
        Intrinsics.checkParameterIsNotNull(loc, "loc");
        Intrinsics.checkParameterIsNotNull(message, "message");
        CVLErrorLogger.INSTANCE.error(message, loc);
    }

    @NotNull
    public static final CVLErrorType typeError(@NotNull CVLExp exp, @NotNull CVLLocation loc, @NotNull String message) {
        Intrinsics.checkParameterIsNotNull(exp, "exp");
        Intrinsics.checkParameterIsNotNull(loc, "loc");
        Intrinsics.checkParameterIsNotNull(message, "message");
        CVLErrorLogger.INSTANCE.error("could not type expression \"" + exp + "\", message: " + message, loc);
        return new CVLErrorType(exp, message);
    }

    private static final CVLErrorType typeError(CVLExp exp, CVLLocation loc) {
        CVLErrorLogger.INSTANCE.error("could not type expression \"" + exp + '\"', loc);
        return new CVLErrorType(exp, null, 2, null);
    }

    public static final /* synthetic */ CVLErrorType access$typeError(CVLExp exp, CVLLocation loc) {
        return CVLTypeCheckerKt.typeError(exp, loc);
    }
}

