/*
 * Decompiled with CFR 0.152.
 */
package spec.cvlast;

import bridge.EVMMethodInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import spec.CVLErrorLogger;
import spec.CVLKeywords;
import spec.CVLReservedVariables;
import spec.cvlast.CVLCmd;
import spec.cvlast.CVLDefinition;
import spec.cvlast.CVLErrorType;
import spec.cvlast.CVLExp;
import spec.cvlast.CVLFunction;
import spec.cvlast.CVLFunctionType;
import spec.cvlast.CVLGhostFunction;
import spec.cvlast.CVLImportedContract;
import spec.cvlast.CVLInbuiltSimpleTypes;
import spec.cvlast.CVLInbuiltStructTypes;
import spec.cvlast.CVLInvariant;
import spec.cvlast.CVLLocation;
import spec.cvlast.CVLParam;
import spec.cvlast.CVLScope;
import spec.cvlast.CVLSimpleType;
import spec.cvlast.CVLType;
import spec.cvlast.CVLTypeCheckerKt;
import spec.cvlast.CVLTypeEnvironment;
import spec.cvlast.ContractFunction;
import spec.cvlast.CvlSpecFile;
import spec.cvlast.ErrorFunctionDeclarationScope;
import spec.cvlast.Function;
import spec.cvlast.FunctionDeclarationScope;
import spec.cvlast.MethodIdWithCallContext;
import spec.cvlast.MethodReference;
import spec.cvlast.MethodSignature;
import spec.cvlast.SolidityContract;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00da\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0003VWXBK\u0012 \b\u0002\u0010\u0002\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u0012\u0004\u0012\u00020\u00070\u0003\u0012\u0018\b\u0002\u0010\b\u001a\u0012\u0012\b\u0012\u00060\tj\u0002`\n\u0012\u0004\u0012\u00020\u00050\u0003\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u001a\u0010\u0012\u001a\u00020\u00132\n\u0010\u0014\u001a\u00060\tj\u0002`\n2\u0006\u0010\u0015\u001a\u00020\u0005J\u0018\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010\u001b\u001a\u00020\u0013H\u0002J\u0006\u0010\u001c\u001a\u00020\u0000J\u0006\u0010\u001d\u001a\u00020\u0013J\u000e\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u0006J\u000e\u0010 \u001a\u00020!2\u0006\u0010\u001f\u001a\u00020!J\u000e\u0010\"\u001a\u00020#2\u0006\u0010\u001f\u001a\u00020#J\u000e\u0010$\u001a\u00020%2\u0006\u0010\u001f\u001a\u00020%J\u001e\u0010&\u001a\n\u0018\u00010\tj\u0004\u0018\u0001`\n2\u000e\u0010'\u001a\n\u0018\u00010\tj\u0004\u0018\u0001`\nJ\u0014\u0010(\u001a\u0004\u0018\u00010\u00052\n\u0010\u0014\u001a\u00060\tj\u0002`\nJ\u0018\u0010)\u001a\u0004\u0018\u00010\u00072\u0006\u0010*\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0005J\u0018\u0010)\u001a\u0004\u0018\u00010\u00072\u0006\u0010*\u001a\u00020\u00062\u0006\u0010+\u001a\u00020,J$\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\f\u00101\u001a\b\u0012\u0004\u0012\u000203022\u0006\u0010+\u001a\u00020,J \u00104\u001a\u0004\u0018\u00010\u00072\u0006\u0010'\u001a\u00020\u00062\u0006\u00105\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0005J \u00104\u001a\u0004\u0018\u00010\u00072\u0006\u0010'\u001a\u00020\u00062\u0006\u00105\u001a\u00020\u00062\u0006\u0010+\u001a\u00020,J\u0018\u00106\u001a\u0004\u0018\u00010\u00072\u0006\u00107\u001a\u0002082\u0006\u0010\u0015\u001a\u00020\u0005J\u0018\u00106\u001a\u0004\u0018\u00010\u00072\u0006\u00107\u001a\u0002082\u0006\u0010+\u001a\u00020,J\u001c\u00109\u001a\u0004\u0018\u00010\u00072\b\u0010:\u001a\u0004\u0018\u00010\u00072\u0006\u00105\u001a\u00020\u0006H\u0002J\u0016\u0010;\u001a\u00020\u00132\u0006\u0010<\u001a\u00020=2\u0006\u0010\u0015\u001a\u00020\u0005J\u0016\u0010;\u001a\u00020\u00132\u0006\u0010<\u001a\u00020>2\u0006\u0010\u0015\u001a\u00020\u0005J\u0016\u0010;\u001a\u00020\u00132\u0006\u0010?\u001a\u00020@2\u0006\u0010\u0015\u001a\u00020\u0005J\u0016\u0010;\u001a\u00020\u00132\u0006\u0010A\u001a\u00020B2\u0006\u0010\u0015\u001a\u00020\u0005J\u0016\u0010;\u001a\u00020\u00132\u0006\u0010C\u001a\u00020D2\u0006\u0010\u0015\u001a\u00020\u0005J\u0016\u0010;\u001a\u00020\u00132\u0006\u0010E\u001a\u00020F2\u0006\u0010\u0015\u001a\u00020\u0005J\u0016\u0010;\u001a\u00020\u00132\u0006\u0010G\u001a\u00020H2\u0006\u0010\u0015\u001a\u00020\u0005J\u0016\u0010;\u001a\u00020\u00132\u0006\u0010I\u001a\u00020J2\u0006\u0010\u0015\u001a\u00020\u0005J\u0016\u0010;\u001a\u00020\u00132\u0006\u0010K\u001a\u00020L2\u0006\u0010\u0015\u001a\u00020\u0005J\u0016\u0010M\u001a\u00020\u00132\u0006\u0010N\u001a\u00020O2\u0006\u0010\u0015\u001a\u00020\u0005J\u0018\u0010P\u001a\u00020\u00132\u0006\u0010Q\u001a\u00020R2\u0006\u0010\u0015\u001a\u00020\u0005H\u0002J\u001e\u0010S\u001a\u00020\u00132\u0006\u0010T\u001a\u00020U2\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0019R&\u0010\u0002\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u0012\u0004\u0012\u00020\u00070\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u0012\u0012\b\u0012\u00060\tj\u0002`\n\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u00060\u000fR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Y"}, d2={"Lspec/cvlast/CVLSymbolTable;", "", "backing", "", "Lkotlin/Pair;", "Lspec/cvlast/CVLScope;", "", "Lspec/cvlast/CVLSymbolTable$SymbolInfo;", "contractsScope", "Lspec/cvlast/SolidityContract;", "Lbridge/ContractIdentifier;", "isFinalized", "", "(Ljava/util/Map;Ljava/util/Map;Z)V", "freshNameGenerator", "Lspec/cvlast/CVLSymbolTable$FreshNameGenerator;", "reserved", "", "addContractScope", "", "contractName", "scope", "checkName", "name", "loc", "Lspec/cvlast/CVLLocation;", "Lspec/cvlast/MethodReference;", "checkNotFinalized", "copyUnfinalized", "finalize", "freshName", "requested", "freshParam", "Lspec/cvlast/CVLParam$Named;", "freshQuantifierSym", "Lspec/cvlast/CVLExp$QuantifierExp;", "freshVar", "Lspec/cvlast/CVLExp$VariableExp;", "getContractNameFromContractId", "contractId", "getContractScope", "lookUp", "id", "typeEnv", "Lspec/cvlast/CVLTypeEnvironment;", "lookUpMethod", "Lspec/cvlast/CVLSymbolTable$SymbolTableMethodLookupResult;", "exp", "Lspec/cvlast/CVLExp$ApplyExp;", "params", "", "Lspec/cvlast/CVLExp;", "lookUpMethodWithContractID", "methodId", "lookUpWithMethodIdWithCallContext", "methodIdWithCallContext", "Lspec/cvlast/MethodIdWithCallContext;", "lookupMethodInContractEnv", "contractSym", "register", "cmd", "Lspec/cvlast/CVLCmd$Simple$Declaration;", "Lspec/cvlast/CVLCmd$Simple$Definition;", "definition", "Lspec/cvlast/CVLDefinition;", "sub", "Lspec/cvlast/CVLFunction;", "ghost", "Lspec/cvlast/CVLGhostFunction;", "importedContract", "Lspec/cvlast/CVLImportedContract;", "inv", "Lspec/cvlast/CVLInvariant;", "sort", "Lspec/cvlast/CVLSimpleType$UninterpretedSort;", "importedFunction", "Lspec/cvlast/ContractFunction;", "registerCVLKeyword", "keyword", "Lspec/CVLKeywords;", "registerFunction", "function", "Lspec/cvlast/Function;", "registerParam", "param", "Lspec/cvlast/CVLParam;", "FreshNameGenerator", "SymbolInfo", "SymbolTableMethodLookupResult", "Shared"})
public final class CVLSymbolTable {
    private final Set<String> reserved;
    private final FreshNameGenerator freshNameGenerator;
    private final Map<Pair<CVLScope, String>, SymbolInfo> backing;
    private final Map<SolidityContract, CVLScope> contractsScope;
    private boolean isFinalized;

    @NotNull
    public final CVLSymbolTable copyUnfinalized() {
        return new CVLSymbolTable((Map<Pair<CVLScope, String>, SymbolInfo>)new HashMap<Pair<CVLScope, String>, SymbolInfo>(MapsKt.toMap(this.backing)), (Map<SolidityContract, CVLScope>)new HashMap<SolidityContract, CVLScope>(MapsKt.toMap(this.contractsScope)), false);
    }

    private final boolean checkName(MethodReference name, CVLLocation loc) {
        return this.checkName(name.getMethodId(), loc);
    }

    private final boolean checkName(String name, CVLLocation loc) {
        boolean nameIsReserved = SetsKt.minus(this.reserved, CVLReservedVariables.certorafallback_0.name()).contains(name);
        if (nameIsReserved) {
            CVLErrorLogger.INSTANCE.error("Trying to declare a variable with a reserved name: " + name + ". Please use another name", loc);
            return false;
        }
        boolean startingWithReservedPrefix = StringsKt.startsWith$default(name, "certora_", false, 2, null);
        if (startingWithReservedPrefix) {
            CVLErrorLogger.INSTANCE.error("Trying to declare a variable with a reserved prefix: " + name + ". Please use another name", loc);
            return false;
        }
        return true;
    }

    @Nullable
    public final SymbolInfo lookUp(@NotNull String id, @NotNull CVLTypeEnvironment typeEnv) {
        Intrinsics.checkParameterIsNotNull(id, "id");
        Intrinsics.checkParameterIsNotNull(typeEnv, "typeEnv");
        CVLTypeCheckerKt.getLogger().info(new Function0<String>(id, typeEnv){
            final /* synthetic */ String $id;
            final /* synthetic */ CVLTypeEnvironment $typeEnv;

            @NotNull
            public final String invoke() {
                return "Looking up " + this.$id + " in typeenv " + this.$typeEnv;
            }
            {
                this.$id = string2;
                this.$typeEnv = cVLTypeEnvironment;
                super(0);
            }
        });
        SymbolInfo typeFromEnv = typeEnv.lookUp(id);
        if (typeFromEnv != null) {
            return typeFromEnv;
        }
        return this.lookUp(id, typeEnv.getScope());
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final SymbolInfo lookUp(@NotNull String id, @NotNull CVLScope scope) {
        void currentInnerScope;
        Intrinsics.checkParameterIsNotNull(id, "id");
        Intrinsics.checkParameterIsNotNull(scope, "scope");
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = scope;
        while ((CVLScope)currentInnerScope.element != null) {
            CVLTypeCheckerKt.getLogger().info(new Function0<String>(this, id, (Ref.ObjectRef)currentInnerScope){
                final /* synthetic */ CVLSymbolTable this$0;
                final /* synthetic */ String $id;
                final /* synthetic */ Ref.ObjectRef $currentInnerScope;

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final String invoke() {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Pair it;
                    void $this$filterTo$iv$iv;
                    Iterable $this$filter$iv;
                    Iterable iterable = CVLSymbolTable.access$getBacking$p(this.this$0).keySet();
                    StringBuilder stringBuilder = new StringBuilder().append("Looking for ").append(this.$id).append(". All IDs in the scope ").append((CVLScope)this.$currentInnerScope.element).append(": ");
                    boolean $i$f$filter = false;
                    void var3_4 = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        it = (Pair)element$iv$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((CVLScope)it.getFirst(), (CVLScope)this.$currentInnerScope.element)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    Collection<String> collection = (List)destination$iv$iv;
                    $this$filter$iv = collection;
                    boolean $i$f$map = false;
                    $this$filterTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        it = (Pair)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        String string2 = (String)it.getSecond();
                        collection.add(string2);
                    }
                    collection = (List)destination$iv$iv;
                    return stringBuilder.append(collection).toString();
                }
                {
                    this.this$0 = cVLSymbolTable;
                    this.$id = string2;
                    this.$currentInnerScope = objectRef;
                    super(0);
                }
            });
            SymbolInfo symbolInfo = this.backing.get(new Pair<CVLScope, String>((CVLScope)currentInnerScope.element, id));
            if (symbolInfo != null) {
                return symbolInfo;
            }
            currentInnerScope.element = ((CVLScope)currentInnerScope.element).getInnerScope();
        }
        return null;
    }

    @NotNull
    public final CVLExp.VariableExp freshVar(@NotNull CVLExp.VariableExp requested) {
        Intrinsics.checkParameterIsNotNull(requested, "requested");
        return requested.isWildCard() ? requested : CVLExp.VariableExp.copy$default(requested, this.freshNameGenerator.generate(requested.getId()), null, null, 6, null);
    }

    @NotNull
    public final CVLParam.Named freshParam(@NotNull CVLParam.Named requested) {
        Intrinsics.checkParameterIsNotNull(requested, "requested");
        return requested.isWildCard() ? requested : CVLParam.Named.copy$default(requested, null, this.freshNameGenerator.generate(requested.getId()), 1, null);
    }

    @NotNull
    public final CVLExp.QuantifierExp freshQuantifierSym(@NotNull CVLExp.QuantifierExp requested) {
        Intrinsics.checkParameterIsNotNull(requested, "requested");
        return CVLExp.QuantifierExp.copy$default(requested, false, this.freshParam(requested.getParam()), null, null, 13, null);
    }

    @NotNull
    public final String freshName(@NotNull String requested) {
        Intrinsics.checkParameterIsNotNull(requested, "requested");
        return this.freshNameGenerator.generate(requested);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final SymbolTableMethodLookupResult lookUpMethod(@NotNull CVLExp.ApplyExp exp, @NotNull List<? extends CVLExp> params, @NotNull CVLTypeEnvironment typeEnv) {
        SymbolTableMethodLookupResult symbolTableMethodLookupResult;
        CVLType it;
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(exp, "exp");
        Intrinsics.checkParameterIsNotNull(params, "params");
        Intrinsics.checkParameterIsNotNull(typeEnv, "typeEnv");
        Iterable $this$map$iv = params;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            CVLExp cVLExp = (CVLExp)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            CVLType cVLType = ((CVLExp)((Object)it)).getCVLType();
            collection.add(cVLType);
        }
        List paramsCvlTypes = (List)destination$iv$iv;
        boolean firstParamIsEnv = exp instanceof CVLExp.ApplyExp.ContractFunction ? Intrinsics.areEqual((CVLType)CollectionsKt.firstOrNull(paramsCvlTypes), CVLInbuiltStructTypes.envType.getCvlType()) : false;
        List envFreeParamsCvlTypes = firstParamIsEnv ? CollectionsKt.drop(paramsCvlTypes, 1) : paramsCvlTypes;
        SymbolInfo lookUpResult = this.lookUpWithMethodIdWithCallContext(exp.getMethodIdWithCallContext(), typeEnv);
        if (lookUpResult == null) {
            String msg = "failed to look up function, no symbol table entry for " + exp.getMethodIdWithCallContext() + " (is the function public?)";
            CVLErrorLogger.INSTANCE.warn(msg, typeEnv.getLoc());
            symbolTableMethodLookupResult = new SymbolTableMethodLookupResult.FailureWithTypeError(new Function0<CVLErrorType>(exp, typeEnv, msg){
                final /* synthetic */ CVLExp.ApplyExp $exp;
                final /* synthetic */ CVLTypeEnvironment $typeEnv;
                final /* synthetic */ String $msg;

                @NotNull
                public final CVLErrorType invoke() {
                    return CVLTypeCheckerKt.typeError(this.$exp, this.$typeEnv.getLoc(), this.$msg);
                }
                {
                    this.$exp = applyExp;
                    this.$typeEnv = cVLTypeEnvironment;
                    this.$msg = string2;
                    super(0);
                }
            });
        } else if (Intrinsics.areEqual(lookUpResult.getCVLType(), CVLInbuiltStructTypes.methodType.getCvlType())) {
            symbolTableMethodLookupResult = new SymbolTableMethodLookupResult.Success(lookUpResult);
        } else if (lookUpResult instanceof SymbolInfo.CVLFunctionInfo) {
            if (Intrinsics.areEqual((CVLType)CollectionsKt.firstOrNull(envFreeParamsCvlTypes), CVLInbuiltSimpleTypes.calldataarg.INSTANCE.getCvlType())) {
                symbolTableMethodLookupResult = new SymbolTableMethodLookupResult.Success(lookUpResult);
            } else {
                boolean bl;
                block12: {
                    Iterable $this$any$iv = envFreeParamsCvlTypes;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            it = (CVLType)element$iv;
                            boolean bl2 = false;
                            if (!(it instanceof CVLErrorType)) continue;
                            bl = true;
                            break block12;
                        }
                        bl = false;
                    }
                }
                symbolTableMethodLookupResult = bl ? (SymbolTableMethodLookupResult)new SymbolTableMethodLookupResult.FailureWithTypeError(new Function0<CVLErrorType>(exp, typeEnv){
                    final /* synthetic */ CVLExp.ApplyExp $exp;
                    final /* synthetic */ CVLTypeEnvironment $typeEnv;

                    @NotNull
                    public final CVLErrorType invoke() {
                        return CVLTypeCheckerKt.typeError(this.$exp, this.$typeEnv.getLoc(), "at location " + this.$typeEnv.getLoc() + " : looked up a method " + this.$exp.getMethodIdWithCallContext() + " but some arguments are not well typed");
                    }
                    {
                        this.$exp = applyExp;
                        this.$typeEnv = cVLTypeEnvironment;
                        super(0);
                    }
                }) : ((SymbolInfo.CVLFunctionInfo)lookUpResult).matchOverloadings(firstParamIsEnv, envFreeParamsCvlTypes);
            }
        } else {
            symbolTableMethodLookupResult = new SymbolTableMethodLookupResult.FailureWithTypeError(new Function0<CVLErrorType>(exp, typeEnv){
                final /* synthetic */ CVLExp.ApplyExp $exp;
                final /* synthetic */ CVLTypeEnvironment $typeEnv;

                @NotNull
                public final CVLErrorType invoke() {
                    return CVLTypeCheckerKt.typeError(this.$exp, this.$typeEnv.getLoc(), "at location " + this.$typeEnv.getLoc() + " : looked up a method name but seem to have found a " + "variable: " + this.$exp.getMethodIdWithCallContext() + " -- is a variable shadowing a function?");
                }
                {
                    this.$exp = applyExp;
                    this.$typeEnv = cVLTypeEnvironment;
                    super(0);
                }
            });
        }
        return symbolTableMethodLookupResult;
    }

    @Nullable
    public final SymbolInfo lookUpWithMethodIdWithCallContext(@NotNull MethodIdWithCallContext methodIdWithCallContext, @NotNull CVLScope scope) {
        SymbolInfo symbolInfo;
        Intrinsics.checkParameterIsNotNull(methodIdWithCallContext, "methodIdWithCallContext");
        Intrinsics.checkParameterIsNotNull(scope, "scope");
        FunctionDeclarationScope functionDeclarationScope = methodIdWithCallContext.getCalleeContext().getDeclarationSite();
        if (functionDeclarationScope instanceof CvlSpecFile) {
            symbolInfo = this.lookUp(methodIdWithCallContext.getMethodId(), scope);
        } else if (Intrinsics.areEqual(functionDeclarationScope, SolidityContract.Current.INSTANCE) || functionDeclarationScope instanceof SolidityContract.Named) {
            symbolInfo = this.lookUpMethodWithContractID(methodIdWithCallContext.getCalleeContext().getDeclarationSite().getName(), methodIdWithCallContext.getMethodId(), scope);
        } else if (Intrinsics.areEqual(functionDeclarationScope, ErrorFunctionDeclarationScope.INSTANCE)) {
            symbolInfo = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return symbolInfo;
    }

    @Nullable
    public final SymbolInfo lookUpWithMethodIdWithCallContext(@NotNull MethodIdWithCallContext methodIdWithCallContext, @NotNull CVLTypeEnvironment typeEnv) {
        SymbolInfo symbolInfo;
        Intrinsics.checkParameterIsNotNull(methodIdWithCallContext, "methodIdWithCallContext");
        Intrinsics.checkParameterIsNotNull(typeEnv, "typeEnv");
        FunctionDeclarationScope functionDeclarationScope = methodIdWithCallContext.getCalleeContext().getDeclarationSite();
        if (functionDeclarationScope instanceof CvlSpecFile) {
            symbolInfo = this.lookUp(methodIdWithCallContext.getMethodId(), typeEnv);
        } else if (Intrinsics.areEqual(functionDeclarationScope, SolidityContract.Current.INSTANCE) || functionDeclarationScope instanceof SolidityContract.Named) {
            symbolInfo = this.lookUpMethodWithContractID(methodIdWithCallContext.getCalleeContext().getDeclarationSite().getName(), methodIdWithCallContext.getMethodId(), typeEnv);
        } else if (Intrinsics.areEqual(functionDeclarationScope, ErrorFunctionDeclarationScope.INSTANCE)) {
            symbolInfo = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return symbolInfo;
    }

    @Nullable
    public final SymbolInfo lookUpMethodWithContractID(@NotNull String contractId, @NotNull String methodId, @NotNull CVLScope scope) {
        Intrinsics.checkParameterIsNotNull(contractId, "contractId");
        Intrinsics.checkParameterIsNotNull(methodId, "methodId");
        Intrinsics.checkParameterIsNotNull(scope, "scope");
        return this.lookupMethodInContractEnv(this.lookUp(contractId, scope), methodId);
    }

    @Nullable
    public final SymbolInfo lookUpMethodWithContractID(@NotNull String contractId, @NotNull String methodId, @NotNull CVLTypeEnvironment typeEnv) {
        Intrinsics.checkParameterIsNotNull(contractId, "contractId");
        Intrinsics.checkParameterIsNotNull(methodId, "methodId");
        Intrinsics.checkParameterIsNotNull(typeEnv, "typeEnv");
        SymbolInfo lookup = this.lookupMethodInContractEnv(this.lookUp(contractId, typeEnv), methodId);
        return lookup != null ? lookup : this.lookUp(methodId, typeEnv);
    }

    private final SymbolInfo lookupMethodInContractEnv(SymbolInfo contractSym, String methodId) {
        if (contractSym != null && contractSym.getHook() instanceof CVLImportedContract) {
            Object object = contractSym.getHook();
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type spec.cvlast.CVLImportedContract");
            }
            SolidityContract.Named contractName = ((CVLImportedContract)object).getSolidityContractName();
            CVLScope scope = this.getContractScope(contractName);
            if (scope != null) {
                return this.lookUp(methodId, scope);
            }
        }
        return null;
    }

    public final void register(@NotNull CVLSimpleType.UninterpretedSort sort2, @NotNull CVLScope scope) {
        Intrinsics.checkParameterIsNotNull(sort2, "sort");
        Intrinsics.checkParameterIsNotNull(scope, "scope");
        CVLTypeCheckerKt.getLogger().info(new Function0<String>(sort2, scope){
            final /* synthetic */ CVLSimpleType.UninterpretedSort $sort;
            final /* synthetic */ CVLScope $scope;

            @NotNull
            public final String invoke() {
                return "For decl sort " + this.$sort.getName() + ", registering in " + this.$scope;
            }
            {
                this.$sort = uninterpretedSort;
                this.$scope = cVLScope;
                super(0);
            }
        });
        this.checkNotFinalized();
        if (this.backing.containsKey(TuplesKt.to(scope, sort2.getName()))) {
            CVLErrorLogger.INSTANCE.error("identifier " + sort2.getName() + " has already been declared in scope " + scope, new CVLLocation.Empty(null, 1, null));
        } else {
            this.backing.put(TuplesKt.to(scope, sort2.getName()), SymbolInfo.Companion.invoke$default(SymbolInfo.Companion, sort2, false, 2, null));
        }
    }

    public final void register(@NotNull CVLInvariant inv, @NotNull CVLScope scope) {
        Intrinsics.checkParameterIsNotNull(inv, "inv");
        Intrinsics.checkParameterIsNotNull(scope, "scope");
        CVLTypeCheckerKt.getLogger().info(new Function0<String>(inv, scope){
            final /* synthetic */ CVLInvariant $inv;
            final /* synthetic */ CVLScope $scope;

            @NotNull
            public final String invoke() {
                return "For invariant " + this.$inv.getId() + ", registering in " + this.$scope;
            }
            {
                this.$inv = cVLInvariant;
                this.$scope = cVLScope;
                super(0);
            }
        });
        this.checkNotFinalized();
        if (!this.checkName(inv.getId(), (CVLLocation)new CVLLocation.Empty(null, 1, null))) {
            return;
        }
        Pair<CVLScope, String> symbolTableKey = new Pair<CVLScope, String>(scope, inv.getId());
        if (this.backing.containsKey(symbolTableKey)) {
            CVLErrorLogger.INSTANCE.error("identifier " + inv.getId() + " has already been declared in scope " + scope, inv.getLoc());
        } else {
            this.backing.put(symbolTableKey, SymbolInfo.Companion.invoke$default(SymbolInfo.Companion, inv, false, 2, null));
        }
    }

    public final void register(@NotNull CVLFunction sub, @NotNull CVLScope scope) {
        Intrinsics.checkParameterIsNotNull(sub, "sub");
        Intrinsics.checkParameterIsNotNull(scope, "scope");
        CVLTypeCheckerKt.getLogger().info(new Function0<String>(sub, scope){
            final /* synthetic */ CVLFunction $sub;
            final /* synthetic */ CVLScope $scope;

            @NotNull
            public final String invoke() {
                return "For decl of subroutine " + this.$sub.type() + ", registering in " + this.$scope;
            }
            {
                this.$sub = cVLFunction;
                this.$scope = cVLScope;
                super(0);
            }
        });
        this.checkNotFinalized();
        if (!this.checkName(sub.getMethodReference(), (CVLLocation)new CVLLocation.Empty(null, 1, null))) {
            return;
        }
        Pair<CVLScope, String> symbolTableKey = new Pair<CVLScope, String>(scope, sub.getMethodReference().getMethodId());
        if (this.backing.containsKey(symbolTableKey)) {
            CVLErrorLogger.INSTANCE.error("some function with name " + sub.getMethodReference() + " has already been declared in " + "scope " + scope + ". Overloading not allowed for ghost functions", sub.getLoc());
        } else {
            this.registerFunction(sub, scope);
        }
    }

    public final void register(@NotNull CVLGhostFunction ghost2, @NotNull CVLScope scope) {
        Intrinsics.checkParameterIsNotNull(ghost2, "ghost");
        Intrinsics.checkParameterIsNotNull(scope, "scope");
        CVLTypeCheckerKt.getLogger().info(new Function0<String>(ghost2, scope){
            final /* synthetic */ CVLGhostFunction $ghost;
            final /* synthetic */ CVLScope $scope;

            @NotNull
            public final String invoke() {
                return "For decl of ghost function " + this.$ghost.getType() + ", registering in " + this.$scope;
            }
            {
                this.$ghost = cVLGhostFunction;
                this.$scope = cVLScope;
                super(0);
            }
        });
        this.checkNotFinalized();
        if (!this.checkName(ghost2.getMethodReference(), (CVLLocation)new CVLLocation.Empty(null, 1, null))) {
            return;
        }
        Pair<CVLScope, String> symbolTableKey = new Pair<CVLScope, String>(scope, ghost2.getMethodReference().getMethodId());
        if (this.backing.containsKey(symbolTableKey)) {
            CVLErrorLogger.INSTANCE.error("some function with name " + ghost2.getMethodReference() + " has already been declared in " + "scope " + scope + ". Overloading not allowed for ghost functions", ghost2.getLoc());
        } else {
            this.registerFunction(ghost2, scope);
        }
    }

    public final void register(@NotNull CVLDefinition definition2, @NotNull CVLScope scope) {
        Intrinsics.checkParameterIsNotNull(definition2, "definition");
        Intrinsics.checkParameterIsNotNull(scope, "scope");
        CVLTypeCheckerKt.getLogger().info(new Function0<String>(definition2, scope){
            final /* synthetic */ CVLDefinition $definition;
            final /* synthetic */ CVLScope $scope;

            @NotNull
            public final String invoke() {
                return "For definition " + this.$definition + ", registering in " + this.$scope;
            }
            {
                this.$definition = cVLDefinition;
                this.$scope = cVLScope;
                super(0);
            }
        });
        this.checkNotFinalized();
        if (!this.checkName(definition2.getId(), (CVLLocation)new CVLLocation.Empty(null, 1, null))) {
            return;
        }
        Pair<CVLScope, String> symbolTableKey = new Pair<CVLScope, String>(scope, definition2.getId());
        if (this.backing.containsKey(symbolTableKey)) {
            CVLErrorLogger.INSTANCE.error("some function with name " + definition2.getId() + ", has already been declared in " + "scope " + scope + ". Overloading not allowed for definitions", definition2.getLoc());
        } else {
            this.registerFunction(definition2, scope);
        }
    }

    public final void register(@NotNull CVLCmd.Simple.Declaration cmd, @NotNull CVLScope scope) {
        Intrinsics.checkParameterIsNotNull(cmd, "cmd");
        Intrinsics.checkParameterIsNotNull(scope, "scope");
        CVLTypeCheckerKt.getLogger().info(new Function0<String>(cmd){
            final /* synthetic */ CVLCmd.Simple.Declaration $cmd;

            @NotNull
            public final String invoke() {
                return "For decl " + this.$cmd + ", registering";
            }
            {
                this.$cmd = declaration;
                super(0);
            }
        });
        this.checkNotFinalized();
        if (!this.checkName(cmd.getId(), cmd.getLoc())) {
            return;
        }
        if (scope.isIfElseScope() && Intrinsics.areEqual(cmd.getType(), CVLInbuiltStructTypes.methodType.getCvlType())) {
            CVLErrorLogger.INSTANCE.error("Method type variables cannot be declared in if-else scopes (identifier: " + cmd.getId() + ", scope: " + scope + ')', cmd.getLoc());
            return;
        }
        if (this.backing.containsKey(new Pair<CVLScope, String>(scope, cmd.getId()))) {
            CVLErrorLogger.INSTANCE.error("identifier " + cmd.getId() + " has already been declared in scope " + scope, cmd.getLoc());
            return;
        }
        this.backing.put(new Pair<CVLScope, String>(scope, cmd.getId()), SymbolInfo.Companion.invoke$default(SymbolInfo.Companion, cmd, false, 2, null));
    }

    public final void register(@NotNull CVLCmd.Simple.Definition cmd, @NotNull CVLScope scope) {
        boolean bl;
        block7: {
            Intrinsics.checkParameterIsNotNull(cmd, "cmd");
            Intrinsics.checkParameterIsNotNull(scope, "scope");
            CVLTypeCheckerKt.getLogger().info(new Function0<String>(cmd, scope){
                final /* synthetic */ CVLCmd.Simple.Definition $cmd;
                final /* synthetic */ CVLScope $scope;

                @NotNull
                public final String invoke() {
                    return "For def " + this.$cmd + ", registering in " + this.$scope;
                }
                {
                    this.$cmd = definition2;
                    this.$scope = cVLScope;
                    super(0);
                }
            });
            this.checkNotFinalized();
            Iterable $this$any$iv = cmd.getIdL();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!this.checkName(it, cmd.getLoc())) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        if (!bl) {
            return;
        }
        if (cmd.getType() == null) {
            return;
        }
        for (String id : cmd.getIdL()) {
            if (this.backing.containsKey(new Pair<CVLScope, String>(scope, id))) {
                CVLErrorLogger.INSTANCE.error("identifier " + id + " has already been declared in scope " + scope, cmd.getLoc());
                return;
            }
            CVLTypeCheckerKt.getLogger().info(new Function0<String>(scope, id, cmd){
                final /* synthetic */ CVLScope $scope;
                final /* synthetic */ String $id;
                final /* synthetic */ CVLCmd.Simple.Definition $cmd;

                @NotNull
                public final String invoke() {
                    return "Registered in " + this.$scope + ", " + this.$id + ": " + SymbolInfo.Companion.invoke$default(SymbolInfo.Companion, this.$cmd, false, 2, null);
                }
                {
                    this.$scope = cVLScope;
                    this.$id = string2;
                    this.$cmd = definition2;
                    super(0);
                }
            });
            this.backing.put(new Pair<CVLScope, String>(scope, id), SymbolInfo.Companion.invoke$default(SymbolInfo.Companion, cmd, false, 2, null));
        }
    }

    public final void registerParam(@NotNull CVLParam param, @NotNull CVLScope scope, @NotNull CVLLocation loc) {
        Intrinsics.checkParameterIsNotNull(param, "param");
        Intrinsics.checkParameterIsNotNull(scope, "scope");
        Intrinsics.checkParameterIsNotNull(loc, "loc");
        this.checkNotFinalized();
        if (!this.checkName(param.getId(), loc) || param.isWildCard()) {
            return;
        }
        if (this.backing.containsKey(new Pair<CVLScope, String>(scope, param.getId()))) {
            CVLErrorLogger.INSTANCE.error("identifier " + param.getId() + " already has an entry in scope " + scope, loc);
            return;
        }
        this.backing.put(new Pair<CVLScope, String>(scope, param.getId()), SymbolInfo.Companion.invoke$default(SymbolInfo.Companion, param, false, 2, null));
    }

    public final void registerCVLKeyword(@NotNull CVLKeywords keyword, @NotNull CVLScope scope) {
        Intrinsics.checkParameterIsNotNull((Object)keyword, "keyword");
        Intrinsics.checkParameterIsNotNull(scope, "scope");
        this.checkNotFinalized();
        if (this.backing.containsKey(new Pair<CVLScope, String>(scope, keyword.getKeyword()))) {
            CVLErrorLogger.INSTANCE.error("identifier " + keyword.getKeyword() + " already has an entry in scope " + scope, new CVLLocation.Empty(null, 1, null));
            return;
        }
        this.backing.put(new Pair<CVLScope, String>(scope, keyword.getKeyword()), SymbolInfo.Companion.invoke$default(SymbolInfo.Companion, (Object)keyword, false, 2, null));
    }

    private final void registerFunction(Function function, CVLScope scope) {
        Pair<CVLScope, String> symbolTableKey = new Pair<CVLScope, String>(scope, function.getMethodReference().getMethodId());
        SymbolInfo stEntry = this.backing.get(symbolTableKey);
        if (stEntry == null) {
            this.backing.put(symbolTableKey, SymbolInfo.Companion.invoke$default(SymbolInfo.Companion, function, false, 2, null));
        } else if (!(function instanceof ContractFunction) || !(((ContractFunction)function).getMethodSignature() instanceof MethodSignature.Hashed)) {
            SymbolInfo.CVLFunctionInfo cfr_ignored_0 = (SymbolInfo.CVLFunctionInfo)stEntry;
            this.backing.put(symbolTableKey, ((SymbolInfo.CVLFunctionInfo)stEntry).registerOverloading(function));
        }
    }

    public final void register(@NotNull ContractFunction importedFunction, @NotNull CVLScope scope) {
        Intrinsics.checkParameterIsNotNull(importedFunction, "importedFunction");
        Intrinsics.checkParameterIsNotNull(scope, "scope");
        this.checkNotFinalized();
        if (!this.checkName(importedFunction.getMethodReference(), (CVLLocation)new CVLLocation.Empty(null, 1, null))) {
            return;
        }
        this.registerFunction(importedFunction, scope);
        this.backing.put(new Pair<CVLScope, String>(scope, importedFunction.getCanonicalStringRepresentation()), SymbolInfo.Companion.invoke$default(SymbolInfo.Companion, importedFunction.getMethodInfo(), false, 2, null));
    }

    public final void register(@NotNull CVLImportedContract importedContract, @NotNull CVLScope scope) {
        Intrinsics.checkParameterIsNotNull(importedContract, "importedContract");
        Intrinsics.checkParameterIsNotNull(scope, "scope");
        this.checkNotFinalized();
        Pair<CVLScope, String> symbolTableKey = new Pair<CVLScope, String>(scope, importedContract.getSolidityContractVarId().getName());
        if (!this.checkName(importedContract.getSolidityContractVarId().getName(), (CVLLocation)new CVLLocation.Empty(null, 1, null))) {
            return;
        }
        this.backing.put(symbolTableKey, SymbolInfo.Companion.invoke$default(SymbolInfo.Companion, importedContract, false, 2, null));
    }

    private final void checkNotFinalized() {
        if (this.isFinalized) {
            throw (Throwable)((Object)new AssertionError((Object)"Attempt to update symbol table when it has been finalized already"));
        }
    }

    public final void finalize() {
        this.isFinalized = true;
    }

    public final void addContractScope(@NotNull SolidityContract contractName, @NotNull CVLScope scope) {
        Intrinsics.checkParameterIsNotNull(contractName, "contractName");
        Intrinsics.checkParameterIsNotNull(scope, "scope");
        if (this.contractsScope.containsKey(contractName)) {
            CVLErrorLogger.INSTANCE.error("Contract name " + contractName + " already has an entry in scope " + scope, new CVLLocation.Empty(null, 1, null));
        }
        this.contractsScope.put(contractName, scope);
    }

    @Nullable
    public final CVLScope getContractScope(@NotNull SolidityContract contractName) {
        Intrinsics.checkParameterIsNotNull(contractName, "contractName");
        SolidityContract solidityContract = this.getContractNameFromContractId(contractName);
        if (solidityContract == null) {
            solidityContract = contractName;
        }
        SolidityContract resolved = solidityContract;
        return this.contractsScope.get(resolved);
    }

    @Nullable
    public final SolidityContract getContractNameFromContractId(@Nullable SolidityContract contractId) {
        SymbolInfo contractNameSym;
        if (contractId != null && (contractNameSym = this.lookUp(contractId.getName(), CVLScope.Companion.getAstScope())) != null) {
            Object object = contractNameSym.getHook();
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type spec.cvlast.CVLImportedContract");
            }
            return ((CVLImportedContract)object).getSolidityContractName();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public CVLSymbolTable(@NotNull Map<Pair<CVLScope, String>, SymbolInfo> backing, @NotNull Map<SolidityContract, CVLScope> contractsScope, boolean isFinalized) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkParameterIsNotNull(backing, "backing");
        Intrinsics.checkParameterIsNotNull(contractsScope, "contractsScope");
        this.backing = backing;
        this.contractsScope = contractsScope;
        this.isFinalized = isFinalized;
        CVLReservedVariables[] cVLReservedVariablesArray = CVLReservedVariables.values();
        CVLSymbolTable cVLSymbolTable = this;
        boolean $i$f$map = false;
        void var6_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        void var9_10 = $this$mapTo$iv$iv;
        int n = ((void)var9_10).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var13_14 = item$iv$iv = var9_10[i];
            collection = destination$iv$iv;
            boolean bl = false;
            String string2 = it.name();
            collection.add(string2);
        }
        collection = (List)destination$iv$iv;
        cVLSymbolTable.reserved = CollectionsKt.toSet((Iterable)collection);
        this.freshNameGenerator = new FreshNameGenerator();
    }

    public /* synthetic */ CVLSymbolTable(Map map2, Map map3, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            map2 = new HashMap();
        }
        if ((n & 2) != 0) {
            map3 = new HashMap();
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        this(map2, map3, bl);
    }

    public CVLSymbolTable() {
        this(null, null, false, 7, null);
    }

    public static final /* synthetic */ void access$setFinalized$p(CVLSymbolTable $this, boolean bl) {
        $this.isFinalized = bl;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005H\u0002J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u0005H\u0002R\u0016\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lspec/cvlast/CVLSymbolTable$FreshNameGenerator;", "", "(Lspec/cvlast/CVLSymbolTable;)V", "allIds", "", "", "generated", "", "lastUsedIndex", "", "", "generate", "requested", "inAnyScope", "", "id", "taken", "Shared"})
    public final class FreshNameGenerator {
        private final Set<String> generated;
        private final Map<String, Integer> lastUsedIndex;
        private Set<String> allIds;

        /*
         * WARNING - void declaration
         */
        private final boolean inAnyScope(String id) {
            boolean bl;
            if (CVLSymbolTable.this.isFinalized) {
                if (this.allIds == null) {
                    Collection<String> collection;
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Iterable iterable = CVLSymbolTable.this.backing.keySet();
                    FreshNameGenerator freshNameGenerator = this;
                    boolean $i$f$map = false;
                    void var4_8 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void $dstr$_u24__u24$id;
                        String id2;
                        Pair pair = (Pair)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl2 = false;
                        String string2 = id2 = (String)$dstr$_u24__u24$id.component2();
                        collection.add(string2);
                    }
                    collection = (List)destination$iv$iv;
                    freshNameGenerator.allIds = CollectionsKt.toSet((Iterable)collection);
                }
                Set<String> set = this.allIds;
                if (set == null) {
                    Intrinsics.throwNpe();
                }
                bl = set.contains(id);
            } else {
                Iterable $this$map$iv = CVLSymbolTable.this.backing.keySet();
                boolean $i$f$map = false;
                Iterable $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    String id3;
                    Pair $dstr$_u24__u24$id = (Pair)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    String string3 = id3 = (String)$dstr$_u24__u24$id.component2();
                    collection.add(string3);
                }
                bl = ((List)destination$iv$iv).contains(id);
            }
            return bl;
        }

        private final boolean taken(String requested) {
            return this.generated.contains(requested) || CVLSymbolTable.this.reserved.contains(requested) || this.inAnyScope(requested);
        }

        @NotNull
        public final String generate(@NotNull String requested) {
            Intrinsics.checkParameterIsNotNull(requested, "requested");
            String result2 = requested;
            int idx = 0;
            if (this.taken(result2)) {
                Integer n = this.lastUsedIndex.get(requested);
                idx = n != null ? n : 0;
                result2 = requested + ++idx;
                while (this.taken(result2)) {
                    result2 = requested + ++idx;
                }
            }
            this.generated.add(result2);
            this.lastUsedIndex.put(result2, idx);
            return result2;
        }

        public FreshNameGenerator() {
            FreshNameGenerator freshNameGenerator = this;
            boolean bl = false;
            Object object = new LinkedHashSet();
            freshNameGenerator.generated = object;
            freshNameGenerator = this;
            bl = false;
            freshNameGenerator.lastUsedIndex = object = (Map)new LinkedHashMap();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\u0003\u0004\u0005B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0003\u0006\u0007\b\u00a8\u0006\t"}, d2={"Lspec/cvlast/CVLSymbolTable$SymbolTableMethodLookupResult;", "", "()V", "FailureWithParametricTypeError", "FailureWithTypeError", "Success", "Lspec/cvlast/CVLSymbolTable$SymbolTableMethodLookupResult$Success;", "Lspec/cvlast/CVLSymbolTable$SymbolTableMethodLookupResult$FailureWithTypeError;", "Lspec/cvlast/CVLSymbolTable$SymbolTableMethodLookupResult$FailureWithParametricTypeError;", "Shared"})
    public static abstract class SymbolTableMethodLookupResult {
        private SymbolTableMethodLookupResult() {
        }

        public /* synthetic */ SymbolTableMethodLookupResult(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lspec/cvlast/CVLSymbolTable$SymbolTableMethodLookupResult$Success;", "Lspec/cvlast/CVLSymbolTable$SymbolTableMethodLookupResult;", "info", "Lspec/cvlast/CVLSymbolTable$SymbolInfo;", "(Lspec/cvlast/CVLSymbolTable$SymbolInfo;)V", "getInfo", "()Lspec/cvlast/CVLSymbolTable$SymbolInfo;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "Shared"})
        public static final class Success
        extends SymbolTableMethodLookupResult {
            @NotNull
            private final SymbolInfo info;

            @NotNull
            public final SymbolInfo getInfo() {
                return this.info;
            }

            public Success(@NotNull SymbolInfo info) {
                Intrinsics.checkParameterIsNotNull(info, "info");
                super(null);
                this.info = info;
            }

            @NotNull
            public final SymbolInfo component1() {
                return this.info;
            }

            @NotNull
            public final Success copy(@NotNull SymbolInfo info) {
                Intrinsics.checkParameterIsNotNull(info, "info");
                return new Success(info);
            }

            public static /* synthetic */ Success copy$default(Success success, SymbolInfo symbolInfo, int n, Object object) {
                if ((n & 1) != 0) {
                    symbolInfo = success.info;
                }
                return success.copy(symbolInfo);
            }

            @NotNull
            public String toString() {
                return "Success(info=" + this.info + ")";
            }

            public int hashCode() {
                SymbolInfo symbolInfo = this.info;
                return symbolInfo != null ? symbolInfo.hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Success)) break block3;
                        Success success = (Success)object;
                        if (!Intrinsics.areEqual(this.info, success.info)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\t\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lspec/cvlast/CVLSymbolTable$SymbolTableMethodLookupResult$FailureWithTypeError;", "Lspec/cvlast/CVLSymbolTable$SymbolTableMethodLookupResult;", "typeErrorReporter", "Lkotlin/Function0;", "Lspec/cvlast/CVLErrorType;", "(Lkotlin/jvm/functions/Function0;)V", "getTypeErrorReporter", "()Lkotlin/jvm/functions/Function0;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "Shared"})
        public static final class FailureWithTypeError
        extends SymbolTableMethodLookupResult {
            @NotNull
            private final Function0<CVLErrorType> typeErrorReporter;

            @NotNull
            public final Function0<CVLErrorType> getTypeErrorReporter() {
                return this.typeErrorReporter;
            }

            public FailureWithTypeError(@NotNull Function0<CVLErrorType> typeErrorReporter) {
                Intrinsics.checkParameterIsNotNull(typeErrorReporter, "typeErrorReporter");
                super(null);
                this.typeErrorReporter = typeErrorReporter;
            }

            @NotNull
            public final Function0<CVLErrorType> component1() {
                return this.typeErrorReporter;
            }

            @NotNull
            public final FailureWithTypeError copy(@NotNull Function0<CVLErrorType> typeErrorReporter) {
                Intrinsics.checkParameterIsNotNull(typeErrorReporter, "typeErrorReporter");
                return new FailureWithTypeError(typeErrorReporter);
            }

            public static /* synthetic */ FailureWithTypeError copy$default(FailureWithTypeError failureWithTypeError, Function0 function0, int n, Object object) {
                if ((n & 1) != 0) {
                    function0 = failureWithTypeError.typeErrorReporter;
                }
                return failureWithTypeError.copy(function0);
            }

            @NotNull
            public String toString() {
                return "FailureWithTypeError(typeErrorReporter=" + this.typeErrorReporter + ")";
            }

            public int hashCode() {
                Function0<CVLErrorType> function0 = this.typeErrorReporter;
                return function0 != null ? function0.hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof FailureWithTypeError)) break block3;
                        FailureWithTypeError failureWithTypeError = (FailureWithTypeError)object;
                        if (!Intrinsics.areEqual(this.typeErrorReporter, failureWithTypeError.typeErrorReporter)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0002\u0010\u0007J\u001b\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0003J%\u0010\u000b\u001a\u00020\u00002\u001a\b\u0002\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R#\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0014"}, d2={"Lspec/cvlast/CVLSymbolTable$SymbolTableMethodLookupResult$FailureWithParametricTypeError;", "Lspec/cvlast/CVLSymbolTable$SymbolTableMethodLookupResult;", "typeErrorReporter", "Lkotlin/Function2;", "Lspec/cvlast/CVLExp$ApplyExp;", "Lspec/cvlast/CVLLocation;", "Lspec/cvlast/CVLErrorType;", "(Lkotlin/jvm/functions/Function2;)V", "getTypeErrorReporter", "()Lkotlin/jvm/functions/Function2;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "Shared"})
        public static final class FailureWithParametricTypeError
        extends SymbolTableMethodLookupResult {
            @NotNull
            private final Function2<CVLExp.ApplyExp, CVLLocation, CVLErrorType> typeErrorReporter;

            @NotNull
            public final Function2<CVLExp.ApplyExp, CVLLocation, CVLErrorType> getTypeErrorReporter() {
                return this.typeErrorReporter;
            }

            public FailureWithParametricTypeError(@NotNull Function2<? super CVLExp.ApplyExp, ? super CVLLocation, CVLErrorType> typeErrorReporter) {
                Intrinsics.checkParameterIsNotNull(typeErrorReporter, "typeErrorReporter");
                super(null);
                this.typeErrorReporter = typeErrorReporter;
            }

            @NotNull
            public final Function2<CVLExp.ApplyExp, CVLLocation, CVLErrorType> component1() {
                return this.typeErrorReporter;
            }

            @NotNull
            public final FailureWithParametricTypeError copy(@NotNull Function2<? super CVLExp.ApplyExp, ? super CVLLocation, CVLErrorType> typeErrorReporter) {
                Intrinsics.checkParameterIsNotNull(typeErrorReporter, "typeErrorReporter");
                return new FailureWithParametricTypeError(typeErrorReporter);
            }

            public static /* synthetic */ FailureWithParametricTypeError copy$default(FailureWithParametricTypeError failureWithParametricTypeError, Function2 function2, int n, Object object) {
                if ((n & 1) != 0) {
                    function2 = failureWithParametricTypeError.typeErrorReporter;
                }
                return failureWithParametricTypeError.copy(function2);
            }

            @NotNull
            public String toString() {
                return "FailureWithParametricTypeError(typeErrorReporter=" + this.typeErrorReporter + ")";
            }

            public int hashCode() {
                Function2<CVLExp.ApplyExp, CVLLocation, CVLErrorType> function2 = this.typeErrorReporter;
                return function2 != null ? function2.hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof FailureWithParametricTypeError)) break block3;
                        FailureWithParametricTypeError failureWithParametricTypeError = (FailureWithParametricTypeError)object;
                        if (!Intrinsics.areEqual(this.typeErrorReporter, failureWithParametricTypeError.typeErrorReporter)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u000e2\u00020\u0001:\u0004\f\r\u000e\u000fB\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\t\u001a\u00020\nH&J\u0006\u0010\u000b\u001a\u00020\u0004R\u0014\u0010\u0002\u001a\u00020\u0001X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\b\u0082\u0001\u0003\u0010\u0011\u0012\u00a8\u0006\u0013"}, d2={"Lspec/cvlast/CVLSymbolTable$SymbolInfo;", "", "hook", "isTwoState", "", "(Ljava/lang/Object;Z)V", "getHook", "()Ljava/lang/Object;", "()Z", "getCVLType", "Lspec/cvlast/CVLType;", "isParam", "CVLFunctionIdentifierInfo", "CVLFunctionInfo", "Companion", "WithCVLType", "Lspec/cvlast/CVLSymbolTable$SymbolInfo$WithCVLType;", "Lspec/cvlast/CVLSymbolTable$SymbolInfo$CVLFunctionInfo;", "Lspec/cvlast/CVLSymbolTable$SymbolInfo$CVLFunctionIdentifierInfo;", "Shared"})
    public static abstract class SymbolInfo {
        @NotNull
        private final Object hook;
        private final boolean isTwoState;
        public static final Companion Companion = new Companion(null);

        @NotNull
        public abstract CVLType getCVLType();

        public final boolean isParam() {
            return this.getHook() instanceof CVLParam;
        }

        @NotNull
        public Object getHook() {
            return this.hook;
        }

        public boolean isTwoState() {
            return this.isTwoState;
        }

        private SymbolInfo(Object hook2, boolean isTwoState) {
            this.hook = hook2;
            this.isTwoState = isTwoState;
        }

        /* synthetic */ SymbolInfo(Object object, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                bl = false;
            }
            this(object, bl);
        }

        public /* synthetic */ SymbolInfo(Object hook2, boolean isTwoState, DefaultConstructorMarker $constructor_marker) {
            this(hook2, isTwoState);
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u00d6\u0003J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\t\u00a8\u0006\u0015"}, d2={"Lspec/cvlast/CVLSymbolTable$SymbolInfo$WithCVLType;", "Lspec/cvlast/CVLSymbolTable$SymbolInfo;", "hook", "", "isTwoState", "", "(Ljava/lang/Object;Z)V", "getHook", "()Ljava/lang/Object;", "()Z", "component1", "component2", "copy", "equals", "other", "getCVLType", "Lspec/cvlast/CVLType;", "hashCode", "", "toString", "", "Shared"})
        public static final class WithCVLType
        extends SymbolInfo {
            @NotNull
            private final Object hook;
            private final boolean isTwoState;

            @Override
            @NotNull
            public CVLType getCVLType() {
                CVLType cVLType;
                Object object = this.getHook();
                if (object instanceof CVLParam) {
                    cVLType = ((CVLParam)this.getHook()).getType();
                } else if (object instanceof CVLCmd.Simple.Declaration) {
                    cVLType = ((CVLCmd.Simple.Declaration)this.getHook()).getType();
                } else if (object instanceof CVLCmd.Simple.Definition) {
                    cVLType = ((CVLCmd.Simple.Definition)this.getHook()).getType();
                    if (cVLType == null) {
                        throw (Throwable)((Object)new AssertionError((Object)"should not have registered a definition that does not declare anything in the symbol table "));
                    }
                } else if (object instanceof CVLSimpleType.UninterpretedSort) {
                    cVLType = (CVLType)this.getHook();
                } else if (object instanceof CVLGhostFunction) {
                    cVLType = ((CVLGhostFunction)this.getHook()).getType();
                } else if (object instanceof CVLKeywords) {
                    cVLType = ((CVLKeywords)((Object)this.getHook())).getType();
                } else if (object instanceof CVLExp.VariableExp) {
                    cVLType = ((CVLExp.VariableExp)this.getHook()).getCVLType();
                } else if (object instanceof Map.Entry) {
                    Object v = ((Map.Entry)this.getHook()).getValue();
                    if (v == null) {
                        throw new TypeCastException("null cannot be cast to non-null type spec.cvlast.CVLType");
                    }
                    cVLType = (CVLType)v;
                } else if (object instanceof CVLImportedContract) {
                    cVLType = CVLInbuiltSimpleTypes.address.INSTANCE.getCvlType();
                } else {
                    throw (Throwable)new UnsupportedOperationException("missing case? (" + this.getHook() + ')');
                }
                return cVLType;
            }

            @Override
            @NotNull
            public Object getHook() {
                return this.hook;
            }

            @Override
            public boolean isTwoState() {
                return this.isTwoState;
            }

            public WithCVLType(@NotNull Object hook2, boolean isTwoState) {
                Intrinsics.checkParameterIsNotNull(hook2, "hook");
                super(hook2, isTwoState, null);
                this.hook = hook2;
                this.isTwoState = isTwoState;
            }

            public /* synthetic */ WithCVLType(Object object, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 2) != 0) {
                    bl = false;
                }
                this(object, bl);
            }

            @NotNull
            public final Object component1() {
                return this.getHook();
            }

            public final boolean component2() {
                return this.isTwoState();
            }

            @NotNull
            public final WithCVLType copy(@NotNull Object hook2, boolean isTwoState) {
                Intrinsics.checkParameterIsNotNull(hook2, "hook");
                return new WithCVLType(hook2, isTwoState);
            }

            public static /* synthetic */ WithCVLType copy$default(WithCVLType withCVLType, Object object, boolean bl, int n, Object object2) {
                if ((n & 1) != 0) {
                    object = withCVLType.getHook();
                }
                if ((n & 2) != 0) {
                    bl = withCVLType.isTwoState();
                }
                return withCVLType.copy(object, bl);
            }

            @NotNull
            public String toString() {
                return "WithCVLType(hook=" + this.getHook() + ", isTwoState=" + this.isTwoState() + ")";
            }

            public int hashCode() {
                Object object = this.getHook();
                int n = (object != null ? object.hashCode() : 0) * 31;
                int n2 = this.isTwoState() ? 1 : 0;
                if (n2 != 0) {
                    n2 = 1;
                }
                return n + n2;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof WithCVLType)) break block3;
                        WithCVLType withCVLType = (WithCVLType)object;
                        if (!Intrinsics.areEqual(this.getHook(), withCVLType.getHook()) || this.isTwoState() != withCVLType.isTwoState()) break block3;
                    }
                    return true;
                }
                return false;
            }
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\bH\u00c6\u0003J-\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0003H\u00d6\u0003J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\u001c\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\b2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00180\u0005J\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u0006J\t\u0010!\u001a\u00020\"H\u00d6\u0001R\u0011\u0010\n\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\f\u00a8\u0006#"}, d2={"Lspec/cvlast/CVLSymbolTable$SymbolInfo$CVLFunctionInfo;", "Lspec/cvlast/CVLSymbolTable$SymbolInfo;", "hook", "", "impFuncs", "", "Lspec/cvlast/Function;", "isTwoState", "", "(Ljava/lang/Object;Ljava/util/List;Z)V", "hasOverloadings", "getHasOverloadings", "()Z", "getHook", "()Ljava/lang/Object;", "getImpFuncs", "()Ljava/util/List;", "component1", "component2", "component3", "copy", "equals", "other", "getCVLType", "Lspec/cvlast/CVLType;", "hashCode", "", "matchOverloadings", "Lspec/cvlast/CVLSymbolTable$SymbolTableMethodLookupResult;", "firstParamIsEnv", "callParamsWithoutEnv", "registerOverloading", "impFunc", "toString", "", "Shared"})
        public static final class CVLFunctionInfo
        extends SymbolInfo {
            private final boolean hasOverloadings;
            @NotNull
            private final Object hook;
            @NotNull
            private final List<Function> impFuncs;
            private final boolean isTwoState;

            public final boolean getHasOverloadings() {
                return this.hasOverloadings;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            @NotNull
            public CVLType getCVLType() {
                CVLType cVLType;
                if (this.hasOverloadings) {
                    void $this$sortedBy$iv;
                    Iterable iterable = this.impFuncs;
                    StringBuilder stringBuilder = new StringBuilder().append("using a function pointer for a function with overloadings ").append('(');
                    CVLErrorLogger cVLErrorLogger = CVLErrorLogger.INSTANCE;
                    boolean $i$f$sortedBy = false;
                    boolean bl = false;
                    List list2 = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator<T>(){

                        public final int compare(T a, T b) {
                            boolean bl = false;
                            Function it = (Function)a;
                            boolean bl2 = false;
                            Comparable comparable = (Comparable)((Object)it.toString());
                            it = (Function)b;
                            Comparable comparable2 = comparable;
                            bl2 = false;
                            String string2 = it.toString();
                            return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)string2));
                        }
                    });
                    cVLErrorLogger.warn(stringBuilder.append(CollectionsKt.joinToString$default(list2, ", ", null, null, 0, null, null, 62, null)).append("), returning ").append("the first overloading").toString(), new CVLLocation.Empty(null, 1, null));
                    cVLType = CollectionsKt.first(this.impFuncs).type();
                } else {
                    boolean bl = this.impFuncs.size() == 1;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    if (_Assertions.ENABLED && !bl) {
                        boolean bl4 = false;
                        String string2 = "Assertion failed";
                        throw (Throwable)((Object)new AssertionError((Object)string2));
                    }
                    cVLType = CollectionsKt.first(this.impFuncs).type();
                }
                return cVLType;
            }

            @NotNull
            public final SymbolTableMethodLookupResult matchOverloadings(boolean firstParamIsEnv, @NotNull List<? extends CVLType> callParamsWithoutEnv) {
                Intrinsics.checkParameterIsNotNull(callParamsWithoutEnv, "callParamsWithoutEnv");
                boolean foundAMatchButEnvIsMissing = false;
                boolean foundAMatchButEnvIsTooMuch = false;
                for (Function impFunc : this.impFuncs) {
                    boolean bl = !(impFunc instanceof CVLGhostFunction) || this.impFuncs.size() == 1;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    if (!bl) {
                        boolean bl4 = false;
                        String string2 = "An internal error occurred: ghost function " + impFunc.getMethodReference() + " should " + "not be allowed to be overloaded by the type checker. Please report this to Certora.";
                        throw (Throwable)new IllegalStateException(string2.toString());
                    }
                    CVLFunctionType cvlFunc = impFunc.type();
                    boolean isEnvFree = impFunc.isEnvFree();
                    if (callParamsWithoutEnv.size() != cvlFunc.getParamTypes().size()) continue;
                    boolean allConvertible = cvlFunc.canBeAppliedWithParams(callParamsWithoutEnv);
                    if (allConvertible && firstParamIsEnv && isEnvFree) {
                        foundAMatchButEnvIsTooMuch = true;
                        continue;
                    }
                    if (allConvertible && !firstParamIsEnv && !isEnvFree) {
                        foundAMatchButEnvIsMissing = true;
                        continue;
                    }
                    if (!allConvertible) continue;
                    return new SymbolTableMethodLookupResult.Success(new CVLFunctionInfo((Object)impFunc, CollectionsKt.listOf(impFunc), this.isTwoState()));
                }
                String messageSupplement = foundAMatchButEnvIsTooMuch ? " Method is envfree, thus cannot be called with an environment as first argument." : (foundAMatchButEnvIsMissing ? " Method is not envfree; did you forget to provide the environment as the first function argument?" : "");
                return new SymbolTableMethodLookupResult.FailureWithParametricTypeError((Function2<? super CVLExp.ApplyExp, ? super CVLLocation, CVLErrorType>)new Function2<CVLExp.ApplyExp, CVLLocation, CVLErrorType>(callParamsWithoutEnv, messageSupplement){
                    final /* synthetic */ List $callParamsWithoutEnv;
                    final /* synthetic */ String $messageSupplement;

                    @NotNull
                    public final CVLErrorType invoke(@NotNull CVLExp.ApplyExp exp, @NotNull CVLLocation loc) {
                        Intrinsics.checkParameterIsNotNull(exp, "exp");
                        Intrinsics.checkParameterIsNotNull(loc, "loc");
                        return CVLTypeCheckerKt.typeError(exp, loc, "Could not find an overloading of method " + exp.getMethodIdWithCallContext() + " that matches the given arguments: " + CollectionsKt.joinToString$default(this.$callParamsWithoutEnv, ", ", null, null, 0, null, null, 62, null) + '.' + this.$messageSupplement);
                    }
                    {
                        this.$callParamsWithoutEnv = list2;
                        this.$messageSupplement = string2;
                        super(2);
                    }
                });
            }

            @NotNull
            public final CVLFunctionInfo registerOverloading(@NotNull Function impFunc) {
                CVLFunctionInfo cVLFunctionInfo;
                Intrinsics.checkParameterIsNotNull(impFunc, "impFunc");
                if (this.impFuncs.contains(impFunc)) {
                    cVLFunctionInfo = this;
                } else {
                    Object v1;
                    block7: {
                        Iterable iterable = this.impFuncs;
                        boolean bl = false;
                        Iterable iterable2 = iterable;
                        boolean bl2 = false;
                        for (Object t2 : iterable2) {
                            Function it = (Function)t2;
                            boolean bl3 = false;
                            if (!it.type().matches(impFunc.type())) continue;
                            v1 = t2;
                            break block7;
                        }
                        v1 = null;
                    }
                    Function potentialCopy = v1;
                    if (potentialCopy == null) {
                        cVLFunctionInfo = new CVLFunctionInfo(this.getHook(), CollectionsKt.plus((Collection)this.impFuncs, (Iterable)CollectionsKt.listOf(impFunc)), this.isTwoState());
                    } else if (impFunc instanceof ContractFunction && potentialCopy instanceof ContractFunction) {
                        cVLFunctionInfo = new CVLFunctionInfo(this.getHook(), CollectionsKt.plus((Collection)CollectionsKt.minus((Iterable)this.impFuncs, potentialCopy), (Iterable)CollectionsKt.listOf(ContractFunction.copy$default((ContractFunction)potentialCopy, null, null, ((ContractFunction)potentialCopy).getDefinitelyNonPayable() || ((ContractFunction)impFunc).getDefinitelyNonPayable(), potentialCopy.isEnvFree() || impFunc.isEnvFree(), false, null, null, null, null, null, 1011, null))), false, 4, null);
                    } else {
                        CVLErrorLogger.INSTANCE.error("Tried to register two ambiguous function types " + impFunc + " and " + potentialCopy, new CVLLocation.Empty(null, 1, null));
                        cVLFunctionInfo = this;
                    }
                }
                return cVLFunctionInfo;
            }

            @Override
            @NotNull
            public Object getHook() {
                return this.hook;
            }

            @NotNull
            public final List<Function> getImpFuncs() {
                return this.impFuncs;
            }

            @Override
            public boolean isTwoState() {
                return this.isTwoState;
            }

            public CVLFunctionInfo(@NotNull Object hook2, @NotNull List<? extends Function> impFuncs, boolean isTwoState) {
                Intrinsics.checkParameterIsNotNull(hook2, "hook");
                Intrinsics.checkParameterIsNotNull(impFuncs, "impFuncs");
                super(hook2, false, 2, null);
                this.hook = hook2;
                this.impFuncs = impFuncs;
                this.isTwoState = isTwoState;
                this.hasOverloadings = this.impFuncs.size() > 1;
            }

            public /* synthetic */ CVLFunctionInfo(Object object, List list2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 4) != 0) {
                    bl = false;
                }
                this(object, list2, bl);
            }

            @NotNull
            public final Object component1() {
                return this.getHook();
            }

            @NotNull
            public final List<Function> component2() {
                return this.impFuncs;
            }

            public final boolean component3() {
                return this.isTwoState();
            }

            @NotNull
            public final CVLFunctionInfo copy(@NotNull Object hook2, @NotNull List<? extends Function> impFuncs, boolean isTwoState) {
                Intrinsics.checkParameterIsNotNull(hook2, "hook");
                Intrinsics.checkParameterIsNotNull(impFuncs, "impFuncs");
                return new CVLFunctionInfo(hook2, impFuncs, isTwoState);
            }

            public static /* synthetic */ CVLFunctionInfo copy$default(CVLFunctionInfo cVLFunctionInfo, Object object, List list2, boolean bl, int n, Object object2) {
                if ((n & 1) != 0) {
                    object = cVLFunctionInfo.getHook();
                }
                if ((n & 2) != 0) {
                    list2 = cVLFunctionInfo.impFuncs;
                }
                if ((n & 4) != 0) {
                    bl = cVLFunctionInfo.isTwoState();
                }
                return cVLFunctionInfo.copy(object, list2, bl);
            }

            @NotNull
            public String toString() {
                return "CVLFunctionInfo(hook=" + this.getHook() + ", impFuncs=" + this.impFuncs + ", isTwoState=" + this.isTwoState() + ")";
            }

            public int hashCode() {
                Object object = this.getHook();
                List<Function> list2 = this.impFuncs;
                int n = ((object != null ? object.hashCode() : 0) * 31 + (list2 != null ? ((Object)list2).hashCode() : 0)) * 31;
                int n2 = this.isTwoState() ? 1 : 0;
                if (n2 != 0) {
                    n2 = 1;
                }
                return n + n2;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof CVLFunctionInfo)) break block3;
                        CVLFunctionInfo cVLFunctionInfo = (CVLFunctionInfo)object;
                        if (!Intrinsics.areEqual(this.getHook(), cVLFunctionInfo.getHook()) || !Intrinsics.areEqual(this.impFuncs, cVLFunctionInfo.impFuncs) || this.isTwoState() != cVLFunctionInfo.isTwoState()) break block3;
                    }
                    return true;
                }
                return false;
            }
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\b\u0010\r\u001a\u00020\u000eH\u0016J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lspec/cvlast/CVLSymbolTable$SymbolInfo$CVLFunctionIdentifierInfo;", "Lspec/cvlast/CVLSymbolTable$SymbolInfo;", "evmMethodInfo", "Lbridge/EVMMethodInfo;", "(Lbridge/EVMMethodInfo;)V", "getEvmMethodInfo", "()Lbridge/EVMMethodInfo;", "component1", "copy", "equals", "", "other", "", "getCVLType", "Lspec/cvlast/CVLType;", "hashCode", "", "toString", "", "Shared"})
        public static final class CVLFunctionIdentifierInfo
        extends SymbolInfo {
            @NotNull
            private final EVMMethodInfo evmMethodInfo;

            @Override
            @NotNull
            public CVLType getCVLType() {
                return EVMMethodInfo.toCvlStructLit$default(this.evmMethodInfo, false, 1, null).getCVLType();
            }

            @NotNull
            public final EVMMethodInfo getEvmMethodInfo() {
                return this.evmMethodInfo;
            }

            public CVLFunctionIdentifierInfo(@NotNull EVMMethodInfo evmMethodInfo) {
                Intrinsics.checkParameterIsNotNull(evmMethodInfo, "evmMethodInfo");
                super(evmMethodInfo, false, 2, null);
                this.evmMethodInfo = evmMethodInfo;
            }

            @NotNull
            public final EVMMethodInfo component1() {
                return this.evmMethodInfo;
            }

            @NotNull
            public final CVLFunctionIdentifierInfo copy(@NotNull EVMMethodInfo evmMethodInfo) {
                Intrinsics.checkParameterIsNotNull(evmMethodInfo, "evmMethodInfo");
                return new CVLFunctionIdentifierInfo(evmMethodInfo);
            }

            public static /* synthetic */ CVLFunctionIdentifierInfo copy$default(CVLFunctionIdentifierInfo cVLFunctionIdentifierInfo, EVMMethodInfo eVMMethodInfo, int n, Object object) {
                if ((n & 1) != 0) {
                    eVMMethodInfo = cVLFunctionIdentifierInfo.evmMethodInfo;
                }
                return cVLFunctionIdentifierInfo.copy(eVMMethodInfo);
            }

            @NotNull
            public String toString() {
                return "CVLFunctionIdentifierInfo(evmMethodInfo=" + this.evmMethodInfo + ")";
            }

            public int hashCode() {
                EVMMethodInfo eVMMethodInfo = this.evmMethodInfo;
                return eVMMethodInfo != null ? ((Object)eVMMethodInfo).hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof CVLFunctionIdentifierInfo)) break block3;
                        CVLFunctionIdentifierInfo cVLFunctionIdentifierInfo = (CVLFunctionIdentifierInfo)object;
                        if (!Intrinsics.areEqual(this.evmMethodInfo, cVLFunctionIdentifierInfo.evmMethodInfo)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00012\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u0086\u0002\u00a8\u0006\b"}, d2={"Lspec/cvlast/CVLSymbolTable$SymbolInfo$Companion;", "", "()V", "invoke", "Lspec/cvlast/CVLSymbolTable$SymbolInfo;", "hook", "isTwoState", "", "Shared"})
        public static final class Companion {
            @NotNull
            public final SymbolInfo invoke(@NotNull Object hook2, boolean isTwoState) {
                Intrinsics.checkParameterIsNotNull(hook2, "hook");
                Object object = hook2;
                return object instanceof Function ? (SymbolInfo)new CVLFunctionInfo(hook2, CollectionsKt.listOf(hook2), isTwoState) : (object instanceof EVMMethodInfo ? (SymbolInfo)new CVLFunctionIdentifierInfo((EVMMethodInfo)hook2) : (SymbolInfo)new WithCVLType(hook2, isTwoState));
            }

            public static /* synthetic */ SymbolInfo invoke$default(Companion companion, Object object, boolean bl, int n, Object object2) {
                if ((n & 2) != 0) {
                    bl = false;
                }
                return companion.invoke(object, bl);
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

