/*
 * Decompiled with CFR 0.152.
 */
package spec;

import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import log.Logger;
import org.jetbrains.annotations.NotNull;
import spec.cvlast.CVLLocation;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\tJ\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u000fJ\u0016\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R#\u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR#\u0010\f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lspec/CVLErrorLogger;", "", "()V", "errorCount", "", "errors", "", "Lkotlin/Pair;", "", "Lspec/cvlast/CVLLocation;", "getErrors", "()Ljava/util/Set;", "warnings", "getWarnings", "error", "", "msg", "loc", "foundTypeError", "", "stopIfHasErrors", "warn", "Shared"})
public final class CVLErrorLogger {
    private static int errorCount;
    @NotNull
    private static final Set<Pair<String, CVLLocation>> errors;
    @NotNull
    private static final Set<Pair<String, CVLLocation>> warnings;
    public static final CVLErrorLogger INSTANCE;

    public final boolean foundTypeError() {
        return errorCount > 0;
    }

    @NotNull
    public final Set<Pair<String, CVLLocation>> getErrors() {
        return errors;
    }

    @NotNull
    public final Set<Pair<String, CVLLocation>> getWarnings() {
        return warnings;
    }

    public final void error(@NotNull String msg, @NotNull CVLLocation loc) {
        Intrinsics.checkParameterIsNotNull(msg, "msg");
        Intrinsics.checkParameterIsNotNull(loc, "loc");
        if (!errors.contains(TuplesKt.to(msg, loc))) {
            errors.add(TuplesKt.to(msg, loc));
            int n = errorCount;
            errorCount = n + 1;
            String locStr = loc instanceof CVLLocation.Empty ? "" : " (" + loc + ')';
            String errorMsg = "Syntax error in spec file" + locStr + ": " + msg;
            Logger.Companion.alwaysError(errorMsg);
        }
    }

    public final void warn(@NotNull String msg, @NotNull CVLLocation loc) {
        Intrinsics.checkParameterIsNotNull(msg, "msg");
        Intrinsics.checkParameterIsNotNull(loc, "loc");
        if (!warnings.contains(TuplesKt.to(msg, loc))) {
            warnings.add(TuplesKt.to(msg, loc));
            String locStr = loc instanceof CVLLocation.Empty ? "" : " (" + loc + ')';
            String warnMsg = "Syntax warning in spec file" + locStr + ": " + msg;
            Logger.Companion.always(warnMsg, false);
            Logger.Companion.regression(new Function0<String>(warnMsg){
                final /* synthetic */ String $warnMsg;

                @NotNull
                public final String invoke() {
                    return this.$warnMsg;
                }
                {
                    this.$warnMsg = string2;
                    super(0);
                }
            });
        }
    }

    public final void stopIfHasErrors() {
        if (this.foundTypeError()) {
            String string2 = "CVL file has errors.";
            boolean bl = false;
            System.out.println((Object)string2);
            int n = 1;
            bl = false;
            System.exit(n);
            throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
    }

    private CVLErrorLogger() {
    }

    static {
        CVLErrorLogger cVLErrorLogger;
        INSTANCE = cVLErrorLogger = new CVLErrorLogger();
        boolean bl = false;
        errors = new LinkedHashSet();
        bl = false;
        warnings = new LinkedHashSet();
    }
}

