/*
 * Decompiled with CFR 0.152.
 */
package solver;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import solver.CVC4SolverInfo;
import solver.CVC5SolverInfo;
import solver.SolverChoice;
import solver.SolverInfo;
import solver.YicesSolverInfo;
import solver.Z3SolverInfo;
import utils.RuntimeEnvInfo;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u001c\b\u0086\b\u0018\u0000 %2\u00020\u0001:\u0002$%BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\rJ\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0007H\u00c6\u0003J\u000f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0003J\t\u0010\u001d\u001a\u00020\nH\u00c6\u0003J\u000b\u0010\u001e\u001a\u0004\u0018\u00010\nH\u00c6\u0003JM\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\b\u0002\u0010\u000b\u001a\u00020\n2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\nH\u00c6\u0001J\u0013\u0010 \u001a\u00020\u00072\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\"\u001a\u00020\u0005H\u00d6\u0001J\t\u0010#\u001a\u00020\nH\u00d6\u0001R\u0013\u0010\f\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006&"}, d2={"Lsolver/SolverConfig;", "", "solverInfo", "Lsolver/SolverInfo;", "timeoutSeconds", "", "incrementalMode", "", "extraClOptions", "", "", "name", "customSolverExecutable", "(Lsolver/SolverInfo;IZLjava/util/List;Ljava/lang/String;Ljava/lang/String;)V", "getCustomSolverExecutable", "()Ljava/lang/String;", "getExtraClOptions", "()Ljava/util/List;", "getIncrementalMode", "()Z", "getName", "getSolverInfo", "()Lsolver/SolverInfo;", "getTimeoutSeconds", "()I", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "other", "hashCode", "toString", "ArithmeticOperations", "Companion", "GeneralUtils"})
public final class SolverConfig {
    @NotNull
    private final SolverInfo solverInfo;
    private final int timeoutSeconds;
    private final boolean incrementalMode;
    @NotNull
    private final List<String> extraClOptions;
    @NotNull
    private final String name;
    @Nullable
    private final String customSolverExecutable;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final SolverInfo getSolverInfo() {
        return this.solverInfo;
    }

    public final int getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    public final boolean getIncrementalMode() {
        return this.incrementalMode;
    }

    @NotNull
    public final List<String> getExtraClOptions() {
        return this.extraClOptions;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @Nullable
    public final String getCustomSolverExecutable() {
        return this.customSolverExecutable;
    }

    public SolverConfig(@NotNull SolverInfo solverInfo, int timeoutSeconds, boolean incrementalMode, @NotNull List<String> extraClOptions, @NotNull String name, @Nullable String customSolverExecutable) {
        Intrinsics.checkParameterIsNotNull(solverInfo, "solverInfo");
        Intrinsics.checkParameterIsNotNull(extraClOptions, "extraClOptions");
        Intrinsics.checkParameterIsNotNull(name, "name");
        this.solverInfo = solverInfo;
        this.timeoutSeconds = timeoutSeconds;
        this.incrementalMode = incrementalMode;
        this.extraClOptions = extraClOptions;
        this.name = name;
        this.customSolverExecutable = customSolverExecutable;
    }

    public /* synthetic */ SolverConfig(SolverInfo solverInfo, int n, boolean bl, List list2, String string2, String string3, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x10) != 0) {
            string2 = solverInfo.getName();
        }
        if ((n2 & 0x20) != 0) {
            string3 = null;
        }
        this(solverInfo, n, bl, list2, string2, string3);
    }

    @NotNull
    public final SolverInfo component1() {
        return this.solverInfo;
    }

    public final int component2() {
        return this.timeoutSeconds;
    }

    public final boolean component3() {
        return this.incrementalMode;
    }

    @NotNull
    public final List<String> component4() {
        return this.extraClOptions;
    }

    @NotNull
    public final String component5() {
        return this.name;
    }

    @Nullable
    public final String component6() {
        return this.customSolverExecutable;
    }

    @NotNull
    public final SolverConfig copy(@NotNull SolverInfo solverInfo, int timeoutSeconds, boolean incrementalMode, @NotNull List<String> extraClOptions, @NotNull String name, @Nullable String customSolverExecutable) {
        Intrinsics.checkParameterIsNotNull(solverInfo, "solverInfo");
        Intrinsics.checkParameterIsNotNull(extraClOptions, "extraClOptions");
        Intrinsics.checkParameterIsNotNull(name, "name");
        return new SolverConfig(solverInfo, timeoutSeconds, incrementalMode, extraClOptions, name, customSolverExecutable);
    }

    public static /* synthetic */ SolverConfig copy$default(SolverConfig solverConfig, SolverInfo solverInfo, int n, boolean bl, List list2, String string2, String string3, int n2, Object object) {
        if ((n2 & 1) != 0) {
            solverInfo = solverConfig.solverInfo;
        }
        if ((n2 & 2) != 0) {
            n = solverConfig.timeoutSeconds;
        }
        if ((n2 & 4) != 0) {
            bl = solverConfig.incrementalMode;
        }
        if ((n2 & 8) != 0) {
            list2 = solverConfig.extraClOptions;
        }
        if ((n2 & 0x10) != 0) {
            string2 = solverConfig.name;
        }
        if ((n2 & 0x20) != 0) {
            string3 = solverConfig.customSolverExecutable;
        }
        return solverConfig.copy(solverInfo, n, bl, list2, string2, string3);
    }

    @NotNull
    public String toString() {
        return "SolverConfig(solverInfo=" + this.solverInfo + ", timeoutSeconds=" + this.timeoutSeconds + ", incrementalMode=" + this.incrementalMode + ", extraClOptions=" + this.extraClOptions + ", name=" + this.name + ", customSolverExecutable=" + this.customSolverExecutable + ")";
    }

    public int hashCode() {
        SolverInfo solverInfo = this.solverInfo;
        int n = ((solverInfo != null ? solverInfo.hashCode() : 0) * 31 + Integer.hashCode(this.timeoutSeconds)) * 31;
        int n2 = this.incrementalMode ? 1 : 0;
        if (n2 != 0) {
            n2 = 1;
        }
        List<String> list2 = this.extraClOptions;
        String string2 = this.name;
        String string3 = this.customSolverExecutable;
        return (((n + n2) * 31 + (list2 != null ? ((Object)list2).hashCode() : 0)) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof SolverConfig)) break block3;
                SolverConfig solverConfig = (SolverConfig)object;
                if (!Intrinsics.areEqual(this.solverInfo, solverConfig.solverInfo) || this.timeoutSeconds != solverConfig.timeoutSeconds || this.incrementalMode != solverConfig.incrementalMode || !Intrinsics.areEqual(this.extraClOptions, solverConfig.extraClOptions) || !Intrinsics.areEqual(this.name, solverConfig.name) || !Intrinsics.areEqual(this.customSolverExecutable, solverConfig.customSolverExecutable)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lsolver/SolverConfig$ArithmeticOperations;", "", "(Ljava/lang/String;I)V", "LinearOnly", "NonLinear", "BitVector", "Any", "None", "GeneralUtils"})
    public static final class ArithmeticOperations
    extends Enum<ArithmeticOperations> {
        public static final /* enum */ ArithmeticOperations LinearOnly;
        public static final /* enum */ ArithmeticOperations NonLinear;
        public static final /* enum */ ArithmeticOperations BitVector;
        public static final /* enum */ ArithmeticOperations Any;
        public static final /* enum */ ArithmeticOperations None;
        private static final /* synthetic */ ArithmeticOperations[] $VALUES;

        static {
            ArithmeticOperations[] arithmeticOperationsArray = new ArithmeticOperations[5];
            ArithmeticOperations[] arithmeticOperationsArray2 = arithmeticOperationsArray;
            arithmeticOperationsArray[0] = LinearOnly = new ArithmeticOperations();
            arithmeticOperationsArray[1] = NonLinear = new ArithmeticOperations();
            arithmeticOperationsArray[2] = BitVector = new ArithmeticOperations();
            arithmeticOperationsArray[3] = Any = new ArithmeticOperations();
            arithmeticOperationsArray[4] = None = new ArithmeticOperations();
            $VALUES = arithmeticOperationsArray;
        }

        public static ArithmeticOperations[] values() {
            return (ArithmeticOperations[])$VALUES.clone();
        }

        public static ArithmeticOperations valueOf(String string2) {
            return Enum.valueOf(ArithmeticOperations.class, string2);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u001c\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ,\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\u0012"}, d2={"Lsolver/SolverConfig$Companion;", "", "()V", "getAllQuantifiedConfigs", "", "Lsolver/SolverConfig;", "timeoutSeconds", "", "incrementalMode", "", "getBitVectorConfigs", "getDefaultSolverConfigs", "solverChoice", "Lsolver/SolverChoice;", "arithmeticOperations", "Lsolver/SolverConfig$ArithmeticOperations;", "getNonLinearConfigs", "getNonLinearQuantifierFreeConfigs", "GeneralUtils"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Set<SolverConfig> getDefaultSolverConfigs(@NotNull SolverChoice solverChoice, @NotNull ArithmeticOperations arithmeticOperations, int timeoutSeconds, boolean incrementalMode) {
            void $this$flatMapTo$iv;
            Intrinsics.checkParameterIsNotNull(solverChoice, "solverChoice");
            Intrinsics.checkParameterIsNotNull((Object)arithmeticOperations, "arithmeticOperations");
            Iterable iterable = solverChoice;
            boolean bl = false;
            Collection destination$iv = new LinkedHashSet();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv : $this$flatMapTo$iv) {
                Iterable iterable2;
                SolverInfo it = (SolverInfo)element$iv;
                boolean bl2 = false;
                SolverInfo solverInfo = it;
                if (Intrinsics.areEqual(solverInfo, Z3SolverInfo.INSTANCE)) {
                    iterable2 = Z3SolverInfo.INSTANCE.getDefaultConfigs(timeoutSeconds, incrementalMode, arithmeticOperations);
                } else if (Intrinsics.areEqual(solverInfo, CVC5SolverInfo.INSTANCE)) {
                    iterable2 = CVC5SolverInfo.INSTANCE.getDefaultConfigs(timeoutSeconds, incrementalMode, arithmeticOperations);
                } else if (Intrinsics.areEqual(solverInfo, CVC4SolverInfo.INSTANCE)) {
                    if (solverChoice.contains((Object)CVC5SolverInfo.INSTANCE)) {
                        boolean bl3 = false;
                        iterable2 = CollectionsKt.emptyList();
                    } else {
                        iterable2 = CVC4SolverInfo.INSTANCE.getDefaultConfigs(timeoutSeconds, incrementalMode, arithmeticOperations);
                    }
                } else if (Intrinsics.areEqual(solverInfo, YicesSolverInfo.INSTANCE)) {
                    iterable2 = YicesSolverInfo.INSTANCE.getDefaultConfigs(timeoutSeconds, incrementalMode);
                } else {
                    String string2 = "unhandled solver program choice: " + it;
                    boolean bl4 = false;
                    throw (Throwable)new IllegalStateException(string2.toString());
                }
                Iterable list$iv = iterable2;
                CollectionsKt.addAll(destination$iv, list$iv);
            }
            return (Set)destination$iv;
        }

        @NotNull
        public final Set<SolverConfig> getAllQuantifiedConfigs(int timeoutSeconds, boolean incrementalMode) {
            return CVC5SolverInfo.INSTANCE.getQuantifierConfigs(timeoutSeconds, incrementalMode);
        }

        @NotNull
        public final Set<SolverConfig> getNonLinearQuantifierFreeConfigs(int timeoutSeconds, boolean incrementalMode) {
            Set<SolverConfig> set;
            if (RuntimeEnvInfo.INSTANCE.isYicesAvailable()) {
                set = YicesSolverInfo.INSTANCE.getDefaultConfigs(timeoutSeconds, incrementalMode);
            } else {
                boolean bl = false;
                set = SetsKt.emptySet();
            }
            return set;
        }

        @NotNull
        public final Set<SolverConfig> getNonLinearConfigs(int timeoutSeconds, boolean incrementalMode) {
            return CVC5SolverInfo.INSTANCE.getNonLinearConfigs(timeoutSeconds, incrementalMode);
        }

        @NotNull
        public final Set<SolverConfig> getBitVectorConfigs(int timeoutSeconds, boolean incrementalMode) {
            return CVC5SolverInfo.INSTANCE.getBitVectorConfigs(timeoutSeconds, incrementalMode);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

