/*
 * Decompiled with CFR 0.152.
 */
package parallel;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.RecursiveTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import parallel.CompleteJob;
import parallel.Parallel;
import parallel.ParallelPool;
import parallel.Scheduler;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 \u001a2\u00020\u0001:\u0007\u001a\u001b\u001c\u001d\u001e\u001f B\u0017\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0011\b\u0016\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007B\u0017\b\u0002\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u001f\u0010\u0010\u001a\u0002H\u0011\"\u0004\b\u0000\u0010\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0013\u00a2\u0006\u0002\u0010\u0014J0\u0010\u0010\u001a\u0002H\u0011\"\u0004\b\u0000\u0010\u00112\u001d\u0010\u0015\u001a\u0019\u0012\u0004\u0012\u00020\u0017\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00110\u00130\u0016\u00a2\u0006\u0002\b\u0018\u00a2\u0006\u0002\u0010\u0019R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lparallel/ParallelPool;", "Ljava/io/Closeable;", "workerThreads", "", "poolFactory", "Lparallel/ParallelPool$PoolFactory;", "(ILparallel/ParallelPool$PoolFactory;)V", "(I)V", "forkJoinPool", "Ljava/util/concurrent/ForkJoinPool;", "ioPool", "Ljava/util/concurrent/ExecutorService;", "(Ljava/util/concurrent/ForkJoinPool;Ljava/util/concurrent/ExecutorService;)V", "workerThreadPool", "close", "", "run", "T", "x", "Lparallel/Parallel;", "(Lparallel/Parallel;)Ljava/lang/Object;", "f", "Lkotlin/Function1;", "Lparallel/Scheduler;", "Lkotlin/ExtensionFunctionType;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "Companion", "ObjectReference", "ParallelPoolWorkerThread", "PoolFactory", "SchedulingTask", "SimpleSchedudler", "SpawnPolicy", "GeneralUtils"})
public final class ParallelPool
implements Closeable {
    private final ForkJoinPool workerThreadPool;
    private final ExecutorService ioPool;
    @NotNull
    private static final Lazy globalPool$delegate;
    private static final Map<ParallelPool, Map<Class<?>, ObjectReference<?>>> scopeMap;
    public static final Companion Companion;

    public final <T> T run(@NotNull Function1<? super Scheduler, ? extends Parallel<? extends T>> f) {
        Intrinsics.checkParameterIsNotNull(f, "f");
        Parallel<? extends T> x = f.invoke(Scheduler.INSTANCE);
        return this.run(x);
    }

    public final <T> T run(@NotNull Parallel<? extends T> x) {
        T t2;
        Intrinsics.checkParameterIsNotNull(x, "x");
        if (x instanceof CompleteJob) {
            return x.getResult();
        }
        if (System.getProperty("cvt.simple.parallel") != null) {
            new SimpleSchedudler().resolve(x);
            t2 = x.getResult();
        } else {
            this.workerThreadPool.submit(new SchedulingTask(x)).join();
            t2 = x.getResult();
        }
        return t2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.workerThreadPool.shutdownNow();
        this.ioPool.shutdownNow();
        Map<ParallelPool, Map<Class<?>, ObjectReference<?>>> map2 = scopeMap;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (map2) {
            boolean bl3 = false;
            Map<Class<?>, ObjectReference<?>> map3 = scopeMap.remove(this);
        }
    }

    private ParallelPool(ForkJoinPool forkJoinPool, ExecutorService ioPool) {
        this.ioPool = ioPool;
        this.workerThreadPool = forkJoinPool;
    }

    private ParallelPool(int workerThreads, PoolFactory poolFactory) {
        ForkJoinPool forkJoinPool = new ForkJoinPool(workerThreads, poolFactory, null, false, 0, Integer.MAX_VALUE, 1, 1.INSTANCE, 60L, TimeUnit.SECONDS);
        ExecutorService executorService = Executors.newCachedThreadPool();
        Intrinsics.checkExpressionValueIsNotNull(executorService, "Executors.newCachedThreadPool()");
        this(forkJoinPool, executorService);
        poolFactory.setParallelPool(this);
    }

    public ParallelPool(int workerThreads) {
        this(workerThreads, new PoolFactory());
    }

    public /* synthetic */ ParallelPool(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            Object object = System.getProperty("cvt.default.parallelism");
            n = object != null && (object = StringsKt.toIntOrNull((String)object)) != null ? ((Integer)object).intValue() : Runtime.getRuntime().availableProcessors();
        }
        this(n);
    }

    static {
        Companion = new Companion(null);
        globalPool$delegate = LazyKt.lazy(Companion.globalPool.2.INSTANCE);
        scopeMap = new IdentityHashMap();
    }

    public /* synthetic */ ParallelPool(ForkJoinPool forkJoinPool, ExecutorService ioPool, DefaultConstructorMarker $constructor_marker) {
        this(forkJoinPool, ioPool);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lparallel/ParallelPool$PoolFactory;", "Ljava/util/concurrent/ForkJoinPool$ForkJoinWorkerThreadFactory;", "()V", "parallelPool", "Lparallel/ParallelPool;", "getParallelPool", "()Lparallel/ParallelPool;", "setParallelPool", "(Lparallel/ParallelPool;)V", "newThread", "Ljava/util/concurrent/ForkJoinWorkerThread;", "pool", "Ljava/util/concurrent/ForkJoinPool;", "GeneralUtils"})
    private static final class PoolFactory
    implements ForkJoinPool.ForkJoinWorkerThreadFactory {
        @NotNull
        public ParallelPool parallelPool;

        @NotNull
        public final ParallelPool getParallelPool() {
            ParallelPool parallelPool = this.parallelPool;
            if (parallelPool == null) {
                Intrinsics.throwUninitializedPropertyAccessException("parallelPool");
            }
            return parallelPool;
        }

        public final void setParallelPool(@NotNull ParallelPool parallelPool) {
            Intrinsics.checkParameterIsNotNull(parallelPool, "<set-?>");
            this.parallelPool = parallelPool;
        }

        @Override
        @NotNull
        public ForkJoinWorkerThread newThread(@Nullable ForkJoinPool pool) {
            ParallelPool parallelPool = this.parallelPool;
            if (parallelPool == null) {
                Intrinsics.throwUninitializedPropertyAccessException("parallelPool");
            }
            ForkJoinPool forkJoinPool = pool;
            if (forkJoinPool == null) {
                Intrinsics.throwNpe();
            }
            return new ParallelPoolWorkerThread(parallelPool, forkJoinPool);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lparallel/ParallelPool$ParallelPoolWorkerThread;", "Ljava/util/concurrent/ForkJoinWorkerThread;", "parallelPool", "Lparallel/ParallelPool;", "pool", "Ljava/util/concurrent/ForkJoinPool;", "(Lparallel/ParallelPool;Ljava/util/concurrent/ForkJoinPool;)V", "getParallelPool", "()Lparallel/ParallelPool;", "GeneralUtils"})
    public static final class ParallelPoolWorkerThread
    extends ForkJoinWorkerThread {
        @NotNull
        private final ParallelPool parallelPool;

        @NotNull
        public final ParallelPool getParallelPool() {
            return this.parallelPool;
        }

        public ParallelPoolWorkerThread(@NotNull ParallelPool parallelPool, @NotNull ForkJoinPool pool) {
            Intrinsics.checkParameterIsNotNull(parallelPool, "parallelPool");
            Intrinsics.checkParameterIsNotNull(pool, "pool");
            super(pool);
            this.parallelPool = parallelPool;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006J\u001d\u0010\u0007\u001a\u0002H\b\"\u0004\b\u0000\u0010\b*\b\u0012\u0004\u0012\u0002H\b0\tH\u0002\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lparallel/ParallelPool$SimpleSchedudler;", "", "(Lparallel/ParallelPool;)V", "resolve", "", "v", "Lparallel/Parallel;", "removeLast", "T", "", "(Ljava/util/List;)Ljava/lang/Object;", "GeneralUtils"})
    private final class SimpleSchedudler {
        private final <T> T removeLast(@NotNull List<T> $this$removeLast) {
            return $this$removeLast.remove(CollectionsKt.getLastIndex($this$removeLast));
        }

        /*
         * Unable to fully structure code
         */
        public final void resolve(@NotNull Parallel<?> v) {
            Intrinsics.checkParameterIsNotNull(v, "v");
            depQueue = CollectionsKt.mutableListOf(new Parallel[]{v});
            var4_3 = false;
            execQueue = new ArrayList<E>();
            block0: while (true) {
                var4_4 = depQueue;
                var5_6 = false;
                if (!(var4_4.isEmpty() == false)) {
                    var4_4 = execQueue;
                    var5_6 = false;
                    if (!(var4_4.isEmpty() == false)) break;
                }
                while (true) {
                    var4_4 = depQueue;
                    var5_6 = false;
                    if (!(var4_4.isEmpty() == false)) break;
                    j = this.removeLast(depQueue);
                    execQueue.add(j);
                    depQueue.addAll((Collection<Parallel>)j.getDeps());
                }
                do {
                    j = execQueue;
                    var5_6 = false;
                    if (!(j.isEmpty() == false)) continue block0;
                    exec = (Parallel)this.removeLast(execQueue);
                    var5_6 = exec.getRunnable();
                    var6_9 = false;
                    var7_11 = false;
                    var7_11 = false;
                    var8_12 = false;
                    if (!var5_6) {
                        var9_14 = false;
                        var8_13 = "Check failed.";
                        throw (Throwable)new IllegalStateException(var8_13.toString());
                    }
                    res = exec.queueSchedule(ParallelPool.access$getIoPool$p(ParallelPool.this));
                    if (exec.done()) ** GOTO lbl-1000
                    var6_10 = res;
                    var7_11 = false;
                    if (var6_10.isEmpty() == false) lbl-1000:
                    // 2 sources

                    {
                        v0 = true;
                    } else {
                        v0 = false;
                    }
                    var6_9 = v0;
                    var7_11 = false;
                    var8_12 = false;
                    var8_12 = false;
                    var9_14 = false;
                    if (!var6_9) {
                        var10_16 = false;
                        var9_15 = "Check failed.";
                        throw (Throwable)new IllegalStateException(var9_15.toString());
                    }
                    depQueue.addAll((Collection<Parallel>)res);
                    var6_8 = depQueue;
                    var7_11 = false;
                } while (!(var6_8.isEmpty() == false));
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0011\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0002H\u0014R\u0012\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lparallel/ParallelPool$SchedulingTask;", "Ljava/util/concurrent/RecursiveTask;", "", "v", "Lparallel/Parallel;", "(Lparallel/ParallelPool;Lparallel/Parallel;)V", "compute", "GeneralUtils"})
    private final class SchedulingTask
    extends RecursiveTask<Unit> {
        private final Parallel<?> v;

        @Override
        protected void compute() {
            boolean bl;
            Object object;
            Object it;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            boolean $i$f$mapTo;
            Collection destination$iv$iv;
            boolean $i$f$map;
            Iterable $this$map$iv;
            boolean bl2;
            if (!this.v.getRunnable()) {
                List<Parallel<?>> deps = this.v.getDeps();
                Collection collection2 = deps;
                bl2 = false;
                boolean bl3 = !collection2.isEmpty();
                bl2 = false;
                boolean bl4 = false;
                bl4 = false;
                boolean bl5 = false;
                if (!bl3) {
                    boolean bl6 = false;
                    String string2 = "Check failed.";
                    throw (Throwable)new IllegalStateException(string2.toString());
                }
                $this$map$iv = deps;
                $i$f$map = false;
                Iterable iterable = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    Parallel parallel = (Parallel)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl7 = false;
                    object = new SchedulingTask((Parallel<?>)it).fork();
                    collection.add(object);
                }
                $this$map$iv = CollectionsKt.reversed((List)destination$iv$iv);
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (ForkJoinTask)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl8 = false;
                    object = (Unit)((ForkJoinTask)it).join();
                    collection.add(object);
                }
                List cfr_ignored_0 = (List)destination$iv$iv;
            }
            List<Parallel<?>> d = this.v.queueSchedule(ParallelPool.this.ioPool);
            $this$map$iv = d;
            $i$f$map = false;
            if (!$this$map$iv.isEmpty()) {
                $this$map$iv = d;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (Parallel)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl9 = false;
                    SchedulingTask ret = new SchedulingTask((Parallel<?>)it);
                    ret.fork();
                    object = ret;
                    collection.add(object);
                }
                $this$map$iv = (List)destination$iv$iv;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (SchedulingTask)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl10 = false;
                    object = (Unit)((ForkJoinTask)it).join();
                    collection.add(object);
                }
                List cfr_ignored_1 = (List)destination$iv$iv;
                boolean bl11 = this.v.done();
                bl2 = false;
                boolean bl12 = false;
                bl12 = false;
                boolean bl13 = false;
                if (!bl11) {
                    bl = false;
                    String string3 = "Check failed.";
                    throw (Throwable)new IllegalStateException(string3.toString());
                }
                return;
            }
            boolean bl14 = this.v.done();
            bl2 = false;
            boolean bl15 = false;
            bl15 = false;
            boolean bl16 = false;
            if (!bl14) {
                bl = false;
                String string4 = "Check failed.";
                throw (Throwable)new IllegalStateException(string4.toString());
            }
            bl14 = d.isEmpty();
            bl2 = false;
            bl15 = false;
            bl15 = false;
            bl16 = false;
            if (!bl14) {
                bl = false;
                String string5 = "Check failed.";
                throw (Throwable)new IllegalStateException(string5.toString());
            }
        }

        public SchedulingTask(Parallel<?> v) {
            Intrinsics.checkParameterIsNotNull(v, "v");
            this.v = v;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\u0003\u0004\u0005B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0003\u0006\u0007\b\u00a8\u0006\t"}, d2={"Lparallel/ParallelPool$SpawnPolicy;", "", "()V", "FAIL", "GLOBAL", "New", "Lparallel/ParallelPool$SpawnPolicy$GLOBAL;", "Lparallel/ParallelPool$SpawnPolicy$FAIL;", "Lparallel/ParallelPool$SpawnPolicy$New;", "GeneralUtils"})
    public static abstract class SpawnPolicy {
        private SpawnPolicy() {
        }

        public /* synthetic */ SpawnPolicy(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lparallel/ParallelPool$SpawnPolicy$GLOBAL;", "Lparallel/ParallelPool$SpawnPolicy;", "()V", "GeneralUtils"})
        public static final class GLOBAL
        extends SpawnPolicy {
            public static final GLOBAL INSTANCE;

            private GLOBAL() {
                super(null);
            }

            static {
                GLOBAL gLOBAL;
                INSTANCE = gLOBAL = new GLOBAL();
            }
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lparallel/ParallelPool$SpawnPolicy$FAIL;", "Lparallel/ParallelPool$SpawnPolicy;", "()V", "GeneralUtils"})
        public static final class FAIL
        extends SpawnPolicy {
            public static final FAIL INSTANCE;

            private FAIL() {
                super(null);
            }

            static {
                FAIL fAIL;
                INSTANCE = fAIL = new FAIL();
            }
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\t\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lparallel/ParallelPool$SpawnPolicy$New;", "Lparallel/ParallelPool$SpawnPolicy;", "f", "Lkotlin/Function0;", "Lparallel/ParallelPool;", "(Lkotlin/jvm/functions/Function0;)V", "getF", "()Lkotlin/jvm/functions/Function0;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "GeneralUtils"})
        public static final class New
        extends SpawnPolicy {
            @NotNull
            private final Function0<ParallelPool> f;

            @NotNull
            public final Function0<ParallelPool> getF() {
                return this.f;
            }

            public New(@NotNull Function0<ParallelPool> f) {
                Intrinsics.checkParameterIsNotNull(f, "f");
                super(null);
                this.f = f;
            }

            @NotNull
            public final Function0<ParallelPool> component1() {
                return this.f;
            }

            @NotNull
            public final New copy(@NotNull Function0<ParallelPool> f) {
                Intrinsics.checkParameterIsNotNull(f, "f");
                return new New(f);
            }

            public static /* synthetic */ New copy$default(New new_, Function0 function0, int n, Object object) {
                if ((n & 1) != 0) {
                    function0 = new_.f;
                }
                return new_.copy(function0);
            }

            @NotNull
            public String toString() {
                return "New(f=" + this.f + ")";
            }

            public int hashCode() {
                Function0<ParallelPool> function0 = this.f;
                return function0 != null ? function0.hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof New)) break block3;
                        New new_ = (New)object;
                        if (!Intrinsics.areEqual(this.f, new_.f)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0013\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000f"}, d2={"Lparallel/ParallelPool$ObjectReference;", "T", "Ljava/io/Closeable;", "", "wrapped", "refCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "(Ljava/io/Closeable;Ljava/util/concurrent/atomic/AtomicInteger;)V", "getRefCount", "()Ljava/util/concurrent/atomic/AtomicInteger;", "setRefCount", "(Ljava/util/concurrent/atomic/AtomicInteger;)V", "getWrapped", "()Ljava/io/Closeable;", "Ljava/io/Closeable;", "GeneralUtils"})
    public static final class ObjectReference<T extends Closeable> {
        @NotNull
        private final T wrapped;
        @NotNull
        private AtomicInteger refCount;

        @NotNull
        public final T getWrapped() {
            return this.wrapped;
        }

        @NotNull
        public final AtomicInteger getRefCount() {
            return this.refCount;
        }

        public final void setRefCount(@NotNull AtomicInteger atomicInteger) {
            Intrinsics.checkParameterIsNotNull(atomicInteger, "<set-?>");
            this.refCount = atomicInteger;
        }

        public ObjectReference(@NotNull T wrapped, @NotNull AtomicInteger refCount) {
            Intrinsics.checkParameterIsNotNull(wrapped, "wrapped");
            Intrinsics.checkParameterIsNotNull(refCount, "refCount");
            this.wrapped = wrapped;
            this.refCount = refCount;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JF\u0010\r\u001a\u0002H\u000e\"\n\b\u0000\u0010\u000f\u0018\u0001*\u00020\u0010\"\u0004\b\u0001\u0010\u000e2\u000e\b\b\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u00122\u0014\b\b\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u0002H\u000f\u0012\u0004\u0012\u0002H\u000e0\u0014H\u0086\b\u00a2\u0006\u0002\u0010\u0015JK\u0010\r\u001a\u0002H\u000e\"\b\b\u0000\u0010\u000f*\u00020\u0010\"\u0004\b\u0001\u0010\u000e2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u000b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u0002H\u000f\u0012\u0004\u0012\u0002H\u000e0\u0014\u00a2\u0006\u0002\u0010\u0017J'\u0010\u0018\u001a\u0002H\u000f\"\u0004\b\u0000\u0010\u000f2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u001a2\u0006\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\u0002\u0010\u001dR\u001b\u0010\u0003\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R.\u0010\t\u001a\"\u0012\u0004\u0012\u00020\u0004\u0012\u0018\u0012\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lparallel/ParallelPool$Companion;", "", "()V", "globalPool", "Lparallel/ParallelPool;", "getGlobalPool", "()Lparallel/ParallelPool;", "globalPool$delegate", "Lkotlin/Lazy;", "scopeMap", "", "Ljava/lang/Class;", "Lparallel/ParallelPool$ObjectReference;", "allocInScope", "R", "T", "Ljava/io/Closeable;", "mk", "Lkotlin/Function0;", "f", "Lkotlin/Function1;", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "klass", "(Ljava/lang/Class;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "runInherit", "task", "Lparallel/Parallel;", "spawnPolicy", "Lparallel/ParallelPool$SpawnPolicy;", "(Lparallel/Parallel;Lparallel/ParallelPool$SpawnPolicy;)Ljava/lang/Object;", "GeneralUtils"})
    public static final class Companion {
        @NotNull
        public final ParallelPool getGlobalPool() {
            Lazy lazy = globalPool$delegate;
            Companion companion = Companion;
            Object var3_3 = null;
            boolean bl = false;
            return (ParallelPool)lazy.getValue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final <T> T runInherit(@NotNull Parallel<? extends T> task, @NotNull SpawnPolicy spawnPolicy) {
            T t2;
            Intrinsics.checkParameterIsNotNull(task, "task");
            Intrinsics.checkParameterIsNotNull(spawnPolicy, "spawnPolicy");
            Thread t3 = Thread.currentThread();
            if (t3 instanceof ParallelPoolWorkerThread) {
                t2 = ((ParallelPoolWorkerThread)t3).getParallelPool().run(task);
            } else {
                SpawnPolicy spawnPolicy2 = spawnPolicy;
                if (Intrinsics.areEqual(spawnPolicy2, SpawnPolicy.GLOBAL.INSTANCE)) {
                    t2 = this.getGlobalPool().run(task);
                } else {
                    if (Intrinsics.areEqual(spawnPolicy2, SpawnPolicy.FAIL.INSTANCE)) {
                        throw (Throwable)new IllegalStateException("Expected that this call to runInherit occurred within a parallel computation; it is not");
                    }
                    if (spawnPolicy2 instanceof SpawnPolicy.New) {
                        Closeable closeable = ((SpawnPolicy.New)spawnPolicy).getF().invoke();
                        boolean bl = false;
                        Throwable throwable = null;
                        try {
                            ParallelPool it = (ParallelPool)closeable;
                            boolean bl2 = false;
                            T t4 = it.run(task);
                            t2 = t4;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            CloseableKt.closeFinally(closeable, throwable);
                        }
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            return t2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final <T extends Closeable, R> R allocInScope(@NotNull Class<T> klass, @NotNull Function0<? extends T> mk, @NotNull Function1<? super T, ? extends R> f) {
            ObjectReference<Closeable> objectReference22;
            Map map2;
            Intrinsics.checkParameterIsNotNull(klass, "klass");
            Intrinsics.checkParameterIsNotNull(mk, "mk");
            Intrinsics.checkParameterIsNotNull(f, "f");
            Thread t2 = Thread.currentThread();
            if (!(t2 instanceof ParallelPoolWorkerThread)) {
                Closeable closeable = (Closeable)mk.invoke();
                boolean bl = false;
                Throwable throwable = null;
                try {
                    Closeable it = closeable;
                    boolean objectReference22 = false;
                    it = f.invoke(it);
                }
                catch (Throwable it) {
                    throwable = it;
                    throw it;
                }
                finally {
                    CloseableKt.closeFinally(closeable, throwable);
                }
                return (R)it;
            }
            ParallelPool pool = ((ParallelPoolWorkerThread)t2).getParallelPool();
            Map map3 = scopeMap;
            boolean it = false;
            boolean objectReference22 = false;
            synchronized (map3) {
                boolean bl = false;
                Map objectReference22 = (Map)scopeMap.computeIfAbsent(pool, allocInScope.resourceMap.1.1.INSTANCE);
                // MONITOREXIT @DISABLED, blocks:[2, 5] lbl32 : MonitorExitStatement: MONITOREXIT : var7_10
                map2 = objectReference22;
            }
            Intrinsics.checkExpressionValueIsNotNull(map2, "synchronized(scopeMap) {\u2026          }\n            }");
            Map resourceMap2 = map2;
            it = false;
            boolean objectReference22 = false;
            synchronized (resourceMap2) {
                ObjectReference<Closeable> objectReference3;
                boolean bl = false;
                ObjectReference<Closeable> d = (ObjectReference<Closeable>)resourceMap2.get(klass);
                if (d == null) {
                    ObjectReference<Closeable> r = new ObjectReference<Closeable>((Closeable)mk.invoke(), new AtomicInteger(1));
                    resourceMap2.put(klass, r);
                    objectReference3 = r;
                } else {
                    d.getRefCount().incrementAndGet();
                    objectReference3 = d;
                }
                objectReference22 = objectReference3;
            }
            ObjectReference<Closeable> wrapped = objectReference22;
            R ret = f.invoke(wrapped.getWrapped());
            int newCount = wrapped.getRefCount().decrementAndGet();
            if (newCount == 0) {
                boolean bl = false;
                boolean bl2 = false;
                synchronized (resourceMap2) {
                    boolean bl3 = false;
                    if (wrapped.getRefCount().get() == 0) {
                        wrapped.getWrapped().close();
                        resourceMap2.remove(klass);
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }
            return ret;
        }

        public final /* synthetic */ <T extends Closeable, R> R allocInScope(@NotNull Function0<? extends T> mk, @NotNull Function1<? super T, ? extends R> f) {
            int $i$f$allocInScope = 0;
            Intrinsics.checkParameterIsNotNull(mk, "mk");
            Intrinsics.checkParameterIsNotNull(f, "f");
            Intrinsics.reifiedOperationMarker(4, "T");
            return this.allocInScope(Closeable.class, mk, f);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

